/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.persist.oneXone;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.persist.oneXone.A;
import ee.jakarta.tck.persistence.core.entitytest.persist.oneXone.B;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("Entering Setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test1() throws Exception {
        this.logTrace("Begin persist1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("1", "a1", 1);
            B bRef = new B("1", "bean1", 1, a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("getA1");
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)bRef)) {
                pass = true;
            } else {
                this.logErr("Unexpected results - test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test2() throws Exception {
        this.logTrace("Begin persist1X1Test2");
        boolean pass = false;
        boolean result = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("2", "a2", 2);
            B bRef = new B("2", "b2", 2, a1);
            this.logTrace("Persist Instance");
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance Status ");
            result = this.getInstanceStatus(this.findB("2"));
            if (result) {
                try {
                    this.logTrace("entity is managed, remove it ");
                    this.getEntityManager().remove((Object)this.findB("2"));
                    this.getEntityManager().flush();
                    this.logTrace("Persist a removed entity");
                    this.getEntityManager().persist((Object)bRef);
                    pass = this.getInstanceStatus(bRef);
                }
                catch (Exception ee) {
                    this.logErr("Unexpected exception trying to persist a removed entity", ee);
                    pass = false;
                }
            } else {
                this.logTrace("Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test3() throws Exception {
        this.logTrace("Begin persist1X1Test3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            B b1 = new B("13", "b13", 13);
            A aRef = new A("13", "bean13", 13, b1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException e) {
            this.logTrace("IllegalStateException Caught as Expected:" + String.valueOf(e));
            pass = true;
            Object aRef = null;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test4() throws Exception {
        this.logTrace("Begin persist1X1Test4");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("4", "a4", 4);
            B bRef = new B("4", "bean4", 4, a1);
            this.getEntityManager().persist((Object)bRef);
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)a2)) {
                pass = true;
            } else {
                this.logErr("Unexpected results received - test failed");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test5() throws Exception {
        this.logTrace("Begin persist1X1Test5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New A instance");
            A a1 = new A("5", "a5", 5);
            this.logTrace("New B instance");
            B bRef = new B("5", "bean5", 5, a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get newly persisted A instance");
            A a2 = bRef.getA1();
            if (a1 == a2) {
                this.logTrace("try to remove a2 instance");
                this.getEntityManager().remove((Object)a2);
                this.logTrace("try to remove bRef instance");
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
            }
            A newA = this.findA("5");
            B newB = this.findB("5");
            if (null == newA && null == newB) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test6() throws Exception {
        this.logTrace("Begin persist1X1Test6");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("6", "a6", 6);
            B bRef = new B("6", "bean6", 6, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)bRef.getA1());
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test7() throws Exception {
        this.logTrace("Begin persist1X1Test7");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("7", "a7", 7);
            B bRef = new B("7", "bean7", 7, a1);
            this.getEntityManager().persist((Object)bRef);
            pass = this.getEntityManager().contains((Object)bRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test8() throws Exception {
        this.logTrace("Begin persist1X1Test8");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "bean8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("bref created, try find");
            A newA = this.findA("8");
            pass = this.getEntityManager().contains((Object)newA);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test9() throws Exception {
        this.logTrace("Begin persist1X1Test9");
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("9", "a9", 9);
            B bRef = new B("9", "bean9", 9, a1);
            pass = this.getEntityManager().contains((Object)bRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (pass) {
            throw new Exception("persist1X1Test9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test10() throws Exception {
        this.logTrace("Begin persist1X1Test10");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            B b1 = new B("10", "b10", 10);
            A aRef = new A("10", "bean10", 10, b1);
            pass1 = this.getEntityManager().contains((Object)b1);
            pass2 = this.getEntityManager().contains((Object)aRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (pass1 || pass2 || !pass) {
            this.logErr("pass=" + pass + ", pass1=" + pass1 + ", pass2=" + pass2);
            throw new Exception("persist1X1Test10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test11() throws Exception {
        this.logTrace("Begin persist1X1Test11");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("New instances");
            A a1 = new A("11", "a11", 11);
            B bRef = new B("11", "bean11", 11);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                B bRef1 = this.findB("11");
                bRef1.setA1(a1);
                this.getEntityManager().persist((Object)bRef1);
                this.getEntityManager().flush();
                pass = this.getEntityManager().contains((Object)a1);
                this.logTrace("try to find A");
                A a2 = this.findA("11");
                if (null != a2) {
                    this.logTrace("A2 is not null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist1X1Test12() throws Exception {
        this.logTrace("Begin persist1X1Test12");
        boolean pass = false;
        try {
            this.logTrace("New instances");
            A a1 = new A("12", "a12", 12);
            B bRef = new B("12", "bean12", 12, a1);
            this.createB(bRef);
            this.getEntityTransaction().begin();
            B b2 = this.findB("12");
            if (this.getEntityManager().contains((Object)b2)) {
                b2.setBName("newBean12");
                this.getEntityManager().flush();
                this.logTrace("getBName returns: " + b2.getBName());
                if (b2.getBName().equals("newBean12")) {
                    pass = true;
                }
            } else {
                this.logErr("Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test12 failed");
        }
    }

    private A findA(String id) {
        this.logTrace("Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        this.logTrace("Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private B findB(String id) {
        this.logTrace("Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        this.logTrace("Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

