/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkLine;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkPort;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.emc.simulink.util.StateflowUtil;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;

public class TypeHelper {
    private static final String LOAD_SIMULINK = "load_system simulink";
    private static final String FIND_SYSTEM = "sim = find_system('simulink', 'FindAll', 'on', 'LookUnderMasks', 'On', 'type', '?');";
    private static final String TYPES = "unique(get_param(sim, '?Type'));";
    private static final String FIND_KIND_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', 'type', '%s');";
    private static final String FIND_KIND = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'Type', '%s');";
    private static final String FIND_TYPE_WITH_REFS = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', 'FollowLinks', 'on', '%sType', '?');";
    private static final String FIND_TYPE = "find_system('?', 'FindAll', 'on', 'LookUnderMasks', 'On', '%sType', '?');";
    private static Map<String, String> map = new HashMap<String, String>();

    public static Kind getKind(String type) {
        if (type.toLowerCase().startsWith(Kind.STATEFLOW.name().toLowerCase())) {
            return Kind.STATEFLOW;
        }
        String kind = map.get(type);
        if (kind != null) {
            try {
                return Kind.get(kind);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static <T extends ISimulinkModelElement> Collection<T> getAllOfType(SimulinkModel model, MatlabEngine engine, String type) throws EolModelElementTypeNotFoundException {
        Kind kind = null;
        Collection<Object> list = Collections.emptyList();
        kind = TypeHelper.getKind(type);
        if (kind == null) {
            Collections.emptyList();
            Kind[] kindArray = Kind.values();
            int n = kindArray.length;
            int n2 = 0;
            while (n2 < n) {
                Kind k = kindArray[n2];
                try {
                    list = k.getAllSimulinkTypeFromModel(model, engine, type);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++n2;
                }
            }
        } else {
            try {
                return kind.getAllSimulinkTypeFromModel(model, engine, type);
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public static Collection<ISimulinkModelElement> getAll(MatlabEngine engine, SimulinkModel model) {
        ArrayList<ISimulinkModelElement> list = new ArrayList<ISimulinkModelElement>();
        list.addAll(Kind.SIMULINK.getAll(engine, model));
        list.addAll(Kind.STATEFLOW.getAll(engine, model));
        return list;
    }

    public static void put(String type, String supertype) {
        if (!map.containsKey(type)) {
            try {
                map.put(type, supertype);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("unable to add to types");
            }
        }
    }

    public static enum Kind {
        BLOCK("Block"),
        LINE("Line"),
        PORT("Port"),
        SIMULINK("Simulink"),
        STATEFLOW("Stateflow");

        private String kind;

        private Kind(String kind) {
            this.kind = kind;
        }

        public String getKind() {
            return this.kind;
        }

        public boolean is(String v) {
            return this.name().equalsIgnoreCase(v);
        }

        public boolean isSimulink() {
            return !this.equals((Object)STATEFLOW);
        }

        public <T extends ISimulinkModelElement> Collection<T> getAll(MatlabEngine engine, SimulinkModel model) {
            switch (this) {
                case BLOCK: 
                case LINE: 
                case PORT: {
                    try {
                        return this.getAllSimulinkKindFromModel(model, engine);
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case SIMULINK: {
                    ArrayList<T> list = new ArrayList<T>();
                    list.addAll(BLOCK.getAll(engine, model));
                    list.addAll(LINE.getAll(engine, model));
                    list.addAll(PORT.getAll(engine, model));
                    return list;
                }
                case STATEFLOW: {
                    try {
                        return StateflowUtil.getAllStateflowBlocksFromModel(model, engine);
                    }
                    catch (MatlabException matlabException) {}
                }
            }
            return Collections.emptyList();
        }

        private <T extends ISimulinkModelElement> Collection<T> getAllSimulinkKindFromModel(SimulinkModel model, MatlabEngine engine) throws MatlabException, IllegalStateException {
            try {
                String cmd = String.format(model.isFollowLinks() ? TypeHelper.FIND_KIND_WITH_REFS : TypeHelper.FIND_KIND, this.getKind());
                Object blocks = engine.evalWithResult(cmd, model.getSimulinkModelName());
                List<Object> list = Collections.emptyList();
                switch (this) {
                    case BLOCK: {
                        list = SimulinkUtil.getTypeList(SimulinkBlock.class, model, engine, blocks);
                        break;
                    }
                    case LINE: {
                        list = SimulinkUtil.getTypeList(SimulinkLine.class, model, engine, blocks);
                        break;
                    }
                    case PORT: {
                        list = SimulinkUtil.getTypeList(SimulinkPort.class, model, engine, blocks);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid Kind");
                    }
                }
                return list.stream().map(e -> (ISimulinkElement)e).collect(Collectors.toList());
            }
            catch (MatlabException matlabException) {
                return Collections.emptyList();
            }
        }

        private <T extends ISimulinkModelElement> Collection<T> getAllSimulinkTypeFromModel(SimulinkModel model, MatlabEngine engine, String type) throws Exception {
            List<Object> list = Collections.emptyList();
            Object blocks = null;
            if (this.isSimulink()) {
                String cmd = String.format(model.isFollowLinks() ? TypeHelper.FIND_TYPE_WITH_REFS : TypeHelper.FIND_TYPE, this.getKind());
                blocks = engine.evalWithResult(cmd, model.getSimulinkModelName(), type);
                switch (this) {
                    case BLOCK: {
                        list = SimulinkUtil.getTypeList(SimulinkBlock.class, model, engine, blocks);
                        break;
                    }
                    case LINE: {
                        list = SimulinkUtil.getTypeList(SimulinkLine.class, model, engine, blocks);
                        break;
                    }
                    case PORT: {
                        list = SimulinkUtil.getTypeList(SimulinkPort.class, model, engine, blocks);
                        break;
                    }
                }
                return list.stream().map(e -> (ISimulinkElement)e).collect(Collectors.toList());
            }
            if (this.equals((Object)STATEFLOW)) {
                return StateflowUtil.getAllOfStateflowTypeFromModel(model, engine, type);
            }
            throw new EolModelElementTypeNotFoundException(model.getName(), type);
        }

        public static Kind get(String kind) throws Exception {
            try {
                return Kind.valueOf(kind.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("Is not kind");
            }
        }
    }
}

