/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.jaas.JaasPasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ShellFactory;
import org.eclipse.equinox.console.internal.ssh.AuthorizedKeysFileAuthenticator;
import org.eclipse.equinox.console.ssh.SshShellFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SshServ
extends Thread {
    private final BundleContext context;
    private final int port;
    private final String host;
    private SshServer sshServer = null;
    private SshShellFactory shellFactory = null;
    private static final String SSH_KEYSTORE_PROP = "ssh.server.keystore";
    private static final String SSH_KEYSTORE_PROP_DEFAULT = "hostkey.ser";
    private static final String SSH_AUTHORIZED_KEYS_FILE_PROP = "ssh.server.authorized_keys";
    private static final String SSH_CUSTOM_PUBLIC_KEY_AUTHENTICATION = "ssh.custom.publickeys.auth";
    private static final String EQUINOX_CONSOLE_DOMAIN = "equinox_console";

    public SshServ(List<CommandProcessor> processors, BundleContext context, String host, int port) {
        this.context = context;
        this.host = host;
        this.port = port;
        this.shellFactory = new SshShellFactory(processors, context);
    }

    @Override
    public void run() throws RuntimeException {
        this.sshServer = SshServer.setUpDefaultServer();
        if (this.host != null) {
            this.sshServer.setHost(this.host);
        }
        this.sshServer.setPort(this.port);
        this.sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(Paths.get(System.getProperty(SSH_KEYSTORE_PROP, SSH_KEYSTORE_PROP_DEFAULT), new String[0])));
        this.sshServer.setShellFactory((ShellFactory)this.shellFactory);
        this.sshServer.setPasswordAuthenticator(this.createJaasPasswordAuthenticator());
        this.sshServer.setPublickeyAuthenticator(this.createSimpleAuthorizedKeysAuthenticator());
        try {
            this.sshServer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stopSshServer() {
        try {
            this.sshServer.stop(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addCommandProcessor(CommandProcessor processor) {
        this.shellFactory.addCommandProcessor(processor);
    }

    public synchronized void removeCommandProcessor(CommandProcessor processor) {
        this.shellFactory.removeCommandProcessor(processor);
    }

    private PasswordAuthenticator createJaasPasswordAuthenticator() {
        JaasPasswordAuthenticator jaasPasswordAuthenticator = new JaasPasswordAuthenticator();
        jaasPasswordAuthenticator.setDomain(EQUINOX_CONSOLE_DOMAIN);
        return jaasPasswordAuthenticator;
    }

    private PublickeyAuthenticator createSimpleAuthorizedKeysAuthenticator() {
        String authorizedKeysFile = System.getProperty(SSH_AUTHORIZED_KEYS_FILE_PROP);
        if (authorizedKeysFile != null) {
            AuthorizedKeysFileAuthenticator authenticator = new AuthorizedKeysFileAuthenticator();
            authenticator.setAuthorizedKeysFile(authorizedKeysFile);
            return authenticator;
        }
        String customPublicKeysAuthentication = System.getProperty(SSH_CUSTOM_PUBLIC_KEY_AUTHENTICATION);
        if ("true".equals(customPublicKeysAuthentication)) {
            return (username, key, session) -> {
                try {
                    for (ServiceReference reference : this.context.getServiceReferences(PublickeyAuthenticator.class, null)) {
                        PublickeyAuthenticator authenticator = null;
                        try {
                            authenticator = (PublickeyAuthenticator)this.context.getService(reference);
                            if (!authenticator.authenticate(username, key, session)) continue;
                            return true;
                        }
                        finally {
                            if (authenticator != null) {
                                this.context.ungetService(reference);
                            }
                        }
                    }
                    return false;
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
                return false;
            };
        }
        return null;
    }
}

