/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.eclipse.osgi.internal.log.EquinoxLogServices;

public class CSVParser {
    public static TransformTuple[] parse(URL transformMapURL, EquinoxLogServices logServices) throws IOException {
        ArrayList<TransformTuple> list = new ArrayList<TransformTuple>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(transformMapURL.openStream()));){
            String currentLine = null;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.startsWith("#") || (currentLine = currentLine.trim()).length() == 0) continue;
                StringTokenizer toker = new StringTokenizer(currentLine, ",");
                try {
                    String bundlePatternString = toker.nextToken().trim();
                    String pathPatternString = toker.nextToken().trim();
                    String transformPath = toker.nextToken().trim();
                    try {
                        Pattern bundlePattern = Pattern.compile(bundlePatternString);
                        Pattern pathPattern = Pattern.compile(pathPatternString);
                        URL transformerURL = new URL(transformMapURL, transformPath);
                        try {
                            Throwable throwable2 = null;
                            Object var15_21 = null;
                            try (InputStream exitsCheck = transformerURL.openStream();){
                                TransformTuple tuple = new TransformTuple();
                                tuple.bundlePattern = bundlePattern;
                                tuple.pathPattern = pathPattern;
                                tuple.transformerUrl = transformerURL;
                                list.add(tuple);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (IOException e) {
                            logServices.log("org.eclipse.osgi", 4, "Could not add transform :" + transformerURL.toString(), (Throwable)e);
                        }
                    }
                    catch (PatternSyntaxException e) {
                        logServices.log("org.eclipse.osgi", 4, "Could not add compile transform matching regular expression", (Throwable)e);
                    }
                }
                catch (NoSuchElementException e) {
                    logServices.log("org.eclipse.osgi", 4, "Could not parse transform file record :" + currentLine, (Throwable)e);
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return list.toArray(new TransformTuple[list.size()]);
    }
}

