/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.equinox.internal.transforms.StreamTransformer;

public class ProxyStreamTransformer
extends StreamTransformer {
    private final Method method;
    private final Object object;

    public ProxyStreamTransformer(Object object) throws SecurityException, NoSuchMethodException {
        this.object = object;
        this.method = object.getClass().getMethod("getInputStream", InputStream.class, URL.class);
        Class<?> returnType = this.method.getReturnType();
        if (!returnType.equals(InputStream.class)) {
            throw new NoSuchMethodException();
        }
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, URL transformerUrl) throws IOException {
        try {
            return (InputStream)this.method.invoke(this.object, inputStream, transformerUrl);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            return null;
        }
    }

    public Object getTransformer() {
        return this.object;
    }
}

