/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.AddProfileDialog;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.model.Profiles;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.dialogs.ListDialog;

public class InstallAction
extends ProfileModificationAction {
    String userChosenProfileId;

    public InstallAction(ProvisioningUI ui, ISelectionProvider selectionProvider) {
        super(ui, ProvUI.INSTALL_COMMAND_LABEL, selectionProvider, null);
        this.setToolTipText(ProvUI.INSTALL_COMMAND_TOOLTIP);
        this.userChosenProfileId = ui.getProfileId();
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        if (selectionArray.length == 0) {
            return false;
        }
        Object[] objectArray = selectionArray;
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectionArray1 = objectArray[n2];
            if (selectionArray1 instanceof InstalledIUElement && this.isSelectable((IIUElement)selectionArray1)) {
                return true;
            }
            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)selectionArray1, IInstallableUnit.class);
            if (iu != null && this.isSelectable(iu)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        return super.isSelectable(element) && !(element.getParent((Object)element) instanceof AvailableIUElement);
    }

    protected int performAction(ProfileChangeOperation operation, Collection<IInstallableUnit> ius) {
        ProvisioningUI ui = ProvAdminUIActivator.getDefault().getProvisioningUI(this.userChosenProfileId);
        operation.setProfileId(this.userChosenProfileId);
        int ret = ui.openInstallWizard(ius, (InstallOperation)operation, null);
        this.userChosenProfileId = null;
        return ret;
    }

    protected ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> ius) {
        InstallOperation op = new InstallOperation(this.getSession(), ius);
        op.setProfileId(this.userChosenProfileId);
        return op;
    }

    protected boolean isInvalidProfileId() {
        if (this.userChosenProfileId == null) {
            this.userChosenProfileId = this.getUserChosenProfileId();
        }
        return this.userChosenProfileId == null;
    }

    private String getUserChosenProfileId() {
        IProfile profile;
        IProfileRegistry registry = ProvAdminUIActivator.getDefault().getProfileRegistry();
        if (registry.getProfiles().length == 0) {
            AddProfileDialog dialog = new AddProfileDialog(this.getShell(), new String[0]);
            if (dialog.open() == 0) {
                return dialog.getAddedProfileId();
            }
            return null;
        }
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setTitle(ProvAdminUIMessages.InstallAction_ChooseProfile);
        dialog.setLabelProvider((ILabelProvider)new ProvElementLabelProvider());
        dialog.setInput((Object)new Profiles(this.getProvisioningUI()));
        dialog.setContentProvider((IStructuredContentProvider)new ProvElementContentProvider());
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0 && (profile = (IProfile)ProvUI.getAdapter((Object)result[0], IProfile.class)) != null) {
            return profile.getProfileId();
        }
        return null;
    }

    protected void runCanceled() {
        super.runCanceled();
        this.userChosenProfileId = null;
    }
}

