/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.SvgAbsmoveModification;
import org.eclipse.escet.chi.runtime.SvgAttribModification;
import org.eclipse.escet.chi.runtime.SvgCopyModification;
import org.eclipse.escet.chi.runtime.SvgTextModification;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.svg.SvgCanvas;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgVisualizer;
import org.eclipse.swt.widgets.Display;

public class ChiSvgOutput
extends ChiFileHandle {
    private boolean debug = false;
    private int openCount = 0;
    private final ChiCoordinator coord;
    private final String svgPath;
    private String text = "";
    public final SvgVisualizer svgVis;
    private final SvgCanvas canvas;
    private boolean firstDone = false;
    private double curModelTime = 0.0;
    private boolean isChanged = true;
    private double prevModelTime;
    private long prevRealTime;

    public ChiSvgOutput(ChiCoordinator coord, String filename) {
        super(filename, "w");
        this.coord = coord;
        Assert.check((boolean)filename.startsWith("SVG:"));
        this.svgPath = filename.substring(4);
        String svgAbsPath = Paths.resolve((String)this.svgPath);
        this.svgVis = (SvgVisualizer)ControlEditor.show((String)svgAbsPath, SvgVisualizer.class, (String)"SVG visualizer");
        SvgException svgLoadErr = this.svgVis.getSvgError();
        if (svgLoadErr != null) {
            throw svgLoadErr;
        }
        this.canvas = this.svgVis.getSvgCanvas();
        this.canvas.path = this.svgPath;
    }

    @Override
    public int read() {
        String msg = "Cannot read from a SVG output.";
        throw new RuntimeException(msg);
    }

    @Override
    public void markStream(int count) {
        String msg = "Cannot mark the stream of a SVG output.";
        throw new RuntimeException(msg);
    }

    @Override
    public void resetStream() {
        String msg = "Cannot reset the stream of a SVG output.";
        throw new RuntimeException(msg);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(String line) {
        if (this.openCount == 0) {
            return;
        }
        if (!this.svgVis.isAvailable()) {
            this.openCount = 0;
            this.coord.setTerminateAll(null);
            return;
        }
        this.text = String.valueOf(this.text) + line;
        eolIndex = this.text.indexOf(10);
        if (eolIndex >= 0) ** GOTO lbl33
        return;
lbl-1000:
        // 1 sources

        {
            line = this.text.substring(0, eolIndex);
            this.text = this.text.substring(eolIndex + 1);
            eolIndex = this.text.indexOf(10);
            sm = SvgAttribModification.decode(line, this.svgPath);
            if (sm == null) {
                sm = SvgTextModification.decode(line, this.svgPath);
            }
            if (sm == null) {
                sm = SvgCopyModification.decode(line, this.svgPath);
            }
            if (sm == null) {
                sm = SvgAbsmoveModification.decode(line, this.svgPath);
            }
            v0 = redraw = sm == null && line.equals("redraw") != false;
            if (sm == null && !redraw) {
                msg = Strings.fmt((String)"SVG command \"%s\" was not understood.", (Object[])new Object[]{line});
                throw new InputOutputException(msg);
            }
            if (redraw || this.curModelTime != this.coord.getCurrentTime()) {
                if (this.isChanged) {
                    this.displaySvg();
                }
                this.isChanged = false;
            }
            this.curModelTime = this.coord.getCurrentTime();
            if (sm == null) continue;
            sm.apply(this.svgVis);
            this.isChanged = true;
lbl33:
            // 3 sources

            ** while (eolIndex >= 0)
        }
lbl34:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySvg() {
        int height;
        int width;
        byte[] pixelData;
        if (!this.firstDone) {
            try {
                this.canvas.updateImageSize();
            }
            catch (InvalidInputException ex) {
                String msg = Strings.fmt((String)"Failed to update image size for SVG image file \"%s\".", (Object[])new Object[]{this.svgPath});
                throw new InvalidInputException(msg, (Throwable)ex);
            }
        }
        Assert.check(((pixelData = this.canvas.paintInMemory(width = this.canvas.getImageWidth(), height = this.canvas.getImageHeight())).length > 0 ? 1 : 0) != 0);
        Object object = this.canvas.pixelDataLock;
        synchronized (object) {
            this.canvas.pixelData = pixelData;
        }
        if (!this.firstDone) {
            this.prevModelTime = this.curModelTime;
            this.prevRealTime = System.nanoTime();
        } else {
            double modelStep = this.curModelTime - this.prevModelTime;
            if (this.debug) {
                System.out.printf("modelStep = %f - %f = %f units\n", this.curModelTime, this.prevModelTime, modelStep);
            }
            long elapsedRealTime = System.nanoTime() - this.prevRealTime;
            if (this.debug) {
                System.out.printf("elapsed = %d ns = %f s\n", elapsedRealTime, (double)elapsedRealTime / 1.0E9);
            }
            long delayNanos = (long)(modelStep * 1.0E9) - elapsedRealTime;
            long delayMillis = delayNanos / 1000L / 1000L;
            if (this.debug) {
                System.out.printf("delay = %d ns = %d ms = %f s\n", delayNanos, delayMillis, (double)delayMillis / 1000.0);
            }
            if (delayMillis > 0L) {
                try {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.prevModelTime = this.curModelTime;
            this.prevRealTime = System.nanoTime();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ChiSvgOutput.this.canvas.isDisposed()) {
                    return;
                }
                int width = ChiSvgOutput.this.canvas.getImageWidth();
                int height = ChiSvgOutput.this.canvas.getImageHeight();
                ChiSvgOutput.this.canvas.redraw(0, 0, width, height, true);
            }
        });
        if (!this.firstDone) {
            this.svgVis.initDone();
            this.firstDone = true;
        }
    }

    public void openCalled() {
        ++this.openCount;
    }

    @Override
    public boolean isClosed() {
        return this.openCount == 0;
    }

    @Override
    public void close() {
        --this.openCount;
        if (this.openCount == 0) {
            this.displaySvg();
        }
    }

    public void closeDown() {
        if (this.openCount != 0) {
            this.displaySvg();
        }
        this.openCount = 0;
    }
}

