/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.IOException;
import java.io.InputStream;

public class PositionTrackingInputStream
extends InputStream {
    private static final int EOF = -1;
    private final InputStream stream;
    private long prevPos = -1L;
    private long prevLine = -1L;
    private long prevCol = -1L;
    private long nextPos = 0L;
    private long nextLine = 1L;
    private long nextCol = 1L;
    private long markedPrevPos = -1L;
    private long markedPrevLine = -1L;
    private long markedPrevCol = -1L;
    private long markedNextPos = -1L;
    private long markedNextLine = -1L;
    private long markedNextCol = -1L;

    public PositionTrackingInputStream(InputStream stream) {
        this.stream = stream;
    }

    public long getPrevPos() {
        return this.prevPos;
    }

    public long getPrevLine() {
        return this.prevLine;
    }

    public long getPrevCol() {
        return this.prevCol;
    }

    @Override
    public int read() throws IOException {
        int c = this.stream.read();
        this.prevPos = this.nextPos++;
        this.prevLine = this.nextLine++;
        this.prevCol = this.nextCol++;
        if (c != -1 && c == 10) {
            this.nextCol = 1L;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
        this.markedPrevPos = this.prevPos;
        this.markedPrevLine = this.prevLine;
        this.markedPrevCol = this.prevCol;
        this.markedNextPos = this.nextPos;
        this.markedNextLine = this.nextLine;
        this.markedNextCol = this.nextCol;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markedNextPos == -1L) {
            throw new IllegalStateException();
        }
        this.stream.reset();
        this.prevPos = this.markedPrevPos;
        this.prevLine = this.markedPrevLine;
        this.prevCol = this.markedPrevCol;
        this.nextPos = this.markedNextPos;
        this.nextLine = this.markedNextLine;
        this.nextCol = this.markedNextCol;
        this.markedPrevPos = -1L;
        this.markedPrevLine = -1L;
        this.markedPrevCol = -1L;
        this.markedNextPos = -1L;
        this.markedNextLine = -1L;
        this.markedNextCol = -1L;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

