/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.codegen.updates.ReadWriteDeclarations;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BaseFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.common.java.Strings;

public class FindDeclarationUsage {
    private FindDeclarationUsage() {
    }

    public static void collectAssign(Expression expr, ReadWriteDeclarations rwDecls) {
        while (expr instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)expr;
            FindDeclarationUsage.collectUse(projExpr.getIndex(), rwDecls.read);
            expr = projExpr.getChild();
        }
        if (expr instanceof DiscVariableExpression) {
            rwDecls.written.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof ContVariableExpression) {
            rwDecls.written.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof InputVariableExpression) {
            rwDecls.written.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression tupleExpr = (TupleExpression)expr;
            for (Expression fieldExpr : tupleExpr.getFields()) {
                FindDeclarationUsage.collectAssign(fieldExpr, rwDecls);
            }
            return;
        }
        throw new RuntimeException("Unexpected assigned expression node " + Strings.str((Object)expr));
    }

    public static void collectUse(Expression expr, Set<VariableWrapper> accessedDecls) {
        if (expr instanceof BoolExpression) {
            return;
        }
        if (expr instanceof IntExpression) {
            return;
        }
        if (expr instanceof RealExpression) {
            return;
        }
        if (expr instanceof StringExpression) {
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            return;
        }
        if (expr instanceof BaseFunctionExpression) {
            return;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof ConstantExpression) {
            return;
        }
        if (expr instanceof TimeExpression) {
            accessedDecls.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof CastExpression) {
            CastExpression expr2 = (CastExpression)expr;
            FindDeclarationUsage.collectUse(expr2.getChild(), accessedDecls);
            return;
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression expr2 = (UnaryExpression)expr;
            FindDeclarationUsage.collectUse(expr2.getChild(), accessedDecls);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression expr2 = (BinaryExpression)expr;
            FindDeclarationUsage.collectUse(expr2.getLeft(), accessedDecls);
            FindDeclarationUsage.collectUse(expr2.getRight(), accessedDecls);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression expr2 = (IfExpression)expr;
            FindDeclarationUsage.collectUse((List<Expression>)expr2.getGuards(), accessedDecls);
            FindDeclarationUsage.collectUse(expr2.getThen(), accessedDecls);
            FindDeclarationUsage.collectUseElifs((List<ElifExpression>)expr2.getElifs(), accessedDecls);
            FindDeclarationUsage.collectUse(expr2.getElse(), accessedDecls);
            return;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression expr2 = (ProjectionExpression)expr;
            FindDeclarationUsage.collectUse(expr2.getChild(), accessedDecls);
            FindDeclarationUsage.collectUse(expr2.getIndex(), accessedDecls);
            return;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression expr2 = (FunctionCallExpression)expr;
            FindDeclarationUsage.collectUse(expr2.getFunction(), accessedDecls);
            FindDeclarationUsage.collectUse((List<Expression>)expr2.getArguments(), accessedDecls);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression expr2 = (ListExpression)expr;
            FindDeclarationUsage.collectUse((List<Expression>)expr2.getElements(), accessedDecls);
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression expr2 = (TupleExpression)expr;
            FindDeclarationUsage.collectUse((List<Expression>)expr2.getFields(), accessedDecls);
            return;
        }
        if (expr instanceof DiscVariableExpression) {
            accessedDecls.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof AlgVariableExpression) {
            accessedDecls.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof ContVariableExpression) {
            accessedDecls.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        if (expr instanceof InputVariableExpression) {
            accessedDecls.add(VariableWrapper.makeVariableWrapper(expr));
            return;
        }
        throw new RuntimeException("Unexpected usage expression node " + Strings.str((Object)expr));
    }

    public static void collectUse(List<Expression> exprs, Set<VariableWrapper> accessedDecls) {
        for (Expression e : exprs) {
            FindDeclarationUsage.collectUse(e, accessedDecls);
        }
    }

    private static void collectUseElifs(List<ElifExpression> elifs, Set<VariableWrapper> accessedDecls) {
        for (ElifExpression elif : elifs) {
            FindDeclarationUsage.collectUse((List<Expression>)elif.getGuards(), accessedDecls);
            FindDeclarationUsage.collectUse(elif.getThen(), accessedDecls);
        }
    }
}

