/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class ExponentialDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final double b;

    public ExponentialDistribution(CifRandomGenerator randGen, double b) {
        this.randGen = randGen;
        this.b = b;
        if (b <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The scale parameter is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private ExponentialDistribution(ExponentialDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.b = distribution.b;
    }

    @Override
    public RealDistribution copy() {
        return new ExponentialDistribution(this);
    }

    @Override
    public double sample() {
        return ExponentialDistribution.sample(this.randGen, this.b);
    }

    public static double sample(CifRandomGenerator randGen, double b) {
        return -b * Math.log(1.0 - randGen.draw());
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"exponential(%s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.b)});
    }
}

