/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.List;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.BoundedResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.confluence.ConfluenceCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.FiniteResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.nonblockingundercontrol.NonBlockingUnderControlCheckConclusion;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Assert;

public class ControllerCheckerResult {
    public final BoundedResponseCheckConclusion boundedResponseConclusion;
    public final ConfluenceCheckConclusion confluenceConclusion;
    public final FiniteResponseCheckConclusion finiteResponseConclusion;
    public final NonBlockingUnderControlCheckConclusion nonBlockingUnderControlConclusion;

    public ControllerCheckerResult(List<CheckConclusion> conclusions) {
        BoundedResponseCheckConclusion boundedResponseConclusion = null;
        ConfluenceCheckConclusion confluenceConclusion = null;
        FiniteResponseCheckConclusion finiteResponseConclusion = null;
        NonBlockingUnderControlCheckConclusion nonBlockingUnderControlConclusion = null;
        for (CheckConclusion conclusion : conclusions) {
            if (conclusion instanceof BoundedResponseCheckConclusion) {
                BoundedResponseCheckConclusion brConclusion = (BoundedResponseCheckConclusion)conclusion;
                Assert.check((boundedResponseConclusion == null ? 1 : 0) != 0);
                boundedResponseConclusion = brConclusion;
                continue;
            }
            if (conclusion instanceof ConfluenceCheckConclusion) {
                ConfluenceCheckConclusion cConclusion = (ConfluenceCheckConclusion)conclusion;
                Assert.check((confluenceConclusion == null ? 1 : 0) != 0);
                confluenceConclusion = cConclusion;
                continue;
            }
            if (conclusion instanceof FiniteResponseCheckConclusion) {
                FiniteResponseCheckConclusion frConclusion = (FiniteResponseCheckConclusion)conclusion;
                Assert.check((finiteResponseConclusion == null ? 1 : 0) != 0);
                finiteResponseConclusion = frConclusion;
                continue;
            }
            if (conclusion instanceof NonBlockingUnderControlCheckConclusion) {
                NonBlockingUnderControlCheckConclusion nbucConclusion = (NonBlockingUnderControlCheckConclusion)conclusion;
                Assert.check((nonBlockingUnderControlConclusion == null ? 1 : 0) != 0);
                nonBlockingUnderControlConclusion = nbucConclusion;
                continue;
            }
            throw new RuntimeException("Unknown conclusion: " + String.valueOf(conclusion));
        }
        this.boundedResponseConclusion = boundedResponseConclusion;
        this.confluenceConclusion = confluenceConclusion;
        this.finiteResponseConclusion = finiteResponseConclusion;
        this.nonBlockingUnderControlConclusion = nonBlockingUnderControlConclusion;
        if (boundedResponseConclusion != null && finiteResponseConclusion != null && finiteResponseConclusion.propertyHolds()) {
            Assert.check((boolean)boundedResponseConclusion.controllablesBound.isBounded());
        }
    }

    public boolean noFailureFound() {
        boolean result = true;
        result &= this.boundedResponseConclusion == null || this.boundedResponseConclusion.propertyHolds();
        result &= this.confluenceConclusion == null || this.confluenceConclusion.propertyHolds();
        result &= this.finiteResponseConclusion == null || this.finiteResponseConclusion.propertyHolds();
        return result &= this.nonBlockingUnderControlConclusion == null || this.nonBlockingUnderControlConclusion.propertyHolds();
    }

    public void updateSpecification(Specification spec) {
        if (this.boundedResponseConclusion != null) {
            Integer unctrlBound = this.boundedResponseConclusion.propertyHolds() ? Integer.valueOf(this.boundedResponseConclusion.uncontrollablesBound.getBound()) : null;
            Integer ctrlBound = this.boundedResponseConclusion.propertyHolds() ? Integer.valueOf(this.boundedResponseConclusion.controllablesBound.getBound()) : null;
            CifControllerPropertiesAnnotationUtils.setBoundedResponse((Specification)spec, (Integer)unctrlBound, (Integer)ctrlBound);
        }
        if (this.confluenceConclusion != null) {
            CifControllerPropertiesAnnotationUtils.setConfluence((Specification)spec, (boolean)this.confluenceConclusion.propertyHolds());
        }
        if (this.finiteResponseConclusion != null) {
            CifControllerPropertiesAnnotationUtils.setFiniteResponse((Specification)spec, (boolean)this.finiteResponseConclusion.propertyHolds());
        }
        if (this.nonBlockingUnderControlConclusion != null) {
            CifControllerPropertiesAnnotationUtils.setNonBlockingUnderControl((Specification)spec, (boolean)this.nonBlockingUnderControlConclusion.propertyHolds());
        }
    }
}

