/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifDocAnnotationUtils {
    public static final String NAME = "doc";

    private CifDocAnnotationUtils() {
    }

    public static List<String> getDocs(AnnotatedObject obj) {
        return CifAnnotationUtils.getAnnotations(obj, NAME).map(a -> CifDocAnnotationUtils.getDoc(a)).toList();
    }

    public static String getDoc(Annotation docAnno) {
        return docAnno.getArguments().stream().map(arg -> CifDocAnnotationUtils.getDoc(arg)).collect(Collectors.joining("\n"));
    }

    private static String getDoc(AnnotationArgument docAnnoArg) {
        try {
            Object value = CifEvalUtils.eval(docAnnoArg.getValue(), false);
            return (String)value;
        }
        catch (CifEvalException e) {
            AnnotatedObject annotatedObj = (AnnotatedObject)docAnnoArg.eContainer().eContainer();
            if (CifTextUtils.hasName((PositionObject)annotatedObj)) {
                String msg = Strings.fmt((String)"Failed to evaluate an argument of the \"doc\" annotation of \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)annotatedObj)});
                throw new InvalidModelException(msg, (Throwable)e);
            }
            throw new InvalidModelException("Failed to evaluate an argument of a \"doc\" annotation.", (Throwable)e);
        }
    }
}

