/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps.conversion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.eventbased.apps.conversion.CifOrigin;
import org.eclipse.escet.cif.eventbased.automata.AutomatonComparator;
import org.eclipse.escet.cif.eventbased.automata.AutomatonKind;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ConvertToEventBased {
    public Map<org.eclipse.escet.cif.metamodel.cif.declarations.Event, Event> events;
    public List<org.eclipse.escet.cif.eventbased.automata.Automaton> automata;
    public Map<String, Automaton> origAutoms = Maps.map();

    public void convertSpecification(Specification spec) {
        this.events = Maps.map();
        this.automata = Lists.list();
        this.convertComponent((ComplexComponent)spec);
    }

    public void sortAutomata() {
        Collections.sort(this.automata, AutomatonComparator.INSTANCE);
    }

    private static boolean getBooleanValue(List<Expression> preds, boolean defaultValue, boolean initial) {
        if (preds.isEmpty()) {
            return defaultValue;
        }
        if (CifValueUtils.isTriviallyTrue(preds, (boolean)initial, (boolean)true)) {
            return true;
        }
        if (CifValueUtils.isTriviallyFalse(preds, (boolean)initial, (boolean)true)) {
            return false;
        }
        throw new RuntimeException("Precondition violation.");
    }

    private Event convertEvent(Expression expr) {
        Assert.check((boolean)(expr instanceof EventExpression));
        org.eclipse.escet.cif.metamodel.cif.declarations.Event evt = ((EventExpression)expr).getEvent();
        Event autEvt = this.events.get(evt);
        if (autEvt != null) {
            return autEvt;
        }
        Event.EventControllability eventContr = evt.getControllable() == null ? Event.EventControllability.PLAIN_EVENT : (evt.getControllable() != false ? Event.EventControllability.CONTR_EVENT : Event.EventControllability.UNCONTR_EVENT);
        autEvt = new Event(CifTextUtils.getAbsName((PositionObject)evt, (boolean)false), eventContr);
        this.events.put(evt, autEvt);
        return autEvt;
    }

    private void convertComponent(ComplexComponent comp) {
        if (comp instanceof Automaton) {
            this.convertAutomaton((Automaton)comp);
            return;
        }
        if (comp instanceof Group) {
            Group group = (Group)comp;
            for (Component cmp : group.getComponents()) {
                this.convertComponent((ComplexComponent)cmp);
            }
            return;
        }
        throw new RuntimeException("Unexpected component: " + String.valueOf(comp));
    }

    private void convertAutomaton(Automaton aut) {
        Set alphabet = Sets.set();
        if (aut.getAlphabet() == null) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Event event = this.convertEvent(edgeEvent.getEvent());
                        alphabet.add(event);
                    }
                }
            }
        } else {
            for (Expression evt : aut.getAlphabet().getEvents()) {
                Event event = this.convertEvent(evt);
                alphabet.add(event);
            }
        }
        Set monitors = null;
        if (aut.getMonitors() != null) {
            EList monEvents = aut.getMonitors().getEvents();
            if (monEvents.isEmpty()) {
                monitors = alphabet;
            } else {
                monitors = Sets.setc((int)monEvents.size());
                for (Expression exprevt : monEvents) {
                    Event event = this.convertEvent(exprevt);
                    monitors.add(event);
                }
            }
        }
        org.eclipse.escet.cif.eventbased.automata.Automaton resAut = new org.eclipse.escet.cif.eventbased.automata.Automaton(alphabet);
        switch (aut.getKind()) {
            case NONE: {
                resAut.kind = AutomatonKind.UNKNOWN;
                break;
            }
            case PLANT: {
                resAut.kind = AutomatonKind.PLANT;
                break;
            }
            case REQUIREMENT: {
                resAut.kind = AutomatonKind.REQUIREMENT;
                break;
            }
            case SUPERVISOR: {
                resAut.kind = AutomatonKind.SUPERVISOR;
            }
        }
        resAut.name = CifTextUtils.getAbsName((PositionObject)aut);
        this.origAutoms.put(resAut.name, aut);
        Set seen = Sets.set();
        Map locs = Maps.map();
        for (Location loc : aut.getLocations()) {
            org.eclipse.escet.cif.eventbased.automata.Location srcLoc = this.convertLocation(loc, locs, resAut);
            if (monitors != null) {
                seen.clear();
            }
            for (Edge edge : loc.getEdges()) {
                org.eclipse.escet.cif.eventbased.automata.Location dstLoc = edge.getTarget() == null ? srcLoc : this.convertLocation(edge.getTarget(), locs, resAut);
                boolean guard = ConvertToEventBased.getBooleanValue((List<Expression>)edge.getGuards(), true, false);
                for (EdgeEvent ee : edge.getEvents()) {
                    Event evt = this.convertEvent(ee.getEvent());
                    if (!guard) continue;
                    org.eclipse.escet.cif.eventbased.automata.Edge.addEdge(evt, srcLoc, dstLoc);
                    if (monitors == null) continue;
                    seen.add(evt);
                }
            }
            if (monitors == null) continue;
            for (Event evt : monitors) {
                if (seen.contains(evt)) continue;
                org.eclipse.escet.cif.eventbased.automata.Edge.addEdge(evt, srcLoc, srcLoc);
            }
        }
        this.automata.add(resAut);
    }

    private org.eclipse.escet.cif.eventbased.automata.Location convertLocation(Location loc, Map<Location, org.eclipse.escet.cif.eventbased.automata.Location> locations, org.eclipse.escet.cif.eventbased.automata.Automaton resAut) {
        org.eclipse.escet.cif.eventbased.automata.Location resLoc = locations.get(loc);
        if (resLoc != null) {
            return resLoc;
        }
        CifOrigin org = new CifOrigin(loc);
        resLoc = new org.eclipse.escet.cif.eventbased.automata.Location(resAut, org);
        resLoc.marked = ConvertToEventBased.getBooleanValue((List<Expression>)loc.getMarkeds(), false, false);
        locations.put(loc, resLoc);
        if (ConvertToEventBased.getBooleanValue((List<Expression>)loc.getInitials(), false, true)) {
            Assert.areEqual((Object)resAut.initial, null);
            resAut.setInitial(resLoc);
        }
        return resLoc;
    }
}

