/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import java.util.List;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.Statement;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.VoidType;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckExpression;
import org.eclipse.escet.chi.typecheck.CheckStatement;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.VariableSymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class DeclarationSymbolEntry
extends SymbolEntry {
    protected CheckContext parameterCtxt = null;

    public DeclarationSymbolEntry(boolean mustBeUsed, CheckContext ctxt) {
        super(mustBeUsed, ctxt);
    }

    protected List<VariableDeclaration> checkParameters(boolean printable) {
        Assert.check((this.parameterCtxt == null ? 1 : 0) != 0);
        List newVars = Lists.list();
        this.parameterCtxt = this.ctxt.newSymbolContext();
        for (VariableDeclaration vd : this.getOriginalDecl().getVariables()) {
            if (!vd.isParameter()) continue;
            Type nType = CheckType.transNonvoidType(vd.getType(), this.ctxt);
            Assert.check((vd.getInitialValue() == null ? 1 : 0) != 0);
            boolean cond = !printable || CheckType.isPrintable(nType);
            this.ctxt.checkThrowError(cond, Message.INCORRECT_MODEL_PARAM_TYPE, vd.getType().getPosition(), CheckType.toString(nType));
            VariableDeclaration nv = ChiConstructors.newVariableDeclaration(null, (String)vd.getName(), (Boolean)true, (Position)PositionUtils.copyPosition((PositionObject)vd), (Type)nType);
            newVars.add(nv);
            VariableSymbolEntry se = new VariableSymbolEntry(true, nv, this.ctxt);
            this.parameterCtxt.addSymbol(se);
        }
        return newVars;
    }

    protected Type checkExitType(Type eTp, CheckContext ctxt) {
        if (eTp == null) {
            return null;
        }
        if (CheckType.isPrintable(eTp = CheckType.transType(eTp, ctxt = ctxt.remove(CheckContext.ContextItem.NO_VOID)))) {
            return eTp;
        }
        Type tp = CheckType.dropReferences(eTp);
        if (tp instanceof VoidType) {
            return eTp;
        }
        ctxt.throwError(Message.EXIT_TYPE_IS_NOT_A_PRINTABLE_VALUE, eTp.getPosition(), CheckType.toString(eTp));
        return null;
    }

    protected void checkBody(BehaviourDeclaration newDecl, CheckContext ctxt) {
        CheckContext xtxt = ctxt.newSymbolContext();
        for (VariableDeclaration vd : this.getOriginalDecl().getVariables()) {
            if (vd.isParameter()) continue;
            Type nType = CheckType.transNonvoidType(vd.getType(), xtxt);
            Expression newInitial = null;
            if (vd.getInitialValue() != null) {
                newInitial = CheckExpression.transExpression(vd.getInitialValue(), xtxt);
                boolean cond = CheckType.matchType(newInitial.getType(), nType);
                xtxt.checkThrowError(cond, Message.CANNOT_ASSIGN, vd.getPosition(), CheckType.toString(newInitial.getType()), CheckType.toString(nType));
            }
            VariableDeclaration nv = ChiConstructors.newVariableDeclaration((Expression)newInitial, (String)vd.getName(), (Boolean)false, (Position)PositionUtils.copyPosition((PositionObject)vd), (Type)nType);
            newDecl.getVariables().add((Object)nv);
            VariableSymbolEntry se = new VariableSymbolEntry(true, nv, ctxt);
            xtxt.addSymbol(se);
        }
        List<Statement> newStats = CheckStatement.transStatementList((List<Statement>)this.getOriginalDecl().getStatements(), xtxt);
        newDecl.getStatements().addAll(newStats);
        xtxt.checkSymbolUsage();
        this.parameterCtxt.checkSymbolUsage();
    }

    protected abstract BehaviourDeclaration getOriginalDecl();

    protected abstract BehaviourDeclaration getNewDecl();

    public List<Type> getParameterTypes() {
        List parms = Lists.list();
        for (VariableDeclaration vd : this.getNewDecl().getVariables()) {
            if (!vd.isParameter()) continue;
            parms.add(CheckType.copyType(vd.getType()));
        }
        return parms;
    }
}

