/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_;
import org.knowm.xchart.internal.chartpart.Formatter_Number;
import org.knowm.xchart.internal.chartpart.Formatter_String;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;

class AxisTickCalculator_Category
extends AxisTickCalculator_ {
    public AxisTickCalculator_Category(Axis.Direction axisDirection, double workingSpace, List<?> categories, Series.DataType axisType, AxesChartStyler styler) {
        super(axisDirection, workingSpace, Double.NaN, Double.NaN, styler);
        this.calculate(categories, axisType);
    }

    private void calculate(List<?> categories, Series.DataType axisType) {
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        double margin = Utils.getTickStartOffset(this.workingSpace, tickSpace);
        double gridStep = tickSpace / (double)categories.size();
        double firstPosition = gridStep / 2.0;
        int xAxisMaxLabelCount = this.styler.getXAxisMaxLabelCount();
        if (xAxisMaxLabelCount == 1) {
            throw new IllegalArgumentException("Unsupported max label count equal to 1");
        }
        if (0 < xAxisMaxLabelCount && xAxisMaxLabelCount < categories.size()) {
            ArrayList sparseCategories = new ArrayList();
            double step = (double)categories.size() / (double)(xAxisMaxLabelCount - 1);
            double stepIdx = 0.0;
            while (Math.round(stepIdx) < (long)categories.size()) {
                int idx = (int)Math.round(stepIdx);
                Object label = categories.get(idx);
                sparseCategories.add(label);
                stepIdx += step;
            }
            Object lastLabel = categories.get(categories.size() - 1);
            sparseCategories.add(lastLabel);
            categories = sparseCategories;
            gridStep = tickSpace / (double)(categories.size() - 1);
            firstPosition = 0.0;
        }
        if (axisType == Series.DataType.String) {
            this.axisFormat = new Formatter_String();
        } else if (axisType == Series.DataType.Number) {
            this.axisFormat = new Formatter_Number(this.styler, this.axisDirection, this.minValue, this.maxValue);
        } else if (axisType == Series.DataType.Date) {
            if (this.styler.getDatePattern() == null) {
                throw new RuntimeException("You need to set the Date Formatting Pattern!!!");
            }
            SimpleDateFormat simpleDateformat = new SimpleDateFormat(this.styler.getDatePattern(), this.styler.getLocale());
            simpleDateformat.setTimeZone(this.styler.getTimezone());
            this.axisFormat = simpleDateformat;
        }
        int counter = 0;
        for (Object category : categories) {
            if (axisType == Series.DataType.String) {
                this.tickLabels.add(category.toString());
            } else if (axisType == Series.DataType.Number) {
                this.tickLabels.add(this.axisFormat.format(new BigDecimal(category.toString()).doubleValue()));
            } else if (axisType == Series.DataType.Date) {
                this.tickLabels.add(this.axisFormat.format(((Date)category).getTime()));
            }
            double tickLabelPosition = margin + firstPosition + gridStep * (double)counter++;
            this.tickLocations.add(tickLabelPosition);
        }
    }
}

