/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.Position;

public class PrintFileIntoDecls
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Pushing print file declarations inwards for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.push((ComplexComponent)spec, null);
    }

    private void push(ComplexComponent comp, PrintFile printFile) {
        Iterator ioIter = comp.getIoDecls().iterator();
        while (ioIter.hasNext()) {
            IoDecl ioDecl = (IoDecl)ioIter.next();
            if (!(ioDecl instanceof PrintFile)) continue;
            printFile = (PrintFile)ioDecl;
            ioIter.remove();
        }
        for (IoDecl ioDecl : comp.getIoDecls()) {
            Assert.check((!(ioDecl instanceof PrintFile) ? 1 : 0) != 0);
            if (!(ioDecl instanceof Print)) continue;
            this.push((Print)ioDecl, printFile);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.push((ComplexComponent)child, printFile);
            }
        }
    }

    private void push(Print print, PrintFile printFile) {
        if (print.getFile() != null) {
            return;
        }
        if (printFile == null) {
            printFile = CifConstructors.newPrintFile();
            printFile.setPosition((Position)EMFHelper.deepclone((EObject)print.getPosition()));
            printFile.setPath(":stdout");
            print.setFile(printFile);
        } else {
            print.setFile((PrintFile)EMFHelper.deepclone((EObject)printFile));
        }
    }
}

