/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.AppProperties;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.DevModeOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.app.framework.output.StreamOutputComponent;
import org.eclipse.escet.common.java.Assert;

public final class AppEnv {
    private static ThreadLocal<AppEnvData> data = new ThreadLocal();

    private AppEnv() {
    }

    public static boolean isRegistered() {
        AppEnvData rslt = data.get();
        return rslt != null;
    }

    public static AppEnvData getData() {
        AppEnvData rslt = data.get();
        if (rslt == null) {
            throw new RuntimeException("Current thread is not registered with the application framework. Register an application, or register the current thread for an already registered application. See the application framework documentation for more information.");
        }
        return rslt;
    }

    public static AppStreams getStreams() {
        return AppEnv.getData().getStreams();
    }

    public static <T extends IOutputComponent> OutputProvider<T> getProvider() {
        return AppEnv.getData().getProvider();
    }

    public static Options getOptions() {
        return AppEnv.getData().getOptions();
    }

    public static Application<?> getApplication() {
        return AppEnv.getData().getApplication();
    }

    public static AppProperties getProperties() {
        return AppEnv.getData().getProperties();
    }

    public static String getProperty(String propertyName) {
        return AppEnv.getProperties().get(propertyName);
    }

    public static String getProperty(String propertyName, String defaultValue) {
        return AppEnv.getProperties().get(propertyName, defaultValue);
    }

    public static Object setProperty(String propertyName, String value) {
        return AppEnv.getProperties().set(propertyName, value);
    }

    public static boolean isGuiAvailable() {
        return AppEnv.getData().isGuiAvailable();
    }

    public static void checkGuiAvailable(String functionality) {
        AppEnv.getData().checkGuiAvailable(functionality);
    }

    public static boolean isTerminationRequested() {
        return AppEnv.getData().isTerminationRequested();
    }

    public static void terminate() {
        AppEnv.getData().terminate();
    }

    public static void registerApplication(AppEnvData appData) {
        Assert.notNull((Object)appData);
        if (data.get() != null) {
            String msg = "Can't register an application on a thread that already has a registered application.";
            throw new IllegalStateException(msg);
        }
        data.set(appData);
    }

    public static void unregisterApplication() {
        AppEnv.getData();
        data.set(null);
    }

    public static void registerThread(AppEnvData appData, boolean allowReRegister) {
        Assert.notNull((Object)appData);
        if (!allowReRegister && data.get() != null) {
            String msg = "Can't register an already registered thread with the application framework.";
            throw new IllegalStateException(msg);
        }
        data.set(appData);
    }

    public static void unregisterThread() {
        AppEnv.getData();
        data.set(null);
    }

    public static void registerSimple() {
        AppEnv.registerApplication(new AppEnvData(null));
        OutputProvider.register(new StreamOutputComponent());
        Options.set(OutputModeOption.class, OutputMode.WARNING);
        Options.set(DevModeOption.class, Boolean.valueOf(false));
    }
}

