/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;

public class SvgFileIntoDecls
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Pushing SVG file declarations inwards for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.push((ComplexComponent)spec, null);
    }

    private void push(ComplexComponent comp, SvgFile svgFile) {
        Iterator ioIter = comp.getIoDecls().iterator();
        while (ioIter.hasNext()) {
            IoDecl ioDecl = (IoDecl)ioIter.next();
            if (!(ioDecl instanceof SvgFile)) continue;
            svgFile = (SvgFile)ioDecl;
            ioIter.remove();
        }
        if (svgFile != null) {
            for (IoDecl ioDecl : comp.getIoDecls()) {
                Assert.check((!(ioDecl instanceof SvgFile) ? 1 : 0) != 0);
                if (ioDecl instanceof SvgCopy) {
                    this.push((SvgCopy)ioDecl, svgFile);
                    continue;
                }
                if (ioDecl instanceof SvgMove) {
                    this.push((SvgMove)ioDecl, svgFile);
                    continue;
                }
                if (ioDecl instanceof SvgOut) {
                    this.push((SvgOut)ioDecl, svgFile);
                    continue;
                }
                if (!(ioDecl instanceof SvgIn)) continue;
                this.push((SvgIn)ioDecl, svgFile);
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.push((ComplexComponent)child, svgFile);
            }
        }
    }

    private void push(SvgCopy svgCopy, SvgFile svgFile) {
        if (svgCopy.getSvgFile() != null) {
            return;
        }
        svgCopy.setSvgFile((SvgFile)EMFHelper.deepclone((EObject)svgFile));
    }

    private void push(SvgMove svgMove, SvgFile svgFile) {
        if (svgMove.getSvgFile() != null) {
            return;
        }
        svgMove.setSvgFile((SvgFile)EMFHelper.deepclone((EObject)svgFile));
    }

    private void push(SvgOut svgOut, SvgFile svgFile) {
        if (svgOut.getSvgFile() != null) {
            return;
        }
        svgOut.setSvgFile((SvgFile)EMFHelper.deepclone((EObject)svgFile));
    }

    private void push(SvgIn svgIn, SvgFile svgFile) {
        if (svgIn.getSvgFile() != null) {
            return;
        }
        svgIn.setSvgFile((SvgFile)EMFHelper.deepclone((EObject)svgFile));
    }
}

