/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.CifToBddConverter;
import org.eclipse.escet.cif.bdd.conversion.preconditions.CifToBddConverterPreChecker;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AnnoNoSpecificAnnosCheck;
import org.eclipse.escet.cif.checkers.checks.AutOnlySpecificSupKindsCheck;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithCertainNumberOfInitLocsCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoMarkerPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeOnlySimpleAssignmentsCheck;
import org.eclipse.escet.cif.checkers.checks.EqnNotAllowedCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoChannelsCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoTauCheck;
import org.eclipse.escet.cif.checkers.checks.EventOnlyWithControllabilityCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificBinaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificUnaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificUserDefCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.checkers.checks.VarDiscOnlyStaticEvalInitCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoContinuousCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesOptimized;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifRelations;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifToDmm;
import org.eclipse.escet.cif.multilevel.ciftodmm.SpecHasPlantCheck;
import org.eclipse.escet.cif.multilevel.ciftodmm.SpecHasRequirementCheck;
import org.eclipse.escet.cif.multilevel.clustering.ComputeMultiLevelTree;
import org.eclipse.escet.cif.multilevel.clustering.TreeNode;
import org.eclipse.escet.cif.multilevel.options.DmmOutputFileOption;
import org.eclipse.escet.cif.multilevel.options.PartialSpecsOutputDirectoryOption;
import org.eclipse.escet.cif.multilevel.partialspecs.PartialSpecsBuilder;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.dsm.BusDetectionAlgorithm;
import org.eclipse.escet.common.dsm.ClusterInput;
import org.eclipse.escet.common.dsm.Dmm;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.DsmClustering;
import org.eclipse.escet.common.dsm.app.ConvergenceOption;
import org.eclipse.escet.common.dsm.app.DsmBusDetectionAlgorithmOption;
import org.eclipse.escet.common.dsm.app.DsmBusFactorOption;
import org.eclipse.escet.common.dsm.app.DsmEvaporationOption;
import org.eclipse.escet.common.dsm.app.DsmInflationOption;
import org.eclipse.escet.common.dsm.app.DsmStepCountOption;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class MultilevelApp
extends Application<IOutputComponent> {
    private static final RealMatrixFormat MAT_DEBUG_FORMAT;
    private static final String VIOLATIONS_REPORT_SEPARATOR_CHAR = "=";

    static {
        NumberFormat valueFmt = NumberFormat.getIntegerInstance(Locale.US);
        MAT_DEBUG_FORMAT = new RealMatrixFormat("", "", "  ", "", "\n", " ", valueFmt);
    }

    public static void main(String[] args) {
        MultilevelApp app = new MultilevelApp();
        app.run(args, true);
    }

    public MultilevelApp() {
    }

    public MultilevelApp(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        String absSpecPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        String[] annosToKeep = new String[]{"requirement:reachable"};
        new RemoveAnnotations(annosToKeep).transform(spec);
        new ElimComponentDefInst().transform(spec);
        new ElimSelf().transform(spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        removeIoDecls.warnAboutIgnoredSvgInputDecsIfRemoved(this.getAppEnvData().getProvider().getWarningOutputStream());
        new SimplifyValuesOptimized().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        MultilevelApp.checkSpec(spec, absSpecPath, () -> this.isTerminationRequested());
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifRelations cifRelations = CifToDmm.transformToDmms(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        if (DmmOutputFileOption.getDmmOutputFilePath() != null) {
            cifRelations.writeDmms(InputFileOption.getPath(), DmmOutputFileOption.getDmmOutputFilePath());
        }
        Dmm reqsPlantsDmm = cifRelations.relations;
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Plant groups:");
            OutputProvider.dbg((String)cifRelations.plantGroups.toString());
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Requirement groups:");
            OutputProvider.dbg((String)cifRelations.requirementGroups.toString());
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Requirement / Plant relations:");
            OutputProvider.dbg((String)cifRelations.relations.toString());
            OutputProvider.dbg();
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        for (PositionObject posObj : cifRelations.getUselessRequirements()) {
            if (posObj instanceof Automaton) {
                OutputProvider.warn((String)"Requirement automaton \"%s\" has no relation to any plant element and does not affect behavior.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false)});
                continue;
            }
            if (posObj instanceof Invariant) {
                Invariant inv = (Invariant)posObj;
                OutputProvider.warn((String)"Requirement invariant \"%s\" has no relation to any plant element and does not affect behavior.", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)true)});
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of requirement found: \"" + String.valueOf(posObj) + "\"."));
        }
        RealMatrix unclusteredMatrix = reqsPlantsDmm.adjacencies.transpose().multiply(reqsPlantsDmm.adjacencies);
        OutputProvider.dbg((String)"Unclustered reqsPlants:");
        OutputProvider.dbg((String)MAT_DEBUG_FORMAT.format(unclusteredMatrix));
        OutputProvider.dbg();
        if (this.isTerminationRequested()) {
            return 0;
        }
        OutputProvider.dbg((String)"--- Start of clustering --");
        OutputProvider.idbg();
        double evap = DsmEvaporationOption.getEvaporationFactor();
        int stepCount = DsmStepCountOption.getStepCountValue();
        double inflation = DsmInflationOption.getInflationFactor();
        double epsilon = ConvergenceOption.getConvergenceValue();
        BusDetectionAlgorithm busDetectionAlgorithm = DsmBusDetectionAlgorithmOption.getBusAlgorithm();
        double busInclusion = DsmBusFactorOption.getBusFactor();
        ClusterInput clusteringInput = new ClusterInput(unclusteredMatrix, reqsPlantsDmm.columnLabels, evap, stepCount, inflation, epsilon, busDetectionAlgorithm, busInclusion, this.getAppEnvData().getProvider().getDebugOutputStream());
        Dsm clusteredDsm = DsmClustering.flowBasedMarkovClustering((ClusterInput)clusteringInput);
        OutputProvider.ddbg();
        OutputProvider.dbg((String)"--- End of clustering --");
        OutputProvider.dbg();
        OutputProvider.dbg((String)"Clustered DSM for reqsPlantsDmm (for information only, this data is not actually used):");
        OutputProvider.dbg((String)MAT_DEBUG_FORMAT.format(clusteredDsm.adjacencies));
        OutputProvider.dbg();
        if (this.isTerminationRequested()) {
            return 0;
        }
        TreeNode rootNode = ComputeMultiLevelTree.transformCluster(clusteredDsm.rootGroup, unclusteredMatrix, reqsPlantsDmm.adjacencies, this.getAppEnvData().getProvider().getDebugOutputStream());
        if (this.isTerminationRequested()) {
            return 0;
        }
        List<TreeNode> linearizedTree = rootNode.linearizeTree();
        boolean first = true;
        for (TreeNode node : linearizedTree) {
            if (!first) {
                OutputProvider.out();
            }
            first = false;
            for (Object line : node.toBox(cifRelations).getLines()) {
                OutputProvider.out((String)"%s", (Object[])new Object[]{line});
            }
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        PartialSpecsBuilder partialBuilder = new PartialSpecsBuilder(spec);
        for (TreeNode node : linearizedTree) {
            List neededObjects = Lists.list();
            Iterator iterator = new BitSetIterator(node.plantGroups).iterator();
            while (iterator.hasNext()) {
                int plantGrp = (Integer)iterator.next();
                neededObjects.addAll(cifRelations.getPlantsOfGroup(plantGrp));
            }
            iterator = new BitSetIterator(node.requirementGroups).iterator();
            while (iterator.hasNext()) {
                int reqGrp = (Integer)iterator.next();
                neededObjects.addAll(cifRelations.getRequirementsOfGroup(reqGrp));
            }
            if (this.isTerminationRequested()) {
                return 0;
            }
            node.partialSpec = partialBuilder.createPartialSpecification(neededObjects);
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        PathPair partialSpecsDirPair = PartialSpecsOutputDirectoryOption.getPath();
        this.ensureDirectory(partialSpecsDirPair);
        String absCifDir = cifReader.getAbsDirPath();
        this.writePartialSpecs(partialSpecsDirPair, linearizedTree, absCifDir);
        int numSpecifications = 0;
        int numChecksOk = 0;
        int numChecksIncompleteOk = 0;
        int numChecksViolations = 0;
        for (TreeNode node : linearizedTree) {
            ++numSpecifications;
            Specification copiedSpec = (Specification)EMFHelper.deepclone((EObject)node.partialSpec);
            CifToBddConverterPreChecker dbsPreChecker = CifToBddConverter.preparePreChecker((Specification)copiedSpec, (WarnOutput)this.getAppEnvData().getProvider().getWarningOutputStream(), (boolean)false, () -> this.isTerminationRequested());
            String absPartialSpecPath = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{partialSpecsDirPair.systemPath, node.hierarchicalName + ".cif"});
            OutputProvider.out((String)"Checking partial specification \"%s.cif\" against the pre-conditions of data-based synthesis...", (Object[])new Object[]{node.hierarchicalName});
            CifCheckViolations violations = dbsPreChecker.check(copiedSpec, absPartialSpecPath);
            node.numDbsViolations = violations.getViolations().count();
            boolean bl = node.dbsCheckIsComplete = !violations.isIncomplete();
            if (node.numDbsViolations > 0L) {
                ++numChecksViolations;
                OutputProvider.warn((String)"Data-based synthesis does not support partial specification \"%s.cif\".", (Object[])new Object[]{node.hierarchicalName});
            } else if (node.dbsCheckIsComplete) {
                ++numChecksOk;
            } else {
                ++numChecksIncompleteOk;
            }
            if (!node.dbsCheckIsComplete) {
                OutputProvider.warn((String)"Data-based synthesis pre-condition check of the partial \"%s.cif\" specification was not completed.", (Object[])new Object[]{node.hierarchicalName});
            }
            if (node.numDbsViolations <= 0L) continue;
            node.dbsPrecheckerReportLines = violations.createReport();
        }
        int numSummaryTextLines = 0;
        OutputProvider.out((String)"Summary:");
        OutputProvider.iout();
        if (numChecksOk > 0) {
            ++numSummaryTextLines;
            OutputProvider.out((String)Strings.adjustForPlurals((String)"Found {num} partial specification{p '' s} that {p is are} supported by data-based synthesis.", (int[])new int[]{numChecksOk}));
        }
        if (numChecksIncompleteOk > 0) {
            ++numSummaryTextLines;
            OutputProvider.out((String)Strings.adjustForPlurals((String)"Found {num} partial specification{p '' s} that {p is are} supported by data-based synthesis, but {p 'it was' 'they were'} not completely checked.", (int[])new int[]{numChecksIncompleteOk}));
        }
        if (numChecksViolations > 0) {
            ++numSummaryTextLines;
            OutputProvider.out((String)Strings.adjustForPlurals((String)"Found {num} partial specification{p '' s} that {p is are} not supported by data-based synthesis.", (int[])new int[]{numChecksViolations}));
        }
        if (numSummaryTextLines > 1) {
            OutputProvider.out((String)Strings.adjustForPlurals((String)"Created {num} partial specification{p '' s} in total.", (int[])new int[]{numSpecifications}));
        }
        OutputProvider.dout();
        this.writeSynthesisScript(partialSpecsDirPair, linearizedTree);
        OutputProvider.out((String)Strings.adjustForPlurals((String)"Created a ToolDef script to perform data-based synthesis on the generated partial specification{p 0 '' s}.", (int[])new int[]{numSpecifications}));
        return 0;
    }

    private void ensureDirectory(PathPair pathPair) {
        Path absSpecDirPath = Paths.get(pathPair.systemPath, new String[0]);
        if (!Files.isDirectory(absSpecDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(absSpecDirPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\".", (Object[])new Object[]{pathPair.userPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
    }

    private void writePartialSpecs(PathPair partialSpecsDirPair, List<TreeNode> nodes, String absCifDir) {
        for (TreeNode node : nodes) {
            String cifFilename = node.hierarchicalName + ".cif";
            String outPath = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{partialSpecsDirPair.userPath, cifFilename});
            String absOutPath = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{partialSpecsDirPair.systemPath, cifFilename});
            CifWriter.writeCifSpec((Specification)node.partialSpec, (PathPair)new PathPair(outPath, absOutPath), (String)absCifDir);
        }
        OutputProvider.out((String)"Wrote %d partial specification%s to directory \"%s\".", (Object[])new Object[]{nodes.size(), nodes.size() == 1 ? "" : "s", partialSpecsDirPair.userPath});
    }

    private void writeSynthesisScript(PathPair partialSpecsDirPair, List<TreeNode> nodes) {
        int maxLengthPartialSpecName = 0;
        for (TreeNode node : nodes) {
            int nameLength = node.hierarchicalName.length();
            maxLengthPartialSpecName = Math.max(maxLengthPartialSpecName, nameLength);
        }
        MemoryCodeBox box = new MemoryCodeBox(4);
        box.add("// This script was generated by the CIF multi-level splitter tool, part of the Eclipse ESCET toolkit.");
        box.add();
        box.add("from \"lib:cif\" import *;");
        box.add();
        box.add("// Partial specifications to synthesize.");
        box.add("//");
        box.add("// Change a line to a comment if the stated specification should not be synthesized.");
        box.add("list string partial_spec_files = [");
        box.indent();
        for (TreeNode node : nodes) {
            if (node.numDbsViolations > 0L) {
                box.add("// \"%s.cif\", // WARNING: The partial specification is NOT supported by data-based synthesis. See below for the reported problems.", new Object[]{node.hierarchicalName});
                continue;
            }
            if (!node.dbsCheckIsComplete) {
                box.add("\"%s.cif\", // WARNING: The partial specification was only partially checked for being supported by data-based synthesis.");
                continue;
            }
            box.add("\"%s.cif\",", new Object[]{node.hierarchicalName});
        }
        box.dedent();
        box.add("];");
        box.add();
        box.add("// Options that are always used.");
        box.add("list string basic_options = [");
        box.add("];");
        box.add();
        box.add("// Options that are used if the specification does not have 'non_general_options'.");
        box.add("list string general_options = [");
        box.add("];");
        box.add();
        box.add("// Options that replace 'general_options', for specific partial specifications.");
        box.add("map(string: list string) non_general_options = {");
        for (TreeNode node : nodes) {
            int numSpaces = maxLengthPartialSpecName - node.hierarchicalName.length();
            box.add("//%s\"%s.cif\":%s [],", new Object[]{Strings.spaces((int)box.getIndentAmount()), node.hierarchicalName, Strings.spaces((int)numSpaces)});
        }
        box.add("};");
        box.add();
        box.add("// Prefix of the original partial specifications.");
        box.add("string orig_prefix = \"partialSpec\";");
        box.add();
        box.add("// Prefix to use for a synthesized supervisor as replacement of the 'orig_prefix' prefix.");
        box.add("string sup_prefix = \"partialSup\";");
        box.add();
        box.add("// Perform data-based synthesis on all specifications in 'partial_spec_files'.");
        box.add("int num_files = size(partial_spec_files);");
        box.add("for num, spec_file in enumerate(partial_spec_files):");
        box.indent();
        box.add("outln(\"========\");");
        box.add("outln(\"Partial specification %s/%s: \\\"%s\\\".\", num + 1, num_files, spec_file);");
        box.add("outln();");
        box.add();
        box.add("// Decide the name of the supervisor.");
        box.add("string out_file;");
        box.add("if startswith(spec_file, orig_prefix):");
        box.indent();
        box.add("out_file = sup_prefix + spec_file[size(orig_prefix):];");
        box.dedent();
        box.add("else");
        box.indent();
        box.add("out_file = sup_prefix + spec_file;");
        box.dedent();
        box.add("end");
        box.add();
        box.add("// Construct the data-based synthesis command.");
        box.add("list string cmd = [spec_file, \"--output=\" + out_file] + basic_options;");
        box.add("if contains(non_general_options, spec_file):");
        box.indent();
        box.add("cmd = cmd + non_general_options[spec_file];");
        box.dedent();
        box.add("else");
        box.indent();
        box.add("cmd = cmd + general_options;");
        box.dedent();
        box.add("end");
        box.add();
        box.add("// And run it.");
        box.add("outln(\"Running data-based synthesis (%s)...\", cmd);");
        box.add("cifdatasynth(cmd);");
        box.add("outln();");
        box.dedent();
        box.add("end");
        for (TreeNode node : nodes) {
            if (node.dbsPrecheckerReportLines == null) continue;
            box.add();
            String headerText = Strings.fmt((String)"Data-based synthesis pre-condition problems for partial specification \"%s.cif\".", (Object[])new Object[]{node.hierarchicalName});
            box.add("// %s", new Object[]{headerText});
            if (!node.dbsCheckIsComplete) {
                box.add("// WARNING: The problems may be incomplete since the pre-condition check was interrupted before finishing.");
            }
            box.add("// %s", new Object[]{VIOLATIONS_REPORT_SEPARATOR_CHAR.repeat(headerText.length())});
            for (String line : node.dbsPrecheckerReportLines) {
                box.add("//    %s", new Object[]{line});
            }
        }
        String toolDefFilename = "synthesize_partials.tooldef";
        String outPath = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{partialSpecsDirPair.userPath, toolDefFilename});
        String absOutPath = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{partialSpecsDirPair.systemPath, toolDefFilename});
        box.writeToFile(outPath, absOutPath);
    }

    public static void checkSpec(Specification spec, String absSpecPath, Termination termination) {
        MultiLevelPreChecker checker = new MultiLevelPreChecker(termination);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF multi-level splitter");
    }

    public String getAppName() {
        return "CIF multi-level splitter";
    }

    public String getAppDescription() {
        return "Splits the CIF specification into a multi-level tree of smaller co-operating partial specifications.";
    }

    public String getAppToolDefLibName() {
        return "cif";
    }

    public String getAppToolDefToolName() {
        return "cifmultilevel";
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = MultilevelApp.getGeneralOptionCategory();
        List clusterOpts = Lists.list((Object[])new Option[]{Options.getInstance(DsmEvaporationOption.class), Options.getInstance(DsmInflationOption.class), Options.getInstance(DsmBusDetectionAlgorithmOption.class), Options.getInstance(DsmBusFactorOption.class), Options.getInstance(ConvergenceOption.class), Options.getInstance(DsmStepCountOption.class)});
        OptionCategory clusterCat = new OptionCategory("Clustering", "Options to steer the clustering algorithms.", Lists.list(), clusterOpts);
        List<Option> programOpts = List.of(Options.getInstance(InputFileOption.class), Options.getInstance(DmmOutputFileOption.class), Options.getInstance(PartialSpecsOutputDirectoryOption.class));
        OptionCategory programCat = new OptionCategory("Multi-level splitting", "Multi-level splitting options.", List.of(clusterCat), programOpts);
        return new OptionCategory("CIF Multi-level Splitter Options", "All options for the CIF multi-level splitter tool.", List.of(generalCat, programCat), List.of());
    }

    private static class MultiLevelPreChecker
    extends CifPreconditionChecker {
        public MultiLevelPreChecker(Termination termination) {
            super(termination, new CifCheck[]{new AutOnlyWithCertainNumberOfInitLocsCheck(AutOnlyWithCertainNumberOfInitLocsCheck.AllowedNumberOfInitLocs.EXACTLY_ONE), new VarNoDiscWithMultiInitValuesCheck(), new VarDiscOnlyStaticEvalInitCheck(), new AutOnlySpecificSupKindsCheck(new SupKind[]{SupKind.PLANT, SupKind.REQUIREMENT}), new SpecHasPlantCheck(), new SpecHasRequirementCheck(), new InvNoSpecificInvsCheck().disallow(NoInvariantSupKind.KINDLESS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.SUPERVISOR, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.PLANT, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.REQUIREMENT, NoInvariantKind.STATE, NoInvariantPlaceKind.ALL_PLACES).disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.LOCATIONS), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.COMP_DEF_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.COMP_TYPES}), new EventNoTauCheck(), new VarNoContinuousCheck(), new EqnNotAllowedCheck(), new AnnoNoSpecificAnnosCheck(new AnnoNoSpecificAnnosCheck.NoSpecificAnno[]{AnnoNoSpecificAnnosCheck.NoSpecificAnno.REQUIREMENT_REACHABLE}), new FuncNoSpecificUserDefCheck(new FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc[]{FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.EXTERNAL, FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.INTERNAL}), new EventOnlyWithControllabilityCheck(), new EventNoChannelsCheck(), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.COMP_DEF_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.COMP_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DICT_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES_AS_DATA, TypeNoSpecificTypesCheck.NoSpecificType.INT_TYPES_RANGELESS, TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.REAL_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.SET_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.STRING_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.TUPLE_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.VOID_TYPES}), new ExprNoSpecificExprsCheck(new ExprNoSpecificExprsCheck.NoSpecificExpr[]{ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_REFS_USER_DEF, ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.COMP_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.COMP_PARAM_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.CONT_VAR_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.DICT_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.TUPLE_FIELD_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_CALLS, ExprNoSpecificExprsCheck.NoSpecificExpr.LIST_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.REAL_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.RECEIVE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.SET_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SLICE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.STRING_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.TIME_VAR_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.TUPLE_LITS}), new ExprNoSpecificUnaryExprsCheck(new ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp[]{ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.NEGATE, ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.SAMPLE}), new ExprNoSpecificBinaryExprsCheck(new ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp[]{ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_STRINGS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.CONJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DISJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DIVISION, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ELEMENT_OF, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_INT_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_REAL, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_TUPLE, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_EQUAL_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_THAN_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_THAN_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_EQUAL_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_THAN_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_THAN_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MODULUS_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MULTIPLICATION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBSET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_INT_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_REAL, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_TUPLE}), new EdgeOnlySimpleAssignmentsCheck(), new CompNoInitPredsCheck(true), new CompNoMarkerPredsCheck(true)});
        }
    }
}

