/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.parser.ast.declarations.AEventDecl;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class EventDeclWrap
extends DeclWrap<Event> {
    private final AEventDecl astDecl;

    public EventDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AEventDecl astDecl, Event mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((Event)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        if (this.astDecl.type != null) {
            CifType type;
            this.tchecker.addToCycle(this);
            try {
                type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope, this.tchecker);
            }
            finally {
                this.tchecker.removeFromCycle(this);
            }
            if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
                this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Event", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
            ((Event)this.mmDecl).setType(type);
        }
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecl.annotations, this.scope, this.tchecker);
        ((Event)this.mmDecl).getAnnotations().addAll(annos);
        CifType type = ((Event)this.mmDecl).getType();
        if (type != null && !(type instanceof VoidType) && CifValueUtils.getPossibleValueCount((CifType)type) == 1.0) {
            this.tchecker.addProblem(ErrMsg.TYPE_ONE_VALUE, type.getPosition(), "", CifTextUtils.typeToStr((CifType)type), "channel", CifTextUtils.getAbsName((PositionObject)this.mmDecl, (boolean)false), "value communicated via the channel");
        }
        this.status = CheckStatus.FULL;
    }

    @Override
    protected void checkName() {
        EventDeclWrap.checkEventName(this.getName(), (Event)this.mmDecl, this.getPosition(), this.tchecker);
    }

    public static void checkEventName(String name, Event event, Position position, CifTypeChecker tchecker) {
        Boolean controllable = event.getControllable();
        if (name.startsWith("e_")) {
            if (controllable != null) {
                tchecker.addProblem(ErrMsg.EVENT_NAME_CONTR_MISMATCH, position, CifTextUtils.getAbsName((PositionObject)event), "e_", "events not declared as controllable or uncontrollable");
            }
        } else if (name.startsWith("c_")) {
            if (controllable == null || !controllable.booleanValue()) {
                tchecker.addProblem(ErrMsg.EVENT_NAME_CONTR_MISMATCH, position, CifTextUtils.getAbsName((PositionObject)event), "c_", "controllable events");
            }
        } else if (name.startsWith("u_") && (controllable == null || controllable.booleanValue())) {
            tchecker.addProblem(ErrMsg.EVENT_NAME_CONTR_MISMATCH, position, CifTextUtils.getAbsName((PositionObject)event), "u_", "uncontrollable events");
        }
    }
}

