/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.eventbased.NfaToDfa;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertFromEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBasedPreChecker;
import org.eclipse.escet.cif.eventbased.apps.options.AddStateAnnosOption;
import org.eclipse.escet.cif.eventbased.apps.options.ResultNameOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.ApplicationException;

public class NfaToDfaApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        NfaToDfaApplication app = new NfaToDfaApplication();
        app.run(args, true);
    }

    public NfaToDfaApplication() {
    }

    public NfaToDfaApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(ResultNameOption.class));
        options.add(Options.getInstance(AddStateAnnosOption.class));
        return new OptionCategory("NFA to DFA automaton conversion", "CIF event-based NFA to DFA automaton conversion options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(NfaToDfaApplication.getGeneralOptionCategory());
        List options = Lists.list();
        return new OptionCategory("Event-based NFA to DFA automaton conversion options", "All options for the event-based NFA to DFA automaton convert tool.", subPages, options);
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String resultName;
        Specification spec;
        CifReader cifReader;
        block10: {
            Automaton aut;
            block9: {
                ConvertToEventBased cte;
                block8: {
                    String absSpecPath;
                    block7: {
                        try {
                            OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                            cifReader = (CifReader)new CifReader().init();
                            spec = (Specification)cifReader.read();
                            absSpecPath = Paths.resolve((String)InputFileOption.getPath());
                            if (!this.isTerminationRequested()) break block7;
                            return 0;
                        }
                        catch (ApplicationException e) {
                            String msg = Strings.fmt((String)"Failed to convert from NFA to DFA for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
                            throw new ApplicationException(msg, (Throwable)e);
                        }
                    }
                    new ElimComponentDefInst().transform(spec);
                    boolean allowPlainEvents = true;
                    boolean allowNonDeterminism = true;
                    ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata expectedNumberOfAutomata = ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata.EXACTLY_ONE_AUTOMATON;
                    EnumSet<SupKind> disallowedAutSupKinds = EnumSet.noneOf(SupKind.class);
                    boolean requireAutHasInitLoc = false;
                    boolean requireReqSubsetPlantAlphabet = false;
                    boolean requireAutMarkedAndNonMarked = false;
                    Termination termination = () -> this.isTerminationRequested();
                    ConvertToEventBasedPreChecker checker = new ConvertToEventBasedPreChecker(allowPlainEvents, allowNonDeterminism, expectedNumberOfAutomata, disallowedAutSupKinds, requireAutHasInitLoc, requireReqSubsetPlantAlphabet, requireAutMarkedAndNonMarked, termination);
                    checker.reportPreconditionViolations(spec, absSpecPath, this.getAppName());
                    OutputProvider.dbg((String)"Converting to internal representation...");
                    cte = new ConvertToEventBased();
                    cte.convertSpecification(spec);
                    if (!this.isTerminationRequested()) break block8;
                    return 0;
                }
                OutputProvider.dbg((String)"Computing DFA...");
                aut = NfaToDfa.toDFA(cte.automata.get(0), cte.automata.get((int)0).alphabet);
                if (!this.isTerminationRequested()) break block9;
                return 0;
            }
            if (OutputProvider.dodbg()) {
                OutputProvider.dbg((String)"NFA to DFA conversion finished (%s).", (Object[])new Object[]{AutomatonHelper.getAutStatistics(aut)});
            }
            OutputProvider.dbg((String)"Converting from internal representation...");
            resultName = "dfa";
            resultName = ResultNameOption.getRsltName(resultName);
            boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
            ConvertFromEventBased cfe = new ConvertFromEventBased();
            spec = cfe.convertAutomaton(aut, resultName, doAddStateAnnos);
            if (!this.isTerminationRequested()) break block10;
            return 0;
        }
        Object outPath = "_" + resultName + ".cif";
        outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outPath);
        OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
        String absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (PathPair)new PathPair((String)outPath, absOutPath), (String)cifReader.getAbsDirPath());
        return 0;
    }

    public String getAppName() {
        return "CIF NFA to DFA automaton conversion tool";
    }

    public String getAppDescription() {
        return "Creates the event-based DFA version of an (NFA) automaton in a CIF specification.";
    }

    public String getAppToolDefLibName() {
        return "cif";
    }

    public String getAppToolDefToolName() {
        return "cifnfadfa";
    }
}

