/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import org.eclipse.escet.chi.metamodel.chi.ConstantDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckExpression;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class ConstantSymbolEntry
extends SymbolEntry {
    private ConstantDeclaration oldCd;
    private ConstantDeclaration newCd;

    public ConstantSymbolEntry(ConstantDeclaration cd, CheckContext ctxt) {
        super(true, ctxt);
        this.oldCd = cd;
        this.newCd = null;
    }

    @Override
    public String getName() {
        return this.oldCd.getName();
    }

    @Override
    public Position getPosition() {
        return this.oldCd.getPosition();
    }

    @Override
    public void typeCheckForUse() {
        if (this.checkState == SymbolEntry.TypeCheckState.NOT_STARTED) {
            this.checkState = SymbolEntry.TypeCheckState.USE_CHECK_DONE;
        }
        this.fullTypeCheck();
    }

    @Override
    public void fullTypeCheck() {
        if (this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE) {
            return;
        }
        this.declareBusy();
        try {
            this.newCd = ConstantSymbolEntry.transConstantDeclaration(this.oldCd, this.ctxt);
        }
        finally {
            this.declareFinished();
        }
    }

    @Override
    public void checkUsage(CheckContext ctxt) {
        if (this.isUsed) {
            return;
        }
        ctxt.addWarning(Message.UNUSED_CONSTANT, this.getPosition(), this.getName());
    }

    public ConstantDeclaration getConstant() {
        Assert.check((this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        if (this.newCd == null) {
            throw new SemanticException();
        }
        return this.newCd;
    }

    private static ConstantDeclaration transConstantDeclaration(ConstantDeclaration decl, CheckContext ctxt) {
        ctxt = ctxt.add(CheckContext.ContextItem.NO_SAMPLE, CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_REAL_TIMER_CAST, CheckContext.ContextItem.NO_VARIABLES, CheckContext.ContextItem.NO_MODELS);
        Type newCType = CheckType.transNonvoidType(decl.getType(), ctxt);
        Expression newVal = CheckExpression.transExpression(decl.getValue(), ctxt);
        if (!CheckType.matchType(newVal.getType(), newCType)) {
            ctxt.throwError(Message.CONST_HAS_INVALID_VALUE, decl.getPosition(), decl.getName(), CheckType.toString(newVal.getType()), CheckType.toString(newCType));
        }
        return ChiConstructors.newConstantDeclaration((String)decl.getName(), (Position)PositionUtils.copyPosition((PositionObject)decl), (Type)newCType, (Expression)newVal);
    }
}

