/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89;

import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89BoolTypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89EnumTypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89IntTypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89RealTypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89StringTypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Assert;

public class C89TypeCodeGen
extends TypeCodeGen {
    @Override
    public TypeInfo typeToTarget(CifType type, CodeContext ctxt) {
        return this.buildTypeInfo(type, ctxt);
    }

    private TypeInfo buildTypeInfo(CifType type, CodeContext ctxt) {
        boolean genLocalFunctions = false;
        if (type instanceof BoolType) {
            return this.uniqueTypeInfo(new C89BoolTypeInfo(false, type), ctxt);
        }
        if (type instanceof IntType) {
            return this.uniqueTypeInfo(new C89IntTypeInfo(false, type), ctxt);
        }
        if (type instanceof EnumType) {
            return this.uniqueTypeInfo(new C89EnumTypeInfo(false, ctxt.getPrefix(), (EnumType)type), ctxt);
        }
        if (type instanceof RealType) {
            return this.uniqueTypeInfo(new C89RealTypeInfo(false, type), ctxt);
        }
        if (type instanceof StringType) {
            return this.uniqueTypeInfo(new C89StringTypeInfo(false, type), ctxt);
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            Assert.check((boolean)CifTypeUtils.isArrayType((ListType)ltype));
            TypeInfo[] elmTIs = new TypeInfo[]{this.buildTypeInfo(ltype.getElementType(), ctxt)};
            return this.uniqueTypeInfo(new C89ArrayTypeInfo(false, type, elmTIs, ltype.getLower()), ctxt);
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            TypeInfo[] fieldTIs = new TypeInfo[ttype.getFields().size()];
            int i = 0;
            while (i < ttype.getFields().size()) {
                CifType fieldType = ((Field)ttype.getFields().get(i)).getType();
                fieldTIs[i] = this.buildTypeInfo(fieldType, ctxt);
                ++i;
            }
            return this.uniqueTypeInfo(new C89TupleTypeInfo(false, type, fieldTIs), ctxt);
        }
        throw new RuntimeException("Unexpected/unsupported type: " + String.valueOf(type));
    }
}

