/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript.typeinfos;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprProperties;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptDataValue;
import org.eclipse.escet.cif.codegen.typeinfos.IntTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class JavaScriptIntTypeInfo
extends IntTypeInfo {
    public JavaScriptIntTypeInfo(CifType cifType) {
        super(cifType);
    }

    @Override
    public String getTargetType() {
        return "var";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("var %s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public ExprCode convertLiteral(String value, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(new JavaScriptDataValue(value));
        return result;
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return Strings.fmt((String)"%sUtils.equalObjs(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return Strings.fmt((String)"!%sUtils.equalObjs(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        }
        if (binOp.equals((Object)BinaryOperator.LESS_THAN)) {
            return "(${left-value}) < (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_EQUAL)) {
            return "(${left-value}) <= (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_THAN)) {
            return "(${left-value}) > (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_EQUAL)) {
            return "(${left-value}) >= (${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    protected ExprCode convertIntNegate(Expression child, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(child, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.setDestination(dest);
        if (properties.isEmpty()) {
            result.setDataValue(new JavaScriptDataValue(Strings.fmt((String)"-(%s)", (Object[])new Object[]{childCode.getData()})));
        } else {
            result.setDataValue(new JavaScriptDataValue(Strings.fmt((String)"%sUtils.negateInt(%s)", (Object[])new Object[]{ctxt.getPrefix(), childCode.getData()})));
        }
        return result;
    }

    @Override
    protected ExprCode convertAddition(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) + (${right-value})" : Strings.fmt((String)"%sUtils.addInt(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertSubtraction(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) - (${right-value})" : Strings.fmt((String)"%sUtils.subtractInt(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertDiv(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) / (${right-value})" : Strings.fmt((String)"%sUtils.div(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertMod(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) % (${right-value})" : Strings.fmt((String)"%sUtils.mod(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertMultiplication(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) * (${right-value})" : Strings.fmt((String)"%sUtils.multiplyInt(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JavaScriptIntTypeInfo;
    }

    @Override
    public int hashCode() {
        return JavaScriptIntTypeInfo.class.hashCode();
    }

    @Override
    protected ExprCode convertAbsStdLib(Expression expression, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.absInt(${args})", (Object[])new Object[]{ctxt.getPrefix()}), Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertMaximumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.maxInt(${args})", (Object[])new Object[]{ctxt.getPrefix()}), exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertMinimumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.minInt(${args})", (Object[])new Object[]{ctxt.getPrefix()}), exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertSignStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.signInt(${args})", (Object[])new Object[]{ctxt.getPrefix()}), Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertPowerStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.powInt(${args})", (Object[])new Object[]{ctxt.getPrefix()}), exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertCeilStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.ceil(${args})", (Object[])new Object[]{ctxt.getPrefix()}), Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertFloorStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.floor(${args})", (Object[])new Object[]{ctxt.getPrefix()}), Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertRoundStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.round(${args})", (Object[])new Object[]{ctxt.getPrefix()}), Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        IntType lhsInt = (IntType)lhsType;
        IntType rhsInt = (IntType)rhsType;
        int lhsLower = CifTypeUtils.getLowerBound((IntType)lhsInt);
        int rhsLower = CifTypeUtils.getLowerBound((IntType)rhsInt);
        String guard1 = null;
        if (rhsLower < lhsLower) {
            guard1 = Strings.fmt((String)"(%s) < %s", (Object[])new Object[]{rhsValue.getData(), lhsLower});
        }
        int lhsUpper = CifTypeUtils.getUpperBound((IntType)lhsInt);
        int rhsUpper = CifTypeUtils.getUpperBound((IntType)rhsInt);
        String guard2 = null;
        if (rhsUpper > lhsUpper) {
            guard2 = Strings.fmt((String)"(%s) > %s", (Object[])new Object[]{rhsValue.getData(), lhsUpper});
        }
        if (guard1 != null) {
            if (guard2 != null) {
                guard1 = Strings.fmt((String)"%s || %s", (Object[])new Object[]{guard1, guard2});
            }
        } else {
            if (guard2 == null) {
                return;
            }
            guard1 = guard2;
        }
        Object indexedVarName = Strings.stringToJava((String)varName);
        if (!errorTexts.isEmpty()) {
            Object indices = "\"";
            for (RangeCheckErrorLevelText errText : errorTexts) {
                indices = errText.isIntVariable ? (String)indices + "[\" + (" + errText.text + ").toString() + \"]" : (String)indices + "[" + errText.text + "]";
            }
            indices = (String)indices + "\"";
            indexedVarName = (String)indexedVarName + " + " + (String)indices;
        }
        code.add("if (%s) {", new Object[]{guard1});
        code.indent();
        code.add("%sUtils.rangeErrInt(%s, %sUtils.valueToStr(%s), %s);", new Object[]{ctxt.getPrefix(), indexedVarName, ctxt.getPrefix(), rhsValue.getData(), Strings.stringToJava((String)CifTextUtils.typeToStr((CifType)varType))});
        code.dedent();
        code.add("}");
    }
}

