//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2025 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.merger;

import static org.eclipse.escet.common.java.Strings.fmt;

import org.eclipse.escet.common.app.framework.options.BooleanOption;
import org.eclipse.escet.common.app.framework.options.Options;

/**
 * Option to configure whether to remove the controller properties annotations of the input specifications (and not
 * merge them), or keep them (so that they end up in the merged specification).
 */
public class RemoveControllerPropertiesAnnosOption extends BooleanOption {
    /** Default value of the option. */
    private static final boolean DEFAULT_VALUE = true;

    /** The option description. */
    private static final String DESCRIPTION = "Enable this option to remove the controller properties annotations of "
            + "the input specifications. Disable the option to keep them and merge them into the merged specification. "
            + "Consult the tool documentation for more information about the proper use of this option.";

    /** Constructor for the {@link RemoveControllerPropertiesAnnosOption} class. */
    public RemoveControllerPropertiesAnnosOption() {
        super(
                // name
                "Remove controller properties annotations",

                // description
                DESCRIPTION + fmt(" [DEFAULT=%s]", DEFAULT_VALUE),

                // cmdShort
                null,

                // cmdLong
                "remove-controller-properties-annotations",

                // cmdValue
                "BOOL",

                // defaultValue
                DEFAULT_VALUE,

                // showInDialog
                true,

                // optDialogDescr
                DESCRIPTION,

                // optDialogCheckboxText
                "Remove controller properties annotations"

        );
    }

    /**
     * Returns whether to remove the controller properties annotations of the input specifications (and not merge them),
     * or keep them (so that they end up in the merged specification).
     *
     * @return {@code true} to remove the controller properties annotations, {@code false} to keep and merge them.
     */
    public static boolean isEnabled() {
        return Options.get(RemoveControllerPropertiesAnnosOption.class);
    }
}
