/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.typegen.PlcDerivedTypeData;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultTypeGenerator
implements TypeGenerator {
    private final NameGenerator nameGenerator;
    private final PlcElementaryType standardIntType;
    private final PlcElementaryType standardRealType;
    private final Map<TypeEqHashWrap, PlcStructType> structTypes = Maps.map();
    private final EnumDeclDataFactory enumDeclDataFactory;
    private final List<PlcDerivedTypeData> derivedTypesAndDeps = Lists.list();

    public DefaultTypeGenerator(PlcTarget target, NameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
        this.standardIntType = target.getStdIntegerType();
        this.standardRealType = target.getStdRealType();
        ConvertEnums selectedEnumConversion = target.getActualEnumerationsConversion();
        this.enumDeclDataFactory = switch (selectedEnumConversion) {
            case ConvertEnums.CONSTS -> new ConstsEnumDeclsFactory(target, nameGenerator, this.derivedTypesAndDeps);
            case ConvertEnums.INTS -> new IntegersEnumDeclsFactory(target, this.derivedTypesAndDeps);
            case ConvertEnums.KEEP -> new KeepEnumDeclsFactory(nameGenerator, this.derivedTypesAndDeps);
            default -> throw new AssertionError((Object)("Unexpected enumeration conversion \"" + String.valueOf((Object)selectedEnumConversion) + "\" found."));
        };
    }

    @Override
    public PlcType convertType(CifType type) {
        if (type instanceof BoolType) {
            return PlcElementaryType.BOOL_TYPE;
        }
        if (type instanceof IntType) {
            return this.standardIntType;
        }
        if (type instanceof RealType) {
            return this.standardRealType;
        }
        if (type instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)type;
            return this.convertType(typeRef.getType().getType());
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            return this.convertTupleType(tupleType);
        }
        if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            EnumDeclData declData = this.getOrCreateConvertedEnumDecl(enumType.getEnum());
            return declData.plcEnumType;
        }
        if (type instanceof ListType) {
            ListType arrayType = (ListType)type;
            int size = arrayType.getLower();
            Assert.check((boolean)CifTypeUtils.isArrayType((ListType)arrayType));
            PlcType elemType = this.convertType(arrayType.getElementType());
            return new PlcArrayType(0, size == 0 ? 0 : size - 1, elemType);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    @Override
    public PlcStructType convertTupleType(TupleType tupleType) {
        TypeEqHashWrap typeWrap = new TypeEqHashWrap((CifType)tupleType, true, false);
        PlcStructType structType = this.structTypes.get(typeWrap);
        if (structType == null) {
            structType = this.makePlcStructType(tupleType);
            this.structTypes.put(typeWrap, structType);
        }
        return structType;
    }

    @Override
    public List<PlcDerivedTypeData> getDerivedTypesAndDeps() {
        return this.derivedTypesAndDeps;
    }

    @Override
    public List<PlcDataVariable> getCreatedConstants() {
        return this.enumDeclDataFactory.getCreatedConstants();
    }

    private PlcStructType makePlcStructType(TupleType tupleType) {
        String typeName;
        EList tupleFields = tupleType.getFields();
        List structFields = Lists.listc((int)tupleFields.size());
        Set childDerivedTypes = Sets.set();
        int fieldNumber = 1;
        for (Field field : tupleFields) {
            String fieldName = "field" + String.valueOf(fieldNumber);
            PlcType fieldType = this.convertType(field.getType());
            structFields.add(new PlcStructField(fieldName, fieldType));
            ++fieldNumber;
            if (!(fieldType instanceof PlcDerivedType)) continue;
            PlcDerivedType childDerivedType = (PlcDerivedType)fieldType;
            childDerivedTypes.add(childDerivedType);
        }
        EObject eObject = tupleType.eContainer();
        if (eObject instanceof TypeDecl) {
            TypeDecl typeDecl = (TypeDecl)eObject;
            structName = CifTextUtils.getAbsName((PositionObject)typeDecl, (boolean)false);
            typeName = this.nameGenerator.generateGlobalName((String)structName, true);
        } else {
            structName = "TupleStruct" + tupleType.getFields().size();
            typeName = this.nameGenerator.generateGlobalName((String)structName, false);
        }
        PlcStructType structType = new PlcStructType(typeName, structFields);
        this.derivedTypesAndDeps.add(new PlcDerivedTypeData(structType, childDerivedTypes));
        return structType;
    }

    @Override
    public void convertEnumDecl(EnumDecl enumDecl) {
        this.getOrCreateConvertedEnumDecl(enumDecl);
    }

    @Override
    public PlcExpression convertEnumLiteral(EnumLiteral enumLit) {
        EnumDecl enumDecl = (EnumDecl)enumLit.eContainer();
        EnumDeclData declData = this.getOrCreateConvertedEnumDecl(enumDecl);
        return declData.getLiteralValue(enumDecl.getLiterals().indexOf((Object)enumLit));
    }

    private EnumDeclData getOrCreateConvertedEnumDecl(EnumDecl enumDecl) {
        return this.enumDeclDataFactory.getOrCreateConvertedEnumDecl(enumDecl);
    }

    private static class ConstsEnumDeclsFactory
    extends EnumDeclDataFactory {
        private final Map<EnumDecl, EnumDeclData> enumTypes = Maps.map();
        private final PlcTarget target;
        private final NameGenerator nameGenerator;
        private final List<PlcDataVariable> createdConstants = Lists.list();

        public ConstsEnumDeclsFactory(PlcTarget target, NameGenerator nameGenerator, List<PlcDerivedTypeData> createdDerivedTypes) {
            super(createdDerivedTypes);
            this.target = target;
            this.nameGenerator = nameGenerator;
        }

        @Override
        protected EnumDeclData getOrCreateConvertedEnumDecl(EnumDecl enumDecl) {
            return this.enumTypes.computeIfAbsent(enumDecl, key -> this.convertToPlcConstants(enumDecl));
        }

        private EnumDeclData convertToPlcConstants(EnumDecl enumDecl) {
            int numLiterals = enumDecl.getLiterals().size();
            PlcElementaryType valueType = PlcElementaryType.getTypeByRequiredCount(numLiterals, this.target.getSupportedBitStringTypes());
            PlcExpression[] litValues = new PlcExpression[numLiterals];
            int idx = 0;
            while (idx < numLiterals) {
                String name = this.nameGenerator.generateGlobalName((PositionObject)enumDecl.getLiterals().get(idx));
                String targetText = this.target.getUsageVariableText(PlcVariablePurpose.CONSTANT, name);
                PlcDataVariable constVar = new PlcDataVariable(targetText, name, valueType, null, new PlcIntLiteral(idx, valueType));
                this.createdConstants.add(constVar);
                litValues[idx] = new PlcVarExpression((PlcBasicVariable)constVar, new PlcVarExpression.PlcProjection[0]);
                ++idx;
            }
            return new EnumDeclData(valueType, litValues);
        }

        @Override
        public List<PlcDataVariable> getCreatedConstants() {
            return this.createdConstants;
        }
    }

    private static class EnumDeclData {
        public final PlcType plcEnumType;
        private final PlcExpression[] literalValues;

        private EnumDeclData(PlcType plcEnumType, PlcExpression[] literalValues) {
            this.plcEnumType = plcEnumType;
            this.literalValues = literalValues;
        }

        public PlcExpression getLiteralValue(int litIndex) {
            return this.literalValues[litIndex];
        }
    }

    private static abstract class EnumDeclDataFactory {
        protected final List<PlcDerivedTypeData> createdDerivedTypes;

        protected EnumDeclDataFactory(List<PlcDerivedTypeData> createdDerivedTypes) {
            this.createdDerivedTypes = createdDerivedTypes;
        }

        protected abstract EnumDeclData getOrCreateConvertedEnumDecl(EnumDecl var1);

        public List<PlcDataVariable> getCreatedConstants() {
            return List.of();
        }
    }

    private static class IntegersEnumDeclsFactory
    extends EnumDeclDataFactory {
        private final Map<EnumDecl, EnumDeclData> enumTypes = Maps.map();
        private final PlcTarget target;

        public IntegersEnumDeclsFactory(PlcTarget target, List<PlcDerivedTypeData> createdDerivedTypes) {
            super(createdDerivedTypes);
            this.target = target;
        }

        @Override
        protected EnumDeclData getOrCreateConvertedEnumDecl(EnumDecl enumDecl) {
            return this.enumTypes.computeIfAbsent(enumDecl, key -> this.convertToPlcIntegers(enumDecl));
        }

        private EnumDeclData convertToPlcIntegers(EnumDecl enumDecl) {
            int numLiterals = enumDecl.getLiterals().size();
            PlcElementaryType valueType = PlcElementaryType.getTypeByRequiredCount(numLiterals, this.target.getSupportedBitStringTypes());
            PlcExpression[] litValues = (PlcExpression[])IntStream.range(0, numLiterals).mapToObj(idx -> new PlcIntLiteral(idx, valueType)).toArray(PlcExpression[]::new);
            return new EnumDeclData(valueType, litValues);
        }
    }

    private static class KeepEnumDeclsFactory
    extends EnumDeclDataFactory {
        private final NameGenerator nameGenerator;
        private final Map<CifEnumUtils.EnumDeclEqHashWrap, EnumDeclData> enumTypes = Maps.map();

        public KeepEnumDeclsFactory(NameGenerator nameGenerator, List<PlcDerivedTypeData> createdDerivedTypes) {
            super(createdDerivedTypes);
            this.nameGenerator = nameGenerator;
        }

        @Override
        protected EnumDeclData getOrCreateConvertedEnumDecl(EnumDecl enumDecl) {
            CifEnumUtils.EnumDeclEqHashWrap representativeEnumDecl = new CifEnumUtils.EnumDeclEqHashWrap(enumDecl);
            return this.enumTypes.computeIfAbsent(representativeEnumDecl, key -> this.convertToPlcEnumType(enumDecl));
        }

        private EnumDeclData convertToPlcEnumType(EnumDecl enumDecl) {
            String typeName = this.nameGenerator.generateGlobalName((PositionObject)enumDecl);
            List<String> literalNames = enumDecl.getLiterals().stream().map(lit -> this.nameGenerator.generateGlobalName((PositionObject)lit)).toList();
            PlcEnumType plcEnumType = new PlcEnumType(typeName, literalNames);
            PlcExpression[] litValues = (PlcExpression[])plcEnumType.literals.toArray(PlcExpression[]::new);
            this.createdDerivedTypes.add(new PlcDerivedTypeData(plcEnumType, Set.of()));
            return new EnumDeclData(plcEnumType, litValues);
        }
    }
}

