/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Strings;

public class LiteralCodeGenerator {
    private LiteralCodeGenerator() {
    }

    public static boolean isSerializableType(CifType type) {
        return CifTypeUtils.supportsValueEquality((CifType)type);
    }

    public static boolean isSerializableLiteral(Expression expr) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof ListExpression) {
            for (Expression child : ((ListExpression)expr).getElements()) {
                if (LiteralCodeGenerator.isSerializableLiteral(child)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            for (Expression child : ((SetExpression)expr).getElements()) {
                if (LiteralCodeGenerator.isSerializableLiteral(child)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            for (Expression child : ((TupleExpression)expr).getFields()) {
                if (LiteralCodeGenerator.isSerializableLiteral(child)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            for (DictPair pair : ((DictExpression)expr).getPairs()) {
                if (!LiteralCodeGenerator.isSerializableLiteral(pair.getKey())) {
                    return false;
                }
                if (LiteralCodeGenerator.isSerializableLiteral(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof CastExpression) {
            CifType nrtype;
            CastExpression cexpr = (CastExpression)expr;
            Expression child = cexpr.getChild();
            if (!LiteralCodeGenerator.isSerializableLiteral(child)) {
                return false;
            }
            CifType nctype = CifTypeUtils.normalizeType((CifType)child.getType());
            if (CifTypeUtils.checkTypeCompat((CifType)nctype, (CifType)(nrtype = CifTypeUtils.normalizeType((CifType)expr.getType())), (RangeCompat)RangeCompat.EQUAL)) {
                return true;
            }
            return nctype instanceof IntType && nrtype instanceof RealType;
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            Expression child = uexpr.getChild();
            if (!LiteralCodeGenerator.isSerializableLiteral(child)) {
                return false;
            }
            switch (uexpr.getOperator()) {
                case NEGATE: {
                    return true;
                }
                case PLUS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static String gencodeLiteral(Expression literal, CifCompilerContext ctxt) {
        Object path = ctxt.getLiteralDataFileName();
        path = "cifcode/" + (String)path;
        ByteArrayOutputStream stream = ctxt.addResourceFile((String)path);
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);
        try {
            LiteralCodeGenerator.writeLiteral(literal, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to compile literal.", ex);
        }
        String methodName = ctxt.getLiteralReadMethodName(literal.getType());
        String loaderCode = "SPEC.resourceClassLoader";
        String pathCode = Strings.stringToJava((String)path);
        return Strings.fmt((String)"%s(%s, %s)", (Object[])new Object[]{methodName, loaderCode, pathCode});
    }

    private static void writeLiteral(Expression expr, Writer writer) throws IOException {
        if (expr instanceof BoolExpression) {
            boolean value = ((BoolExpression)expr).isValue();
            writer.append(value ? "true" : "false");
            return;
        }
        if (expr instanceof IntExpression) {
            int value = ((IntExpression)expr).getValue();
            writer.append(Integer.toString(value));
            return;
        }
        if (expr instanceof RealExpression) {
            writer.append(((RealExpression)expr).getValue());
            return;
        }
        if (expr instanceof StringExpression) {
            String value = ((StringExpression)expr).getValue();
            writer.append("\"");
            writer.append(Strings.escape((String)value));
            writer.append("\"");
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteralExpression lexpr = (EnumLiteralExpression)expr;
            String name = lexpr.getLiteral().getName();
            writer.write(name);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            writer.append("[");
            boolean first = true;
            for (Expression child : lexpr.getElements()) {
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                LiteralCodeGenerator.writeLiteral(child, writer);
            }
            writer.append("]");
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            writer.append("{");
            boolean first = true;
            for (Expression child : sexpr.getElements()) {
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                LiteralCodeGenerator.writeLiteral(child, writer);
            }
            writer.append("}");
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            writer.append("(");
            boolean first = true;
            for (Expression child : texpr.getFields()) {
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                LiteralCodeGenerator.writeLiteral(child, writer);
            }
            writer.append(")");
            return;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            writer.append("{");
            boolean first = true;
            for (DictPair pair : dexpr.getPairs()) {
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                LiteralCodeGenerator.writeLiteral(pair.getKey(), writer);
                writer.append(":");
                LiteralCodeGenerator.writeLiteral(pair.getValue(), writer);
            }
            writer.append("}");
            return;
        }
        if (expr instanceof CastExpression) {
            LiteralCodeGenerator.writeLiteral(((CastExpression)expr).getChild(), writer);
            return;
        }
        if (expr instanceof UnaryExpression) {
            boolean negate = false;
            while (expr instanceof UnaryExpression) {
                UnaryExpression uexpr = (UnaryExpression)expr;
                UnaryOperator op = uexpr.getOperator();
                if (op == UnaryOperator.NEGATE) {
                    negate = !negate;
                }
                expr = uexpr.getChild();
            }
            if (negate) {
                writer.append("-");
            }
            LiteralCodeGenerator.writeLiteral(expr, writer);
            return;
        }
        throw new RuntimeException("Unsupported literal expr: " + String.valueOf(expr));
    }

    public static void gencodeLiteralReaders(CifCompilerContext ctxt) {
        Map<TypeEqHashWrap, String> literalTypes = ctxt.literalTypes;
        if (literalTypes.isEmpty()) {
            return;
        }
        JavaCodeFile file = ctxt.addCodeFile("LiteralReader");
        file.imports.add("org.eclipse.escet.common.java.exceptions.InputOutputException");
        CodeBox h = file.header;
        h.add("/** Literal reader. */");
        h.add("public final class %s {", new Object[]{"LiteralReader"});
        CodeBox c = file.body;
        boolean first = true;
        for (Map.Entry<TypeEqHashWrap, String> entry : literalTypes.entrySet()) {
            if (!first) {
                c.add();
            }
            first = false;
            CifType type = entry.getKey().type;
            String methodName = entry.getValue();
            c.add("// %s", new Object[]{CifTextUtils.typeToStr((CifType)type)});
            c.add("public static %s %s(ClassLoader loader, String path) {", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), methodName});
            c.indent();
            c.add("try {");
            c.indent();
            c.add("try (LiteralStream stream = new LiteralStream(loader, path)) {");
            c.indent();
            c.add("return %s(stream);", new Object[]{methodName});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("} catch (InputOutputException ex) {");
            c.indent();
            c.add("// Currently literal reading is only used internally,");
            c.add("// so we expect no exceptions here.");
            c.add("throw new RuntimeException(\"Failed to read literal of type \\\"%s\\\".\", ex);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.typeToStr((CifType)type))});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
            c.add();
            c.add("// %s", new Object[]{CifTextUtils.typeToStr((CifType)type)});
            c.add("public static %s %s(String valueText) {", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), methodName});
            c.indent();
            c.add("try {");
            c.indent();
            c.add("try (LiteralStream stream = new LiteralStream(valueText)) {");
            c.indent();
            c.add("return %s(stream);", new Object[]{methodName});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("} catch (InputOutputException ex) {");
            c.indent();
            c.add("throw new InputOutputException(\"Failed to read literal of type \\\"%s\\\".\", ex);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.typeToStr((CifType)type))});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
            c.add();
            c.add("// %s", new Object[]{CifTextUtils.typeToStr((CifType)type)});
            c.add("public static %s %s(LiteralStream stream) {", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), methodName});
            c.indent();
            c.add("try {");
            c.indent();
            c.add("return %sInternal(stream);", new Object[]{methodName});
            c.dedent();
            c.add("} catch (InputOutputException ex) {");
            c.indent();
            c.add("throw new InputOutputException(\"Failed to read literal of type \\\"%s\\\".\", ex);", new Object[]{StringEscapeUtils.escapeJava((String)CifTextUtils.typeToStr((CifType)type))});
            c.dedent();
            c.add("}");
            c.dedent();
            c.add("}");
            c.add();
            c.add("// %s", new Object[]{CifTextUtils.typeToStr((CifType)type)});
            c.add("private static %s %sInternal(LiteralStream stream) {", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), methodName});
            c.indent();
            type = CifTypeUtils.normalizeType((CifType)type);
            if (type instanceof IntType) {
                IntType itype = (IntType)type;
                int lower = itype.getLower();
                int upper = itype.getUpper();
                String readName = "RuntimeLiteralReader.readIntLiteral";
                c.add("int rslt = %s(stream);", new Object[]{readName});
                c.add("if (rslt < %d) {", new Object[]{lower});
                c.indent();
                c.add("throw new InputOutputException(fmt(\"Expected an integer value that is at least %d, but found integer value %%d.\", rslt));", new Object[]{lower});
                c.dedent();
                c.add("}");
                c.add("if (rslt > %d) {", new Object[]{upper});
                c.indent();
                c.add("throw new InputOutputException(fmt(\"Expected an integer value that is at most %d, but found integer value %%d.\", rslt));", new Object[]{upper});
                c.dedent();
                c.add("}");
                c.add("return rslt;");
            } else if (type instanceof EnumType) {
                EnumType etype = (EnumType)type;
                String className = ctxt.getEnumClassName(etype.getEnum());
                String readName = "RuntimeLiteralReader.readEnumLiteral";
                c.add("return %s(stream, %s.class);", new Object[]{readName, className});
            } else if (type instanceof ListType) {
                ListType ltype = (ListType)type;
                CifType elemType = ltype.getElementType();
                int size = ltype.getLower() == null ? 100 : ltype.getLower();
                c.add("%s rslt = new ArrayList<%s>(%d);", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), TypeCodeGenerator.gencodeType(elemType, ctxt, true), size});
                c.add("stream.expectCharacter('[');");
                c.add("while (true) {");
                c.indent();
                c.add("if (stream.matchCharacter(']')) break;");
                c.add("%s elem = %s(stream);", new Object[]{TypeCodeGenerator.gencodeType(elemType, ctxt), ctxt.getLiteralReadMethodName(elemType)});
                c.add("rslt.add(elem);");
                c.add("int c = stream.expectCharacter(',', ']');");
                c.add("if (c == ',') continue;");
                c.add("if (c == ']') break;");
                c.dedent();
                c.add("}");
                if (ltype.getLower() != null) {
                    c.add("if (rslt.size() < %d) {", new Object[]{ltype.getLower()});
                    c.indent();
                    c.add("throw new InputOutputException(fmt(\"Expected a list with at least %d elements, but found a list with %%d elements.\", rslt.size()));", new Object[]{ltype.getLower()});
                    c.dedent();
                    c.add("}");
                }
                if (ltype.getUpper() != null) {
                    c.add("if (rslt.size() > %d) {", new Object[]{ltype.getUpper()});
                    c.indent();
                    c.add("throw new InputOutputException(fmt(\"Expected a list with at most %d elements, but found a list with %%d elements.\", rslt.size()));", new Object[]{ltype.getUpper()});
                    c.dedent();
                    c.add("}");
                }
                c.add("return rslt;");
            } else if (type instanceof SetType) {
                SetType stype = (SetType)type;
                CifType elemType = stype.getElementType();
                c.add("%s rslt = new LinkedHashSet<%s>();", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), TypeCodeGenerator.gencodeType(elemType, ctxt, true)});
                c.add("stream.expectCharacter('{');");
                c.add("while (true) {");
                c.indent();
                c.add("if (stream.matchCharacter('}')) break;");
                c.add("%s elem = %s(stream);", new Object[]{TypeCodeGenerator.gencodeType(elemType, ctxt), ctxt.getLiteralReadMethodName(elemType)});
                c.add("rslt.add(elem);");
                c.add("int c = stream.expectCharacter(',', '}');");
                c.add("if (c == ',') continue;");
                c.add("if (c == '}') break;");
                c.dedent();
                c.add("}");
                c.add("return rslt;");
            } else if (type instanceof TupleType) {
                TupleType ttype = (TupleType)type;
                EList fields = ttype.getFields();
                StringBuilder args = new StringBuilder();
                c.add("stream.expectCharacter('(');");
                int i = 0;
                while (i < fields.size()) {
                    CifType fieldType = ((Field)fields.get(i)).getType();
                    if (i > 0) {
                        c.add("stream.expectCharacter(',');");
                        args.append(", ");
                    }
                    c.add("%s elem%d = %s(stream);", new Object[]{TypeCodeGenerator.gencodeType(fieldType, ctxt), i, ctxt.getLiteralReadMethodName(fieldType)});
                    args.append("elem");
                    args.append(i);
                    ++i;
                }
                c.add("stream.expectCharacter(')');");
                String className = ctxt.getTupleTypeClassName(ttype);
                c.add("return new %s(%s);", new Object[]{className, args.toString()});
            } else if (type instanceof DictType) {
                DictType dtype = (DictType)type;
                CifType keyType = dtype.getKeyType();
                CifType valueType = dtype.getValueType();
                c.add("%s rslt = new LinkedHashMap<%s, %s>();", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), TypeCodeGenerator.gencodeType(keyType, ctxt, true), TypeCodeGenerator.gencodeType(valueType, ctxt, true)});
                c.add("stream.expectCharacter('{');");
                c.add("while (true) {");
                c.indent();
                c.add("if (stream.matchCharacter('}')) break;");
                c.add("%s key = %s(stream);", new Object[]{TypeCodeGenerator.gencodeType(keyType, ctxt), ctxt.getLiteralReadMethodName(keyType)});
                c.add("stream.expectCharacter(':');");
                c.add("%s value = %s(stream);", new Object[]{TypeCodeGenerator.gencodeType(valueType, ctxt), ctxt.getLiteralReadMethodName(valueType)});
                c.add("rslt.put(key, value);");
                c.add("int c = stream.expectCharacter(',', '}');");
                c.add("if (c == ',') continue;");
                c.add("if (c == '}') break;");
                c.dedent();
                c.add("}");
                c.add("return rslt;");
            } else {
                throw new RuntimeException("Unexpected type: " + String.valueOf(type));
            }
            c.dedent();
            c.add("}");
        }
    }
}

