/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime;

import java.util.List;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.tooldef.runtime.ToolDefRuntimeUtils;
import org.eclipse.escet.tooldef.runtime.ToolDefTuple;
import org.eclipse.escet.tooldef.runtime.ToolDefTuplePair;

public class ToolDefTupleNary<P, R extends ToolDefTuple>
extends ToolDefTuple {
    public final P prefix;
    public final R remainder;

    public ToolDefTupleNary(P prefix, R remainder) {
        Assert.notNull(remainder);
        this.prefix = prefix;
        this.remainder = remainder;
    }

    @Override
    public int size() {
        return 1 + ((ToolDefTuple)this.remainder).size();
    }

    @Override
    protected void collectValues(List<Object> values) {
        values.add(this.prefix);
        ((ToolDefTuple)this.remainder).collectValues(values);
    }

    @Override
    public Object getValue(int idx) {
        if (idx == 0) {
            return this.prefix;
        }
        return ((ToolDefTuple)this.remainder).getValue(idx - 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolDefTupleNary)) {
            return false;
        }
        ToolDefTupleNary other = (ToolDefTupleNary)obj;
        return ToolDefRuntimeUtils.equalValues(this.prefix, other.prefix) && ToolDefRuntimeUtils.equalValues(this.remainder, other.remainder);
    }

    @Override
    public int hashCode() {
        return ToolDefTupleNary.class.hashCode() ^ ToolDefRuntimeUtils.hashValue(this.prefix) ^ ToolDefRuntimeUtils.hashValue(this.remainder);
    }

    @Override
    public String toString() {
        List txts = Lists.list();
        txts.add(ToolDefRuntimeUtils.valueToStr(this.prefix));
        R cur = this.remainder;
        while (cur instanceof ToolDefTupleNary) {
            ToolDefTupleNary nary = (ToolDefTupleNary)cur;
            txts.add(ToolDefRuntimeUtils.valueToStr(nary.prefix));
            cur = nary.remainder;
        }
        Assert.check((boolean)(cur instanceof ToolDefTuplePair));
        ToolDefTuplePair pair = (ToolDefTuplePair)cur;
        txts.add(ToolDefRuntimeUtils.valueToStr(pair.left));
        txts.add(ToolDefRuntimeUtils.valueToStr(pair.right));
        return "(" + String.join((CharSequence)", ", txts) + ")";
    }
}

