/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.spec;

import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class CifBddTypedVariable
extends CifBddVariable {
    public final PositionObject obj;
    public final CifType type;

    public CifBddTypedVariable(PositionObject obj, CifType type, int lower, int upper) {
        super(obj, lower, upper);
        this.obj = obj;
        this.type = type;
        if (type instanceof BoolType) {
            Assert.areEqual((Object)lower, (Object)0);
            Assert.areEqual((Object)upper, (Object)1);
            Assert.areEqual((Object)this.count, (Object)2);
        } else if (type instanceof IntType) {
            IntType intType = (IntType)type;
            Assert.check((lower <= upper ? 1 : 0) != 0);
            Assert.areEqual((Object)lower, (Object)CifTypeUtils.getLowerBound((IntType)intType));
            Assert.areEqual((Object)upper, (Object)CifTypeUtils.getUpperBound((IntType)intType));
            Assert.check((this.count > 0 ? 1 : 0) != 0);
            Assert.areEqual((Object)this.count, (Object)CifTypeUtils.getPossibleValuesCount((IntType)intType));
        } else if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            EnumDecl enumDecl = enumType.getEnum();
            Assert.areEqual((Object)lower, (Object)0);
            Assert.areEqual((Object)upper, (Object)(this.count - 1));
            Assert.check((this.count > 0 ? 1 : 0) != 0);
            Assert.areEqual((Object)this.count, (Object)enumDecl.getLiterals().size());
        } else {
            throw new RuntimeException("Unexpected type: " + String.valueOf(type));
        }
    }

    @Override
    protected String toStringInternal() {
        return Strings.fmt((String)"%s \"%s\" of type \"%s\"", (Object[])new Object[]{this.getKindText(), this.readableName, this.getTypeText()});
    }

    @Override
    public String getTypeText() {
        return CifTextUtils.typeToStr((CifType)this.type);
    }
}

