/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ide;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.base.BaseFactory;
import org.eclipse.etrice.core.common.base.BasePackage;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.ide.AbstractIdeQuickfixProvider;
import org.eclipse.etrice.core.common.scoping.ModelPathGlobalScopeProvider;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ConnectionNecessity;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolution;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class RoomIdeQuickfixProvider
extends AbstractIdeQuickfixProvider {
    @Inject
    private EObjectAtOffsetHelper eobjectAtOffsetHelper;
    @Inject
    private ModelPathGlobalScopeProvider modelpathGlobalScopeProvider;

    protected Function<AbstractIdeQuickfixProvider.QuickfixMethodContext, List<DiagnosticResolution>> getQuickfixMethod(String issueCode) {
        return switch (issueCode) {
            case "org.eclipse.xtext.diagnostics.Diagnostic.Linking" -> this::fixUnresolvedReference;
            case "RoomJavaValidator.WrongModelName" -> this::fixRoomModelName;
            case "RoomJavaValidator.ChangeConnectionNecessity" -> this::fixConnectionNecessity;
            default -> null;
        };
    }

    private List<DiagnosticResolution> fixUnresolvedReference(AbstractIdeQuickfixProvider.QuickfixMethodContext context) {
        int startOffset = context.document().getOffSet(context.diagnostic().getRange().getStart());
        int endOffset = context.document().getOffSet(context.diagnostic().getRange().getEnd());
        INode crossRefNode = this.eobjectAtOffsetHelper.getCrossReferenceNode((XtextResource)context.resource(), (ITextRegion)new TextRegion(startOffset, endOffset - startOffset));
        if (crossRefNode == null) {
            return List.of();
        }
        EReference reference = GrammarUtil.getReference((CrossReference)((CrossReference)crossRefNode.getGrammarElement()));
        if (reference == null) {
            return List.of();
        }
        if (!RoomPackage.Literals.ROOM_CLASS.isSuperTypeOf(reference.getEReferenceType()) && reference.getEReferenceType() != BasePackage.Literals.ANNOTATION_TYPE) {
            return List.of();
        }
        String missingName = context.document().getSubstring(context.diagnostic().getRange());
        IScope scope = this.modelpathGlobalScopeProvider.getScope(context.resource(), reference, description -> missingName.equals(description.getQualifiedName().getLastSegment()));
        ArrayList<DiagnosticResolution> resolutions = new ArrayList<DiagnosticResolution>();
        for (IEObjectDescription description2 : Iterables.limit((Iterable)scope.getAllElements(), (int)8)) {
            DiagnosticResolution resolution = context.createResolution("Import " + description2.getQualifiedName().toString(), eobject -> {
                RoomModel roomModel = (RoomModel)EcoreUtil2.getContainerOfType((EObject)eobject, RoomModel.class);
                Import imp = BaseFactory.eINSTANCE.createImport();
                imp.setImportedNamespace(description2.getQualifiedName().toString());
                roomModel.getImports().add((Object)imp);
            });
            resolutions.add(resolution);
        }
        return resolutions;
    }

    private List<DiagnosticResolution> fixRoomModelName(AbstractIdeQuickfixProvider.QuickfixMethodContext context) {
        String fileName = (String)context.issueData().get(1);
        return context.createSingleResolution("Rename model", List.of(new TextEdit(context.diagnostic().getRange(), fileName)));
    }

    private List<DiagnosticResolution> fixConnectionNecessity(AbstractIdeQuickfixProvider.QuickfixMethodContext context) {
        return context.createSingleResolution("Make relay port mandatory", element -> {
            String relayPortName = (String)context.issueData().get(0);
            BindingEndPoint ep1 = ((Binding)element).getEndpoint1();
            BindingEndPoint ep2 = ((Binding)element).getEndpoint2();
            Port relayPort = ep1.getActorRef() == null && ep1.getPort().getName().equals(relayPortName) ? ep1.getPort() : ep2.getPort();
            relayPort.setConnectionNecessity(ConnectionNecessity.MANDATORY);
        });
    }
}

