/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.IBufferListener;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.junit.NoJobsWorkspaceTestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class TextFileBufferTest
extends NoJobsWorkspaceTestCase {
    private TextFileBuffer buffer;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.getProject("p");
        p.create(null);
        p.open(null);
        this.buffer = TextFileBuffer.forFile((IFile)p.getFile("f"));
    }

    protected void tearDown() throws Exception {
        if (this.buffer != null) {
            this.buffer.release();
        }
        super.tearDown();
    }

    public void testBug496840() throws Throwable {
        this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "a")), null);
        final Throwable[] exception = new Throwable[1];
        Display display = PlatformUI.createDisplay();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            DisplayAutoCloseable r1 = new DisplayAutoCloseable(display);
            try {
                try (WorkbenchAutoCloseable r2 = new WorkbenchAutoCloseable();){
                    PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

                        public void postStartup() {
                            try {
                                TextFileBufferTest.this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "b")), null);
                                TextFileBufferTest.this.buffer.getCoreTextFileBufferProvider().getBuffer().requestSynchronizationContext();
                                TextFileBufferTest.this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "c")), null);
                            }
                            catch (CoreException e) {
                                exception[0] = e;
                            }
                            this.getWorkbenchConfigurer().emergencyClose();
                        }

                        public void eventLoopException(Throwable e) {
                            exception[0] = e;
                        }

                        public boolean openWindows() {
                            return true;
                        }

                        public String getInitialWindowPerspectiveId() {
                            return null;
                        }
                    });
                    if (exception[0] != null) {
                        throw exception[0];
                    }
                }
                if (r1 != null) {
                    r1.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (r1 != null) {
                    r1.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        TextFileBufferTest.assertFalse((boolean)PlatformUI.isWorkbenchRunning());
        try {
            this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "d")), null);
            TextFileBufferTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.buffer.getCoreTextFileBufferProvider().getBuffer().releaseSynchronizationContext();
        this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "d")), null);
        TextFileBufferTest.assertEquals((String)"dcba", (String)this.buffer.getSnapshot().getContents());
    }

    public void testSaveListener() throws Exception {
        SaveListener listener = new SaveListener();
        this.buffer.addListener((IBufferListener)listener);
        try {
            this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "a")), null);
            TextFileBufferTest.assertFalse((boolean)this.buffer.isDirty());
            TextFileBufferTest.assertSame((Object)this.buffer, (Object)listener.savedBuffer);
            listener.savedBuffer = null;
            Thread.sleep(1000L);
            this.buffer.save(Contexts.EMPTY_CONTEXT, null);
            TextFileBufferTest.assertNull((Object)listener.savedBuffer);
            this.buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "b")), null);
            TextFileBufferTest.assertFalse((boolean)this.buffer.isDirty());
            TextFileBufferTest.assertSame((Object)this.buffer, (Object)listener.savedBuffer);
            listener.savedBuffer = null;
            Thread.sleep(1000L);
            BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "c"));
            change.setSaveMode(SaveMode.LEAVE_UNSAVED);
            IBufferChange undoChange = this.buffer.applyChange((IBufferChange)change, null);
            TextFileBufferTest.assertTrue((boolean)this.buffer.isDirty());
            TextFileBufferTest.assertNull((Object)listener.savedBuffer);
            this.buffer.applyChange(undoChange, null);
            TextFileBufferTest.assertFalse((boolean)this.buffer.isDirty());
            TextFileBufferTest.assertNull((Object)listener.savedBuffer);
        }
        finally {
            this.buffer.removeListener((IBufferListener)listener);
        }
    }

    private static class DisplayAutoCloseable
    implements AutoCloseable {
        private final Display display;

        DisplayAutoCloseable(Display display) {
            this.display = display;
        }

        @Override
        public void close() {
            this.display.dispose();
        }
    }

    private static class SaveListener
    implements IBufferListener {
        IBuffer savedBuffer;

        private SaveListener() {
        }

        public void bufferSaved(IBuffer buffer) {
            this.savedBuffer = buffer;
        }
    }

    private class WorkbenchAutoCloseable
    implements AutoCloseable {
        private WorkbenchAutoCloseable() {
        }

        @Override
        public void close() {
            if (PlatformUI.isWorkbenchRunning()) {
                TextFileBufferTest.assertTrue((boolean)PlatformUI.getWorkbench().close());
            }
        }
    }
}

