/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.preference;

import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.handly.ui.preference.IPreferenceListener;
import org.eclipse.handly.ui.preference.PreferenceChangeEvent;
import org.eclipse.jface.action.Action;

public class ToggleAction
extends Action {
    private final IBooleanPreference preference;
    private final IPreferenceListener preferenceListener = new IPreferenceListener(){

        @Override
        public void preferenceChanged(PreferenceChangeEvent event) {
            ToggleAction.this.setChecked(ToggleAction.this.preference.getValue());
        }
    };

    public ToggleAction(IBooleanPreference preference) {
        if (preference == null) {
            throw new IllegalArgumentException();
        }
        this.preference = preference;
        this.setChecked(preference.getValue());
        preference.addListener(this.preferenceListener);
    }

    public void dispose() {
        this.preference.removeListener(this.preferenceListener);
    }

    public void run() {
        boolean negated = !this.preference.getValue();
        this.preference.setValue(negated);
    }
}

