/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotBase;

public final class TextFileStoreSnapshot
extends TextFileSnapshotBase {
    private final IFileStore fileStore;
    private final long lastModified;
    private final IStatus status;
    private String contents;

    public TextFileStoreSnapshot(IFileStore fileStore) {
        this(fileStore, (String)null);
    }

    public TextFileStoreSnapshot(IFileStore fileStore, Charset charset) {
        this(fileStore, charset.name());
    }

    private TextFileStoreSnapshot(IFileStore fileStore, String charset) {
        if (fileStore == null) {
            throw new IllegalArgumentException();
        }
        this.fileStore = fileStore;
        this.lastModified = TextFileStoreSnapshot.getLastModified(fileStore);
        if (this.lastModified == 0L) {
            this.status = Status.OK_STATUS;
            this.contents = "";
        } else {
            IStatus status = Status.OK_STATUS;
            String contents = null;
            try {
                contents = TextFileStoreSnapshot.readContents(fileStore, charset);
            }
            catch (CoreException e) {
                Activator.logError(e);
                status = Activator.createErrorStatus(e.getMessage(), e);
            }
            this.status = status;
            this.contents = contents;
        }
    }

    @Override
    public synchronized String getContents() {
        if (this.contents != null && this.lastModified != TextFileStoreSnapshot.getLastModified(this.fileStore)) {
            this.contents = null;
        }
        return this.contents;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean exists() {
        return this.lastModified != 0L;
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        if (this.lastModified != TextFileStoreSnapshot.getLastModified(this.fileStore) || !this.status.isOK()) {
            return false;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String readContents(IFileStore fileStore, String charset) throws CoreException {
        if (charset == null) {
            charset = TextFileStoreSnapshot.detectCharset(fileStore);
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                String string;
                InputStreamReader reader;
                InputStream stream;
                block19: {
                    block18: {
                        stream = fileStore.openInputStream(0, null);
                        reader = new InputStreamReader(stream, charset);
                        string = String.valueOf(TextFileStoreSnapshot.getInputStreamAsCharArray(stream, reader));
                        if (reader == null) break block18;
                        reader.close();
                    }
                    if (stream == null) break block19;
                    stream.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (stream != null) {
                                stream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    private static String detectCharset(IFileStore fileStore) throws CoreException {
        String charset = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = fileStore.openInputStream(0, null);){
                charset = TextFileStoreSnapshot.getCharset(contents, fileStore.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        if (charset == null) {
            charset = ITextFileBufferManager.DEFAULT.getDefaultEncoding();
        }
        return charset;
    }

    private static long getLastModified(IFileStore fileStore) {
        return fileStore.fetchInfo().getLastModified();
    }
}

