/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.universal.PageData;
import org.eclipse.ui.internal.intro.universal.util.BundleUtil;
import org.eclipse.ui.internal.intro.universal.util.Log;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IntroData {
    private String productId;
    private Map<String, PageData> pages = new HashMap<String, PageData>();
    private boolean active;

    public IntroData(String productId, String fileNameOrData, boolean active) {
        this.productId = productId;
        this.active = active;
        if (fileNameOrData != null) {
            this.initialize(fileNameOrData);
        }
    }

    public String getProductId() {
        return this.productId;
    }

    public PageData getPage(String pageId) {
        return this.pages.get(pageId);
    }

    public boolean isActive() {
        return this.active;
    }

    private void initialize(String fileNameOrData) {
        Document doc = this.parse(fileNameOrData);
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        NodeList pages = root.getChildNodes();
        int i = 0;
        while (i < pages.getLength()) {
            Node node = pages.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals("page")) {
                this.loadPage((Element)node);
            }
            ++i;
        }
    }

    private void loadPage(Element page) {
        PageData pd = new PageData(page);
        this.pages.put(pd.getId(), pd);
    }

    public void addImplicitContent() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        int i = 0;
        while (i < elements.length) {
            String cid;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("configExtension") && (cid = element.getAttribute("configId")) != null && cid.equals("org.eclipse.ui.intro.universalConfig")) {
                this.addCandidate(element);
            }
            ++i;
        }
    }

    private void addCandidate(IConfigurationElement element) {
        String fileName = element.getAttribute("content");
        if (fileName == null) {
            return;
        }
        String bundleId = element.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return;
        }
        String content = BundleUtil.getResolvedResourceLocation("", fileName, bundle);
        IntroContentParser parser = new IntroContentParser(content);
        Document dom = parser.getDocument();
        if (dom == null) {
            return;
        }
        Element root = dom.getDocumentElement();
        Element extension = null;
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element el;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (el = (Element)child).getNodeName().equalsIgnoreCase("extensionContent")) {
                extension = el;
                break;
            }
            ++i;
        }
        if (extension == null) {
            return;
        }
        String id = extension.getAttribute("id");
        String name = extension.getAttribute("name");
        String path = extension.getAttribute("path");
        if (id == null || path == null) {
            return;
        }
        int at = path.lastIndexOf("/@");
        if (at == -1) {
            return;
        }
        if (path.charAt(path.length() - 1) != '@') {
            return;
        }
        String pageId = path.substring(0, at);
        PageData pd = this.pages.get(pageId);
        if (pd == null) {
            pd = new PageData(pageId);
            this.pages.put(pageId, pd);
        }
        pd.addImplicitExtension(id, name);
    }

    private Document parse(String fileNameOrData) {
        Document document = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(true);
            docFactory.setExpandEntityReferences(false);
            DocumentBuilder parser = docFactory.newDocumentBuilder();
            if (fileNameOrData.charAt(0) == '<') {
                StringReader reader = new StringReader(fileNameOrData);
                document = parser.parse(new InputSource(reader));
            } else {
                document = parser.parse(fileNameOrData);
            }
            return document;
        }
        catch (SAXParseException spe) {
            StringBuilder buffer = new StringBuilder("IntroData error in line ");
            buffer.append(spe.getLineNumber());
            buffer.append(", uri ");
            buffer.append(spe.getSystemId());
            buffer.append("\n");
            buffer.append(spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Log.error(buffer.toString(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Log.error(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            Log.error(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            Log.error(ioe.getMessage(), ioe);
        }
        return null;
    }

    public void write(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        writer.println("<extensions>");
        for (PageData pd : this.pages.values()) {
            pd.write(writer, "   ");
        }
        writer.println("</extensions>");
    }
}

