/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileLocationDetails {
    Path path;
    IFileStore fileStore;
    IFileInfo fileInfo;
    int line = -1;
    int column = -1;

    public static FileLocationDetails resolve(String path) {
        FileLocationDetails details = FileLocationDetails.checkLocation(path, -1, -1);
        if (details != null) {
            return details;
        }
        Pattern lPattern = Pattern.compile("^(?<path>.*?)[+:](?<line>\\d+)$");
        Pattern lcPattern = Pattern.compile("^(?<path>.*?)[+:](?<line>\\d+)[:+](?<column>\\d+)$");
        Matcher m = lPattern.matcher(path);
        if (m.matches()) {
            try {
                details = FileLocationDetails.checkLocation(m.group("path"), Integer.parseInt(m.group("line")), -1);
                if (details != null) {
                    return details;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((m = lcPattern.matcher(path)).matches()) {
            try {
                details = FileLocationDetails.checkLocation(m.group("path"), Integer.parseInt(m.group("line")), m.group("column") != null ? Integer.parseInt(m.group("column")) : -1);
                if (details != null) {
                    return details;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private static FileLocationDetails checkLocation(String path, int line, int column) {
        FileLocationDetails spec = new FileLocationDetails();
        spec.path = new Path(path);
        spec.fileStore = EFS.getLocalFileSystem().getStore((IPath)spec.path);
        spec.fileInfo = spec.fileStore.fetchInfo();
        spec.line = line;
        spec.column = column;
        return spec.fileInfo.exists() ? spec : null;
    }
}

