/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.graph.updater.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletionUtils.class);
    private IGraphDatabase graph;
    private IGraphNodeIndex fragmentIndex;

    public DeletionUtils(IGraphDatabase graph) {
        this.graph = graph;
        this.fragmentIndex = graph.getOrCreateNodeIndex("fragmentdictionary");
    }

    protected boolean delete(IGraphNode modelElement) {
        if (!modelElement.getEdges().iterator().hasNext()) {
            try {
                this.removeFromIndexes(modelElement);
                modelElement.delete();
                return true;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected boolean deleteAll(IGraphNode file, VcsCommitItem s, IGraphChangeListener changeListener) throws Exception {
        long start = System.currentTimeMillis();
        boolean success = true;
        try {
            String repository = s.getCommit().getDelta().getManager().getLocation();
            LOGGER.debug("deleting nodes from file: {}", file.getProperty("_hawkid"));
            HashSet<IGraphNode> modelElements = new HashSet<IGraphNode>();
            for (IGraphEdge rel : file.getIncomingWithType("_hawkFile")) {
                modelElements.add(rel.getStartNode());
            }
            for (IGraphNode node : modelElements) {
                this.dereference(node, changeListener, s);
            }
            for (IGraphNode node : modelElements) {
                this.makeProxyRefs(s, node, repository, file, changeListener);
            }
            for (IGraphNode node : modelElements) {
                if (!this.delete(node)) continue;
                changeListener.modelElementRemoval(s, node, false);
            }
            modelElements = null;
            changeListener.fileRemoval(s, file);
            this.delete(file);
            LOGGER.debug("deleted all, took: {}s", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
        }
        catch (Exception e) {
            success = false;
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return success;
    }

    protected void makeProxyRefs(VcsCommitItem commitItem, IGraphNode referencedModelElement, String repositoryURL, IGraphNode referencedElementFileNode, IGraphChangeListener listener) {
        IGraphNodeIndex proxydictionary = this.graph.getOrCreateNodeIndex("proxydictionary");
        boolean isOrphan = true;
        Iterator singletonMatches = this.fragmentIndex.get("id", referencedModelElement.getProperty("_hawkid")).iterator();
        if (singletonMatches.hasNext() && ((IGraphNode)singletonMatches.next()).getOutgoingWithType("_hawkFile").iterator().hasNext()) {
            isOrphan = false;
        }
        if (isOrphan) {
            for (IGraphEdge rel : referencedModelElement.getIncoming()) {
                IGraphNode referencingNode = rel.getStartNode();
                IGraphNode endNode = rel.getEndNode();
                if (referencingNode.getProperty("derivationlanguage") != null && referencingNode.getProperty("derivationlogic") != null) {
                    rel.delete();
                    continue;
                }
                String referencingNodeFileID = ((IGraphEdge)referencingNode.getOutgoingWithType("_hawkFile").iterator().next()).getEndNode().getProperty("_hawkid").toString();
                String referencedElementFileID = (String)referencedElementFileNode.getProperty("_hawkid");
                String type = rel.getType();
                if (!referencingNodeFileID.equals(referencedElementFileID)) {
                    String fullReferencedElementPathFileURI = String.valueOf(repositoryURL) + "||||" + referencedElementFileID;
                    String fullReferencedElementPathElementURI = String.valueOf(fullReferencedElementPathFileURI) + "#" + referencedModelElement.getProperty("_hawkid").toString();
                    String[] proxies = referencingNode.getProperty("hawkProxyRef:" + fullReferencedElementPathFileURI);
                    proxies = new Utils().addToElementProxies(proxies, fullReferencedElementPathElementURI, type, rel.getProperty("isContainment") != null, rel.getProperty("isContainer") != null);
                    referencingNode.setProperty("hawkProxyRef:" + fullReferencedElementPathFileURI, (Object)proxies);
                    proxydictionary.add(referencingNode, "hawkProxyRef:", (Object)fullReferencedElementPathFileURI);
                    rel.delete();
                } else {
                    rel.delete();
                }
                listener.referenceRemoval(commitItem, referencingNode, endNode, type, false);
            }
        }
    }

    protected void dereference(IGraphNode modelElement, IGraphChangeListener l, VcsCommitItem s) {
        boolean safeToDereference = true;
        if (s != null) {
            for (IGraphEdge rel : modelElement.getOutgoingWithType("_hawkFile")) {
                IGraphNode fileNode = rel.getEndNode();
                if (s.getPath().equals(fileNode.getProperty("_hawkid"))) {
                    rel.delete();
                    continue;
                }
                safeToDereference = false;
            }
        }
        if (safeToDereference) {
            for (IGraphEdge rel : modelElement.getOutgoing()) {
                if (rel.getProperty("isDerived") != null) {
                    if (l == null && s == null) {
                        LOGGER.warn("warning dereference has null listener/vcscommit -- this should only be used for non-model elements");
                        break;
                    }
                    IGraphNode n = rel.getEndNode();
                    l.modelElementRemoval(s, n, true);
                    this.removeFromIndexes(n);
                    for (IGraphEdge e : n.getOutgoing()) {
                        e.delete();
                    }
                    n.delete();
                    continue;
                }
                rel.delete();
            }
        }
    }

    protected void removeFromIndexes(IGraphNode n) {
        for (String indexname : this.graph.getNodeIndexNames()) {
            this.graph.getOrCreateNodeIndex(indexname).remove(n);
        }
    }

    public void delete(IGraphEdge rel) {
        try {
            rel.delete();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void dereference(IGraphNode metaModelElement) {
        this.dereference(metaModelElement, null, null);
    }
}

