/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.contextful;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobPatternFileSupplier
implements Supplier<Set<IGraphNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobPatternFileSupplier.class);
    private final List<String> fplist;
    private final List<String> rplist;
    private final IGraphDatabase graph;

    public GlobPatternFileSupplier(IGraphDatabase graph, List<String> fplist, List<String> rplist) {
        this.graph = graph;
        this.fplist = fplist;
        this.rplist = rplist;
    }

    @Override
    public synchronized Set<IGraphNode> get() {
        GraphWrapper gw = new GraphWrapper(this.graph);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IGraphTransaction tx = this.graph.beginTransaction();){
                Set fileNodes = gw.getFileNodes(this.rplist, this.fplist);
                HashSet<IGraphNode> rawFileNodes = new HashSet<IGraphNode>();
                for (FileNode fn : fileNodes) {
                    rawFileNodes.add(fn.getNode());
                }
                tx.success();
                return rawFileNodes;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }
}

