/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.greycat;

import greycat.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.greycat.AbstractGreycatDatabase;
import org.eclipse.hawk.greycat.GreycatNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreycatNodeIterable
implements IGraphIterable<GreycatNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreycatNodeIterable.class);
    private final Callable<Node[]> nodesGenerator;
    private final AbstractGreycatDatabase db;

    public GreycatNodeIterable(AbstractGreycatDatabase db, Callable<Node[]> nodesGenerator) {
        this.db = db;
        this.nodesGenerator = nodesGenerator;
    }

    public Iterator<GreycatNode> iterator() {
        try {
            Node[] nodes = this.nodesGenerator.call();
            ArrayList<GreycatNode> gNodes = new ArrayList<GreycatNode>();
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node n3 = nodeArray[n2];
                GreycatNode gNode = this.db.lookup(n3.world(), n3.time(), n3.id());
                if (!gNode.isSoftDeleted()) {
                    gNodes.add(gNode);
                }
                n3.free();
                ++n2;
            }
            return gNodes.iterator();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    public int size() {
        try {
            return this.nodesGenerator.call().length;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public GreycatNode getSingle() {
        return this.iterator().next();
    }
}

