/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.net.URI;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.january.form.DiscreteEntry;
import org.eclipse.january.form.IEntryVisitor;
import org.osgi.service.prefs.BackingStoreException;

@XmlRootElement(name="ExecutableEntry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExecutableEntry
extends DiscreteEntry {
    private URI executableUri;
    private HashMap<String, URI> allowedValueToURI = new HashMap();

    public ExecutableEntry() {
    }

    public ExecutableEntry(String ... allowed) {
        super(allowed);
    }

    @Override
    public boolean setValue(String ... newValues) {
        URI uri = null;
        if (newValues.length == 2 && (uri = URI.create(newValues[1])) != null && this.setValue(newValues[0])) {
            this.allowedValueToURI.put(this.value, uri);
            this.executableUri = uri;
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(String newValue) {
        if (super.setValue(newValue)) {
            this.executableUri = this.allowedValueToURI.get(newValue);
            return true;
        }
        return false;
    }

    public URI getExecutableURI() {
        return this.executableUri;
    }

    public void persistToPreferences(String prefId) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(prefId);
        try {
            for (String key : this.allowedValueToURI.keySet()) {
                prefs.put(this.allowedValueToURI.get(key).toString(), key);
                prefs.flush();
            }
        }
        catch (BackingStoreException e) {
            this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
        }
    }

    public void loadFromPreferences(String prefId) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(prefId);
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String pref = prefs.get(key, "");
                if (!pref.isEmpty()) {
                    this.allowedValues.add(pref);
                    this.allowedValueToURI.put(pref, URI.create(key));
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
        }
        if (!this.allowedValues.isEmpty()) {
            this.allowedValues.add(0, "Select Application");
            this.setDefaultValue((String)this.allowedValues.get(0));
        } else {
            this.allowedValues.add("Import Application");
            this.setDefaultValue((String)this.allowedValues.get(0));
        }
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.visit(this);
    }
}

