/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.AllowedValueType;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;

@XmlRootElement(name="MatrixComponent")
public class MatrixComponent
extends ICEObject
implements Component {
    @XmlAttribute
    private boolean isSquare;
    @XmlElement
    private ArrayList<Double> elements;
    @XmlAttribute
    private int nRows;
    @XmlAttribute
    private int nCols;
    @XmlAttribute
    private AllowedValueType valueType;
    @XmlElement
    private ArrayList<Double> allowedValues;
    private boolean resizable = true;

    @XmlTransient
    public boolean isSquare() {
        return this.isSquare;
    }

    public int addRow() {
        if (!this.resizable) {
            return -1;
        }
        if (this.valueType == AllowedValueType.Continuous && this.allowedValues == null || this.valueType == AllowedValueType.Discrete && this.allowedValues == null) {
            return -1;
        }
        if (this.isSquare) {
            this.resizeSquareMatrix(true);
        } else {
            this.resizeRow(true);
        }
        this.notifyListeners();
        return this.nRows - 1;
    }

    public MatrixComponent(boolean isSquare, AllowedValueType allowedValueType) {
        this.isSquare = isSquare;
        this.valueType = allowedValueType;
        this.elements = new ArrayList();
        this.elements.add(0.0);
        this.nCols = 1;
        this.nRows = 1;
        this.listeners = new ArrayList();
    }

    public boolean deleteRow() {
        double defaultValue = 0.0;
        if (!this.resizable) {
            return false;
        }
        if (this.valueType == AllowedValueType.Continuous && this.allowedValues == null || this.valueType == AllowedValueType.Discrete && this.allowedValues == null) {
            return false;
        }
        if (this.valueType != AllowedValueType.Undefined) {
            defaultValue = this.allowedValues.get(0);
        }
        if (this.elements.size() == 1 && this.elements.get(0) != defaultValue) {
            this.elements = new ArrayList();
            this.elements.add(defaultValue);
            return true;
        }
        if (this.elements.size() == 1 && this.elements.get(0) == defaultValue) {
            return false;
        }
        if (this.elements.size() == this.nCols) {
            this.nCols = 1;
            this.nRows = 1;
            this.elements = new ArrayList();
            this.elements.add(defaultValue);
            return true;
        }
        if (this.isSquare) {
            this.resizeSquareMatrix(false);
        } else {
            this.resizeRow(false);
        }
        this.notifyListeners();
        return true;
    }

    public int numberOfRows() {
        return this.nRows;
    }

    public int numberOfColumns() {
        return this.nCols;
    }

    public void copy(MatrixComponent otherMatrixComponent) {
        int i;
        if (otherMatrixComponent == null) {
            return;
        }
        super.copy(otherMatrixComponent);
        if (otherMatrixComponent.allowedValues == null) {
            this.allowedValues = otherMatrixComponent.allowedValues;
        } else {
            this.allowedValues = new ArrayList();
            i = 0;
            while (i < otherMatrixComponent.allowedValues.size()) {
                this.allowedValues.add(otherMatrixComponent.allowedValues.get(i));
                ++i;
            }
        }
        if (otherMatrixComponent.elements == null) {
            this.elements = otherMatrixComponent.elements;
        } else {
            this.elements = new ArrayList();
            i = 0;
            while (i < otherMatrixComponent.elements.size()) {
                this.elements.add(otherMatrixComponent.elements.get(i));
                ++i;
            }
        }
        this.isSquare = otherMatrixComponent.isSquare;
        this.nCols = otherMatrixComponent.nCols;
        this.nRows = otherMatrixComponent.nRows;
        this.resizable = otherMatrixComponent.resizable;
        this.valueType = otherMatrixComponent.valueType;
        this.notifyListeners();
    }

    @Override
    public Object clone() {
        MatrixComponent matrixComponent = new MatrixComponent();
        matrixComponent.copy(this);
        return matrixComponent;
    }

    @Override
    public boolean equals(Object otherMatrixComponent) {
        boolean retVal = true;
        if (this == otherMatrixComponent) {
            return true;
        }
        if (otherMatrixComponent == null || !(otherMatrixComponent instanceof MatrixComponent)) {
            return false;
        }
        if (!super.equals(otherMatrixComponent)) {
            return false;
        }
        MatrixComponent castedComponent = (MatrixComponent)otherMatrixComponent;
        retVal = this.isSquare == castedComponent.isSquare && this.resizable == castedComponent.resizable && this.allowedValues.equals(castedComponent.allowedValues) && this.elements.equals(castedComponent.elements) && this.nCols == castedComponent.nCols && this.nRows == castedComponent.nRows && this.valueType == castedComponent.valueType;
        return retVal;
    }

    @Override
    public int hashCode() {
        int hash = 9;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + this.nCols;
        hash = 31 * hash + this.nRows;
        if (this.allowedValues != null) {
            hash = 31 * hash + this.allowedValues.hashCode();
        }
        if (this.elements != null) {
            hash = 31 * hash + this.elements.hashCode();
        }
        hash = 31 * hash + this.valueType.hashCode();
        hash = this.isSquare ? 31 * hash + 2 : 31 * hash + 1;
        hash = this.resizable ? 31 * hash + 2 : 31 * hash + 1;
        return hash;
    }

    public int addColumn() {
        if (!this.resizable) {
            return -1;
        }
        if (this.valueType == AllowedValueType.Continuous && this.allowedValues == null || this.valueType == AllowedValueType.Discrete && this.allowedValues == null) {
            return -1;
        }
        if (this.isSquare) {
            this.resizeSquareMatrix(true);
        } else {
            this.resizeColumn(true);
        }
        this.notifyListeners();
        return this.nCols - 1;
    }

    public boolean deleteColumn() {
        double defaultValue = 0.0;
        if (!this.resizable) {
            return false;
        }
        if (this.valueType == AllowedValueType.Continuous && this.allowedValues == null || this.valueType == AllowedValueType.Discrete && this.allowedValues == null) {
            return false;
        }
        if (this.valueType != AllowedValueType.Undefined) {
            defaultValue = this.allowedValues.get(0);
        }
        if (this.elements.size() == 1 && this.elements.get(0) != defaultValue) {
            this.elements = new ArrayList();
            this.elements.add(defaultValue);
            return true;
        }
        if (this.elements.size() == 1 && this.elements.get(0) == defaultValue) {
            return false;
        }
        if (this.elements.size() == this.nRows) {
            this.nCols = 1;
            this.nRows = 1;
            this.elements = new ArrayList();
            this.elements.add(defaultValue);
            return true;
        }
        if (this.isSquare) {
            this.resizeSquareMatrix(false);
        } else {
            this.resizeColumn(false);
        }
        this.notifyListeners();
        return true;
    }

    public boolean setElementValue(int rowIndex, int colIndex, Double value) {
        if (value == null) {
            return false;
        }
        if (rowIndex < 0 || colIndex < 0) {
            return false;
        }
        if (rowIndex >= this.nRows || colIndex >= this.nCols) {
            return false;
        }
        if (this.valueType == AllowedValueType.Continuous && this.allowedValues == null || this.valueType == AllowedValueType.Discrete && this.allowedValues == null) {
            return false;
        }
        if (this.valueType == AllowedValueType.Continuous ? value < this.allowedValues.get(0) || value > this.allowedValues.get(1) : this.valueType == AllowedValueType.Discrete && !this.allowedValues.contains(value)) {
            return false;
        }
        this.elements.set(this.nCols * rowIndex + colIndex, value);
        this.notifyListeners();
        return true;
    }

    public Double getElementValue(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return null;
        }
        if (rowIndex >= this.nRows || colIndex >= this.nCols) {
            return null;
        }
        if (this.valueType == AllowedValueType.Continuous && this.allowedValues == null || this.valueType == AllowedValueType.Discrete && this.allowedValues == null) {
            return null;
        }
        return this.elements.get(this.nCols * rowIndex + colIndex);
    }

    public void setAllowedValues(ArrayList<Double> values) {
        if (values == null || this.allowedValues != null) {
            return;
        }
        if (values.isEmpty()) {
            return;
        }
        if (values.size() != 2 && this.valueType == AllowedValueType.Continuous) {
            return;
        }
        if (this.elements.size() > 1 || this.elements.isEmpty()) {
            return;
        }
        this.elements.set(0, values.get(0));
        this.allowedValues = new ArrayList();
        int i = 0;
        while (i < values.size()) {
            this.allowedValues.add(values.get(i));
            ++i;
        }
        this.notifyListeners();
    }

    public MatrixComponent() {
        this.isSquare = false;
        this.valueType = AllowedValueType.Undefined;
        this.elements = new ArrayList();
        this.elements.add(0.0);
        this.nCols = 1;
        this.nRows = 1;
        this.listeners = new ArrayList();
    }

    public MatrixComponent(boolean isSquare) {
        this.isSquare = isSquare;
        this.valueType = AllowedValueType.Undefined;
        this.elements = new ArrayList();
        this.elements.add(0.0);
        this.nCols = 1;
        this.nRows = 1;
        this.listeners = new ArrayList();
    }

    public ArrayList<Double> getRow(int index) {
        int placeInElements = 0;
        if (index < 0 || index >= this.nRows) {
            return null;
        }
        ArrayList<Double> rowArray = new ArrayList<Double>();
        int i = placeInElements = this.nCols * index;
        while (i < this.nCols * (index + 1)) {
            rowArray.add(this.elements.get(i));
            ++i;
        }
        return rowArray;
    }

    public ArrayList<Double> getColumn(int index) {
        int placeInElements = -1;
        if (index < 0 || index >= this.nCols) {
            return null;
        }
        ArrayList<Double> colArray = new ArrayList<Double>();
        int i = placeInElements = this.nRows * index;
        while (i < this.nRows * (index + 1)) {
            colArray.add(this.elements.get(i));
            ++i;
        }
        return colArray;
    }

    private void resizeRow(boolean addOrRemove) {
        double defaultValue = 0.0;
        if (this.valueType != AllowedValueType.Undefined) {
            defaultValue = this.allowedValues.get(0);
        }
        if (addOrRemove) {
            int i = 0;
            while (i < this.nCols) {
                this.elements.add(defaultValue);
                ++i;
            }
            ++this.nRows;
        } else {
            int i = 0;
            while (i < this.nCols) {
                this.elements.remove(this.elements.size() - 1);
                ++i;
            }
            --this.nRows;
        }
    }

    private void resizeColumn(boolean addOrRemove) {
        double defaultValue = 0.0;
        if (this.valueType != AllowedValueType.Undefined) {
            defaultValue = this.allowedValues.get(0);
        }
        if (addOrRemove) {
            int i = 0;
            while (i < this.nRows) {
                this.elements.add((i + 1) * this.nCols + i, defaultValue);
                ++i;
            }
            ++this.nCols;
        } else {
            int i = 0;
            while (i < this.nRows) {
                this.elements.remove((i + 1) * this.nCols - i - 1);
                ++i;
            }
            --this.nCols;
        }
    }

    private void resizeSquareMatrix(boolean addOrRemove) {
        if (addOrRemove) {
            this.resizeColumn(true);
            this.resizeRow(true);
        } else {
            this.resizeColumn(false);
            this.resizeRow(false);
        }
    }

    @XmlAttribute
    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.notifyListeners();
    }

    @XmlTransient
    public AllowedValueType getAllowedValueType() {
        return this.valueType;
    }

    @XmlTransient
    public ArrayList<Double> getAllowedValues() {
        ArrayList<Double> tempDoubles = new ArrayList<Double>();
        if (this.allowedValues == null) {
            return null;
        }
        int i = 0;
        while (i < this.allowedValues.size()) {
            tempDoubles.add(this.allowedValues.get(i));
            ++i;
        }
        return tempDoubles;
    }

    @Override
    public void update(String updatedKey, String newValue) {
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        visitor.visit(this);
    }
}

