/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kxv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "grinwic mīn belā",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "epiā mānānka belā",
               "",
               "epiā delāit belā",
               "",
               "epiā belā",
               "",
            };
        final String[] Cook = new String[] {
               "kuk dīp mānānka belā",
               "",
               "kuk dīp ādā kār~ā belā",
               "",
               "kuk dīp belā",
               "",
            };
        final String[] Cuba = new String[] {
               "kubā mānānka belā",
               "CST",
               "kubā delāiṭ belā",
               "CDT",
               "kubā belā",
               "CT",
            };
        final String[] Fiji = new String[] {
               "piji mānānka belā",
               "",
               "piji kār~ā belā",
               "",
               "piji belā",
               "",
            };
        final String[] Gulf = new String[] {
               "galp mānānka belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hwoḍ mānānka belā",
               "",
               "hwoḍ kār~ā belā",
               "",
               "hwoḍ belā",
               "",
            };
        final String[] Iran = new String[] {
               "irān mānānka belā",
               "",
               "irān ḍelāiṭ belā",
               "",
               "irān belā",
               "",
            };
        final String[] Niue = new String[] {
               "niū belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "amska mānānka belā",
               "",
               "amska kār~ā belā",
               "",
               "amska belā",
               "",
            };
        final String[] Peru = new String[] {
               "peru mānānka belā",
               "",
               "peru kār~ā belā",
               "",
               "peru belā",
               "",
            };
        final String[] Truk = new String[] {
               "cuk belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "waka dīpa belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "cili mānānka belā",
               "",
               "cili kār~ā belā",
               "",
               "cini belā",
               "",
            };
        final String[] China = new String[] {
               "cin mānānka belā",
               "CST",
               "cin delāiṭ belā",
               "CDT",
               "cin belā",
               "CT",
            };
        final String[] Cocos = new String[] {
               "kokos dīp belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "debis belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "bārat mānānka belā",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "jāpān mānānka belā",
               "JST",
               "jāpān ḍelāiṭ belā",
               "JDT",
               "jāpān belā",
               "JT",
            };
        final String[] Korea = new String[] {
               "koriān mānānka belā",
               "KST",
               "koriān ḍelāiṭ belā",
               "KST",
               "koriān belā",
               "KST",
            };
        final String[] Nauru = new String[] {
               "nāurū belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepāl belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "pālāu belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "saāmoa mānānka belā",
               "SST",
               "saāmoa ḍelāiṭ",
               "SST",
               "saāmoa belā",
               "SST",
            };
        final String[] Syowa = new String[] {
               "sawā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ṭangā mānānka belā",
               "",
               "ṭangā kār~ā belā",
               "",
               "ṭangā belā",
               "",
            };
        final String[] Alaska = new String[] {
               "alaska mananka belā",
               "AKST",
               "alaska ḍelaaiṭ belā",
               "AKDT",
               "alaska belā",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "āmajon mananka belā",
               "",
               "āmajon karã masa belā",
               "",
               "āmajon belā",
               "",
            };
        final String[] Azores = new String[] {
               "ajores mānānka belā",
               "",
               "ajores kār~ā belā",
               "",
               "ajores belā",
               "",
            };
        final String[] Bhutan = new String[] {
               "butān belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "bruneti dārusālām belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "isṭr dīp mānānka belā",
               "",
               "isṭr dīp kār~ā belā",
               "",
               "isṭr dīp belā",
               "",
            };
        final String[] Guyana = new String[] {
               "guyān belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "ijarāīl mānānka belā",
               "IST",
               "ijarāīl ḍelāiṭ belā",
               "IDT",
               "ijarāīl belā",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kasrāē belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "māwosn belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "mosko mānānka belā",
               "MSK",
               "mosko kār~ā belā",
               "MSK",
               "mosko belā",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponāpe belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "tāhiti belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tāipē mānānka belā",
               "CST",
               "tāipē ḍelāiṭ",
               "CDT",
               "tāipē belā",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuwalū belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "wostak belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "walis aḍē puṭunā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ārbiāti mānānka belā",
               "",
               "ārbiāti delāit belā",
               "",
               "ārbiāti belā",
               "",
            };
        final String[] Armenia = new String[] {
               "ārmeniā mānānka belā",
               "",
               "ārmeniā kār~ā belā",
               "",
               "ārmeniā belā",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolwiā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "cyātām mānānka belā",
               "",
               "cyātām delāit belā",
               "",
               "cyātām belā",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "smani jaga pruti belā",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "iquāḍor belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambiyr belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "jarjiā mānānka belā",
               "",
               "jarjiā kār~ā belā",
               "",
               "jarjīā belā",
               "",
            };
        final String[] Irkutsk = new String[] {
               "īrkustak mānānka belā",
               "",
               "īrkustak kār~ā belā",
               "",
               "īrkustak belā",
               "",
            };
        final String[] Magadan = new String[] {
               "māgādan mānānka belā",
               "",
               "māgādan ḍelāit belā",
               "",
               "māgādan belā",
               "",
            };
        final String[] Myanmar = new String[] {
               "miñyāmār belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norpok dīp mānānka belā",
               "",
               "norpok dīp ḍelāiṭ belā",
               "",
               "norpok dīp belā",
               "",
            };
        final String[] Noronha = new String[] {
               "parn~ḍo ḍe norohā~ mānānka belā",
               "",
               "parn~ḍo ḍe norohā~ kār~ā belā",
               "",
               "parn~ḍo ḍe norohā~ belā",
               "",
            };
        final String[] Reunion = new String[] {
               "rīūnīan belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "rotērā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "soloman dīpati belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ṭokelāu belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "urguwē manaka belā",
               "",
               "urguwē kār~ā belā",
               "",
               "urguwē belā",
               "",
            };
        final String[] Vanuatu = new String[] {
               "wanuātū mānānka belā",
               "",
               "wanuātū kār~ā belā",
               "",
               "wanuātū belā",
               "",
            };
        final String[] Yakutsk = new String[] {
               "yakustuk mānānka belā",
               "",
               "yakustuk kār~ā belā",
               "",
               "yakustuk belā",
               "",
            };
        final String[] Atlantic = new String[] {
               "āṭlānṭik mānānka belā",
               "AST",
               "āṭlānṭik delāiṭ belā",
               "AST",
               "āṭlānṭik belā",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "brājiliā mānānka belā",
               "",
               "brājiliā kār~ā belā",
               "",
               "brājiliā belā",
               "",
            };
        final String[] Chamorro = new String[] {
               "cāmor mānānka belā",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolombiā mānānka belā",
               "",
               "kolombiā kār~ā belā",
               "",
               "kolombiā belā",
               "",
            };
        final String[] Falkland = new String[] {
               "paklyānḍ dīpati mānānka belā",
               "",
               "paklyānḍ dīpati kār~ā belā",
               "",
               "paklyānḍ dīpati belā",
               "",
            };
        final String[] Malaysia = new String[] {
               "malesiā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "māldīp belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ūlānbator mānānka belā",
               "",
               "ūlānbator kār~ā belā",
               "",
               "ūlānbator belā",
               "",
            };
        final String[] Pakistan = new String[] {
               "pākistān mānānka belā",
               "PKT",
               "pākistān kār~ā belā",
               "PKST",
               "pākistān belā",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "pārāguyē mānānka belā",
               "",
               "pārāguyē kār~ā belā",
               "",
               "pārāguyē belā",
               "",
            };
        final String[] Pitcairn = new String[] {
               "piṭkēran belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sakālin mānānka belā",
               "",
               "sakālin kār~ā belā",
               "",
               "sakālin belā",
               "",
            };
        final String[] Suriname = new String[] {
               "surīnām belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ārjenṭinā mānānka belā",
               "",
               "ārjenṭinā kār~ā belā belā",
               "",
               "ārjenṭinā belā",
               "",
            };
        final String[] Christmas = new String[] {
               "krismās dīp belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "gālāpogs belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hang kang mānānka belā",
               "HKT",
               "hang kang kār~ā belā",
               "HKST",
               "hang kang belā",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "inḍocinā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgijstān belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "laṛ hawe mānānka belā",
               "",
               "laṛ hawe ḍelāiṭ belā",
               "",
               "laṛ hawe belā",
               "",
            };
        final String[] Marquesas = new String[] {
               "mārksas belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "marīsasmānānka belā",
               "",
               "marīsas kār~ā belā",
               "",
               "marīsas belā",
               "",
            };
        final String[] Singapore = new String[] {
               "singāpur mānānka belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "wenēzuelā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "wālgogrāḍ mānānka belā",
               "MSK",
               "wālgogrāḍ kār~ā belā",
               "MSK",
               "wālgogrāḍ belā",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "ājerbāijān mānānka belā",
               "",
               "ājerbāijān kār~ā belā",
               "",
               "ājerbāijān belā",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bānglādes mānānka belā",
               "",
               "bānglādes kār~ā belā",
               "",
               "bānglādes belā",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kep bḍ mānānka belā",
               "",
               "kep bḍ kār~ā belā",
               "",
               "kep bḍ belā",
               "",
            };
        final String[] East_Timor = new String[] {
               "weḍāhapu timor belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kājākstān belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "sēsels belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tājikistān belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzwēkistān mānānka belā",
               "",
               "uzwēkistān kārã belā",
               "",
               "uzwēkistān belā",
               "",
            };
        final String[] Afghanistan = new String[] {
               "aapganistan belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krāsnōrska mānānka belā",
               "",
               "krāsnōrska kār~ā belā",
               "",
               "krāsnōrska belā",
               "",
            };
        final String[] New_Zealand = new String[] {
               "niūjilānḍ mānānka belā",
               "NZST",
               "niūjilānḍ ḍelāiṭ belā",
               "NZDT",
               "niūjilānḍ belā",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "nawosibisrk mānānka belā",
               "",
               "nawosibisrk kār~ā belā",
               "",
               "nawosibisrk belā",
               "",
            };
        final String[] Philippines = new String[] {
               "pilipin mānānka belā",
               "PST",
               "pilipin kār~ā belā",
               "PDT",
               "pilipin belā",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "wlādiwostak mānānka belā",
               "",
               "wlādiwostak kār~ā belā",
               "",
               "wlādiwostak belā",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "bārat kājā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "lāin dīp belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "niūpaunḍlyānḍ mānānka belā",
               "NST",
               "niūpaunḍlyānḍ ḍelāiṭ belā",
               "NDT",
               "niūpaunḍlyānḍ belā",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmenistān manaka belā",
               "",
               "turkmenistān kār~ā belā",
               "",
               "turkmenistān belā",
               "",
            };
        final String[] French_Guiana = new String[] {
               "prench guyān belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "niū keleḍoniā mānānka belā",
               "",
               "niū keleḍoniā kār~ā belā",
               "",
               "niū keleḍoniā belā",
               "",
            };
        final String[] South_Georgia = new String[] {
               "dkīṇa jarjīā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "yakaterinbarg mānānka belā",
               "",
               "yakaterinbarg kār~ā belā",
               "",
               "yakaterinbarg belā",
               "",
            };
        final String[] Africa_Central = new String[] {
               "madini aaprika belā",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "veḍa hpu aaprika belā",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "veḍa kuṇpu aaprika mananka belā",
               "WAT",
               "veḍa kuṇpu aaprika karã belā",
               "WAT",
               "veḍakuṇpu aaprika belā",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ḍumonṭ ḍi arwilē belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "mādinā yuropiāti mānānka belā",
               "CET",
               "mādinā yuropiāti kār~ā belā",
               "CEST",
               "mādinā yuropiāti belā",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "weḍāhpu yuropiāti mānānka belā",
               "EET",
               "weḍāhpu yuropiāti kār~ā belā",
               "EEST",
               "weḍāhpu yuropiāti belā",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "weḍākūṇūpu yuropiāti mānānka belā",
               "WET",
               "weḍākūṇūpu yuropiāti kār~ā belā",
               "WEST",
               "weḍākūṇūpu yuropiāti belā",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "meksikān pesipic mānānka belā",
               "MST",
               "meksikān pesipic ḍelāiṭ belā",
               "MDT",
               "meksikān pesipic belā",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "dkiṇ aaprika belā",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "madinī mananka belā",
               "CST",
               "madinī ḍelaaiṭ belā",
               "CDT",
               "madinī belā",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "veḍahapu mananka belā",
               "EST",
               "veḍahapu ḍelaaiṭ belā",
               "EST",
               "veḍahapu belā",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "pesipik mananka belā",
               "PST",
               "pesipik ḍelaaiṭ belā",
               "PDT",
               "pesipik belā",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "prenc dakiṇ aḍe aanṭārkṭik belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "gīlbrṭ dīp belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hāwāe- aalūsān mānānka belā",
               "HST",
               "hāwāe- aalūsān ḍelāiṭ belā",
               "HST",
               "hāwāe- aalūsān belā",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "piniksa dīpati belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "sēnṭ pierē aḍē mekwēlān mānānka belā",
               "",
               "sēnṭ pierē aḍē mekwēlān ḍelāiṭ belā",
               "",
               "sēnṭ pierē aḍē mekwēlān belā",
               "",
            };
        final String[] America_Mountain = new String[] {
               "harka mananka belā",
               "MST",
               "harka ḍelaaiṭ belā",
               "MST",
               "harka belā",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "mārsāl dīpa belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "pāpuā niu gunīā belā",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "āstreliāti mādinā mānānka belā",
               "ACST",
               "āstreliāti mādinā delāiṭ belā",
               "ACDT",
               "mādinā āstreliā belā",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "āstreliāti weḍāhapū mānānka belā",
               "AEST",
               "āstreliāti weḍāhapū delāiti belā",
               "AEDT",
               "weḍāhapu āstraliā belā",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "āstreliāti weḍākuṇupū mānānka belā",
               "AWST",
               "āstreliāti weḍākuṇupū delāiṭ belā",
               "AWDT",
               "weḍākuṇupū āstreliā belā",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "mādini inḍnesiā belā",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "weḍāhpu inḍnesiā belā",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "weḍākūṇpū inḍnesiā belā",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "āstreliāti mādinā weḍākuṇupu mānānka belā",
               "",
               "āstreliāti mādinā weḍākuṇupu delāiṭ belā",
               "",
               "āstreliāti mādinā weḍākuṇupu belā",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "smani jaga pruti belā",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "aairis manaka belā",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "smani jaga pruti belā",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "smani jaga pruti belā",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "smani jaga pruti belā",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "smani jaga pruti belā",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "smani jaga pruti belā",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "aairis manaka belā",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "grinwic mīn belā",
                    "GMT",
                    "briṭis karã masa belā",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "eḍen" },
            { "timezone.excity.Asia/Baku", "baku" },
            { "timezone.excity.Asia/Dili", "ḍili" },
            { "timezone.excity.Asia/Gaza", "gaja" },
            { "timezone.excity.Asia/Hovd", "hovd" },
            { "timezone.excity.Asia/Omsk", "omsk" },
            { "timezone.excity.Asia/Oral", "oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "amman" },
            { "timezone.excity.Asia/Aqtau", "aktau" },
            { "timezone.excity.Asia/Chita", "cita" },
            { "timezone.excity.Asia/Dhaka", "ḍaka" },
            { "timezone.excity.Asia/Dubai", "dubai" },
            { "timezone.excity.Asia/Kabul", "kabul" },
            { "timezone.excity.Asia/Macau", "mkao" },
            { "timezone.excity.Asia/Qatar", "katar" },
            { "timezone.excity.Asia/Seoul", "seol" },
            { "timezone.excity.Asia/Tokyo", "ṭokyo" },
            { "timezone.excity.Asia/Tomsk", "ṭomsk" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "juba" },
            { "timezone.excity.Africa/Lome", "lom" },
            { "timezone.excity.Asia/Almaty", "almaṭy" },
            { "timezone.excity.Asia/Anadyr", "anaḍir" },
            { "timezone.excity.Asia/Aqtobe", "aaktobe" },
            { "timezone.excity.Asia/Atyrau", "atarau" },
            { "timezone.excity.Asia/Beirut", "beirut" },
            { "timezone.excity.Asia/Brunei", "brunei" },
            { "timezone.excity.Asia/Hebron", "hebron" },
            { "timezone.excity.Asia/Kuwait", "kuvait" },
            { "timezone.excity.Asia/Manila", "manīla" },
            { "timezone.excity.Asia/Muscat", "maskat" },
            { "timezone.excity.Asia/Riyadh", "riyad" },
            { "timezone.excity.Asia/Saigon", "ho ci minh siti" },
            { "timezone.excity.Asia/Taipei", "taipei" },
            { "timezone.excity.Asia/Tehran", "tehran" },
            { "timezone.excity.Asia/Urumqi", "urumci" },
            { "timezone.excity.Etc/Unknown", "puṇaã ti gaḍa" },
            { "timezone.excity.Europe/Kiev", "kiyv" },
            { "timezone.excity.Europe/Oslo", "oslo" },
            { "timezone.excity.Europe/Riga", "riga" },
            { "timezone.excity.Europe/Rome", "rom" },
            { "timezone.excity.Indian/Mahe", "mahe" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ecra" },
            { "timezone.excity.Africa/Cairo", "kairo" },
            { "timezone.excity.Africa/Ceuta", "seuṭa" },
            { "timezone.excity.Africa/Dakar", "ḍkar" },
            { "timezone.excity.Africa/Lagos", "lagos" },
            { "timezone.excity.Africa/Tunis", "ṭunis" },
            { "timezone.excity.America/Adak", "aḍak" },
            { "timezone.excity.America/Lima", "lima" },
            { "timezone.excity.America/Nome", "nom" },
            { "timezone.excity.Asia/Baghdad", "bagdad" },
            { "timezone.excity.Asia/Bahrain", "bahrain" },
            { "timezone.excity.Asia/Bangkok", "bangkok" },
            { "timezone.excity.Asia/Barnaul", "barnaul" },
            { "timezone.excity.Asia/Bishkek", "biskek" },
            { "timezone.excity.Asia/Colombo", "kolombo" },
            { "timezone.excity.Asia/Irkutsk", "irkuṭsk" },
            { "timezone.excity.Asia/Jakarta", "jakarta" },
            { "timezone.excity.Asia/Karachi", "karacī" },
            { "timezone.excity.Asia/Kuching", "kucing" },
            { "timezone.excity.Asia/Magadan", "megaḍan" },
            { "timezone.excity.Asia/Nicosia", "nikosiya" },
            { "timezone.excity.Asia/Rangoon", "yangon" },
            { "timezone.excity.Asia/Tbilisi", "tbilisi" },
            { "timezone.excity.Asia/Thimphu", "timphu" },
            { "timezone.excity.Asia/Yakutsk", "yakuṭsk" },
            { "timezone.excity.Asia/Yerevan", "yerevan" },
            { "timezone.excity.Europe/Kirov", "kirov" },
            { "timezone.excity.Europe/Malta", "malṭa" },
            { "timezone.excity.Europe/Minsk", "minsk" },
            { "timezone.excity.Europe/Paris", "paris" },
            { "timezone.excity.Europe/Sofia", "sopiya" },
            { "timezone.excity.Europe/Vaduz", "vaḍuj" },
            { "timezone.excity.Indian/Cocos", "kokos" },
            { "timezone.excity.Pacific/Apia", "apia" },
            { "timezone.excity.Pacific/Fiji", "piji" },
            { "timezone.excity.Pacific/Guam", "guam" },
            { "timezone.excity.Pacific/Niue", "niue" },
            { "timezone.excity.Pacific/Truk", "cūk" },
            { "timezone.excity.Pacific/Wake", "vek" },
            { "timezone.excity.Africa/Asmera", "asmara" },
            { "timezone.excity.Africa/Bamako", "bamako" },
            { "timezone.excity.Africa/Bangui", "bangui" },
            { "timezone.excity.Africa/Banjul", "banjul" },
            { "timezone.excity.Africa/Bissau", "bissau" },
            { "timezone.excity.Africa/Douala", "duala" },
            { "timezone.excity.Africa/Harare", "hrare" },
            { "timezone.excity.Africa/Kigali", "kigali" },
            { "timezone.excity.Africa/Luanda", "luanḍa" },
            { "timezone.excity.Africa/Lusaka", "lusaka" },
            { "timezone.excity.Africa/Malabo", "malabo" },
            { "timezone.excity.Africa/Maputo", "mapuṭu" },
            { "timezone.excity.Africa/Maseru", "maseru" },
            { "timezone.excity.Africa/Niamey", "niyame" },
            { "timezone.excity.America/Aruba", "aruba" },
            { "timezone.excity.America/Bahia", "bahia" },
            { "timezone.excity.America/Belem", "belem" },
            { "timezone.excity.America/Boise", "boisī" },
            { "timezone.excity.America/Jujuy", "huhue" },
            { "timezone.excity.America/Sitka", "sitka" },
            { "timezone.excity.America/Thule", "tule" },
            { "timezone.excity.Asia/Ashgabat", "asgabaṭ" },
            { "timezone.excity.Asia/Calcutta", "kolkata" },
            { "timezone.excity.Asia/Damascus", "ḍamaskus" },
            { "timezone.excity.Asia/Dushanbe", "dusambe" },
            { "timezone.excity.Asia/Jayapura", "jayapura" },
            { "timezone.excity.Asia/Katmandu", "kaṭmanḍu" },
            { "timezone.excity.Asia/Khandyga", "kandiga" },
            { "timezone.excity.Asia/Makassar", "makasar" },
            { "timezone.excity.Asia/Qostanay", "kosṭane" },
            { "timezone.excity.Asia/Sakhalin", "sahalin" },
            { "timezone.excity.Asia/Shanghai", "sengai" },
            { "timezone.excity.Asia/Tashkent", "taskenṭ" },
            { "timezone.excity.Asia/Ust-Nera", "yust-nera" },
            { "timezone.excity.Europe/Athens", "etens" },
            { "timezone.excity.Europe/Berlin", "berlin" },
            { "timezone.excity.Europe/Dublin", "ḍblin" },
            { "timezone.excity.Europe/Jersey", "jersi" },
            { "timezone.excity.Europe/Lisbon", "lisbon" },
            { "timezone.excity.Europe/London", "lnḍn" },
            { "timezone.excity.Europe/Madrid", "meḍriḍ" },
            { "timezone.excity.Europe/Monaco", "monako" },
            { "timezone.excity.Europe/Moscow", "mosko" },
            { "timezone.excity.Europe/Prague", "prag" },
            { "timezone.excity.Europe/Samara", "samara" },
            { "timezone.excity.Europe/Skopje", "skopi" },
            { "timezone.excity.Europe/Tirane", "ṭirane" },
            { "timezone.excity.Europe/Vienna", "vienna" },
            { "timezone.excity.Europe/Warsaw", "varsa" },
            { "timezone.excity.Europe/Zagreb", "tegusigalpa" },
            { "timezone.excity.Europe/Zurich", "juric" },
            { "timezone.excity.Indian/Chagos", "chagos" },
            { "timezone.excity.Indian/Comoro", "komoro" },
            { "timezone.excity.Pacific/Efate", "ipeṭe" },
            { "timezone.excity.Pacific/Nauru", "nauru" },
            { "timezone.excity.Pacific/Palau", "palau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "abidjan" },
            { "timezone.excity.Africa/Algiers", "aljīyrs" },
            { "timezone.excity.Africa/Conakry", "konakrī" },
            { "timezone.excity.Africa/Kampala", "kmpala" },
            { "timezone.excity.Africa/Mbabane", "mbabane" },
            { "timezone.excity.Africa/Nairobi", "nairobi" },
            { "timezone.excity.Africa/Tripoli", "tripoli" },
            { "timezone.excity.America/Belize", "belij" },
            { "timezone.excity.America/Bogota", "bogoṭa" },
            { "timezone.excity.America/Cancun", "kankun" },
            { "timezone.excity.America/Cayman", "keiman" },
            { "timezone.excity.America/Cuiaba", "kuaaba" },
            { "timezone.excity.America/Dawson", "ḍaosn" },
            { "timezone.excity.America/Denver", "ḍenver" },
            { "timezone.excity.America/Guyana", "guyana" },
            { "timezone.excity.America/Havana", "havana" },
            { "timezone.excity.America/Inuvik", "inūvik" },
            { "timezone.excity.America/Juneau", "junov" },
            { "timezone.excity.America/La_Paz", "la paj" },
            { "timezone.excity.America/Maceio", "masīo" },
            { "timezone.excity.America/Manaus", "manaus" },
            { "timezone.excity.America/Merida", "meriḍa" },
            { "timezone.excity.America/Nassau", "nasau" },
            { "timezone.excity.America/Panama", "panama" },
            { "timezone.excity.America/Recife", "resipi" },
            { "timezone.excity.America/Regina", "rejina" },
            { "timezone.excity.Asia/Famagusta", "pamagusta" },
            { "timezone.excity.Asia/Hong_Kong", "hong kong" },
            { "timezone.excity.Asia/Jerusalem", "jerusalem" },
            { "timezone.excity.Asia/Kamchatka", "kamcaṭka" },
            { "timezone.excity.Asia/Pontianak", "ponṭianak" },
            { "timezone.excity.Asia/Pyongyang", "pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "kijuorda" },
            { "timezone.excity.Asia/Samarkand", "samarkand" },
            { "timezone.excity.Asia/Singapore", "singapor" },
            { "timezone.excity.Asia/Vientiane", "vienṭiaan" },
            { "timezone.excity.Europe/Andorra", "aaṇḍora" },
            { "timezone.excity.Europe/Saratov", "saraṭov" },
            { "timezone.excity.Europe/Tallinn", "talin" },
            { "timezone.excity.Europe/Vatican", "vaṭikan" },
            { "timezone.excity.Europe/Vilnius", "vilnius" },
            { "timezone.excity.Indian/Mayotte", "mayoṭ" },
            { "timezone.excity.Indian/Reunion", "reunion" },
            { "timezone.excity.Pacific/Easter", "īster" },
            { "timezone.excity.Pacific/Kanton", "kanṭon" },
            { "timezone.excity.Pacific/Kosrae", "kisrae" },
            { "timezone.excity.Pacific/Majuro", "majuro" },
            { "timezone.excity.Pacific/Midway", "miḍvay" },
            { "timezone.excity.Pacific/Noumea", "numie" },
            { "timezone.excity.Pacific/Ponape", "ponpei" },
            { "timezone.excity.Pacific/Saipan", "saipan" },
            { "timezone.excity.Pacific/Tahiti", "ṭahiṭi" },
            { "timezone.excity.Pacific/Tarawa", "tarava" },
            { "timezone.excity.Pacific/Wallis", "vallis" },
            { "timezone.excity.Africa/Blantyre", "blanṭaer" },
            { "timezone.excity.Africa/Djibouti", "jibuti" },
            { "timezone.excity.Africa/El_Aaiun", "el aaiyun" },
            { "timezone.excity.Africa/Freetown", "prīṭaun" },
            { "timezone.excity.Africa/Gaborone", "gaboron" },
            { "timezone.excity.Africa/Khartoum", "karṭoum" },
            { "timezone.excity.Africa/Kinshasa", "kinsasa" },
            { "timezone.excity.Africa/Monrovia", "monrovia" },
            { "timezone.excity.Africa/Ndjamena", "njamena" },
            { "timezone.excity.Africa/Sao_Tome", "sao ṭom" },
            { "timezone.excity.Africa/Windhoek", "vindhuk" },
            { "timezone.excity.America/Antigua", "enṭigua" },
            { "timezone.excity.America/Caracas", "karakas" },
            { "timezone.excity.America/Cayenne", "keyen" },
            { "timezone.excity.America/Chicago", "cikago" },
            { "timezone.excity.America/Cordoba", "korḍaba" },
            { "timezone.excity.America/Creston", "kresṭon" },
            { "timezone.excity.America/Curacao", "kyuraso" },
            { "timezone.excity.America/Detroit", "ḍeṭroiṭ" },
            { "timezone.excity.America/Godthab", "nūk" },
            { "timezone.excity.America/Grenada", "grenaḍa" },
            { "timezone.excity.America/Halifax", "helipaks" },
            { "timezone.excity.America/Iqaluit", "ikaluiṭ" },
            { "timezone.excity.America/Jamaica", "jamaika" },
            { "timezone.excity.America/Managua", "managua" },
            { "timezone.excity.America/Marigot", "marigoṭ" },
            { "timezone.excity.America/Mendoza", "menḍoja" },
            { "timezone.excity.America/Moncton", "monkṭon" },
            { "timezone.excity.America/Noronha", "noronha" },
            { "timezone.excity.America/Ojinaga", "ojinaga" },
            { "timezone.excity.America/Phoenix", "piniks" },
            { "timezone.excity.America/Tijuana", "tihvana" },
            { "timezone.excity.America/Toronto", "ṭoronṭo" },
            { "timezone.excity.America/Tortola", "ṭorṭola" },
            { "timezone.excity.America/Yakutat", "yakuṭaṭ" },
            { "timezone.excity.Asia/Phnom_Penh", "pnom penh" },
            { "timezone.excity.Atlantic/Azores", "ajores" },
            { "timezone.excity.Atlantic/Canary", "keneri" },
            { "timezone.excity.Atlantic/Faeroe", "pero" },
            { "timezone.excity.Australia/Eucla", "yukla" },
            { "timezone.excity.Australia/Perth", "pert" },
            { "timezone.excity.Europe/Belgrade", "belgraḍe" },
            { "timezone.excity.Europe/Brussels", "brussels" },
            { "timezone.excity.Europe/Budapest", "buḍapest" },
            { "timezone.excity.Europe/Busingen", "busingen" },
            { "timezone.excity.Europe/Chisinau", "kisinau" },
            { "timezone.excity.Europe/Guernsey", "gernsi" },
            { "timezone.excity.Europe/Helsinki", "helsinki" },
            { "timezone.excity.Europe/Istanbul", "istanbul" },
            { "timezone.excity.Europe/Sarajevo", "sarajevo" },
            { "timezone.excity.Indian/Maldives", "maldives" },
            { "timezone.excity.Pacific/Chatham", "ceṭam" },
            { "timezone.excity.Pacific/Fakaofo", "pakaopo" },
            { "timezone.excity.Pacific/Gambier", "gambier" },
            { "timezone.excity.Pacific/Norfolk", "norpok" },
            { "timezone.excity.Africa/Bujumbura", "bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "mogaḍisu" },
            { "timezone.excity.America/Anguilla", "enguilla" },
            { "timezone.excity.America/Asuncion", "esunsion" },
            { "timezone.excity.America/Barbados", "barbaḍos" },
            { "timezone.excity.America/Dominica", "ḍominika" },
            { "timezone.excity.America/Edmonton", "eḍmonṭon" },
            { "timezone.excity.America/Eirunepe", "eirunepe" },
            { "timezone.excity.America/Mazatlan", "masaṭlan" },
            { "timezone.excity.America/Miquelon", "mikvilõ" },
            { "timezone.excity.America/New_York", "niyu york" },
            { "timezone.excity.America/Resolute", "rejalyuṭ" },
            { "timezone.excity.America/Santarem", "satari" },
            { "timezone.excity.America/Santiago", "sanṭiago" },
            { "timezone.excity.America/St_Johns", "senṭ jons" },
            { "timezone.excity.America/St_Kitts", "sent kiṭṭs" },
            { "timezone.excity.America/St_Lucia", "sent lusia" },
            { "timezone.excity.America/Winnipeg", "vinnipeg" },
            { "timezone.excity.Antarctica/Casey", "kesee" },
            { "timezone.excity.Antarctica/Davis", "ḍevis" },
            { "timezone.excity.Antarctica/Syowa", "syova" },
            { "timezone.excity.Antarctica/Troll", "ṭroll" },
            { "timezone.excity.Asia/Krasnoyarsk", "krasneyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "ulanbaṭar" },
            { "timezone.excity.Asia/Vladivostok", "vlaḍivosṭok" },
            { "timezone.excity.Atlantic/Bermuda", "bermūda" },
            { "timezone.excity.Atlantic/Madeira", "maḍiera" },
            { "timezone.excity.Atlantic/Stanley", "sṭanli" },
            { "timezone.excity.Australia/Darwin", "ḍarvin" },
            { "timezone.excity.Australia/Hobart", "hobarṭ" },
            { "timezone.excity.Australia/Sydney", "syḍnī" },
            { "timezone.excity.Europe/Amsterdam", "amsṭerḍam" },
            { "timezone.excity.Europe/Astrakhan", "aasṭrahan" },
            { "timezone.excity.Europe/Bucharest", "bukarest" },
            { "timezone.excity.Europe/Gibraltar", "jibralṭar" },
            { "timezone.excity.Europe/Ljubljana", "lyublyana" },
            { "timezone.excity.Europe/Mariehamn", "marieham" },
            { "timezone.excity.Europe/Podgorica", "pḍgoritsa" },
            { "timezone.excity.Europe/Stockholm", "sṭokhom" },
            { "timezone.excity.Europe/Ulyanovsk", "ulyanovsk" },
            { "timezone.excity.Europe/Volgograd", "volgograḍ" },
            { "timezone.excity.Indian/Christmas", "krisṭmas" },
            { "timezone.excity.Indian/Kerguelen", "kerguelen" },
            { "timezone.excity.Indian/Mauritius", "maurisius" },
            { "timezone.excity.Pacific/Auckland", "āklanḍ" },
            { "timezone.excity.Pacific/Funafuti", "punaputi" },
            { "timezone.excity.Pacific/Pitcairn", "piṭkern" },
            { "timezone.excity.Africa/Casablanca", "kasablanka" },
            { "timezone.excity.Africa/Libreville", "librevill" },
            { "timezone.excity.Africa/Lubumbashi", "lubumbasi" },
            { "timezone.excity.Africa/Nouakchott", "nueksa" },
            { "timezone.excity.Africa/Porto-Novo", "porṭo-ṇovo" },
            { "timezone.excity.America/Anchorage", "ankoraj" },
            { "timezone.excity.America/Araguaina", "aragvaina" },
            { "timezone.excity.America/Boa_Vista", "boa vista" },
            { "timezone.excity.America/Catamarca", "katamarka" },
            { "timezone.excity.America/Chihuahua", "chihuahua" },
            { "timezone.excity.America/Fortaleza", "portaleja" },
            { "timezone.excity.America/Glace_Bay", "glas bay" },
            { "timezone.excity.America/Goose_Bay", "goos be" },
            { "timezone.excity.America/Guatemala", "guatemala" },
            { "timezone.excity.America/Guayaquil", "guajakil" },
            { "timezone.excity.America/Matamoros", "maṭamoros" },
            { "timezone.excity.America/Menominee", "menominī" },
            { "timezone.excity.America/Monterrey", "monṭerre" },
            { "timezone.excity.America/Sao_Paulo", "sao paulo" },
            { "timezone.excity.America/St_Thomas", "senṭ tomas" },
            { "timezone.excity.America/Vancouver", "vankūver" },
            { "timezone.excity.Antarctica/Mawson", "mavson" },
            { "timezone.excity.Antarctica/Palmer", "palmer" },
            { "timezone.excity.Antarctica/Vostok", "vosṭok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "kuala lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "nevokujneṭsk" },
            { "timezone.excity.Europe/Bratislava", "braṭislava" },
            { "timezone.excity.Europe/Copenhagen", "kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "lksembrg" },
            { "timezone.excity.Europe/San_Marino", "san marino" },
            { "timezone.excity.Europe/Simferopol", "simperopol" },
            { "timezone.excity.Pacific/Galapagos", "galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "kvajalein" },
            { "timezone.excity.Pacific/Marquesas", "markisas" },
            { "timezone.excity.Pacific/Pago_Pago", "pango pango" },
            { "timezone.excity.Pacific/Rarotonga", "rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "ṭongaṭapu" },
            { "timezone.excity.Africa/Addis_Ababa", "aḍis ababa" },
            { "timezone.excity.Africa/Brazzaville", "brajavill" },
            { "timezone.excity.Africa/Ouagadougou", "vagdugu" },
            { "timezone.excity.America/Costa_Rica", "kosṭa rika" },
            { "timezone.excity.America/Grand_Turk", "granḍ ṭurk" },
            { "timezone.excity.America/Guadeloupe", "guaḍeloupe" },
            { "timezone.excity.America/Hermosillo", "ermosijo" },
            { "timezone.excity.America/Kralendijk", "krelenḍeik" },
            { "timezone.excity.America/Louisville", "louiville" },
            { "timezone.excity.America/Martinique", "marṭinik" },
            { "timezone.excity.America/Metlakatla", "meṭlakaṭla" },
            { "timezone.excity.America/Montevideo", "monṭevidio" },
            { "timezone.excity.America/Montserrat", "monṭserreṭ" },
            { "timezone.excity.America/Paramaribo", "paramaribo" },
            { "timezone.excity.America/Rio_Branco", "rio branko" },
            { "timezone.excity.America/St_Vincent", "senṭ vinsenṭ" },
            { "timezone.excity.America/Whitehorse", "vhaiṭhors" },
            { "timezone.excity.Antarctica/McMurdo", "mek murḍo" },
            { "timezone.excity.Antarctica/Rothera", "rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "sreḍnekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "yikaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "reykyavik" },
            { "timezone.excity.Atlantic/St_Helena", "sent helena" },
            { "timezone.excity.Australia/Adelaide", "aedileid" },
            { "timezone.excity.Australia/Brisbane", "brisbane" },
            { "timezone.excity.Australia/Lindeman", "linḍerman" },
            { "timezone.excity.Europe/Isle_of_Man", "aail ap man" },
            { "timezone.excity.Europe/Kaliningrad", "kaliningraḍ" },
            { "timezone.excity.Pacific/Kiritimati", "kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "johannesburg" },
            { "timezone.excity.America/El_Salvador", "el salvaḍor" },
            { "timezone.excity.America/Fort_Nelson", "phort nelsn" },
            { "timezone.excity.America/Los_Angeles", "los anjeles" },
            { "timezone.excity.America/Mexico_City", "meksico siṭy" },
            { "timezone.excity.America/Porto_Velho", "porṭp velho" },
            { "timezone.excity.America/Puerto_Rico", "puerto riko" },
            { "timezone.excity.America/Tegucigalpa", "tegu" },
            { "timezone.excity.Arctic/Longyearbyen", "lngyarbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "kep verḍe" },
            { "timezone.excity.Australia/Lord_Howe", "lorḍ hove" },
            { "timezone.excity.Australia/Melbourne", "melborne" },
            { "timezone.excity.Indian/Antananarivo", "ṭananariv" },
            { "timezone.excity.Pacific/Guadalcanal", "guaḍalkenal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "dar es salaam" },
            { "timezone.excity.America/Blanc-Sablon", "blank-sablon" },
            { "timezone.excity.America/Buenos_Aires", "buenous aires" },
            { "timezone.excity.America/Campo_Grande", "kampo granḍe" },
            { "timezone.excity.America/Danmarkshavn", "ḍanmarksavn" },
            { "timezone.excity.America/Dawson_Creek", "ḍaoson krīk" },
            { "timezone.excity.America/Indiana/Knox", "noks, inḍiyana" },
            { "timezone.excity.America/Indianapolis", "inḍianapolis" },
            { "timezone.excity.America/Punta_Arenas", "puṇṭa erenas" },
            { "timezone.excity.America/Rankin_Inlet", "rankin inledṭ" },
            { "timezone.excity.America/Scoresbysund", "iṭokoṭormiṭ" },
            { "timezone.excity.Antarctica/Macquarie", "mekvari" },
            { "timezone.excity.Pacific/Bougainville", "bouganvill" },
            { "timezone.excity.Pacific/Port_Moresby", "porṭ moresbi" },
            { "timezone.excity.America/Cambridge_Bay", "kembrij be" },
            { "timezone.excity.America/Coral_Harbour", "eṭikoken" },
            { "timezone.excity.America/Indiana/Vevay", "vivi, inḍiyana" },
            { "timezone.excity.America/Lower_Princes", "lover princ’s kuvaṭar" },
            { "timezone.excity.America/Port_of_Spain", "porṭ ap spain" },
            { "timezone.excity.America/Santo_Domingo", "sento ḍomingo" },
            { "timezone.excity.America/St_Barthelemy", "senṭ bartelemi" },
            { "timezone.excity.America/Swift_Current", "svipṭ kurrenṭ" },
            { "timezone.excity.Australia/Broken_Hill", "broken hill" },
            { "timezone.excity.America/Bahia_Banderas", "baia banḍeras" },
            { "timezone.excity.America/Port-au-Prince", "port-au-prinse" },
            { "timezone.excity.Atlantic/South_Georgia", "dkiṇ jorjia" },
            { "timezone.excity.America/Argentina/Salta", "salṭa" },
            { "timezone.excity.America/Indiana/Marengo", "marengo, inḍiyana" },
            { "timezone.excity.America/Indiana/Winamac", "vinamak, inḍiyana" },
            { "timezone.excity.America/Argentina/Tucuman", "ṭukūmn" },
            { "timezone.excity.America/Argentina/Ushuaia", "usvaiya" },
            { "timezone.excity.America/Indiana/Tell_City", "ṭell sity, inḍiyana" },
            { "timezone.excity.America/Indiana/Vincennes", "vincens, inḍiyana" },
            { "timezone.excity.Antarctica/DumontDUrville", "ḍyumont de urvill" },
            { "timezone.excity.America/Argentina/La_Rioja", "la rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "san huan" },
            { "timezone.excity.America/Argentina/San_Luis", "san luis" },
            { "timezone.excity.America/Indiana/Petersburg", "piṭtrsberg, inḍiyana" },
            { "timezone.excity.America/Kentucky/Monticello", "monṭisello, kenṭukī" },
            { "timezone.excity.America/North_Dakota/Beulah", "biyula, uttar ḍakoṭa" },
            { "timezone.excity.America/North_Dakota/Center", "maḍinī uttar ḍakoṭa" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "riyo gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "neu salem, uttar ḍakoṭa" },
        };
        return data;
    }
}
