/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "ਨਾਉਰੂ";
        final String metaValue_TR = "ਤੁਰਕੀ";
        final String metaValue_ar = "ਅਰਬੀ";
        final String metaValue_hy = "ਅਰਮੀਨੀਆਈ";
        final String metaValue_bn = "ਬੰਗਾਲੀ";
        final String metaValue_ccp = "ਚਕਮਾ";
        final String metaValue_ka = "ਜਾਰਜੀਆਈ";
        final String metaValue_el = "ਯੂਨਾਨੀ";
        final String metaValue_gu = "ਗੁਜਰਾਤੀ";
        final String metaValue_he = "ਹਿਬਰੂ";
        final String metaValue_ja = "ਜਪਾਨੀ";
        final String metaValue_km = "ਖਮੇਰ";
        final String metaValue_kn = "ਕੰਨੜ";
        final String metaValue_ko = "ਕੋਰੀਆਈ";
        final String metaValue_lo = "ਲਾਓ";
        final String metaValue_la = "ਲਾਤੀਨੀ";
        final String metaValue_ml = "ਮਲਿਆਲਮ";
        final String metaValue_or = "ਉੜੀਆ";
        final String metaValue_si = "ਸਿੰਹਾਲਾ";
        final String metaValue_su = "ਸੂੰਡਾਨੀ";
        final String metaValue_syr = "ਸੀਰੀਆਈ";
        final String metaValue_ta = "ਤਮਿਲ";
        final String metaValue_te = "ਤੇਲਗੂ";
        final String metaValue_th = "ਥਾਈ";
        final String metaValue_bo = "ਤਿੱਬਤੀ";
        final String metaValue_vai = "ਵਾਈ";
        final Object[][] data = new Object[][] {
            { "001", "ਸੰਸਾਰ" },
            { "002", "ਅਫ਼ਰੀਕਾ" },
            { "003", "ਉੱਤਰ ਅਮਰੀਕਾ" },
            { "005", "ਦੱਖਣ ਅਮਰੀਕਾ" },
            { "009", "ਓਸ਼ੇਨੀਆ" },
            { "011", "ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ" },
            { "013", "ਕੇਂਦਰੀ ਅਮਰੀਕਾ" },
            { "014", "ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ" },
            { "015", "ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ" },
            { "017", "ਮੱਧ ਅਫ਼ਰੀਕਾ" },
            { "018", "ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ" },
            { "019", "ਅਮਰੀਕਾ" },
            { "021", "ਉੱਤਰੀ ਅਮਰੀਕਾ" },
            { "029", "ਕੈਰੇਬੀਆਈ" },
            { "030", "ਪੂਰਬੀ ਏਸ਼ੀਆ" },
            { "034", "ਦੱਖਣੀ ਏਸ਼ੀਆ" },
            { "035", "ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ" },
            { "039", "ਦੱਖਣੀ ਯੂਰਪ" },
            { "053", "ਆਸਟਰੇਲੇਸ਼ੀਆ" },
            { "054", "ਮੇਲਾਨੇਸ਼ੀਆ" },
            { "057", "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਇਲਾਕਾ" },
            { "061", "ਪੋਲੀਨੇਸ਼ੀਆ" },
            { "142", "ਏਸ਼ੀਆ" },
            { "143", "ਕੇਂਦਰੀ ਏਸ਼ੀਆ" },
            { "145", "ਪੱਛਮੀ ਏਸ਼ੀਆ" },
            { "150", "ਯੂਰਪ" },
            { "151", "ਪੂਰਬੀ ਯੂਰਪ" },
            { "154", "ਉੱਤਰੀ ਯੂਰਪ" },
            { "155", "ਪੱਛਮੀ ਯੂਰਪ" },
            { "202", "ਉਪ-ਸਹਾਰਾ ਅਫ਼ਰੀਕਾ" },
            { "419", "ਲਾਤੀਨੀ ਅਮਰੀਕਾ" },
            { "AC", "ਅਸੈਂਸ਼ਨ ਟਾਪੂ" },
            { "AD", "ਅੰਡੋਰਾ" },
            { "AE", "ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ" },
            { "AF", "ਅਫ਼ਗਾਨਿਸਤਾਨ" },
            { "AG", "ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ" },
            { "AI", "ਅੰਗੁਇਲਾ" },
            { "AL", "ਅਲਬਾਨੀਆ" },
            { "AM", "ਅਰਮੀਨੀਆ" },
            { "AO", "ਅੰਗੋਲਾ" },
            { "AQ", "ਅੰਟਾਰਕਟਿਕਾ" },
            { "AR", "ਅਰਜਨਟੀਨਾ" },
            { "AS", "ਅਮੈਰੀਕਨ ਸਮੋਆ" },
            { "AT", "ਆਸਟਰੀਆ" },
            { "AU", "ਆਸਟ੍ਰੇਲੀਆ" },
            { "AW", "ਅਰੂਬਾ" },
            { "AX", "ਅਲੈਂਡ ਟਾਪੂ" },
            { "AZ", "ਅਜ਼ਰਬਾਈਜਾਨ" },
            { "BA", "ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ" },
            { "BB", "ਬਾਰਬਾਡੋਸ" },
            { "BD", "ਬੰਗਲਾਦੇਸ਼" },
            { "BE", "ਬੈਲਜੀਅਮ" },
            { "BF", "ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ" },
            { "BG", "ਬੁਲਗਾਰੀਆ" },
            { "BH", "ਬਹਿਰੀਨ" },
            { "BI", "ਬੁਰੁੰਡੀ" },
            { "BJ", "ਬੇਨਿਨ" },
            { "BL", "ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ" },
            { "BM", "ਬਰਮੂਡਾ" },
            { "BN", "ਬਰੂਨੇਈ" },
            { "BO", "ਬੋਲੀਵੀਆ" },
            { "BQ", "ਕੈਰੇਬੀਆਈ ਨੀਦਰਲੈਂਡ" },
            { "BR", "ਬ੍ਰਾਜ਼ੀਲ" },
            { "BS", "ਬਹਾਮਾਸ" },
            { "BT", "ਭੂਟਾਨ" },
            { "BV", "ਬੌਵੇਟ ਟਾਪੂ" },
            { "BW", "ਬੋਤਸਵਾਨਾ" },
            { "BY", "ਬੇਲਾਰੂਸ" },
            { "BZ", "ਬੇਲੀਜ਼" },
            { "CA", "ਕੈਨੇਡਾ" },
            { "CC", "ਕੋਕੋਸ (ਕੀਲਿੰਗ) ਟਾਪੂ" },
            { "CD", "ਕਾਂਗੋ - ਕਿੰਸ਼ਾਸਾ" },
            { "CF", "ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ ਗਣਰਾਜ" },
            { "CG", "ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ" },
            { "CH", "ਸਵਿਟਜ਼ਰਲੈਂਡ" },
            { "CI", "ਕੋਟ ਡੀਵੋਆਰ" },
            { "CK", "ਕੁੱਕ ਟਾਪੂ" },
            { "CL", "ਚਿਲੀ" },
            { "CM", "ਕੈਮਰੂਨ" },
            { "CN", "ਚੀਨ" },
            { "CO", "ਕੋਲੰਬੀਆ" },
            { "CP", "ਕਲਿੱਪਰਟਨ ਟਾਪੂ" },
            { "CR", "ਕੋਸਟਾ ਰੀਕਾ" },
            { "CU", "ਕਿਊਬਾ" },
            { "CV", "ਕੇਪ ਵਰਡੇ" },
            { "CW", "ਕੁਰਾਕਾਓ" },
            { "CX", "ਕ੍ਰਿਸਮਿਸ ਟਾਪੂ" },
            { "CY", "ਸਾਇਪ੍ਰਸ" },
            { "CZ", "ਚੈਕੀਆ" },
            { "DE", "ਜਰਮਨੀ" },
            { "DG", "ਡੀਇਗੋ ਗਾਰਸੀਆ" },
            { "DJ", "ਜਿਬੂਤੀ" },
            { "DK", "ਡੈਨਮਾਰਕ" },
            { "DM", "ਡੋਮੀਨਿਕਾ" },
            { "DO", "ਡੋਮੀਨਿਕਾਈ ਗਣਰਾਜ" },
            { "DZ", "ਅਲਜੀਰੀਆ" },
            { "EA", "ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ" },
            { "EC", "ਇਕਵੇਡੋਰ" },
            { "EE", "ਇਸਟੋਨੀਆ" },
            { "EG", "ਮਿਸਰ" },
            { "EH", "ਪੱਛਮੀ ਸਹਾਰਾ" },
            { "ER", "ਇਰੀਟ੍ਰਿਆ" },
            { "ES", "ਸਪੇਨ" },
            { "ET", "ਇਥੋਪੀਆ" },
            { "EU", "ਯੂਰਪੀ ਸੰਘ" },
            { "EZ", "ਯੂਰੋਜ਼ੋਨ" },
            { "FI", "ਫਿਨਲੈਂਡ" },
            { "FJ", "ਫ਼ਿਜੀ" },
            { "FK", "ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ" },
            { "FM", "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ" },
            { "FO", "ਫੈਰੋ ਟਾਪੂ" },
            { "FR", "ਫ਼ਰਾਂਸ" },
            { "GA", "ਗਬੋਨ" },
            { "GB", "ਯੂਨਾਈਟਡ ਕਿੰਗਡਮ" },
            { "GD", "ਗ੍ਰੇਨਾਡਾ" },
            { "GE", "ਜਾਰਜੀਆ" },
            { "GF", "ਫਰੈਂਚ ਗੁਇਆਨਾ" },
            { "GG", "ਗਰਨਜੀ" },
            { "GH", "ਘਾਨਾ" },
            { "GI", "ਜਿਬਰਾਲਟਰ" },
            { "GL", "ਗ੍ਰੀਨਲੈਂਡ" },
            { "GM", "ਗੈਂਬੀਆ" },
            { "GN", "ਗਿਨੀ" },
            { "GP", "ਗੁਆਡੇਲੋਪ" },
            { "GQ", "ਭੂ-ਖੰਡੀ ਗਿਨੀ" },
            { "GR", "ਗ੍ਰੀਸ" },
            { "GS", "ਦੱਖਣੀ ਜਾਰਜੀਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਟਾਪੂ" },
            { "GT", "ਗੁਆਟੇਮਾਲਾ" },
            { "GU", "ਗੁਆਮ" },
            { "GW", "ਗਿਨੀ-ਬਿਸਾਉ" },
            { "GY", "ਗੁਯਾਨਾ" },
            { "HK", "ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ" },
            { "HM", "ਹਰਡ ਤੇ ਮੈਕਡੋਨਾਲਡ ਟਾਪੂ" },
            { "HN", "ਹੋਂਡੁਰਸ" },
            { "HR", "ਕਰੋਏਸ਼ੀਆ" },
            { "HT", "ਹੈਤੀ" },
            { "HU", "ਹੰਗਰੀ" },
            { "IC", "ਕੇਨਾਰੀ ਟਾਪੂ" },
            { "ID", "ਇੰਡੋਨੇਸ਼ੀਆ" },
            { "IE", "ਆਇਰਲੈਂਡ" },
            { "IL", "ਇਜ਼ਰਾਈਲ" },
            { "IM", "ਆਇਲ ਆਫ ਮੈਨ" },
            { "IN", "ਭਾਰਤ" },
            { "IO", "ਬਰਤਾਨਵੀ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਖਿੱਤਾ" },
            { "IQ", "ਇਰਾਕ" },
            { "IR", "ਈਰਾਨ" },
            { "IS", "ਆਈਸਲੈਂਡ" },
            { "IT", "ਇਟਲੀ" },
            { "JE", "ਜਰਸੀ" },
            { "JM", "ਜਮਾਇਕਾ" },
            { "JO", "ਜਾਰਡਨ" },
            { "JP", "ਜਪਾਨ" },
            { "KE", "ਕੀਨੀਆ" },
            { "KG", "ਕਿਰਗਿਜ਼ਸਤਾਨ" },
            { "KH", "ਕੰਬੋਡੀਆ" },
            { "KI", "ਕਿਰਬਾਤੀ" },
            { "KM", "ਕੋਮੋਰੋਸ" },
            { "KN", "ਸੇਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ" },
            { "KP", "ਉੱਤਰ ਕੋਰੀਆ" },
            { "KR", "ਦੱਖਣ ਕੋਰੀਆ" },
            { "KW", "ਕੁਵੈਤ" },
            { "KY", "ਕੇਮੈਨ ਟਾਪੂ" },
            { "KZ", "ਕਜ਼ਾਖਸਤਾਨ" },
            { "LA", "ਲਾਓਸ" },
            { "LB", "ਲੈਬਨਾਨ" },
            { "LC", "ਸੇਂਟ ਲੂਸੀਆ" },
            { "LI", "ਲਿਚੇਂਸਟਾਇਨ" },
            { "LK", "ਸ੍ਰੀ ਲੰਕਾ" },
            { "LR", "ਲਾਈਬੀਰੀਆ" },
            { "LS", "ਲੇਸੋਥੋ" },
            { "LT", "ਲਿਥੁਆਨੀਆ" },
            { "LU", "ਲਕਜ਼ਮਬਰਗ" },
            { "LV", "ਲਾਤਵੀਆ" },
            { "LY", "ਲੀਬੀਆ" },
            { "MA", "ਮੋਰੱਕੋ" },
            { "MC", "ਮੋਨਾਕੋ" },
            { "MD", "ਮੋਲਡੋਵਾ" },
            { "ME", "ਮੋਂਟੇਨੇਗਰੋ" },
            { "MF", "ਸੇਂਟ ਮਾਰਟਿਨ" },
            { "MG", "ਮੈਡਾਗਾਸਕਰ" },
            { "MH", "ਮਾਰਸ਼ਲ ਟਾਪੂ" },
            { "MK", "ਉੱਤਰੀ ਮੈਕਡੋਨੀਆ" },
            { "ML", "ਮਾਲੀ" },
            { "MM", "ਮਿਆਂਮਾਰ (ਬਰਮਾ)" },
            { "MN", "ਮੰਗੋਲੀਆ" },
            { "MO", "ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ" },
            { "MP", "ਉੱਤਰੀ ਮਾਰੀਆਨਾ ਟਾਪੂ" },
            { "MQ", "ਮਾਰਟੀਨਿਕ" },
            { "MR", "ਮੋਰਿਟਾਨੀਆ" },
            { "MS", "ਮੋਂਟਸੇਰਾਤ" },
            { "MT", "ਮਾਲਟਾ" },
            { "MU", "ਮੌਰੀਸ਼ਸ" },
            { "MV", "ਮਾਲਦੀਵ" },
            { "MW", "ਮਲਾਵੀ" },
            { "MX", "ਮੈਕਸੀਕੋ" },
            { "MY", "ਮਲੇਸ਼ੀਆ" },
            { "MZ", "ਮੋਜ਼ਾਮਬੀਕ" },
            { "NA", "ਨਾਮੀਬੀਆ" },
            { "NC", "ਨਿਊ ਕੈਲੇਡੋਨੀਆ" },
            { "NE", "ਨਾਈਜਰ" },
            { "NF", "ਨੋਰਫੌਕ ਟਾਪੂ" },
            { "NG", "ਨਾਈਜੀਰੀਆ" },
            { "NI", "ਨਿਕਾਰਾਗੁਆ" },
            { "NL", "ਨੀਦਰਲੈਂਡ" },
            { "NO", "ਨਾਰਵੇ" },
            { "NP", "ਨੇਪਾਲ" },
            { "NR", metaValue_NR },
            { "NU", "ਨਿਯੂ" },
            { "NZ", "ਨਿਊਜ਼ੀਲੈਂਡ" },
            { "OM", "ਓਮਾਨ" },
            { "PA", "ਪਨਾਮਾ" },
            { "PE", "ਪੇਰੂ" },
            { "PF", "ਫਰੈਂਚ ਪੋਲੀਨੇਸ਼ੀਆ" },
            { "PG", "ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ" },
            { "PH", "ਫਿਲੀਪੀਨਜ" },
            { "PK", "ਪਾਕਿਸਤਾਨ" },
            { "PL", "ਪੋਲੈਂਡ" },
            { "PM", "ਸੇਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ" },
            { "PN", "ਪਿਟਕੇਰਨ ਟਾਪੂ" },
            { "PR", "ਪਿਊਰਟੋ ਰਿਕੋ" },
            { "PS", "ਫਿਲੀਸਤੀਨੀ ਇਲਾਕਾ" },
            { "PT", "ਪੁਰਤਗਾਲ" },
            { "PW", "ਪਲਾਉ" },
            { "PY", "ਪੈਰਾਗਵੇ" },
            { "QA", "ਕਤਰ" },
            { "QO", "ਆਊਟਲਾਇੰਗ ਓਸ਼ੀਨੀਆ" },
            { "RE", "ਰਿਯੂਨੀਅਨ" },
            { "RO", "ਰੋਮਾਨੀਆ" },
            { "RS", "ਸਰਬੀਆ" },
            { "RU", "ਰੂਸ" },
            { "RW", "ਰਵਾਂਡਾ" },
            { "SA", "ਸਾਊਦੀ ਅਰਬ" },
            { "SB", "ਸੋਲੋਮਨ ਟਾਪੂ" },
            { "SC", "ਸੇਸ਼ਲਸ" },
            { "SD", "ਸੂਡਾਨ" },
            { "SE", "ਸਵੀਡਨ" },
            { "SG", "ਸਿੰਗਾਪੁਰ" },
            { "SH", "ਸੇਂਟ ਹੇਲੇਨਾ" },
            { "SI", "ਸਲੋਵੇਨੀਆ" },
            { "SJ", "ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ" },
            { "SK", "ਸਲੋਵਾਕੀਆ" },
            { "SL", "ਸਿਏਰਾ ਲਿਓਨ" },
            { "SM", "ਸੈਨ ਮਰੀਨੋ" },
            { "SN", "ਸੇਨੇਗਲ" },
            { "SO", "ਸੋਮਾਲੀਆ" },
            { "SR", "ਸੂਰੀਨਾਮ" },
            { "SS", "ਦੱਖਣ ਸੁਡਾਨ" },
            { "ST", "ਸਾਓ ਟੋਮ ਅਤੇ ਪ੍ਰਿੰਸੀਪੇ" },
            { "SV", "ਅਲ ਸਲਵਾਡੋਰ" },
            { "SX", "ਸਿੰਟ ਮਾਰਟੀਨ" },
            { "SY", "ਸੀਰੀਆ" },
            { "SZ", "ਇਸਵਾਤੀਨੀ" },
            { "TA", "ਟ੍ਰਿਸਟਾਨ ਦਾ ਕੁੰਹਾ" },
            { "TC", "ਟੁਰਕਸ ਅਤੇ ਕੈਕੋਸ ਟਾਪੂ" },
            { "TD", "ਚਾਡ" },
            { "TF", "ਫਰੈਂਚ ਦੱਖਣੀ ਪ੍ਰਦੇਸ਼" },
            { "TG", "ਟੋਗੋ" },
            { "TH", "ਥਾਈਲੈਂਡ" },
            { "TJ", "ਤਾਜਿਕਿਸਤਾਨ" },
            { "TK", "ਟੋਕੇਲਾਉ" },
            { "TL", "ਤਿਮੋਰ-ਲੇਸਤੇ" },
            { "TM", "ਤੁਰਕਮੇਨਿਸਤਾਨ" },
            { "TN", "ਟਿਊਨੀਸ਼ੀਆ" },
            { "TO", "ਟੌਂਗਾ" },
            { "TR", metaValue_TR },
            { "TT", "ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ" },
            { "TV", "ਟੁਵਾਲੂ" },
            { "TW", "ਤਾਇਵਾਨ" },
            { "TZ", "ਤਨਜ਼ਾਨੀਆ" },
            { "UA", "ਯੂਕਰੇਨ" },
            { "UG", "ਯੂਗਾਂਡਾ" },
            { "UM", "ਯੂ.ਐੱਸ. ਦੂਰ-ਦੁਰਾਡੇ ਟਾਪੂ" },
            { "UN", "ਸੰਯੁਕਤ ਰਾਸ਼ਟਰ" },
            { "US", "ਸੰਯੁਕਤ ਰਾਜ" },
            { "UY", "ਉਰੂਗਵੇ" },
            { "UZ", "ਉਜ਼ਬੇਕਿਸਤਾਨ" },
            { "VA", "ਵੈਟੀਕਨ ਸਿਟੀ" },
            { "VC", "ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ" },
            { "VE", "ਵੇਨੇਜ਼ੂਏਲਾ" },
            { "VG", "ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਟਾਪੂ" },
            { "VI", "ਯੂ ਐੱਸ ਵਰਜਿਨ ਟਾਪੂ" },
            { "VN", "ਵੀਅਤਨਾਮ" },
            { "VU", "ਵਾਨੂਆਟੂ" },
            { "WF", "ਵਾਲਿਸ ਅਤੇ ਫੂਟੂਨਾ" },
            { "WS", "ਸਾਮੋਆ" },
            { "XA", "ਗਲਤ-ਉਚਾਰਨ" },
            { "XB", "ਲਿਖਤ ਦੀ ਗਲਤ ਦਿਸ਼ਾ" },
            { "XK", "ਕੋਸੋਵੋ" },
            { "YE", "ਯਮਨ" },
            { "YT", "ਮਾਯੋਟੀ" },
            { "ZA", "ਦੱਖਣੀ ਅਫਰੀਕਾ" },
            { "ZM", "ਜ਼ਾਮਬੀਆ" },
            { "ZW", "ਜ਼ਿੰਬਾਬਵੇ" },
            { "ZZ", "ਅਣਪਛਾਤਾ ਇਲਾਕਾ" },
            { "aa", "ਅਫ਼ਾਰ" },
            { "ab", "ਅਬਖਾਜ਼ੀਅਨ" },
            { "af", "ਅਫ਼ਰੀਕੀ" },
            { "ak", "ਅਕਾਨ" },
            { "am", "ਅਮਹਾਰਿਕ" },
            { "an", "ਅਰਾਗੋਨੀ" },
            { "ar", metaValue_ar },
            { "as", "ਅਸਾਮੀ" },
            { "av", "ਅਵਾਰਿਕ" },
            { "ay", "ਅਈਮਾਰਾ" },
            { "az", "ਅਜ਼ਰਬਾਈਜਾਨੀ" },
            { "ba", "ਬਸ਼ਕੀਰ" },
            { "be", "ਬੇਲਾਰੂਸੀ" },
            { "bg", "ਬੁਲਗਾਰੀਆਈ" },
            { "bi", "ਬਿਸਲਾਮਾ" },
            { "bm", "ਬੰਬਾਰਾ" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ਬਰੇਟਨ" },
            { "bs", "ਬੋਸਨੀਆਈ" },
            { "ca", "ਕੈਟਾਲਾਨ" },
            { "ce", "ਚੇਚਨ" },
            { "ch", "ਚਮੋਰੋ" },
            { "co", "ਕੋਰਸੀਕਨ" },
            { "cs", "ਚੈੱਕ" },
            { "cu", "ਚਰਚ ਸਲਾਵੀ" },
            { "cv", "ਚੁਵਾਸ਼" },
            { "cy", "ਵੈਲਸ਼" },
            { "da", "ਡੈਨਿਸ਼" },
            { "de", "ਜਰਮਨ" },
            { "dv", "ਦਿਵੇਹੀ" },
            { "dz", "ਜ਼ੋਂਗਖਾ" },
            { "ee", "ਈਵਈ" },
            { "el", metaValue_el },
            { "en", "ਅੰਗਰੇਜ਼ੀ" },
            { "eo", "ਇਸਪੇਰਾਂਟੋ" },
            { "es", "ਸਪੇਨੀ" },
            { "et", "ਇਸਟੋਨੀਆਈ" },
            { "eu", "ਬਾਸਕ" },
            { "fa", "ਫ਼ਾਰਸੀ" },
            { "ff", "ਫੁਲਾਹ" },
            { "fi", "ਫਿਨਿਸ਼" },
            { "fj", "ਫ਼ਿਜ਼ੀ" },
            { "fo", "ਫ਼ੇਰੋਸੇ" },
            { "fr", "ਫਰਾਂਸੀਸੀ" },
            { "fy", "ਪੱਛਮੀ ਫ੍ਰਿਸੀਅਨ" },
            { "ga", "ਆਇਰਸ਼" },
            { "gd", "ਸਕਾਟਿਸ਼ ਗੇਲਿਕ" },
            { "gl", "ਗੈਲਿਸ਼ਿਅਨ" },
            { "gn", "ਗੁਆਰਾਨੀ" },
            { "gu", metaValue_gu },
            { "gv", "ਮੈਂਕਸ" },
            { "ha", "ਹੌਸਾ" },
            { "he", metaValue_he },
            { "hi", "ਹਿੰਦੀ" },
            { "hr", "ਕ੍ਰੋਏਸ਼ਿਆਈ" },
            { "ht", "ਹੈਤੀਆਈ" },
            { "hu", "ਹੰਗਰੀਆਈ" },
            { "hy", metaValue_hy },
            { "hz", "ਹਰੇਰੋ" },
            { "ia", "ਇੰਟਰਲਿੰਗੁਆ" },
            { "id", "ਇੰਡੋਨੇਸ਼ੀਆਈ" },
            { "ie", "ਇੰਟਰਲਿੰਗੁਈ" },
            { "ig", "ਇਗਬੋ" },
            { "ii", "ਸਿਚੁਆਨ ਯੀ" },
            { "io", "ਇਡੂ" },
            { "is", "ਆਈਸਲੈਂਡਿਕ" },
            { "it", "ਇਤਾਲਵੀ" },
            { "iu", "ਇੰਕਟੀਟੂਤ" },
            { "ja", metaValue_ja },
            { "jv", "ਜਾਵਾਨੀਜ਼" },
            { "ka", metaValue_ka },
            { "ki", "ਕਿਕੂਯੂ" },
            { "kj", "ਕੁਆਨਯਾਮਾ" },
            { "kk", "ਕਜ਼ਾਖ਼" },
            { "kl", "ਕਲਾਅੱਲੀਸੁਟ" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "ਕਨੂਰੀ" },
            { "ks", "ਕਸ਼ਮੀਰੀ" },
            { "ku", "ਕੁਰਦਿਸ਼" },
            { "kv", "ਕੋਮੀ" },
            { "kw", "ਕੋਰਨਿਸ਼" },
            { "ky", "ਕਿਰਗੀਜ਼" },
            { "la", metaValue_la },
            { "lb", "ਲਕਜ਼ਮਬਰਗਿਸ਼" },
            { "lg", "ਗਾਂਡਾ" },
            { "li", "ਲਿਮਬੁਰਗੀ" },
            { "ln", "ਲਿੰਗਾਲਾ" },
            { "lo", metaValue_lo },
            { "lt", "ਲਿਥੁਆਨੀਅਨ" },
            { "lu", "ਲੂਬਾ-ਕਾਟਾਂਗਾ" },
            { "lv", "ਲਾਤੀਵੀ" },
            { "mg", "ਮਾਲਾਗੈਸੀ" },
            { "mh", "ਮਾਰਸ਼ਲੀਜ਼" },
            { "mi", "ਮਾਉਰੀ" },
            { "mk", "ਮੈਕਡੋਨੀਆਈ" },
            { "ml", metaValue_ml },
            { "mn", "ਮੰਗੋਲੀ" },
            { "mr", "ਮਰਾਠੀ" },
            { "ms", "ਮਲਯ" },
            { "mt", "ਮਾਲਟੀਜ਼" },
            { "my", "ਬਰਮੀ" },
            { "na", metaValue_NR },
            { "nb", "ਨਾਰਵੇਜਿਆਈ ਬੋਕਮਲ" },
            { "nd", "ਉੱਤਰੀ ਨਡੇਬੇਲੇ" },
            { "ne", "ਨੇਪਾਲੀ" },
            { "ng", "ਐਂਡੋਂਗਾ" },
            { "nl", "ਡੱਚ" },
            { "nn", "ਨਾਰਵੇਜਿਆਈ ਨਿਓਨੌਰਸਕ" },
            { "no", "ਨਾਰਵੇਜਿਆਈ" },
            { "nr", "ਸਾਊਥ ਨਡੇਬੇਲੇ" },
            { "nv", "ਨਵਾਜੋ" },
            { "ny", "ਨਯਾਂਜਾ" },
            { "oc", "ਓਕਸੀਟਾਨ" },
            { "om", "ਓਰੋਮੋ" },
            { "or", metaValue_or },
            { "os", "ਓਸੈਟਿਕ" },
            { "pa", "ਪੰਜਾਬੀ" },
            { "pi", "ਪਾਲੀ" },
            { "pl", "ਪੋਲੈਂਡੀ" },
            { "ps", "ਪਸ਼ਤੋ" },
            { "pt", "ਪੁਰਤਗਾਲੀ" },
            { "qu", "ਕਕੇਸ਼ੁਆ" },
            { "rm", "ਰੋਮਾਂਸ਼" },
            { "rn", "ਰੁੰਡੀ" },
            { "ro", "ਰੋਮਾਨੀਆਈ" },
            { "ru", "ਰੂਸੀ" },
            { "rw", "ਕਿਨਿਆਰਵਾਂਡਾ" },
            { "sa", "ਸੰਸਕ੍ਰਿਤ" },
            { "sc", "ਸਾਰਡੀਨੀਆਈ" },
            { "sd", "ਸਿੰਧੀ" },
            { "se", "ਉੱਤਰੀ ਸਾਮੀ" },
            { "sg", "ਸਾਂਗੋ" },
            { "si", metaValue_si },
            { "sk", "ਸਲੋਵਾਕ" },
            { "sl", "ਸਲੋਵੇਨੀਆਈ" },
            { "sm", "ਸਾਮੋਨ" },
            { "sn", "ਸ਼ੋਨਾ" },
            { "so", "ਸੋਮਾਲੀ" },
            { "sq", "ਅਲਬਾਨੀਆਈ" },
            { "sr", "ਸਰਬੀਆਈ" },
            { "ss", "ਸਵਾਤੀ" },
            { "st", "ਦੱਖਣੀ ਸੋਥੋ" },
            { "su", metaValue_su },
            { "sv", "ਸਵੀਡਿਸ਼" },
            { "sw", "ਸਵਾਹਿਲੀ" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ਤਾਜਿਕ" },
            { "th", metaValue_th },
            { "ti", "ਤਿਗ੍ਰੀਨਿਆ" },
            { "tk", "ਤੁਰਕਮੇਨ" },
            { "tn", "ਤਸਵਾਨਾ" },
            { "to", "ਟੌਂਗਨ" },
            { "tr", metaValue_TR },
            { "ts", "ਸੋਂਗਾ" },
            { "tt", "ਤਤਾਰ" },
            { "tw", "ਤ੍ਵਿ" },
            { "ty", "ਤਾਹੀਟੀ" },
            { "ug", "ਉਇਗੁਰ" },
            { "uk", "ਯੂਕਰੇਨੀਆਈ" },
            { "ur", "ਉਰਦੂ" },
            { "uz", "ਉਜ਼ਬੇਕ" },
            { "ve", "ਵੇਂਡਾ" },
            { "vi", "ਵੀਅਤਨਾਮੀ" },
            { "vo", "ਵੋਲਾਪੂਕ" },
            { "wa", "ਵਲੂਨ" },
            { "wo", "ਵੋਲੋਫ" },
            { "xh", "ਖੋਸਾ" },
            { "yi", "ਯਿਦਿਸ਼" },
            { "yo", "ਯੋਰੂਬਾ" },
            { "za", "ਜ਼ੁਆਂਗ" },
            { "zh", "ਚੀਨੀ" },
            { "zu", "ਜ਼ੁਲੂ" },
            { "ace", "ਅਚੀਨੀ" },
            { "ach", "ਅਕੋਲੀ" },
            { "ada", "ਅਡਾਂਗਮੇ" },
            { "ady", "ਅਡਿਗੇ" },
            { "agq", "ਅਗੇਮ" },
            { "ain", "ਆਇਨੂ" },
            { "ale", "ਅਲੇਉਟ" },
            { "alt", "ਦੱਖਣੀ ਅਲਤਾਈ" },
            { "ang", "ਪੁਰਾਣੀ ਅੰਗਰੇਜ਼ੀ" },
            { "ann", "ਓਬੋਲੋ" },
            { "anp", "ਅੰਗਿਕਾ" },
            { "arn", "ਮਾਪੁਚੇ" },
            { "arp", "ਅਰਾਫਾਓ" },
            { "ars", "ਨਾਜਦੀ ਅਰਬੀ" },
            { "asa", "ਅਸੂ" },
            { "ast", "ਅਸਤੂਰੀ" },
            { "atj", "ਅਤਿਕਾਮੇਕਵ" },
            { "awa", "ਅਵਧੀ" },
            { "ban", "ਬਾਲੀਨੀਜ਼" },
            { "bas", "ਬਾਸਾ" },
            { "bem", "ਬੇਂਬਾ" },
            { "bez", "ਬੇਨਾ" },
            { "bgc", "ਹਰਿਆਣਵੀ" },
            { "bgn", "ਪੱਛਮੀ ਬਲੂਚੀ" },
            { "bho", "ਭੋਜਪੁਰੀ" },
            { "bin", "ਬਿਨੀ" },
            { "bla", "ਸਿਕਸਿਕਾ" },
            { "blo", "ਅਨੀ" },
            { "brx", "ਬੋਡੋ" },
            { "bug", "ਬਗਨੀਜ਼" },
            { "byn", "ਬਲਿਨ" },
            { "cay", "ਕਾਯੁਗਾ" },
            { "ccp", metaValue_ccp },
            { "ceb", "ਸੀਬੂਆਨੋ" },
            { "cgg", "ਚੀਗਾ" },
            { "chk", "ਚੂਕੀਸ" },
            { "chm", "ਮਾਰੀ" },
            { "cho", "ਚੌਕਟੋ" },
            { "chp", "ਚਿਪਵਿਆਨ" },
            { "chr", "ਚੇਰੋਕੀ" },
            { "chy", "ਛਾਇਆਨ" },
            { "ckb", "ਕੇਂਦਰੀ ਕੁਰਦਿਸ਼" },
            { "clc", "ਚਿਲਕੋਟਿਨ" },
            { "crg", "ਮਿਚਿਫੋ" },
            { "crj", "ਦੱਖਣੀ ਪੂਰਬੀ ਕ੍ਰੀ" },
            { "crk", "ਪਲੇਨਸ ਕ੍ਰੀ" },
            { "crl", "ਉੱਤਰੀ ਪੂਰਬੀ ਕ੍ਰੀ" },
            { "crm", "ਮੂਜ਼ ਕ੍ਰੀ" },
            { "crr", "ਕੈਰੋਲੀਨਾ ਐਲਗੋਂਕਵਿਅਨ" },
            { "crs", "ਸੇਸੇਲਵਾ ਕ੍ਰਿਓਲ ਫ੍ਰੈਂਚ" },
            { "csw", "ਸਵੈਂਪੀ ਕ੍ਰੀ" },
            { "dak", "ਡਕੋਟਾ" },
            { "dar", "ਦਾਰਗਵਾ" },
            { "dav", "ਟੇਟਾ" },
            { "dgr", "ਡੋਗਰਿੱਬ" },
            { "dje", "ਜ਼ਾਰਮਾ" },
            { "doi", "ਡੋਗਰੀ" },
            { "dsb", "ਲੋਅਰ ਸੋਰਬੀਅਨ" },
            { "dua", "ਡੂਆਲਾ" },
            { "dyo", "ਜੋਲਾ-ਫੋਇਨੀ" },
            { "dzg", "ਡਜ਼ਾਗਾ" },
            { "ebu", "ਇੰਬੂ" },
            { "efi", "ਐਫਿਕ" },
            { "egy", "ਪੁਰਾਤਨ ਮਿਸਰੀ" },
            { "eka", "ਏਕਾਜੁਕ" },
            { "ewo", "ਇਵੋਂਡੋ" },
            { "fil", "ਫਿਲੀਪਿਨੋ" },
            { "fon", "ਫੌਨ" },
            { "frc", "ਕੇਜੁਨ ਫ਼੍ਰੈਂਚ" },
            { "frr", "ਉੱਤਰੀ ਫ੍ਰੀਜ਼ੀਅਨ" },
            { "fur", "ਫਰੀਉਲੀਅਨ" },
            { "gaa", "ਗਾ" },
            { "gag", "ਗਾਗੌਜ਼" },
            { "gan", "ਚੀਨੀ ਗਾਨ" },
            { "gez", "ਜੀਜ਼" },
            { "gil", "ਗਿਲਬਰਤੀਜ਼" },
            { "gor", "ਗੋਰੋਂਤਾਲੋ" },
            { "grc", "ਪੁਰਾਤਨ ਯੂਨਾਨੀ" },
            { "gsw", "ਜਰਮਨ (ਸਵਿਸ)" },
            { "guz", "ਗੁਸੀ" },
            { "gwi", "ਗਵਿਚ’ਇਨ" },
            { "hai", "ਹਾਇਡਾ" },
            { "hak", "ਚੀਨੀ ਹਾਕਾ" },
            { "haw", "ਹਵਾਈ" },
            { "hax", "ਦੱਖਣੀ ਹਾਇਡਾ" },
            { "hif", "ਫਿਜੀ ਹਿੰਦੀ" },
            { "hil", "ਹਿਲੀਗੇਨਨ" },
            { "hmn", "ਹਮੋਂਗ" },
            { "hsb", "ਅੱਪਰ ਸੋਰਬੀਅਨ" },
            { "hsn", "ਚੀਨੀ ਜ਼ਿਆਂਗ" },
            { "hup", "ਹੂਪਾ" },
            { "hur", "ਹਾਲਕੋਮੇਲਮ" },
            { "iba", "ਇਬਾਨ" },
            { "ibb", "ਇਬੀਬੀਓ" },
            { "ikt", "ਪੱਛਮੀ ਕੈਨੇਡੀਅਨ ਇਨੂਕਟੀਟੂਟ" },
            { "ilo", "ਇਲੋਕੋ" },
            { "inh", "ਇੰਗੁਸ਼" },
            { "jbo", "ਲੋਜਬਾਨ" },
            { "jgo", "ਨਗੋਂਬਾ" },
            { "jmc", "ਮਚਾਮੇ" },
            { "kab", "ਕਬਾਇਲ" },
            { "kac", "ਕਾਚਿਨ" },
            { "kaj", "ਜਜੂ" },
            { "kam", "ਕੰਬਾ" },
            { "kbd", "ਕਬਾਰਦੀ" },
            { "kcg", "ਟਾਇਪ" },
            { "kde", "ਮਕੋਂਡ" },
            { "kea", "ਕਾਬੁਵੇਰਦਿਆਨੂ" },
            { "kfo", "ਕੋਰੋ" },
            { "kgp", "ਕੈਨਗਾਂਗੋ" },
            { "kha", "ਖਾਸੀ" },
            { "khq", "ਕੋਯਰਾ ਚੀਨੀ" },
            { "kkj", "ਕਾਕੋ" },
            { "kln", "ਕਲੇਜਿਨ" },
            { "kmb", "ਕਿਮਬੁੰਦੂ" },
            { "koi", "ਕੋਮੀ-ਪੇਰਮਿਆਕ" },
            { "kok", "ਕੋਂਕਣੀ" },
            { "kpe", "ਕਪੇਲ" },
            { "krc", "ਕਰਾਚੇ ਬਲਕਾਰ" },
            { "krl", "ਕਰੀਲੀਅਨ" },
            { "kru", "ਕੁਰੁਖ" },
            { "ksb", "ਸ਼ੰਬਾਲਾ" },
            { "ksf", "ਬਫ਼ੀਆ" },
            { "ksh", "ਕਲੋਨੀਅਨ" },
            { "kum", "ਕੁਮੀਕ" },
            { "kwk", "ਕਵਾਕ’ਵਾਲਾ" },
            { "kxv", "ਕੁਵੀ" },
            { "lad", "ਲੈਡੀਨੋ" },
            { "lag", "ਲੰਗਾਈ" },
            { "lez", "ਲੈਜ਼ਗੀ" },
            { "lij", "ਲਿਗੂਰੀ" },
            { "lil", "ਲਿਲੂਏਟ" },
            { "lkt", "ਲਕੋਟਾ" },
            { "lmo", "ਲੰਬਾਰਡ" },
            { "lou", "ਲੇਉ" },
            { "loz", "ਲੋਜ਼ੀ" },
            { "lrc", "ਉੱਤਰੀ ਲੁਰੀ" },
            { "lsm", "ਸਾਮੀਆ" },
            { "lua", "ਲਿਊਬਾ-ਲਿਊਲਿਆ" },
            { "lun", "ਲੁੰਡਾ" },
            { "luo", "ਲੂਓ" },
            { "lus", "ਮਿਜ਼ੋ" },
            { "luy", "ਲੂਈਆ" },
            { "mad", "ਮਾਡੂਰੀਸ" },
            { "mag", "ਮਗਾਹੀ" },
            { "mai", "ਮੈਥਲੀ" },
            { "mak", "ਮਕਾਸਰ" },
            { "mas", "ਮਸਾਈ" },
            { "mdf", "ਮੋਕਸ਼ਾ" },
            { "men", "ਮੇਂਡੇ" },
            { "mer", "ਮੇਰੂ" },
            { "mfe", "ਮੋਰੀਸਿਅਨ" },
            { "mgh", "ਮਖੋਵਾ-ਮਿੱਟੋ" },
            { "mgo", "ਮੇਟਾ" },
            { "mic", "ਮਾਇਮੈਕ" },
            { "min", "ਮਿਨਾਂਗਕਾਬਾਓ" },
            { "mni", "ਮਨੀਪੁਰੀ" },
            { "moe", "ਇਨੂੰ-ਏਮੁਨ" },
            { "moh", "ਮੋਹਆਕ" },
            { "mos", "ਮੋਸੀ" },
            { "mua", "ਮੁੰਡੇਂਗ" },
            { "mul", "ਬਹੁਤੀਆਂ ਬੋਲੀਆਂ" },
            { "mus", "ਕ੍ਰੀਕ" },
            { "mwl", "ਮਿਰਾਂਡੀ" },
            { "myv", "ਇਰਜ਼ੀਆ" },
            { "mzn", "ਮੇਜ਼ੈਂਡਰਾਨੀ" },
            { "nan", "ਚੀਨੀ ਮਿਨ ਨਾਨ" },
            { "nap", "ਨਿਆਪੋਲੀਟਨ" },
            { "naq", "ਨਾਮਾ" },
            { "nds", "ਲੋ ਜਰਮਨ" },
            { "new", "ਨੇਵਾਰੀ" },
            { "nia", "ਨਿਆਸ" },
            { "niu", "ਨਿਊਏਈ" },
            { "nmg", "ਕਵਾਸਿਓ" },
            { "nnh", "ਨਿਓਮਬੂਨ" },
            { "nog", "ਨੋਗਾਈ" },
            { "nqo", "ਐਂਕੋ" },
            { "nso", "ਉੱਤਰੀ ਸੋਥੋ" },
            { "nus", "ਨੁਏਰ" },
            { "nyn", "ਨਿਆਂਕੋਲੇ" },
            { "ojb", "ਉੱਤਰ-ਪੱਛਮੀ ਔਜਿਬਵਾ" },
            { "ojc", "ਸੈਂਟਰਲ ਔਜਿਬਵਾ" },
            { "ojs", "ਓਜੀ-ਕ੍ਰੀ" },
            { "ojw", "ਪੱਛਮੀ ਓਜਿਬਵਾ" },
            { "oka", "ਓਕਾਨਾਗਨ" },
            { "pag", "ਪੰਗਾਸੀਨਾਨ" },
            { "pam", "ਪੈਂਪਾਂਗਾ" },
            { "pap", "ਪਾਪਿਆਮੈਂਟੋ" },
            { "pau", "ਪਲਾਊਵੀ" },
            { "pcm", "ਨਾਇਜੀਰੀਆਈ ਪਿਡਗਿਨ" },
            { "pis", "ਪਿਜਿਨ" },
            { "pqm", "ਮਾਲੀਸੇਟ-ਪਾਸਾਮਾਕਵੋਡੀ" },
            { "prg", "ਪਰੂਸ਼ੀਆ" },
            { "quc", "ਕੇਸ਼" },
            { "raj", "ਰਾਜਸਥਾਨੀ" },
            { "rap", "ਰਾਪਾਨੁਈ" },
            { "rar", "ਰਾਰੋਤੋਂਗਨ" },
            { "rhg", "ਰੋਹਿੰਗਿਆ" },
            { "rof", "ਰੋਮਬੋ" },
            { "rup", "ਅਰੋਮੀਨੀਆਈ" },
            { "rwk", "ਰਵਾ" },
            { "sad", "ਸਾਂਡੋ" },
            { "sah", "ਸਾਖਾ" },
            { "saq", "ਸਮਬੁਰੂ" },
            { "sat", "ਸੰਥਾਲੀ" },
            { "sba", "ਨਗਾਂਬੇ" },
            { "sbp", "ਸੇਂਗੋ" },
            { "scn", "ਸਿਸੀਲੀਅਨ" },
            { "sco", "ਸਕਾਟਸ" },
            { "sdh", "ਦੱਖਣੀ ਕੁਰਦਿਸ਼" },
            { "seh", "ਸੇਨਾ" },
            { "ses", "ਕੋਇਰਾਬੋਰੋ ਸੇਂਨੀ" },
            { "shi", "ਟਚੇਲਹਿਟ" },
            { "shn", "ਸ਼ਾਨ" },
            { "slh", "ਦੱਖਣੀ ਲੁਸ਼ੂਟਸੀਡ" },
            { "sma", "ਦੱਖਣੀ ਸਾਮੀ" },
            { "smj", "ਲਿਊਲ ਸਾਮੀ" },
            { "smn", "ਇਨਾਰੀ ਸਾਮੀ" },
            { "sms", "ਸਕੌਲਟ ਸਾਮੀ" },
            { "snk", "ਸੋਨਿੰਕੇ" },
            { "srn", "ਸ੍ਰਾਨਾਨ ਟੋਂਗੋ" },
            { "ssy", "ਸਾਹੋ" },
            { "str", "ਸਟਰੇਟਸ ਸੈਲਿਸ਼" },
            { "suk", "ਸੁਕੁਮਾ" },
            { "swb", "ਕੋਮੋਰੀਅਨ" },
            { "syr", metaValue_syr },
            { "szl", "ਸਿਲੇਸੀਅਨ" },
            { "tce", "ਦੱਖਣੀ ਟਚੋਨ" },
            { "tem", "ਟਿਮਨੇ" },
            { "teo", "ਟੇਸੋ" },
            { "tet", "ਟੇਟਮ" },
            { "tgx", "ਟੈਗਿਸ਼" },
            { "tht", "ਤਹਿਲਟਨ" },
            { "tig", "ਟਿਗਰਾ" },
            { "tlh", "ਕਲਿੰਗਨ" },
            { "tli", "ਟਲਿੰਗਿਟ" },
            { "tok", "ਤੋਕੀ ਪੋਨਾ" },
            { "tpi", "ਟੋਕ ਪਿਸਿਨ" },
            { "trv", "ਟਾਰੋਕੋ" },
            { "ttm", "ਉੱਤਰੀ ਟਚੋਨ" },
            { "tum", "ਤੁੰਬੁਕਾ" },
            { "tvl", "ਟਿਊਵਾਲੂ" },
            { "twq", "ਤਾਸਾਵਿਕ" },
            { "tyv", "ਤੁਵੀਨੀਅਨ" },
            { "tzm", "ਮੱਧ ਐਟਲਸ ਤਮਾਜ਼ਿਤ" },
            { "udm", "ਉਦਮੁਰਤ" },
            { "umb", "ਉਮਬੁੰਡੂ" },
            { "und", "ਅਣਪਛਾਤੀ ਬੋਲੀ" },
            { "vai", metaValue_vai },
            { "vec", "ਵੇਨੇਸ਼ੀਅਨ" },
            { "vmw", "ਮਖੂਵਾ" },
            { "vun", "ਵੂੰਜੋ" },
            { "wae", "ਵਾਲਸਰ" },
            { "wal", "ਵੋਲਾਏਟਾ" },
            { "war", "ਵੈਰੇ" },
            { "wbp", "ਵਾਲਪੁਰੀ" },
            { "wuu", "ਚੀਨੀ ਵੂ" },
            { "xal", "ਕਾਲਮਿਕ" },
            { "xnr", "ਕਾਂਗੜੀ" },
            { "xog", "ਸੋਗਾ" },
            { "yav", "ਯਾਂਗਬੇਨ" },
            { "ybb", "ਯੇਂਬਾ" },
            { "yrl", "ਨਹੀਂਗਾਤੂ" },
            { "yue", "ਕੈਂਟੋਨੀਜ਼" },
            { "zgh", "ਮਿਆਰੀ ਮੋਰੋਕੇਨ ਟਾਮਾਜ਼ਿਕ" },
            { "zun", "ਜ਼ੂਨੀ" },
            { "zxx", "ਬੋਲੀ ਸੰਬੰਧੀ ਕੋਈ ਸਮੱਗਰੀ ਨਹੀਂ" },
            { "zza", "ਜ਼ਾਜ਼ਾ" },
            { "Adlm", "ਅਦਲਾਮ" },
            { "Arab", metaValue_ar },
            { "Aran", "ਨਸਤਾਲੀਕ" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "ਬੋਪੋਮੋਫੋ" },
            { "Brai", "ਬਰੇਲ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ਯੂਨੀਫਾਈਡ ਕੈਨੇਡੀਅਨ ਐਬੋਰਿਜਿਨਲ ਸਿਲੇਬਿਕਸ" },
            { "Cher", "ਚੈਰੋਕੀ" },
            { "Cyrl", "ਸਿਰਿਲਿਕ" },
            { "Deva", "ਦੇਵਨਾਗਰੀ" },
            { "Ethi", "ਇਥੀਓਪਿਕ" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ਗੁਰਮੁਖੀ" },
            { "Hanb", "ਹਾਂਬ" },
            { "Hang", "ਹੰਗੁਲ" },
            { "Hani", "ਹਾਨ" },
            { "Hans", "ਸਰਲ" },
            { "Hant", "ਰਵਾਇਤੀ" },
            { "Hebr", metaValue_he },
            { "Hira", "ਹਿਰਾਗਾਨਾ" },
            { "Hrkt", "ਜਾਪਾਨੀ ਸਿਲੇਬਰੀਜ਼" },
            { "Jamo", "ਜਾਮੋ" },
            { "Jpan", metaValue_ja },
            { "Kana", "ਕਾਟਾਕਾਨਾ" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "ਮੰਗੋਲੀਅਨ" },
            { "Mtei", "ਮਿਤੇਈ ਮਾਏਕ" },
            { "Mymr", "ਮਿਆਂਮਾਰ" },
            { "Nkoo", "ਐਨ’ਕੋ" },
            { "Olck", "ਓਲ ਚੀਕੀ" },
            { "Orya", metaValue_or },
            { "Rohg", "ਹਨੀਫੀ" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "ਟਿਫੀਨਾਘ" },
            { "Thaa", "ਥਾਨਾ" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "ਯੀ" },
            { "Zmth", "ਗਣਿਤ ਚਿੰਨ੍ਹ-ਲਿਪੀ" },
            { "Zsye", "ਇਮੋਜੀ" },
            { "Zsym", "ਚਿੰਨ੍ਹ" },
            { "Zxxx", "ਅਲਿਖਤ" },
            { "Zyyy", "ਸਧਾਰਨ" },
            { "Zzzz", "ਅਣਪਛਾਤੀ ਲਿਪੀ" },
            { "de_AT", "ਜਰਮਨ (ਆਸਟਰੀਆਈ)" },
            { "de_CH", "ਹਾਈ ਜਰਮਨ (ਸਵਿਟਜ਼ਰਲੈਂਡ)" },
            { "en_GB", "ਅੰਗਰੇਜ਼ੀ (ਬਰਤਾਨਵੀ)" },
            { "en_US", "ਅੰਗਰੇਜ਼ੀ (ਅਮਰੀਕੀ)" },
            { "es_ES", "ਸਪੇਨੀ (ਯੂਰਪੀ)" },
            { "fa_AF", "ਦਾਰੀ" },
            { "fr_CA", "ਫਰਾਂਸੀਸੀ (ਕੈਨੇਡੀਅਨ)" },
            { "nl_BE", "ਫਲੈਮਿਸ਼" },
            { "pt_BR", "ਪੁਰਤਗਾਲੀ (ਬ੍ਰਾਜ਼ੀਲੀ)" },
            { "pt_PT", "ਪੁਰਤਗਾਲੀ (ਯੂਰਪੀ)" },
            { "ro_MD", "ਮੋਲਡਾਵੀਆਈ" },
            { "sw_CD", "ਕਾਂਗੋ ਸਵਾਇਲੀ" },
            { "ar_001", "ਆਧੁਨਿਕ ਮਿਆਰੀ ਅਰਬੀ" },
            { "es_419", "ਸਪੇਨੀ (ਲਾਤੀਨੀ ਅਮਰੀਕੀ)" },
            { "key.ca", "ਕੈਲੰਡਰ" },
            { "key.cf", "ਮੁਦਰਾ ਬਣਤਰ" },
            { "key.co", "ਲੜੀਬੱਧ ਕ੍ਰਮ" },
            { "key.cu", "ਮੁਦਰਾ" },
            { "key.hc", "ਘੰਟੇ ਦਾ ਚੱਕਰ (12 ਬਨਾਮ 24)" },
            { "key.lb", "ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ" },
            { "key.ms", "ਮਾਪ ਪ੍ਰਣਾਲੀ" },
            { "key.nu", "ਸੰਖਿਆਵਾਂ" },
            { "nds_NL", "ਲੋ ਸੈਕਸਨ" },
            { "type.ca.roc", "ਮਿੰਗੂਓ ਕੈਲੰਡਰ" },
            { "type.hc.h11", "12 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (0–11)" },
            { "type.hc.h12", "12 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (1–12)" },
            { "type.hc.h23", "24 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (0–23)" },
            { "type.hc.h24", "24 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (1–24)" },
            { "type.nu.arab", "ਅਰਬੀ-ਭਾਰਤੀ ਅੰਕ" },
            { "type.nu.armn", "ਆਰਮੀਨੀਅਨ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.beng", "ਬੰਗਾਲੀ ਅੰਕ" },
            { "type.nu.brah", "ਬਰਾਹਮੀ ਅੰਕ" },
            { "type.nu.cakm", "ਚਕਮਾ ਅੰਕ" },
            { "type.nu.deva", "ਦੇਵਨਾਗਰੀ ਅੰਕ" },
            { "type.nu.ethi", "ਐਥਿਓਪਿਕ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.geor", "ਜਾਰਜੀਅਨ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.grek", "ਯੂਨਾਨੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.gujr", "ਗੁਜਰਾਤੀ ਅੰਕ" },
            { "type.nu.guru", "ਗੁਰਮੁਖੀ ਅੰਕ" },
            { "type.nu.hans", "ਸਰਲ ਚੀਨੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.hant", "ਰਵਾਇਤੀ ਚੀਨੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.hebr", "ਹਿਬਰੂ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.java", "ਜਾਵਾਨੀਜ਼ ਅੰਕ" },
            { "type.nu.jpan", "ਜਪਾਨੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.khmr", "ਖਮੇਰ ਅੰਕ" },
            { "type.nu.knda", "ਕੰਨੜ ਅੰਕ" },
            { "type.nu.laoo", "ਲਾਓ ਅੰਕ" },
            { "type.nu.latn", "ਪੱਛਮੀ ਅੰਕ" },
            { "type.nu.mlym", "ਮਲਿਆਲਮ ਅੰਕ" },
            { "type.nu.mong", "ਮੰਗੋਲ ਅੰਕ" },
            { "type.nu.mtei", "ਮਿਤੇਈ ਮਾਏਕ ਅੰਕ" },
            { "type.nu.mymr", "ਮਿਆਂਮਾਰ ਅੰਕ" },
            { "type.nu.olck", "ਓਲ ਚੀਕੀ ਅੰਕ" },
            { "type.nu.orya", "ਉੜੀਆ ਅੰਕ" },
            { "type.nu.taml", "ਰਵਾਇਤੀ ਤਮਿਲ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.telu", "ਤੇਲਗੂ ਅੰਕ" },
            { "type.nu.thai", "ਥਾਈ ਅੰਕ" },
            { "type.nu.tibt", "ਤਿੱਬਤੀ ਅੰਕ" },
            { "type.nu.vaii", "ਵਾਈ ਅੰਕ" },
            { "type.ca.dangi", "ਡਾਂਗੀ ਕੈਲੰਡਰ" },
            { "type.co.ducet", "ਮੂਲ ਯੂਨੀਕੋਡ ਲੜੀਬੱਧ ਕ੍ਰਮ" },
            { "type.lb.loose", "ਖੁੱਲ੍ਹੀ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ" },
            { "type.nu.roman", "ਰੋਮਨ ਸੰਖਿਆਵਾਂ" },
            { "type.ca.coptic", "ਕੋਪਟਿਕ ਕੈਲੰਡਰ" },
            { "type.ca.hebrew", "ਹਿਬਰੂ ਕੈਲੰਡਰ" },
            { "type.ca.indian", "ਭਾਰਤੀ ਕੌਮੀ ਕੈਲੰਡਰ" },
            { "type.co.compat", "ਪਿਛਲਾ ਤਰਤੀਬ ਵਾਰ ਕ੍ਰਮ, ਅਨੁਰੂਪਤਾ ਲਈ" },
            { "type.co.search", "ਆਮ-ਮੰਤਵ ਖੋਜ" },
            { "type.lb.normal", "ਸਧਾਰਨ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ" },
            { "type.lb.strict", "ਪੱਕੀ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ" },
            { "type.ms.metric", "ਮੀਟਰਿਕ ਪ੍ਰਣਾਲੀ" },
            { "type.ca.chinese", "ਚੀਨੀ ਕੈਲੰਡਰ" },
            { "type.ca.islamic", "ਇਸਲਾਮੀ ਕੈਲੰਡਰ" },
            { "type.ca.iso8601", "(ISO-8601) ਕੈਲੰਡਰ" },
            { "type.ca.persian", "ਫ਼ਾਰਸੀ ਕੈਲੰਡਰ" },
            { "type.cf.account", "ਲੇਖਾ ਮੁਦਰਾ ਬਣਤਰ" },
            { "type.nu.arabext", "ਵਿਸਤਾਰਿਤ ਅਰਬੀ-ਭਾਰਤੀ ਅੰਕ" },
            { "type.nu.armnlow", "ਆਰਮੀਨੀਅਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.greklow", "ਯੂਨਾਨੀ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.hanidec", "ਚੀਨੀ ਦਸ਼ਮਲਵ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.hansfin", "ਸਰਲ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.hantfin", "ਰਵਾਇਤੀ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.jpanfin", "ਜਪਾਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ" },
            { "type.nu.tamldec", "ਤਮਿਲ ਅੰਕ" },
            { "type.ca.buddhist", "ਬੋਧੀ ਕੈਲੰਡਰ" },
            { "type.ca.ethiopic", "ਇਥੀਓਪਿਕ ਕੈਲੰਡਰ" },
            { "type.ca.japanese", "ਜਪਾਨੀ ਕੈਲੰਡਰ" },
            { "type.cf.standard", "ਮਿਆਰੀ ਮੁਦਰਾ ਬਣਤਰ" },
            { "type.co.standard", "ਸਧਾਰਨ ਲੜੀਬੱਧ ਕ੍ਰਮ" },
            { "type.ms.uksystem", "ਇੰਪੀਰੀਅਲ ਮਾਪ ਪ੍ਰਣਾਲੀ" },
            { "type.ms.ussystem", "ਅਮਰੀਕੀ ਮਾਪ ਪ੍ਰਣਾਲੀ" },
            { "type.nu.fullwide", "ਪੂਰਨ ਵਿਸਤਾਰ ਅੰਕ" },
            { "type.nu.romanlow", "ਰੋਮਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ" },
            { "type.ca.gregorian", "ਗਰੇਗੋਰੀਅਨ ਕੈਲੰਡਰ" },
            { "type.co.dictionary", "ਸ਼ਬਦ-ਕੋਸ਼ ਲੜੀਬੱਧ ਕ੍ਰਮ" },
            { "type.co.traditional", "ਰਵਾਇਤੀ ਲੜੀਬੱਧ ਕ੍ਰਮ" },
            { "type.ca.islamic-rgsa", "ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਸਾਊਦੀ ਅਰਬ, ਚੰਨ ਦਿਖਣਾ)" },
            { "type.ca.islamic-tbla", "ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਟੇਬਲਰ, ਖਗੋਲੀ ਯੁੱਗ)" },
            { "type.ca.islamic-civil", "ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਸਾਰਨੀਬੱਧ, ਸਮਾਜਿਕ ਯੁੱਗ)" },
            { "type.ca.islamic-umalqura", "ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਅਮ ਅਲ-ਕੁਰਾ)" },
            { "type.ca.ethiopic-amete-alem", "ਇਥੀਓਪਿਕ-ਅਮੀਟ-ਆਲਮ" },
        };
        return data;
    }
}
