/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kxv_Deva extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "तुर्की";
        final String metaValue_bn = "बंगाली";
        final String metaValue_chr = "चेरोकी";
        final String metaValue_kn = "कन्नड़";
        final String metaValue_ml = "मलयालम";
        final String metaValue_ta = "तमिल";
        final String metaValue_te = "तेलुगू";
        final Object[][] data = new Object[][] {
            { "001", "राजि, पृती" },
            { "419", "लातिन आमेरिका ति" },
            { "AD", "अंडोरा" },
            { "AE", "आण्डी ति अरब एमिरेट्स" },
            { "AF", "अप़गानिस्तान" },
            { "AG", "एंटिगुआ ऑड़े बरबुडा" },
            { "AI", "एंग्विला" },
            { "AL", "अल्बानिया" },
            { "AM", "आर्मेनिया" },
            { "AO", "अंगोला" },
            { "AQ", "अंटार्कटिका" },
            { "AR", "अर्जेंटीना" },
            { "AS", "आमेरिका-ति समोआ" },
            { "AT", "ऑस्ट्रिया" },
            { "AU", "ऑस्ट्रेलिया" },
            { "AW", "अरूबा" },
            { "AX", "एलेंड द्वीप" },
            { "AZ", "अज़रबेजान" },
            { "BA", "बोस्निया ऑड़े हर्ज़ेगोविना" },
            { "BB", "बारबाडोस" },
            { "BD", "बांग्लादेस" },
            { "BE", "बेल्जियम" },
            { "BF", "बुर्किना प़ासो" },
            { "BG", "बुल्गारिया" },
            { "BH", "बहरीन" },
            { "BI", "बुरुंडी" },
            { "BJ", "बेनिन" },
            { "BL", "सेंट बार्तेलेमी" },
            { "BM", "बरमूडा" },
            { "BN", "ब्रूनेई" },
            { "BO", "बोलीविया" },
            { "BQ", "केरिबियन नीदरलेंड" },
            { "BR", "ब्राज़ील" },
            { "BS", "बहामास" },
            { "BT", "बुटान" },
            { "BW", "बोत्स्वाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलीज़" },
            { "CA", "कानाडा" },
            { "CC", "कोकोस (कीलिंग) द्वीप" },
            { "CD", "कांगो - किंसासा" },
            { "CF", "मध्य अप़्रीकी गणराज्य" },
            { "CG", "कांगो – ब्राज़ाविल" },
            { "CH", "स्विट्ज़रलेंड" },
            { "CI", "कोट डी वोआ" },
            { "CK", "कुक द्वीप" },
            { "CL", "चिली" },
            { "CM", "केमरून" },
            { "CN", "चीन" },
            { "CO", "कोलंबिया" },
            { "CR", "कोस्टारिका" },
            { "CU", "क्यूबा" },
            { "CV", "केप वर्ड" },
            { "CW", "क्यूरासाओ" },
            { "CX", "क्रिसमस द्वीप" },
            { "CY", "साइप्रस" },
            { "CZ", "चेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "डिएगो गार्सिया" },
            { "DJ", "जिबूती" },
            { "DK", "डेनमार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन गणराज्य" },
            { "DZ", "अल्जीरिया" },
            { "EA", "सेउटा ऑड़े मेलिला" },
            { "EC", "इक्वाडोर" },
            { "EE", "एस्टोनिया" },
            { "EG", "मिस्र" },
            { "EH", "वेड़ा कुण्पु सहारा" },
            { "ER", "इरिट्रिया" },
            { "ES", "स्पेन" },
            { "ET", "इतियोपिया" },
            { "FI", "प़िनलेंड" },
            { "FJ", "प़िजी" },
            { "FK", "प़ॉकलेंड द्वीप" },
            { "FM", "माइक्रोनेसिया" },
            { "FO", "पेरो दीप" },
            { "FR", "प़्रांस" },
            { "GA", "ग्याबॉन" },
            { "GB", "यूनाइटेड किंगडम" },
            { "GD", "ग्रेनाडा" },
            { "GE", "जॉर्जिया" },
            { "GF", "प़्रेंच गुयाना" },
            { "GG", "गर्नसी" },
            { "GH", "गाना" },
            { "GI", "जिब्राल्टर" },
            { "GL", "ग्रीनलेंड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडेलूप" },
            { "GQ", "इक्वेटोरियल गिनी" },
            { "GR", "यूनान" },
            { "GS", "दकिण जॉर्जिया अड़े दकिण सैंडविच दीप" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनी-बिसाउ" },
            { "GY", "गुयाना" },
            { "HK", "हाँग काँग (एस ए आर चीन)" },
            { "HN", "होंडूरास" },
            { "HR", "क्रोएसिया" },
            { "HT", "हाइती" },
            { "HU", "हंगरी" },
            { "IC", "केनेरी द्वीप" },
            { "ID", "इंडोनेसिया" },
            { "IE", "आयरलेंड" },
            { "IL", "इज़राइल" },
            { "IM", "आइल ऑप़ मेन" },
            { "IN", "बारत" },
            { "IO", "ब्रिटिस हिंद सामुद्रि हांडि" },
            { "IQ", "इराक" },
            { "IR", "ईरान" },
            { "IS", "आइसलेंड" },
            { "IT", "इटली" },
            { "JE", "जर्सी" },
            { "JM", "जमेका" },
            { "JO", "जॉर्डन" },
            { "JP", "जापान" },
            { "KE", "केन्या" },
            { "KG", "किर्गिज़स्तान" },
            { "KH", "कंबोडिया" },
            { "KI", "किरिबाती" },
            { "KM", "कोमोरोस" },
            { "KN", "सेंट किट्स ऑड़े नेविस" },
            { "KP", "उतर कोरिया" },
            { "KR", "दॉकिण कोरिया" },
            { "KW", "कुवेत" },
            { "KY", "केमेन द्वीप" },
            { "KZ", "कज़ाकस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनान" },
            { "LC", "सेंट लूसिया" },
            { "LI", "लिक्टेन्स्टीन" },
            { "LK", "स्रीलंका" },
            { "LR", "लाइबेरिया" },
            { "LS", "लेसोतो" },
            { "LT", "लितुआनिया" },
            { "LU", "लग्ज़मबर्ग" },
            { "LV", "लातविया" },
            { "LY", "लीबिया" },
            { "MA", "मोरक्को" },
            { "MC", "मोनाको" },
            { "MD", "मॉल्डोवा" },
            { "ME", "मोंटेनेग्रो" },
            { "MF", "सेंट मार्टिन" },
            { "MG", "मेडागास्कर" },
            { "MH", "मार्सल द्वीप" },
            { "MK", "उतॉरॉ मकदूनिया" },
            { "ML", "माली" },
            { "MM", "म्यांमार (बर्मा)" },
            { "MN", "मंगोलिया" },
            { "MO", "मकाऊ (एस ए आर चीन)" },
            { "MP", "उतॉरॉ मारियाना द्वीप" },
            { "MQ", "मार्टीनिक" },
            { "MR", "मॉरिटानिया" },
            { "MS", "मोंटसेरात" },
            { "MT", "माल्टा" },
            { "MU", "मॉरीसस" },
            { "MV", "मालदीप" },
            { "MW", "मलावी" },
            { "MX", "मेक्सिको" },
            { "MY", "मलेसिया" },
            { "MZ", "मोज़ांबिक" },
            { "NA", "नामीबिया" },
            { "NC", "न्यू केलेडोनिया" },
            { "NE", "नाइजर" },
            { "NF", "नॉरप़ॉक द्वीप" },
            { "NG", "नाइजीरिया" },
            { "NI", "निकारागुआ" },
            { "NL", "नीदरलेंड" },
            { "NO", "नॉर्वे" },
            { "NP", "नेपाल" },
            { "NR", "नाउरु" },
            { "NU", "नीयू" },
            { "NZ", "न्यूज़ीलेंड" },
            { "OM", "ओमान" },
            { "PA", "पनामा" },
            { "PE", "पेरू" },
            { "PF", "प़्रेंच पोलिनेसिया" },
            { "PG", "पापुआ न्यू गिनी" },
            { "PH", "प़िलिपींस" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोलेंड" },
            { "PM", "सेंट पिएरे ऑड़े मिक्वेलान" },
            { "PN", "पिटकेर्न द्वीप" },
            { "PR", "पोर्टो रिको" },
            { "PS", "प़िलिस्तीनी क्षेत्र" },
            { "PT", "पुर्तगाल" },
            { "PW", "पलाऊ" },
            { "PY", "पराग्वे" },
            { "QA", "क़तर" },
            { "RE", "रियूनियन" },
            { "RO", "रोमानिया" },
            { "RS", "सर्बिया" },
            { "RU", "रूस" },
            { "RW", "र्-वांडा" },
            { "SA", "सऊदी अरब" },
            { "SB", "सोलोमन द्वीप" },
            { "SC", "सेसेल्स" },
            { "SD", "सूडान" },
            { "SE", "स्वीडन" },
            { "SG", "सिंगापुर" },
            { "SH", "सेंट हेलेना" },
            { "SI", "स्लोवेनिया" },
            { "SJ", "स्वालबार्ड ऑड़े जान मायेन" },
            { "SK", "स्लोवाकिया" },
            { "SL", "सिएरा लियोन" },
            { "SM", "सेन मेरीनो" },
            { "SN", "सेनेगल" },
            { "SO", "सोमालिया" },
            { "SR", "सूरीनाम" },
            { "SS", "दॉकिण सूडान" },
            { "ST", "साओ टोम ऑड़े प्रिंसिपे" },
            { "SV", "अल सल्वाडोर" },
            { "SX", "सिंट माऽरतेन" },
            { "SY", "सीरिया" },
            { "SZ", "एस्वाटिनी" },
            { "TC", "तुर्क ऑड़े केकोज़ द्वीप" },
            { "TD", "चाड" },
            { "TF", "प्रेंच दकिनी टेरिटोरी" },
            { "TG", "टोगो" },
            { "TH", "ताईलेंड" },
            { "TJ", "तजाकिस्तान" },
            { "TK", "तोकेलाउ" },
            { "TL", "तिमोर-लेस्त" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "ट्यूनीसिया" },
            { "TO", "टोंगा" },
            { "TR", metaValue_TR },
            { "TT", "त्रिनिदाद ऑड़े टोबेगो" },
            { "TV", "तुवालू" },
            { "TW", "ताइवान" },
            { "TZ", "तंज़ानिया" },
            { "UA", "यूक्रेन" },
            { "UG", "युगांडा" },
            { "UM", "यू॰एस॰ आउटलाइंग द्वीप" },
            { "US", "आण्डि ति राज्यॉ" },
            { "UY", "उरूग्वे" },
            { "UZ", "उज़्बेकिस्तान" },
            { "VA", "बाटिकान सिटी" },
            { "VC", "सेंट विंसेंट ऑड़े ग्रेनाडाइंस" },
            { "VE", "वेनेज़ुएला" },
            { "VG", "ब्रिटिस वर्जिन द्वीप" },
            { "VI", "यू॰एस॰ वर्जिन द्वीप" },
            { "VN", "वियतनाम" },
            { "VU", "वनुआतू" },
            { "WF", "वालिस ऑड़े प़्यूचूना" },
            { "WS", "समोआ" },
            { "XK", "कोसोवो" },
            { "YE", "यमन" },
            { "YT", "मायोते" },
            { "ZA", "दॉकिण आप़्रीका" },
            { "ZM", "ज़ाम्बिया" },
            { "ZW", "ज़िम्बाब्वे" },
            { "af", "आप्रिकान्स" },
            { "am", "अम्हेरी" },
            { "ar", "आरॉबिक" },
            { "as", "आसामीस्" },
            { "az", "अज़रबेजानी" },
            { "be", "बेलारूसी" },
            { "bg", "बुल्गारियाति" },
            { "bn", metaValue_bn },
            { "bo", "तिब्बती" },
            { "bs", "बाॅस्नियाती" },
            { "ca", "कातालान" },
            { "cs", "चेक" },
            { "da", "डेनिस" },
            { "de", "जर्मन" },
            { "el", "ग्रीक" },
            { "en", "इंराजी" },
            { "es", "स्पानिस" },
            { "et", "एस्टोनियाति" },
            { "eu", "बास्क" },
            { "fa", "पर्सियन" },
            { "fi", "प़िनिस" },
            { "fr", "प़्रेंच" },
            { "gl", "ग्यालिसियन" },
            { "gu", "गुजराटी" },
            { "he", "हिब्रू" },
            { "hi", "हिन्दी" },
            { "hr", "क्रोएसियाति" },
            { "hu", "हंगेरियाति" },
            { "hy", "आर्मेनियाति" },
            { "id", "इंडोनेसियाति" },
            { "is", "आइसलेंड िक" },
            { "it", "इताली ती" },
            { "ja", "जापानीज" },
            { "ka", "जॉर्जियाति" },
            { "kk", "कज़ाक़" },
            { "km", "कमेर" },
            { "kn", metaValue_kn },
            { "ko", "कोरियाति" },
            { "ks", "कस्मीरी" },
            { "ky", "किर्गीज़" },
            { "lo", "लाओ" },
            { "lt", "लितुआनियाति" },
            { "lv", "लातवियाति" },
            { "mk", "मकदूनियाति" },
            { "ml", metaValue_ml },
            { "mn", "मंगोलियाति" },
            { "mr", "मराठी" },
            { "ms", "मलय" },
            { "my", "बर्मीज़" },
            { "nb", "नॉर्वेजियाति बोकमाल" },
            { "ne", "नेपाली" },
            { "nl", "डच" },
            { "or", "उड़िया" },
            { "pa", "पंजाबी" },
            { "pl", "पोलिस" },
            { "pt", "पुर्तगाली" },
            { "ro", "रोमानियाति" },
            { "ru", "रुसिया ति" },
            { "sa", "संस्कृत" },
            { "sd", "सिंधी" },
            { "si", "सिंहली" },
            { "sk", "स्लोवाक" },
            { "sl", "स्लोवेनियाति" },
            { "sq", "अल्बानियाति" },
            { "sr", "सर्बियाति" },
            { "sv", "स्वीडिस" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "th", "ताई" },
            { "tr", metaValue_TR },
            { "uk", "यूक्रेनियाति" },
            { "ur", "उर्दू" },
            { "uz", "उज़्बेक" },
            { "vi", "वियतनामी" },
            { "zh", "चीनी" },
            { "zu", "ज़ुलू" },
            { "brx", "बोडो" },
            { "chr", metaValue_chr },
            { "doi", "डोगरी" },
            { "fil", "प़िलिपीनो" },
            { "kok", "कोंकणी" },
            { "kxv", "कुवि" },
            { "mai", "मेतिली" },
            { "mni", "मणिपुरी" },
            { "sat", "संताली" },
            { "Arab", "अरबी" },
            { "Beng", metaValue_bn },
            { "Brah", "ब्राह्मि" },
            { "Cher", metaValue_chr },
            { "Cyrl", "सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Gujr", "गुजराती" },
            { "Guru", "गुरमुकी" },
            { "Hans", "साॅहाॅजाॅ" },
            { "Hant", "हिरूदोल्लु" },
            { "Knda", metaValue_kn },
            { "Latn", "लातिन" },
            { "Mlym", metaValue_ml },
            { "Orya", "ऑड़िया" },
            { "Saur", "सॉउराष्ट्र" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Zxxx", "राचा-आ-आत्ति" },
            { "Zzzz", "पुण्-आँऽति ऑकाॅराॅ" },
            { "de_AT", "ऑस्ट्रियाति जर्मन" },
            { "de_CH", "स्विस हाइ ति जर्मन" },
            { "en_AU", "ऑस्ट्रेलियाति इंराजी" },
            { "en_CA", "कनाडाति इंराजी" },
            { "en_GB", "ब्रिटिस इंराजी" },
            { "en_US", "अमेरिकी इंराजी" },
            { "es_ES", "यूरोपीय ति स्पेनिस" },
            { "es_MX", "मेक्सिको ति स्पेनिस" },
            { "fa_AF", "डॉरि" },
            { "fr_CA", "कनाडाति प़्रेंच" },
            { "fr_CH", "स्विस प़्रेंच" },
            { "nl_BE", "प़्लेमिस" },
            { "pt_BR", "ब्राज़ीली पुर्तगाली" },
            { "pt_PT", "यूरोपीय पुर्तगाली" },
            { "ro_MD", "मोलडावियन" },
            { "sw_CD", "कांगो स्वाहिली" },
            { "ar_001", "पुनिजुगो मानांकॉ आरॉबिक" },
            { "es_419", "लातिन आमेरिका ति स्पेनिस" },
            { "key.ca", "केलेंडर" },
            { "key.cf", "टाकाँ पॉरॉमाटो" },
            { "key.co", "मिला क्रॉमॉ" },
            { "key.cu", "टाकाँ" },
            { "key.hc", "वेड़ाति गिला (१२ ऑड़े २४)" },
            { "key.lb", "धाड़ी लिनी आड़ा" },
            { "key.ms", "लाटिनि लेका" },
            { "key.nu", "सॉङ्क्या" },
            { "hi_Latn", "हिन्दी (लातिन)" },
            { "zh_Hans", "साॅहाॅजाॅ चीनी" },
            { "zh_Hant", "हिरूदोल्लु चीनी" },
            { "type.hc.h11", "१२ गॉन्ता ति पॉद्दॉति (0–११)" },
            { "type.hc.h12", "१२ गॉन्ता ति पॉद्दॉति (१–१२)" },
            { "type.hc.h23", "२४ गॉन्ता ति पॉद्दॉति (0–२३)" },
            { "type.hc.h24", "२४ गॉन्ता ति पॉद्दॉति (१–२४)" },
            { "type.nu.arab", "आरॉबिक-बारतीय नॉम्बर" },
            { "type.nu.beng", "बंगाली नॉम्बर" },
            { "type.nu.deva", "देवनागरी नॉम्बर" },
            { "type.nu.gujr", "गुजराती नॉम्बर" },
            { "type.nu.guru", "गुरमुकी नॉम्बर" },
            { "type.nu.knda", "कन्नड़ नॉम्बर" },
            { "type.nu.latn", "वेड़ा कुण्पु नॉम्बर" },
            { "type.nu.mlym", "मलयालम नॉम्बर" },
            { "type.nu.orya", "ऑड़िया नॉम्बर" },
            { "type.nu.taml", "हिरूदोल्लु तामिल नॉम्बर" },
            { "type.nu.telu", "तेलुगू नॉम्बर" },
            { "type.co.ducet", "डिप़ॉल्ट यूनिकोड सॉर्ट लेँ" },
            { "type.nu.roman", "रोमन नॉम्बर" },
            { "type.ca.indian", "बारॉतॉ जातियॉ केलेंडर" },
            { "type.co.search", "सामानि-उद्देस्य पारिनॉ" },
            { "type.ms.metric", "मेट्रिक पॉद्दॉति" },
            { "type.nu.arabext", "नॉकि-आति आरॉबिक-बारतीय नॉम्बर" },
            { "type.nu.tamldec", "तामिल नॉम्बर" },
            { "type.cf.standard", "मानांकॉ टाकाँ रुपॉ" },
            { "type.co.standard", "मानांकॉ सॉर्ट लेँ" },
            { "type.ms.uksystem", "सामराज्यॉ ति आटिनि मापॉ पॉद्दॉति" },
            { "type.ms.ussystem", "आमेरिका ति मापॉ पॉद्दॉति" },
            { "type.nu.romanlow", "रोमन मिला गिरा नॉम्बर" },
            { "type.ca.gregorian", "ग्रेगोरियन केलेंडर" },
            { "type.co.phonebook", "फॉन्-वॉहि सॉर्ट लेँ" },
        };
        return data;
    }
}
