/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "չակմա";
        final String metaValue_chr = "չերոկի";
        final String metaValue_gu = "գուջարաթի";
        final String metaValue_kn = "կաննադա";
        final String metaValue_ml = "մալայալամ";
        final String metaValue_mni = "մանիպուրի";
        final String metaValue_nqo = "նկո";
        final String metaValue_or = "օրիյա";
        final String metaValue_te = "թելուգու";
        final Object[][] data = new Object[][] {
            { "001", "Աշխարհ" },
            { "002", "Աֆրիկա" },
            { "003", "Հյուսիսային Ամերիկա" },
            { "005", "Հարավային Ամերիկա" },
            { "009", "Օվկիանիա" },
            { "011", "Արևմտյան Աֆրիկա" },
            { "013", "Կենտրոնական Ամերիկա" },
            { "014", "Արևելյան Աֆրիկա" },
            { "015", "Հյուսիսային Աֆրիկա" },
            { "017", "Կենտրոնական Աֆրիկա" },
            { "018", "Հարավային Աֆրիկա" },
            { "019", "Ամերիկա" },
            { "021", "Հյուսիսային Ամերիկա - ԱՄՆ և Կանադա" },
            { "029", "Կարիբներ" },
            { "030", "Արևելյան Ասիա" },
            { "034", "Հարավային Ասիա" },
            { "035", "Հարավարևելյան Ասիա" },
            { "039", "Հարավային Եվրոպա" },
            { "053", "Ավստրալասիա" },
            { "054", "Մելանեզիա" },
            { "057", "Միկրոնեզյան տարածաշրջան" },
            { "061", "Պոլինեզիա" },
            { "142", "Ասիա" },
            { "143", "Կենտրոնական Ասիա" },
            { "145", "Արևմտյան Ասիա" },
            { "150", "Եվրոպա" },
            { "151", "Արևելյան Եվրոպա" },
            { "154", "Հյուսիսային Եվրոպա" },
            { "155", "Արևմտյան Եվրոպա" },
            { "202", "Արևադարձային Աֆրիկա" },
            { "419", "Լատինական Ամերիկա" },
            { "AC", "Համբարձման կղզի" },
            { "AD", "Անդորրա" },
            { "AE", "Արաբական Միացյալ Էմիրություններ" },
            { "AF", "Աֆղանստան" },
            { "AG", "Անտիգուա և Բարբուդա" },
            { "AI", "Անգուիլա" },
            { "AL", "Ալբանիա" },
            { "AM", "Հայաստան" },
            { "AO", "Անգոլա" },
            { "AQ", "Անտարկտիդա" },
            { "AR", "Արգենտինա" },
            { "AS", "Ամերիկյան Սամոա" },
            { "AT", "Ավստրիա" },
            { "AU", "Ավստրալիա" },
            { "AW", "Արուբա" },
            { "AX", "Ալանդյան կղզիներ" },
            { "AZ", "Ադրբեջան" },
            { "BA", "Բոսնիա և Հերցեգովինա" },
            { "BB", "Բարբադոս" },
            { "BD", "Բանգլադեշ" },
            { "BE", "Բելգիա" },
            { "BF", "Բուրկինա Ֆասո" },
            { "BG", "Բուլղարիա" },
            { "BH", "Բահրեյն" },
            { "BI", "Բուրունդի" },
            { "BJ", "Բենին" },
            { "BL", "Սուրբ Բարդուղիմեոս" },
            { "BM", "Բերմուդներ" },
            { "BN", "Բրունեյ" },
            { "BO", "Բոլիվիա" },
            { "BQ", "Կարիբյան Նիդեռլանդներ" },
            { "BR", "Բրազիլիա" },
            { "BS", "Բահամյան կղզիներ" },
            { "BT", "Բութան" },
            { "BV", "Բուվե կղզի" },
            { "BW", "Բոտսվանա" },
            { "BY", "Բելառուս" },
            { "BZ", "Բելիզ" },
            { "CA", "Կանադա" },
            { "CC", "Կոկոսյան (Քիլինգ) կղզիներ" },
            { "CD", "Կոնգո - Կինշասա" },
            { "CF", "Կենտրոնական Աֆրիկյան Հանրապետություն" },
            { "CG", "Կոնգո - Բրազավիլ" },
            { "CH", "Շվեյցարիա" },
            { "CI", "Կոտ դ՚Իվուար" },
            { "CK", "Կուկի կղզիներ" },
            { "CL", "Չիլի" },
            { "CM", "Կամերուն" },
            { "CN", "Չինաստան" },
            { "CO", "Կոլումբիա" },
            { "CP", "Քլիփերթոն կղզի" },
            { "CR", "Կոստա Ռիկա" },
            { "CU", "Կուբա" },
            { "CV", "Կաբո Վերդե" },
            { "CW", "Կյուրասաո" },
            { "CX", "Սուրբ Ծննդյան կղզի" },
            { "CY", "Կիպրոս" },
            { "CZ", "Չեխիա" },
            { "DE", "Գերմանիա" },
            { "DG", "Դիեգո Գարսիա" },
            { "DJ", "Ջիբութի" },
            { "DK", "Դանիա" },
            { "DM", "Դոմինիկա" },
            { "DO", "Դոմինիկյան Հանրապետություն" },
            { "DZ", "Ալժիր" },
            { "EA", "Սեուտա և Մելիլյա" },
            { "EC", "Էկվադոր" },
            { "EE", "Էստոնիա" },
            { "EG", "Եգիպտոս" },
            { "EH", "Արևմտյան Սահարա" },
            { "ER", "Էրիթրեա" },
            { "ES", "Իսպանիա" },
            { "ET", "Եթովպիա" },
            { "EU", "Եվրոպական Միություն" },
            { "EZ", "Եվրագոտի" },
            { "FI", "Ֆինլանդիա" },
            { "FJ", "Ֆիջի" },
            { "FK", "Ֆոլքլենդյան կղզիներ" },
            { "FM", "Միկրոնեզիա" },
            { "FO", "Ֆարերյան կղզիներ" },
            { "FR", "Ֆրանսիա" },
            { "GA", "Գաբոն" },
            { "GB", "Միացյալ Թագավորություն" },
            { "GD", "Գրենադա" },
            { "GE", "Վրաստան" },
            { "GF", "Ֆրանսիական Գվիանա" },
            { "GG", "Գերնսի" },
            { "GH", "Գանա" },
            { "GI", "Ջիբրալթար" },
            { "GL", "Գրենլանդիա" },
            { "GM", "Գամբիա" },
            { "GN", "Գվինեա" },
            { "GP", "Գվադելուպա" },
            { "GQ", "Հասարակածային Գվինեա" },
            { "GR", "Հունաստան" },
            { "GS", "Հարավային Ջորջիա և Հարավային Սենդվիչյան կղզիներ" },
            { "GT", "Գվատեմալա" },
            { "GU", "Գուամ" },
            { "GW", "Գվինեա-Բիսաու" },
            { "GY", "Գայանա" },
            { "HK", "Հոնկոնգի ՀՎՇ" },
            { "HM", "Հերդ կղզի և ՄակԴոնալդի կղզիներ" },
            { "HN", "Հոնդուրաս" },
            { "HR", "Խորվաթիա" },
            { "HT", "Հայիթի" },
            { "HU", "Հունգարիա" },
            { "IC", "Կանարյան կղզիներ" },
            { "ID", "Ինդոնեզիա" },
            { "IE", "Իռլանդիա" },
            { "IL", "Իսրայել" },
            { "IM", "Մեն կղզի" },
            { "IN", "Հնդկաստան" },
            { "IO", "Բրիտանական տարածք Հնդկական Օվկիանոսում" },
            { "IQ", "Իրաք" },
            { "IR", "Իրան" },
            { "IS", "Իսլանդիա" },
            { "IT", "Իտալիա" },
            { "JE", "Ջերսի" },
            { "JM", "Ճամայկա" },
            { "JO", "Հորդանան" },
            { "JP", "Ճապոնիա" },
            { "KE", "Քենիա" },
            { "KG", "Ղրղզստան" },
            { "KH", "Կամբոջա" },
            { "KI", "Կիրիբատի" },
            { "KM", "Կոմորյան կղզիներ" },
            { "KN", "Սենթ Քիտս և Նևիս" },
            { "KP", "Հյուսիսային Կորեա" },
            { "KR", "Հարավային Կորեա" },
            { "KW", "Քուվեյթ" },
            { "KY", "Կայմանյան կղզիներ" },
            { "KZ", "Ղազախստան" },
            { "LA", "Լաոս" },
            { "LB", "Լիբանան" },
            { "LC", "Սենթ Լյուսիա" },
            { "LI", "Լիխտենշտեյն" },
            { "LK", "Շրի Լանկա" },
            { "LR", "Լիբերիա" },
            { "LS", "Լեսոտո" },
            { "LT", "Լիտվա" },
            { "LU", "Լյուքսեմբուրգ" },
            { "LV", "Լատվիա" },
            { "LY", "Լիբիա" },
            { "MA", "Մարոկկո" },
            { "MC", "Մոնակո" },
            { "MD", "Մոլդովա" },
            { "ME", "Չեռնոգորիա" },
            { "MF", "Սեն Մարտեն" },
            { "MG", "Մադագասկար" },
            { "MH", "Մարշալյան կղզիներ" },
            { "MK", "Հյուսիսային Մակեդոնիա" },
            { "ML", "Մալի" },
            { "MM", "Մյանմա (Բիրմա)" },
            { "MN", "Մոնղոլիա" },
            { "MO", "Չինաստանի Մակաո ՀՎՇ" },
            { "MP", "Հյուսիսային Մարիանյան կղզիներ" },
            { "MQ", "Մարտինիկա" },
            { "MR", "Մավրիտանիա" },
            { "MS", "Մոնսեռատ" },
            { "MT", "Մալթա" },
            { "MU", "Մավրիկիոս" },
            { "MV", "Մալդիվներ" },
            { "MW", "Մալավի" },
            { "MX", "Մեքսիկա" },
            { "MY", "Մալայզիա" },
            { "MZ", "Մոզամբիկ" },
            { "NA", "Նամիբիա" },
            { "NC", "Նոր Կալեդոնիա" },
            { "NE", "Նիգեր" },
            { "NF", "Նորֆոլկ կղզի" },
            { "NG", "Նիգերիա" },
            { "NI", "Նիկարագուա" },
            { "NL", "Նիդեռլանդներ" },
            { "NO", "Նորվեգիա" },
            { "NP", "Նեպալ" },
            { "NR", "Նաուրու" },
            { "NU", "Նիուե" },
            { "NZ", "Նոր Զելանդիա" },
            { "OM", "Օման" },
            { "PA", "Պանամա" },
            { "PE", "Պերու" },
            { "PF", "Ֆրանսիական Պոլինեզիա" },
            { "PG", "Պապուա Նոր Գվինեա" },
            { "PH", "Ֆիլիպիններ" },
            { "PK", "Պակիստան" },
            { "PL", "Լեհաստան" },
            { "PM", "Սեն Պիեռ և Միքելոն" },
            { "PN", "Պիտկեռն կղզիներ" },
            { "PR", "Պուերտո Ռիկո" },
            { "PS", "Պաղեստինյան տարածքներ" },
            { "PT", "Պորտուգալիա" },
            { "PW", "Պալաու" },
            { "PY", "Պարագվայ" },
            { "QA", "Կատար" },
            { "QO", "Արտաքին Օվկիանիա" },
            { "RE", "Ռեյունիոն" },
            { "RO", "Ռումինիա" },
            { "RS", "Սերբիա" },
            { "RU", "Ռուսաստան" },
            { "RW", "Ռուանդա" },
            { "SA", "Սաուդյան Արաբիա" },
            { "SB", "Սողոմոնյան կղզիներ" },
            { "SC", "Սեյշելներ" },
            { "SD", "Սուդան" },
            { "SE", "Շվեդիա" },
            { "SG", "Սինգապուր" },
            { "SH", "Սուրբ Հեղինեի կղզի" },
            { "SI", "Սլովենիա" },
            { "SJ", "Սվալբարդ և Յան Մայեն" },
            { "SK", "Սլովակիա" },
            { "SL", "Սիեռա Լեոնե" },
            { "SM", "Սան Մարինո" },
            { "SN", "Սենեգալ" },
            { "SO", "Սոմալի" },
            { "SR", "Սուրինամ" },
            { "SS", "Հարավային Սուդան" },
            { "ST", "Սան Տոմե և Փրինսիպի" },
            { "SV", "Սալվադոր" },
            { "SX", "Սինտ Մարտեն" },
            { "SY", "Սիրիա" },
            { "SZ", "Էսվատինի" },
            { "TA", "Տրիստան դա Կունյա" },
            { "TC", "Թըրքս և Կայկոս կղզիներ" },
            { "TD", "Չադ" },
            { "TF", "Ֆրանսիական Հարավային Տարածքներ" },
            { "TG", "Տոգո" },
            { "TH", "Թաիլանդ" },
            { "TJ", "Տաջիկստան" },
            { "TK", "Տոկելաու" },
            { "TL", "Թիմոր Լեշտի" },
            { "TM", "Թուրքմենստան" },
            { "TN", "Թունիս" },
            { "TO", "Տոնգա" },
            { "TR", "Թուրքիա" },
            { "TT", "Տրինիդադ և Տոբագո" },
            { "TV", "Տուվալու" },
            { "TW", "Թայվան" },
            { "TZ", "Տանզանիա" },
            { "UA", "Ուկրաինա" },
            { "UG", "Ուգանդա" },
            { "UM", "Արտաքին կղզիներ (ԱՄՆ)" },
            { "UN", "Միավորված ազգերի կազմակերպություն" },
            { "US", "Միացյալ Նահանգներ" },
            { "UY", "Ուրուգվայ" },
            { "UZ", "Ուզբեկստան" },
            { "VA", "Վատիկան" },
            { "VC", "Սենթ Վինսենթ և Գրենադիններ" },
            { "VE", "Վենեսուելա" },
            { "VG", "Բրիտանական Վիրջինյան կղզիներ" },
            { "VI", "ԱՄՆ Վիրջինյան կղզիներ" },
            { "VN", "Վիետնամ" },
            { "VU", "Վանուատու" },
            { "WF", "Ուոլիս և Ֆուտունա" },
            { "WS", "Սամոա" },
            { "XA", "կեղծ տարբերիչներ" },
            { "XB", "կեղծ երկուղղված" },
            { "XK", "Կոսովո" },
            { "YE", "Եմեն" },
            { "YT", "Մայոտ" },
            { "ZA", "Հարավաֆրիկյան Հանրապետություն" },
            { "ZM", "Զամբիա" },
            { "ZW", "Զիմբաբվե" },
            { "ZZ", "Անհայտ տարածաշրջան" },
            { "aa", "աֆարերեն" },
            { "ab", "աբխազերեն" },
            { "af", "աֆրիկաանս" },
            { "ak", "աքան" },
            { "am", "ամհարերեն" },
            { "an", "արագոներեն" },
            { "ar", "արաբերեն" },
            { "as", "ասամերեն" },
            { "av", "ավարերեն" },
            { "ay", "այմարա" },
            { "az", "ադրբեջաներեն" },
            { "ba", "բաշկիրերեն" },
            { "be", "բելառուսերեն" },
            { "bg", "բուլղարերեն" },
            { "bi", "բիսլամա" },
            { "bm", "բամբարա" },
            { "bn", "բենգալերեն" },
            { "bo", "տիբեթերեն" },
            { "br", "բրետոներեն" },
            { "bs", "բոսնիերեն" },
            { "ca", "կատալաներեն" },
            { "ce", "չեչեներեն" },
            { "ch", "չամոռո" },
            { "co", "կորսիկերեն" },
            { "cs", "չեխերեն" },
            { "cu", "սլավոներեն, եկեղեցական" },
            { "cv", "չուվաշերեն" },
            { "cy", "ուելսերեն" },
            { "da", "դանիերեն" },
            { "de", "գերմաներեն" },
            { "dv", "դիվեհի" },
            { "dz", "ջոնգքհա" },
            { "ee", "էվե" },
            { "el", "հունարեն" },
            { "en", "անգլերեն" },
            { "eo", "էսպերանտո" },
            { "es", "իսպաներեն" },
            { "et", "էստոներեն" },
            { "eu", "բասկերեն" },
            { "fa", "պարսկերեն" },
            { "ff", "ֆուլահ" },
            { "fi", "ֆիններեն" },
            { "fj", "ֆիջիերեն" },
            { "fo", "ֆարյորերեն" },
            { "fr", "ֆրանսերեն" },
            { "fy", "արևմտաֆրիզերեն" },
            { "ga", "իռլանդերեն" },
            { "gd", "շոտլանդական գաելերեն" },
            { "gl", "գալիսերեն" },
            { "gn", "գուարանի" },
            { "gu", metaValue_gu },
            { "gv", "մեներեն" },
            { "ha", "հաուսա" },
            { "he", "եբրայերեն" },
            { "hi", "հինդի" },
            { "hr", "խորվաթերեն" },
            { "ht", "խառնակերտ հայիթերեն" },
            { "hu", "հունգարերեն" },
            { "hy", "հայերեն" },
            { "hz", "հերերո" },
            { "ia", "ինտերլինգուա" },
            { "id", "ինդոնեզերեն" },
            { "ie", "ինտերլինգուե" },
            { "ig", "իգբո" },
            { "ii", "սիչուան" },
            { "io", "իդո" },
            { "is", "իսլանդերեն" },
            { "it", "իտալերեն" },
            { "iu", "ինուկտիտուտ" },
            { "ja", "ճապոներեն" },
            { "jv", "ճավայերեն" },
            { "ka", "վրացերեն" },
            { "ki", "կիկույու" },
            { "kj", "կուանյամա" },
            { "kk", "ղազախերեն" },
            { "kl", "կալաալիսուտ" },
            { "km", "քմերերեն" },
            { "kn", metaValue_kn },
            { "ko", "կորեերեն" },
            { "kr", "կանուրի" },
            { "ks", "քաշմիրերեն" },
            { "ku", "քրդերեն" },
            { "kv", "կոմիերեն" },
            { "kw", "կոռներեն" },
            { "ky", "ղրղզերեն" },
            { "la", "լատիներեն" },
            { "lb", "լյուքսեմբուրգերեն" },
            { "lg", "գանդա" },
            { "li", "լիմբուրգերեն" },
            { "ln", "լինգալա" },
            { "lo", "լաոսերեն" },
            { "lt", "լիտվերեն" },
            { "lu", "լուբա-կատանգա" },
            { "lv", "լատվիերեն" },
            { "mg", "մալգաշերեն" },
            { "mh", "մարշալերեն" },
            { "mi", "մաորի" },
            { "mk", "մակեդոներեն" },
            { "ml", metaValue_ml },
            { "mn", "մոնղոլերեն" },
            { "mr", "մարաթի" },
            { "ms", "մալայերեն" },
            { "mt", "մալթայերեն" },
            { "my", "բիրմայերեն" },
            { "na", "նաուրու" },
            { "nb", "գրքային նորվեգերեն" },
            { "nd", "հյուսիսային նդեբելե" },
            { "ne", "նեպալերեն" },
            { "ng", "նդոնգա" },
            { "nl", "հոլանդերեն" },
            { "nn", "նոր նորվեգերեն" },
            { "no", "նորվեգերեն" },
            { "nr", "հարավային նդեբելե" },
            { "nv", "նավախո" },
            { "ny", "նյանջա" },
            { "oc", "օքսիտաներեն" },
            { "oj", "օջիբվա" },
            { "om", "օրոմո" },
            { "or", metaValue_or },
            { "os", "օսերեն" },
            { "pa", "փենջաբերեն" },
            { "pi", "պալի" },
            { "pl", "լեհերեն" },
            { "ps", "փուշթու" },
            { "pt", "պորտուգալերեն" },
            { "qu", "կեչուա" },
            { "rm", "ռոմանշերեն" },
            { "rn", "ռունդի" },
            { "ro", "ռումիներեն" },
            { "ru", "ռուսերեն" },
            { "rw", "կինյառուանդա" },
            { "sa", "սանսկրիտ" },
            { "sc", "սարդիներեն" },
            { "sd", "սինդհի" },
            { "se", "հյուսիսային սաամի" },
            { "sg", "սանգո" },
            { "sh", "սերբա-խորվաթերեն" },
            { "si", "սինհալերեն" },
            { "sk", "սլովակերեն" },
            { "sl", "սլովեներեն" },
            { "sm", "սամոաերեն" },
            { "sn", "շոնա" },
            { "so", "սոմալիերեն" },
            { "sq", "ալբաներեն" },
            { "sr", "սերբերեն" },
            { "ss", "սվազերեն" },
            { "st", "հարավային սոթո" },
            { "su", "սունդաներեն" },
            { "sv", "շվեդերեն" },
            { "sw", "սուահիլի" },
            { "ta", "թամիլերեն" },
            { "te", metaValue_te },
            { "tg", "տաջիկերեն" },
            { "th", "թայերեն" },
            { "ti", "տիգրինյա" },
            { "tk", "թուրքմեներեն" },
            { "tl", "տագալերեն" },
            { "tn", "ցվանա" },
            { "to", "տոնգերեն" },
            { "tr", "թուրքերեն" },
            { "ts", "ցոնգա" },
            { "tt", "թաթարերեն" },
            { "tw", "տուի" },
            { "ty", "թաիտերեն" },
            { "ug", "ույղուրերեն" },
            { "uk", "ուկրաիներեն" },
            { "ur", "ուրդու" },
            { "uz", "ուզբեկերեն" },
            { "ve", "վենդա" },
            { "vi", "վիետնամերեն" },
            { "vo", "վոլապյուկ" },
            { "wa", "վալոներեն" },
            { "wo", "վոլոֆ" },
            { "xh", "քոսա" },
            { "yi", "իդիշ" },
            { "yo", "յորուբա" },
            { "za", "ժուանգ" },
            { "zh", "չինարեն" },
            { "zu", "զուլուերեն" },
            { "ace", "աչեհերեն" },
            { "ach", "աչոլի" },
            { "ada", "ադանգմերեն" },
            { "ady", "ադիղերեն" },
            { "aeb", "թունիսական արաբերեն" },
            { "agq", "աղեմ" },
            { "ain", "այներեն" },
            { "akk", "աքքադերեն" },
            { "ale", "ալեութերեն" },
            { "alt", "հարավային ալթայերեն" },
            { "ang", "հին անգլերեն" },
            { "ann", "օբոլո" },
            { "anp", "անգիկա" },
            { "arc", "արամեերեն" },
            { "arn", "մապուչի" },
            { "arp", "արապահո" },
            { "arq", "ալժիրական արաբերեն" },
            { "ars", "նեջդի արաբերեն" },
            { "arz", "եգիպտական արաբերեն" },
            { "asa", "ասու" },
            { "ase", "ամերիկյան ժեստերի լեզու" },
            { "ast", "աստուրերեն" },
            { "atj", "աթիկամեկ" },
            { "awa", "ավադհի" },
            { "ban", "բալիերեն" },
            { "bas", "բասաա" },
            { "bem", "բեմբա" },
            { "bez", "բենա" },
            { "bgc", "հարյանվի" },
            { "bgn", "արևմտաբելուջիերեն" },
            { "bho", "բհոպուրի" },
            { "bin", "բինի" },
            { "bla", "սիկսիկա" },
            { "blo", "անիի" },
            { "brx", "բոդո" },
            { "bss", "աքուզ" },
            { "bug", "բուգիերեն" },
            { "byn", "բիլին" },
            { "cay", "կայուգա" },
            { "ccp", metaValue_ccp },
            { "ceb", "սեբուերեն" },
            { "cgg", "չիգա" },
            { "chk", "տրուկերեն" },
            { "chm", "մարի" },
            { "cho", "չոկտո" },
            { "chp", "չիպևայան" },
            { "chr", metaValue_chr },
            { "chy", "շայեն" },
            { "ckb", "սորանի քրդերեն" },
            { "clc", "չիլկոտիներեն" },
            { "cop", "ղպտերեն" },
            { "crg", "միչիֆ" },
            { "crh", "ղրիմյան թուրքերեն" },
            { "crj", "հարավ-արևելյան քրի" },
            { "crk", "հարթավայրերի քրի" },
            { "crl", "հյուսիս-արևելյան քրի" },
            { "crm", "մուզ քրի" },
            { "crr", "կարոլինական ալգոնկիներեն" },
            { "crs", "սեյշելյան խառնակերտ ֆրանսերեն" },
            { "csw", "ճահճի քրի" },
            { "dak", "դակոտա" },
            { "dar", "դարգիներեն" },
            { "dav", "թաիթա" },
            { "dgr", "դոգրիբ" },
            { "dje", "զարմա" },
            { "doi", "դոգրի" },
            { "dsb", "ստորին սորբերեն" },
            { "dua", "դուալա" },
            { "dyo", "ջոլա-ֆոնյի" },
            { "dzg", "դազագա" },
            { "ebu", "էմբու" },
            { "efi", "էֆիկ" },
            { "egy", "հին եգիպտերեն" },
            { "eka", "էկաջուկ" },
            { "ewo", "էվոնդո" },
            { "fil", "ֆիլիպիներեն" },
            { "fit", "տորնադելեն ֆիններեն" },
            { "fon", "ֆոն" },
            { "frc", "քաջունական ֆրանսերեն" },
            { "fro", "հին ֆրանսերեն" },
            { "frr", "հյուսիսային ֆրիզերեն" },
            { "frs", "արևելաֆրիզերեն" },
            { "fur", "ֆրիուլիերեն" },
            { "gaa", "գայերեն" },
            { "gag", "գագաուզերեն" },
            { "gbz", "զրադաշտական դարի" },
            { "gez", "գեեզ" },
            { "gil", "կիրիբատի" },
            { "goh", "հին վերին գերմաներեն" },
            { "gor", "գորոնտալո" },
            { "got", "գոթերեն" },
            { "grc", "հին հունարեն" },
            { "gsw", "շվեյցարական գերմաներեն" },
            { "guc", "վայուու" },
            { "guz", "գուսի" },
            { "gwi", "գվիչին" },
            { "hai", "հայդա" },
            { "haw", "հավայիերեն" },
            { "hax", "հարավային հայդա" },
            { "hil", "հիլիգայնոն" },
            { "hmn", "հմոնգ" },
            { "hsb", "վերին սորբերեն" },
            { "hsn", "սյան չինարեն" },
            { "hup", "հուպա" },
            { "hur", "հալքոմելեմ" },
            { "iba", "իբաներեն" },
            { "ibb", "իբիբիո" },
            { "ikt", "արևմտականադական ինուկտիտուտ" },
            { "ilo", "իլոկերեն" },
            { "inh", "ինգուշերեն" },
            { "jbo", "լոժբան" },
            { "jgo", "նգոմբա" },
            { "jmc", "մաշամե" },
            { "kab", "կաբիլերեն" },
            { "kac", "կաչիներեն" },
            { "kaj", "ջյու" },
            { "kam", "կամբա" },
            { "kbd", "կաբարդերեն" },
            { "kcg", "տիապ" },
            { "kde", "մակոնդե" },
            { "kea", "կաբուվերդերեն" },
            { "kfo", "կորո" },
            { "kgp", "կաինգան" },
            { "kha", "քասիերեն" },
            { "khq", "կոյրա չինի" },
            { "kkj", "կակո" },
            { "kln", "կալենջին" },
            { "kmb", "կիմբունդու" },
            { "koi", "պերմյակ կոմիերեն" },
            { "kok", "կոնկանի" },
            { "kpe", "կպելլեերեն" },
            { "krc", "կարաչայ-բալկարերեն" },
            { "krl", "կարելերեն" },
            { "kru", "կուրուխ" },
            { "ksb", "շամբալա" },
            { "ksf", "բաֆիա" },
            { "ksh", "քյոլներեն" },
            { "kum", "կումիկերեն" },
            { "kwk", "կվակվալա" },
            { "kxv", "կուվի" },
            { "lad", "լադինո" },
            { "lag", "լանգի" },
            { "lez", "լեզգիերեն" },
            { "lij", "լիգուրերեն" },
            { "lil", "լիլուետ" },
            { "lkt", "լակոտա" },
            { "lmo", "լոմբարդերեն" },
            { "lou", "լուիզիանական կրեոլերեն" },
            { "loz", "լոզի" },
            { "lrc", "հյուսիսային լուրիերեն" },
            { "lsm", "սաամերեն" },
            { "lua", "լուբա-լուլուա" },
            { "lun", "լունդա" },
            { "luo", "լուո" },
            { "lus", "միզո" },
            { "luy", "լույա" },
            { "mad", "մադուրերեն" },
            { "mag", "մագահի" },
            { "mai", "մայթիլի" },
            { "mak", "մակասարերեն" },
            { "mas", "մասաի" },
            { "mdf", "մոկշայերեն" },
            { "men", "մենդե" },
            { "mer", "մերու" },
            { "mfe", "մորիսյեն" },
            { "mgh", "մաքուա-մետտո" },
            { "mgo", "մետա" },
            { "mic", "միկմակ" },
            { "min", "մինանգկաբաու" },
            { "mni", metaValue_mni },
            { "moe", "իննու-այմուն" },
            { "moh", "մոհավք" },
            { "mos", "մոսսի" },
            { "mrj", "արևմտամարիերեն" },
            { "mua", "մունդանգ" },
            { "mul", "բազմալեզու" },
            { "mus", "մասքոջի" },
            { "mwl", "միրանդերեն" },
            { "myv", "էրզյա" },
            { "mzn", "մազանդարաներեն" },
            { "nap", "նեապոլերեն" },
            { "naq", "նամա" },
            { "nds", "ստորին գերմաներեն" },
            { "new", "նեվարերեն" },
            { "nia", "նիասերեն" },
            { "niu", "նիուերեն" },
            { "nmg", "կվասիո" },
            { "nnh", "նգիեմբուն" },
            { "nog", "նոգայերեն" },
            { "non", "հին նորվեգերեն" },
            { "nqo", metaValue_nqo },
            { "nso", "հյուսիսային սոթո" },
            { "nus", "նուեր" },
            { "nyn", "նյանկոլե" },
            { "ojb", "հյուսիս-արևմտյան օջիբվե" },
            { "ojc", "կենտրոնական օջիբվե" },
            { "ojs", "օջի քրի" },
            { "ojw", "արևմտյան օջիբվե" },
            { "oka", "օկանագան" },
            { "osa", "օսեյջ" },
            { "ota", "օսմաներեն" },
            { "pag", "պանգասինաներեն" },
            { "pal", "պահլավերեն" },
            { "pam", "պամպանգաերեն" },
            { "pap", "պապյամենտո" },
            { "pau", "պալաուերեն" },
            { "pcd", "պիկարդերեն" },
            { "pcm", "նիգերիական փիջին" },
            { "pdc", "փենսիլվանական գերմաներեն" },
            { "pdt", "պլատագերմաներեն" },
            { "peo", "հին պարսկերեն" },
            { "pfl", "պալատինյան գերմաներեն" },
            { "phn", "փյունիկերեն" },
            { "pis", "փիջին" },
            { "pms", "պիեմոնտերեն" },
            { "pnt", "պոնտերեն" },
            { "pon", "պոնպեերեն" },
            { "pqm", "մալեսիտ-պասամակվոդի" },
            { "prg", "պրուսերեն" },
            { "pro", "հին պրովանսերեն" },
            { "quc", "քիչե" },
            { "raj", "ռաջաստաներեն" },
            { "rap", "ռապանուի" },
            { "rar", "ռարոտոնգաներեն" },
            { "rgn", "ռոմանիոլերեն" },
            { "rhg", "ռոհինջա" },
            { "rif", "ռիֆերեն" },
            { "rof", "ռոմբո" },
            { "rom", "ռոմաներեն" },
            { "rtm", "ռոտուման" },
            { "rue", "ռուսիներեն" },
            { "rug", "ռովիանա" },
            { "rup", "արոմաներեն" },
            { "rwk", "ռվա" },
            { "sad", "սանդավե" },
            { "sah", "յակուտերեն" },
            { "saq", "սամբուրու" },
            { "sat", "սանտալի" },
            { "sba", "նգամբայ" },
            { "sbp", "սանգու" },
            { "scn", "սիցիլիերեն" },
            { "sco", "շոտլանդերեն" },
            { "sdh", "հարավային քրդերեն" },
            { "seh", "սենա" },
            { "ses", "կոյրաբորո սեննի" },
            { "sga", "հին իռլանդերեն" },
            { "shi", "տաշելհիթ" },
            { "shn", "շաներեն" },
            { "slh", "հարավային լուշուցիդ" },
            { "sma", "հարավային սաամի" },
            { "smj", "լուլե սաամի" },
            { "smn", "ինարի սաամի" },
            { "sms", "սկոլտ սաամի" },
            { "snk", "սոնինկե" },
            { "srn", "սրանան տոնգո" },
            { "ssy", "սահոերեն" },
            { "str", "սթրեյթս սալիշերեն" },
            { "suk", "սուկումա" },
            { "swb", "կոմորերեն" },
            { "syr", "ասորերեն" },
            { "szl", "սիլեզերեն" },
            { "tce", "հարավային թուտչոնե" },
            { "tcy", "տուլու" },
            { "tem", "տեմնե" },
            { "teo", "տեսո" },
            { "ter", "տերենո" },
            { "tet", "տետում" },
            { "tgx", "թագիշ" },
            { "tht", "թալթան" },
            { "tig", "տիգրե" },
            { "tiv", "տիվերեն" },
            { "tkl", "տոկելաու" },
            { "tkr", "ցախուր" },
            { "tlh", "կլինգոն" },
            { "tli", "տլինգիտ" },
            { "tly", "թալիշերեն" },
            { "tmh", "տամաշեկ" },
            { "tok", "տոկիպոնա" },
            { "tpi", "տոկ փիսին" },
            { "tru", "տուրոյո" },
            { "trv", "տարոկո" },
            { "tsd", "ցակոներեն" },
            { "tsi", "ցիմշյան" },
            { "ttm", "հյուսիսային թուտչոնե" },
            { "tum", "տումբուկա" },
            { "tvl", "թուվալուերեն" },
            { "twq", "տասավաք" },
            { "tyv", "տուվերեն" },
            { "tzm", "կենտրոնատլասյան թամազիղտ" },
            { "udm", "ուդմուրտերեն" },
            { "uga", "ուգարիտերեն" },
            { "umb", "ումբունդու" },
            { "und", "անհայտ լեզու" },
            { "vai", "վաի" },
            { "vec", "վենետերեն" },
            { "vep", "վեպսերեն" },
            { "vls", "արևմտաֆլամանդերեն" },
            { "vmw", "մաքուա" },
            { "vot", "վոդերեն" },
            { "vro", "վորո" },
            { "vun", "վունջո" },
            { "wae", "վալսերեն" },
            { "wal", "վոլայտա" },
            { "war", "վարայերեն" },
            { "was", "վաշո" },
            { "wbp", "վարլպիրի" },
            { "wuu", "վու չինարեն" },
            { "xal", "կալմիկերեն" },
            { "xnr", "կանգրի" },
            { "xog", "սոգա" },
            { "yao", "յաո" },
            { "yap", "յափերեն" },
            { "yav", "յանգբեն" },
            { "ybb", "եմբա" },
            { "yrl", "նինգաթու" },
            { "yue", "կանտոներեն" },
            { "zap", "սապոտեկերեն" },
            { "zea", "զեյլանդերեն" },
            { "zen", "զենագա" },
            { "zgh", "ընդհանուր մարոկյան թամազիղտ" },
            { "zun", "զունիերեն" },
            { "zxx", "առանց լեզվային բովանդակության" },
            { "zza", "զազաերեն" },
            { "Adlm", "ադլամ" },
            { "Arab", "արաբական" },
            { "Aran", "նաստալիք" },
            { "Armn", "հայկական" },
            { "Beng", "բենգալական" },
            { "Bopo", "բոպոմոֆո" },
            { "Brai", "Բրայլ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "կանադական միասնական վանկագիր" },
            { "Cher", metaValue_chr },
            { "Cyrl", "կյուրեղագիր" },
            { "Deva", "դեւանագարի" },
            { "Ethi", "եթովպական" },
            { "Geor", "վրացական" },
            { "Grek", "հունական" },
            { "Gujr", metaValue_gu },
            { "Guru", "գուրմուխի" },
            { "Hanb", "հանբ" },
            { "Hang", "հանգըլ" },
            { "Hani", "չինական" },
            { "Hans", "պարզեցված" },
            { "Hant", "ավանդական" },
            { "Hebr", "եբրայական" },
            { "Hira", "հիրագանա" },
            { "Hrkt", "ճապոնական վանկագիր" },
            { "Jamo", "ջամո" },
            { "Jpan", "ճապոնական" },
            { "Kana", "կատականա" },
            { "Khmr", "քմերական" },
            { "Knda", metaValue_kn },
            { "Kore", "կորեական" },
            { "Laoo", "լաոսական" },
            { "Latn", "լատինական" },
            { "Mlym", metaValue_ml },
            { "Mong", "մոնղոլական" },
            { "Mtei", metaValue_mni },
            { "Mymr", "մյանմարական" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "օլ չիկի" },
            { "Orya", metaValue_or },
            { "Rohg", "հանիֆի" },
            { "Sinh", "սինհալական" },
            { "Sund", "սունդանական" },
            { "Syrc", "ասորական" },
            { "Taml", "թամիլական" },
            { "Telu", metaValue_te },
            { "Tfng", "տիֆինաղ" },
            { "Thaa", "թաանա" },
            { "Thai", "թայական" },
            { "Tibt", "տիբեթական" },
            { "Vaii", "վայական" },
            { "Yiii", "ի" },
            { "Zmth", "մաթեմատիկական նշաններ" },
            { "Zsye", "էմոջի" },
            { "Zsym", "նշաններ" },
            { "Zxxx", "չգրված" },
            { "Zyyy", "ընդհանուր" },
            { "Zzzz", "անհայտ գիր" },
            { "de_AT", "ավստրիական գերմաներեն" },
            { "de_CH", "շվեյցարական վերին գերմաներեն" },
            { "en_AU", "ավստրալիական անգլերեն" },
            { "en_CA", "կանադական անգլերեն" },
            { "en_GB", "բրիտանական անգլերեն" },
            { "en_US", "ամերիկյան անգլերեն" },
            { "es_ES", "եվրոպական իսպաներեն" },
            { "es_MX", "մեքսիկական իսպաներեն" },
            { "fa_AF", "դարի" },
            { "fr_CA", "կանադական ֆրանսերեն" },
            { "fr_CH", "շվեյցարական ֆրանսերեն" },
            { "nl_BE", "ֆլամանդերեն" },
            { "pt_BR", "բրազիլական պորտուգալերեն" },
            { "pt_PT", "եվրոպական պորտուգալերեն" },
            { "ro_MD", "մոլդովերեն" },
            { "sw_CD", "կոնգոյի սուահիլի" },
            { "ar_001", "արդի ընդհանուր արաբերեն" },
            { "es_419", "լատինամերիկյան իսպաներեն" },
            { "key.ca", "օրացույց" },
            { "key.cf", "արժույթի ձևաչափ" },
            { "key.co", "տեսակավորման կարգ" },
            { "key.cu", "արժույթ" },
            { "key.hc", "Ժամանակային համակարգ (12 կամ 24)" },
            { "key.lb", "տողանցման ոճ" },
            { "key.ms", "չափման համակարգ" },
            { "key.nu", "թվեր" },
            { "nds_NL", "ստորին սաքսոներեն" },
            { "hi_Latn", "հինդի (լատինատառ)" },
            { "zh_Hans", "պարզեցված չինարեն" },
            { "zh_Hant", "ավանդական չինարեն" },
            { "%%AREVELA", "արևելահայերեն" },
            { "%%AREVMDA", "արեւմտահայերէն" },
            { "type.ca.roc", "մինգուո օրացույց" },
            { "type.hc.h11", "12-ժամյա համակարգ (0-11)" },
            { "type.hc.h12", "12-ժամյա համակարգ (1-12)" },
            { "type.hc.h23", "24-ժամյա համակարգ (0-23)" },
            { "type.hc.h24", "24-ժամյա համակարգ (1-24)" },
            { "type.nu.arab", "արաբա-հնդկական թվանշաններ" },
            { "type.nu.armn", "հայկական թվանշաններ" },
            { "type.nu.beng", "բենգալական թվանշաններ" },
            { "type.nu.cakm", "չակմա թվանշաններ" },
            { "type.nu.deva", "դևանագարի թվանշաններ" },
            { "type.nu.ethi", "եթովպական թվանշաններ" },
            { "type.nu.geor", "վրացական թվանշաններ" },
            { "type.nu.grek", "հունական թվանշաններ" },
            { "type.nu.gujr", "գուջարաթի թվանշաններ" },
            { "type.nu.guru", "գուրմուխի թվանշաններ" },
            { "type.nu.hans", "պարզեցված չինարենի թվանշաններ" },
            { "type.nu.hant", "չինական ավանդական թվանիշեր" },
            { "type.nu.hebr", "եբրայական թվանշաններ" },
            { "type.nu.java", "ճավայական թվանշաններ" },
            { "type.nu.jpan", "ճապոնական թվանշաններ" },
            { "type.nu.khmr", "քմերական թվանշաններ" },
            { "type.nu.knda", "կաննադա թվանշաններ" },
            { "type.nu.laoo", "լաոսական թվանշաններ" },
            { "type.nu.latn", "արևմտյան թվանշաններ" },
            { "type.nu.mlym", "մալայալամ թվանշաններ" },
            { "type.nu.mtei", "մանիպուրի թվանշաններ" },
            { "type.nu.mymr", "բիրմական թվանշաններ" },
            { "type.nu.olck", "օլ չիկի թվանշաններ" },
            { "type.nu.orya", "օրիյա թվանշաններ" },
            { "type.nu.taml", "թամիլական ավանդական թվանշաններ" },
            { "type.nu.telu", "թելուգու թվանշաններ" },
            { "type.nu.thai", "թայական թվանշաններ" },
            { "type.nu.tibt", "տիբեթական թվանշաններ" },
            { "type.nu.vaii", "վայական թվանշաններ" },
            { "type.ca.dangi", "դանգի օրացույց" },
            { "type.co.ducet", "Յունիկոդ լռելյայն տեսակավորում" },
            { "type.lb.loose", "փափուկ տողանցում" },
            { "type.nu.roman", "հռոմեական թվանշաններ" },
            { "type.ca.coptic", "ղպտական օրացույց" },
            { "type.ca.hebrew", "հրեական օրացույց" },
            { "type.co.search", "որոնում" },
            { "type.lb.normal", "սովորական տողանցում" },
            { "type.lb.strict", "կոշտ տողանցում" },
            { "type.ms.metric", "մետրիկ համակարգ" },
            { "type.ca.chinese", "չինական օրացույց" },
            { "type.ca.islamic", "հիջրայի օրացույց" },
            { "type.ca.iso8601", "ISO-8601 օրացույց" },
            { "type.ca.persian", "պարսկական օրացույց" },
            { "type.cf.account", "արժույթի հաշվապահական ձևաչափ" },
            { "type.nu.arabext", "արաբա-հնդկական թվերի ընդլայնված համակարգ" },
            { "type.nu.armnlow", "հայկական փոքր թվանշաններ" },
            { "type.nu.greklow", "հունական փոքրատառ թվանիշեր" },
            { "type.nu.hanidec", "չինական տասնորդական թվանշաններ" },
            { "type.nu.hansfin", "պարզեցված չինարենի ֆինանսական թվանշաններ" },
            { "type.nu.hantfin", "ավանդական չինարենի ֆինանսական թվանշաններ" },
            { "type.nu.jpanfin", "ճապոնական ֆինանսական թվանշաններ" },
            { "type.nu.tamldec", "թամիլական թվանշաններ" },
            { "type.ca.buddhist", "բուդդայական օրացույց" },
            { "type.ca.ethiopic", "եթովպական օրացույց" },
            { "type.ca.japanese", "ճապոնական օրացույց" },
            { "type.cf.standard", "արժույթի ստանդարտ ձևաչափ" },
            { "type.co.standard", "տեսակավորման ստանդարտ կարգ" },
            { "type.ms.uksystem", "անգլիական համակարգ" },
            { "type.ms.ussystem", "ամերիկյան համակարգ" },
            { "type.nu.fullwide", "ամբողջ լայնքով թվանշաններ" },
            { "type.nu.romanlow", "հռոմեական փոքր թվանշաններ" },
            { "type.ca.gregorian", "գրիգորյան օրացույց" },
            { "ListKeyTypePattern", "{0}՝ {1}" },
            { "type.ca.islamic-civil", "հիջրայի քաղաքացիական օրացույց (աղյուսակային)" },
            { "type.ca.islamic-umalqura", "հիջրայի օրացույց (Ում ալ Քուրա)" },
            { "type.ca.ethiopic-amete-alem", "եթովպական Ամետե Ալեմ օրացույց" },
        };
        return data;
    }
}
