/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kxv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AM = "aarmenia";
        final String metaValue_PF = "prenc";
        final String metaValue_chr = "cerokī";
        final String metaValue_gu = "gujraṭī";
        final String metaValue_kn = "knnaḍa";
        final String metaValue_or = "oḍiaa";
        final String metaValue_ta = "tamiḷ";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "001", "raji, purti" },
            { "419", "laṭin amerika" },
            { "AD", "ānḍorā" },
            { "AE", "aanḍiti arab emireṭs" },
            { "AF", "aapganistan" },
            { "AG", "eṇṭigaa aḍe barbuḍaa" },
            { "AI", "anguila" },
            { "AL", "albania" },
            { "AM", metaValue_AM },
            { "AO", "angola" },
            { "AQ", "ānṭarkṭikā" },
            { "AR", "aarhenṭina" },
            { "AS", "amerikati samva" },
            { "AT", "austria" },
            { "AU", "astrelia" },
            { "AW", "aruba" },
            { "AX", "eleṇḍ dīp" },
            { "AZ", "ajerbaijan" },
            { "BA", "bajnia aḍe hertsegovina" },
            { "BB", "barbaḍos" },
            { "BD", "banglades" },
            { "BE", "beljiym" },
            { "BF", "burkina paso" },
            { "BG", "bulgaria" },
            { "BH", "bāren" },
            { "BI", "buruṇḍī" },
            { "BJ", "benīn" },
            { "BL", "se barṭelemi" },
            { "BM", "bermuḍā" },
            { "BN", "brunae" },
            { "BO", "boliviā" },
            { "BQ", "karibiyn nedrlends" },
            { "BR", "brājil" },
            { "BS", "bāhāmās" },
            { "BT", "buṭān" },
            { "BW", "boṭsvana" },
            { "BY", "belarūs" },
            { "BZ", "belīj" },
            { "CA", "kanaḍa" },
            { "CC", "kokos keling dīp" },
            { "CD", "kongo - kinsasa" },
            { "CF", "madini aaprika republik" },
            { "CG", "kongo - brajavil" },
            { "CH", "svitjerlaṇḍ" },
            { "CI", "koṭ ḍi vaa" },
            { "CK", "kuk dīp" },
            { "CL", "cili" },
            { "CM", "kemarun" },
            { "CN", "caina" },
            { "CO", "kolmbiaa" },
            { "CR", "kosta rika" },
            { "CU", "kyuba" },
            { "CV", "kep vrḍi" },
            { "CW", "kyurasao" },
            { "CX", "kristmas dīp" },
            { "CY", "saipras" },
            { "CZ", "cekiya" },
            { "DE", "jermanī" },
            { "DG", "ḍiego garsia" },
            { "DJ", "jibutī" },
            { "DK", "ḍenmark" },
            { "DM", "dominika" },
            { "DO", "dominikan republik" },
            { "DZ", "aljīriaa" },
            { "EA", "seuṭa aḍe melila" },
            { "EC", "ekvaḍor" },
            { "EE", "esṭoniya" },
            { "EG", "ījipṭ" },
            { "EH", "vedakuṇpu sahara" },
            { "ER", "īriṭriaa" },
            { "ES", "spein" },
            { "ET", "ītiyopiya" },
            { "FI", "pinlaṇd" },
            { "FJ", "piji" },
            { "FK", "paklaṇd dīp" },
            { "FM", "micronesiaa" },
            { "FO", "pēro dīp" },
            { "FR", "prans" },
            { "GA", "gbon" },
            { "GB", "uniṭeḍ kingḍom" },
            { "GD", "graneida" },
            { "GE", "jeorjiaa" },
            { "GF", "prenc guiyana" },
            { "GG", "grnse" },
            { "GH", "gana" },
            { "GI", "jbralṭr" },
            { "GL", "grīnlanḍ" },
            { "GM", "gambia" },
            { "GN", "gini" },
            { "GP", "gvadelup" },
            { "GQ", "ikveṭorial gini" },
            { "GR", "grīs" },
            { "GS", "dakiṇ jārjiā aḍe dakiṇ sandwich dīp" },
            { "GT", "gvaṭemala" },
            { "GU", "guām" },
            { "GW", "gini-bisau" },
            { "GY", "guyana" },
            { "HK", "hong kong (sar) caina" },
            { "HN", "honḍuras" },
            { "HR", "kroesia" },
            { "HT", "haiti" },
            { "HU", "hungarī" },
            { "IC", "kanari dīp" },
            { "ID", "inḍonesiya" },
            { "IE", "aayarlanḍ" },
            { "IL", "israel" },
            { "IM", "aail āp man" },
            { "IN", "inḍiā" },
            { "IO", "briṭis inḍiāti samudra handi" },
            { "IQ", "irak" },
            { "IR", "iran" },
            { "IS", "aislanḍ" },
            { "IT", "iṭalī" },
            { "JE", "jersī" },
            { "JM", "jamaika" },
            { "JO", "jorḍan" },
            { "JP", "japan" },
            { "KE", "kenya" },
            { "KG", "kirgistan" },
            { "KH", "kamboḍia" },
            { "KI", "kiribaṭi" },
            { "KM", "komoros" },
            { "KN", "seint kiṭs āḍe nebis" },
            { "KP", "uttar koriya" },
            { "KR", "dkiṇ koriyaa" },
            { "KW", "kuvet" },
            { "KY", "keimen dīp" },
            { "KZ", "kajakstan" },
            { "LA", "laos" },
            { "LB", "lebanon" },
            { "LC", "seint lusiya" },
            { "LI", "likṭensṭein" },
            { "LK", "sri lanka" },
            { "LR", "laiberīya" },
            { "LS", "lesotho" },
            { "LT", "liṭuaania" },
            { "LU", "lksemborg" },
            { "LV", "laṭviya" },
            { "LY", "libya" },
            { "MA", "morkko" },
            { "MC", "monako" },
            { "MD", "molḍovaa" },
            { "ME", "monṭenegro" },
            { "MF", "seint martin" },
            { "MG", "madagascar" },
            { "MH", "marsall dīp" },
            { "MK", "uttar mesiḍoniya" },
            { "ML", "mali" },
            { "MM", "myanmar (brma)" },
            { "MN", "mongolia" },
            { "MO", "makao sar cina" },
            { "MP", "uttar mariyana dīp" },
            { "MQ", "marṭinik" },
            { "MR", "mauriṭaniya" },
            { "MS", "monṭserrarṭ" },
            { "MT", "malṭaa" },
            { "MU", "mauriss" },
            { "MV", "māldīp" },
            { "MW", "malavī" },
            { "MX", "meksīko" },
            { "MY", "maleseāā" },
            { "MZ", "mojambik" },
            { "NA", "namibia" },
            { "NC", "nyu keleḍoniya" },
            { "NE", "naījr" },
            { "NF", "norpok dīp" },
            { "NG", "naigeria" },
            { "NI", "nikaraguaa" },
            { "NL", "nederlanḍs" },
            { "NO", "norvay" },
            { "NP", "nepal" },
            { "NR", "nauru" },
            { "NU", "niyu" },
            { "NZ", "nyu jīlanḍ" },
            { "OM", "oman" },
            { "PA", "panema" },
            { "PE", "peru" },
            { "PF", metaValue_PF },
            { "PG", "papua nyu gini" },
            { "PH", "pilippines" },
            { "PK", "pakistan" },
            { "PL", "polanḍ" },
            { "PM", "seint pierri ande mikelon" },
            { "PN", "piṭkarn dīp" },
            { "PR", "puerto rico" },
            { "PS", "palesṭiati handi" },
            { "PT", "portugal" },
            { "PW", "palau" },
            { "PY", "pareguvai" },
            { "QA", "katar" },
            { "RE", "riyuniyn" },
            { "RO", "romaniya" },
            { "RS", "serbia" },
            { "RU", "russia" },
            { "RW", "rvanḍa" },
            { "SA", "saūdi arabiya" },
            { "SB", "soloman dīp" },
            { "SC", "siselles" },
            { "SD", "suḍan" },
            { "SE", "sviḍen" },
            { "SG", "singapor" },
            { "SH", "seint helena" },
            { "SI", "slovenia" },
            { "SJ", "svalbard aḍe jan mayen" },
            { "SK", "slovakia" },
            { "SL", "sierra leyon" },
            { "SM", "san marino" },
            { "SN", "senegal" },
            { "SO", "somaliya" },
            { "SR", "surīname" },
            { "SS", "dkiṇ sūdan" },
            { "ST", "sao tom aḍe prinsipe" },
            { "SV", "el salvador" },
            { "SX", "sint mārṭen" },
            { "SY", "sīriya" },
            { "SZ", "esvaṭini" },
            { "TC", "turks aḍe keikes dīp" },
            { "TD", "cad" },
            { "TF", "prēnch dakiṇ teritorī" },
            { "TG", "ṭogo" },
            { "TH", "tailanḍ" },
            { "TJ", "tajākīstān" },
            { "TK", "ṭokelau" },
            { "TL", "ṭimor - leste" },
            { "TM", "turkmenīstān" },
            { "TN", "ṭunisiaa" },
            { "TO", "ṭonga" },
            { "TR", "turkī" },
            { "TT", "ṭriniḍaḍ aḍe ṭobego" },
            { "TV", "tuvala" },
            { "TW", "taivan" },
            { "TZ", "ṭanjaniya" },
            { "UA", "yūkrain" },
            { "UG", "yūganḍa" },
            { "UM", "yu.es. aautlaing dīp" },
            { "US", "yunaiṭeḍ stets" },
            { "UY", "ūrugve" },
            { "UZ", "ūjbekistaan" },
            { "VA", "bāṭikān" },
            { "VC", "seint vinseṇṭ aḍe grenaḍi" },
            { "VE", "venejuela" },
            { "VG", "briṭis vrjin dīp" },
            { "VI", "yu.es. vrjin dīp" },
            { "VN", "viyetnam" },
            { "VU", "vanuaatu" },
            { "WF", "vallis aḍe puṭuna" },
            { "WS", "samoaa" },
            { "XK", "kosovo" },
            { "YE", "yemen" },
            { "YT", "mayoṭṭ" },
            { "ZA", "dkīṇ aaprika" },
            { "ZM", "jambiya" },
            { "ZW", "jimbabve" },
            { "af", "aprikaans" },
            { "am", metaValue_AM },
            { "ar", "arabic" },
            { "as", "aasamis" },
            { "az", "ajerbaijani" },
            { "be", "belarusiati" },
            { "bg", "bulgeriati" },
            { "bn", "bangali" },
            { "bo", "tibetī" },
            { "bs", "bajniati" },
            { "ca", "keṭelan" },
            { "cs", "cek" },
            { "da", "denis" },
            { "de", "jerman" },
            { "el", "grīk" },
            { "en", "ingrajī" },
            { "es", "spenis" },
            { "et", "esṭoniyati" },
            { "eu", "bask" },
            { "fa", "persiati" },
            { "fi", "pinnis" },
            { "fr", metaValue_PF },
            { "gl", "galesiati" },
            { "gu", metaValue_gu },
            { "he", "hibru" },
            { "hr", "kroesiati" },
            { "hu", "hngeriyati" },
            { "hy", "aarmeniati" },
            { "id", "inḍonesiyati" },
            { "is", "aislanḍik" },
            { "it", "iṭaliti" },
            { "ja", "japanij" },
            { "ka", "jorjiati" },
            { "kk", "kjaak" },
            { "km", "kmer" },
            { "kn", metaValue_kn },
            { "ko", "koriati" },
            { "ks", "kasmīrī" },
            { "ky", "kyrgyj" },
            { "lo", "lao" },
            { "lt", "lituaniyati" },
            { "lv", "laṭviati" },
            { "mk", "mesiḍoniyati" },
            { "ml", "malyalam" },
            { "mn", "mongoliyati" },
            { "mr", "maraṭi" },
            { "ms", "malei" },
            { "my", "burmij" },
            { "nb", "norvejiati būkmal" },
            { "ne", "nepaḷī" },
            { "nl", "ḍc" },
            { "or", metaValue_or },
            { "pa", "pnjabī" },
            { "pl", "polis" },
            { "pt", "portugīj" },
            { "ro", "romaniyati" },
            { "ru", "rusiyati" },
            { "sa", "sanskrit" },
            { "sd", "sindi" },
            { "si", "sinhali" },
            { "sk", "slovak" },
            { "sl", "sloveniyati" },
            { "sq", "albaniyati" },
            { "sr", "sarbiyati" },
            { "sv", "sviḍis" },
            { "sw", "svahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "th", "tae" },
            { "tr", "turkis" },
            { "uk", "yukraniyati" },
            { "ur", "urdu" },
            { "uz", "ujbek" },
            { "vi", "vietnaamti" },
            { "zh", "cainati" },
            { "zu", "julu" },
            { "brx", "boḍo" },
            { "chr", metaValue_chr },
            { "doi", "ḍogri" },
            { "fil", "pilipino" },
            { "kok", "konkanī" },
            { "kxv", "kuvi" },
            { "mai", "maitilī" },
            { "mni", "maṇipurī" },
            { "sat", "santalī" },
            { "xnr", "kangri" },
            { "Arab", "aarabic" },
            { "Beng", "bangalī" },
            { "Brah", "brahmi" },
            { "Cher", metaValue_chr },
            { "Cyrl", "sirilik" },
            { "Deva", "devnagrī" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukī" },
            { "Hans", "sahaj" },
            { "Hant", "hirudlu" },
            { "Knda", metaValue_kn },
            { "Latn", "laṭin" },
            { "Mlym", "malayalam" },
            { "Orya", metaValue_or },
            { "Saur", "saurastra" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Zxxx", "raciaahalee" },
            { "Zzzz", "puṇāātiakr" },
            { "de_AT", "ausṭriati jerman" },
            { "de_CH", "svis high jerman" },
            { "en_AU", "ausṭreliati ingarjī" },
            { "en_CA", "kanaḍati ingarjī" },
            { "en_GB", "briṭisti ingrajī" },
            { "en_US", "amerikati ingrajī" },
            { "es_ES", "yuropīyati spenis" },
            { "es_MX", "meksikoti spenis" },
            { "fa_AF", "ḍari" },
            { "fr_CA", "kanaḍati prenc" },
            { "fr_CH", "svis prenc" },
            { "nl_BE", "vlaams" },
            { "pt_BR", "brajilian portugīj" },
            { "pt_PT", "yuropīyati portugīj" },
            { "ro_MD", "molḍaviati" },
            { "sw_CD", "kongo svahili" },
            { "ar_001", "punijuga mānānka arabic" },
            { "es_419", "laṭin americati spenis" },
            { "key.ca", "kelenḍr" },
            { "key.cf", "ṭakã pormat" },
            { "key.co", "mila krm" },
            { "key.cu", "ṭakã" },
            { "key.hc", "veḍiti gila (12 vrses 24)" },
            { "key.lb", "daḍi ḍikihin aaḍa" },
            { "key.ms", "laṭini leka" },
            { "key.nu", "sṅkya" },
            { "hi_Latn", "hindi" },
            { "zh_Hans", "sahaj cainati" },
            { "zh_Hant", "hirudlu cainati" },
            { "type.hc.h11", "12 gṇṭati pddti (0 - 11)" },
            { "type.hc.h12", "12 gṇṭati pddti (1–12)" },
            { "type.hc.h23", "24 gṇṭati pddti (0 - 23)" },
            { "type.hc.h24", "24 gṇṭati pddti (1 - 24)" },
            { "type.nu.arab", "arabic-bartiya nmbr" },
            { "type.nu.beng", "bngalī nmbr" },
            { "type.nu.deva", "devnagrī nmbr" },
            { "type.nu.gujr", "gujraṭī nmbr" },
            { "type.nu.guru", "gurumukī nmbr" },
            { "type.nu.knda", "knnaḍ nmbr" },
            { "type.nu.latn", "veḍa kuṇpu nmbr" },
            { "type.nu.mlym", "malayalam nmbr" },
            { "type.nu.orya", "oḍiya nmbr" },
            { "type.nu.taml", "hirudulu tamiḷ nmbr" },
            { "type.nu.telu", "telugū nmbr" },
            { "type.co.ducet", "ḍepalt yunikoḍ baga lẽ" },
            { "type.nu.roman", "roman nmbr" },
            { "type.ca.indian", "barat jatiya kelenḍr" },
            { "type.co.search", "samani udesya parin" },
            { "type.ms.metric", "meṭrik pddti" },
            { "type.nu.arabext", "nkiaati arabic - bartiya nmbr" },
            { "type.nu.tamldec", "tamiḷ nmbr" },
            { "type.cf.standard", "mānānka takã" },
            { "type.co.standard", "mānānka baga lẽ" },
            { "type.ms.uksystem", "samrajyti aaṭini map pddti" },
            { "type.ms.ussystem", "aamerikati map pddti" },
            { "type.nu.romanlow", "roman mila kase nmbr" },
            { "type.ca.gregorian", "gregoriyan kelenḍr" },
            { "type.co.phonebook", "pnbhi baga lẽ" },
        };
        return data;
    }
}
