/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ta extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "கிரீன்விச் சராசரி நேரம்",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "அக்ரே தர நேரம்",
               "",
               "அக்ரே கோடை நேரம்",
               "",
               "அக்ரே நேரம்",
               "",
            };
        final String[] Apia = new String[] {
               "ஏபியா நிலையான நேரம்",
               "",
               "ஏபியா பகலொளி நேரம்",
               "",
               "ஏபியா நேரம்",
               "",
            };
        final String[] Cook = new String[] {
               "குக் தீவுகள் நிலையான நேரம்",
               "",
               "குக் தீவுகள் அரை கோடை நேரம்",
               "",
               "குக் தீவுகள் நேரம்",
               "",
            };
        final String[] Cuba = new String[] {
               "கியூபா நிலையான நேரம்",
               "CST",
               "கியூபா பகலொளி நேரம்",
               "CDT",
               "கியூபா நேரம்",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ஃபிஜி நிலையான நேரம்",
               "",
               "ஃபிஜி கோடை நேரம்",
               "",
               "ஃபிஜி நேரம்",
               "",
            };
        final String[] Gulf = new String[] {
               "வளைகுடா நிலையான நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ஹோவ்த் நிலையான நேரம்",
               "",
               "ஹோவ்த் கோடை நேரம்",
               "",
               "ஹோவ்த் நேரம்",
               "",
            };
        final String[] Iran = new String[] {
               "ஈரான் நிலையான நேரம்",
               "",
               "ஈரான் பகலொளி நேரம்",
               "",
               "ஈரான் நேரம்",
               "",
            };
        final String[] Niue = new String[] {
               "நியு நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ஓம்ஸ்க் நிலையான நேரம்",
               "",
               "ஓம்ஸ்க் கோடை நேரம்",
               "",
               "ஓம்ஸ்க் நேரம்",
               "",
            };
        final String[] Peru = new String[] {
               "பெரு நிலையான நேரம்",
               "",
               "பெரு கோடை நேரம்",
               "",
               "பெரு நேரம்",
               "",
            };
        final String[] Truk = new String[] {
               "சுக் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "வேக் தீவு நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "சிலி நிலையான நேரம்",
               "",
               "சிலி கோடை நேரம்",
               "",
               "சிலி நேரம்",
               "",
            };
        final String[] China = new String[] {
               "சீன நிலையான நேரம்",
               "CST",
               "சீன பகலொளி நேரம்",
               "CDT",
               "சீன நேரம்",
               "CT",
            };
        final String[] Cocos = new String[] {
               "கோகோஸ் தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "டேவிஸ் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "இந்திய நிலையான நேரம்",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ஜப்பான் நிலையான நேரம்",
               "JST",
               "ஜப்பான் பகலொளி நேரம்",
               "JDT",
               "ஜப்பான் நேரம்",
               "JT",
            };
        final String[] Korea = new String[] {
               "கொரிய நிலையான நேரம்",
               "KST",
               "கொரிய பகலொளி நேரம்",
               "KST",
               "கொரிய நேரம்",
               "KST",
            };
        final String[] Nauru = new String[] {
               "நவ்ரூ நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "நேபாள நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "பாலவ் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "சமோவா நிலையான நேரம்",
               "SST",
               "சமோவா பகலொளி நேரம்",
               "SST",
               "சமோவா நேரம்",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ஸ்யோவா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "டோங்கா நிலையான நேரம்",
               "",
               "டோங்கா கோடை நேரம்",
               "",
               "டோங்கா நேரம்",
               "",
            };
        final String[] Yukon = new String[] {
               "யூகோன் நேரம்",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "அலாஸ்கா நிலையான நேரம்",
               "AKST",
               "அலாஸ்கா பகலொளி நேரம்",
               "AKDT",
               "அலாஸ்கா நேரம்",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "அமேசான் நிலையான நேரம்",
               "",
               "அமேசான் கோடை நேரம்",
               "",
               "அமேசான் நேரம்",
               "",
            };
        final String[] Anadyr = new String[] {
               "அனாடையர் தர நேரம்",
               "",
               "அனாடையர் கோடை நேரம்",
               "",
               "அனடீர் நேரம்",
               "",
            };
        final String[] Azores = new String[] {
               "அசோரஸ் நிலையான நேரம்",
               "",
               "அசோர்ஸ் கோடை நேரம்",
               "",
               "அசோரஸ் நேரம்",
               "",
            };
        final String[] Bhutan = new String[] {
               "பூடான் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "புருனே டருஸ்ஸலாம் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ஈஸ்டர் தீவு நிலையான நேரம்",
               "",
               "ஈஸ்டர் தீவு கோடை நேரம்",
               "",
               "ஈஸ்டர் தீவு நேரம்",
               "",
            };
        final String[] Guyana = new String[] {
               "கயானா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "இஸ்ரேல் நிலையான நேரம்",
               "IST",
               "இஸ்ரேல் பகலொளி நேரம்",
               "IDT",
               "இஸ்ரேல் நேரம்",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "கோஸ்ரே நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "மாசன் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "மாஸ்கோ நிலையான நேரம்",
               "MSK",
               "மாஸ்கோ கோடை நேரம்",
               "MSK",
               "மாஸ்கோ நேரம்",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "போனாபே நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "சமரா தர நேரம்",
               "",
               "சமரா கோடை நேரம்",
               "",
               "சமரா நேரம்",
               "",
            };
        final String[] Tahiti = new String[] {
               "தஹிதி நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "தாய்பே நிலையான நேரம்",
               "CST",
               "தாய்பே பகலொளி நேரம்",
               "CDT",
               "தாய்பே நேரம்",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "துவாலு நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "வோஸ்டோக் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "வாலிஸ் மற்றும் ஃப்யூடுனா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "அரேபிய நிலையான நேரம்",
               "",
               "அரேபிய பகலொளி நேரம்",
               "",
               "அரேபிய நேரம்",
               "",
            };
        final String[] Armenia = new String[] {
               "ஆர்மேனிய நிலையான நேரம்",
               "",
               "ஆர்மேனிய கோடை நேரம்",
               "",
               "ஆர்மேனிய நேரம்",
               "",
            };
        final String[] Bolivia = new String[] {
               "பொலிவியா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "சத்தாம் நிலையான நேரம்",
               "",
               "சத்தாம் பகலொளி நேரம்",
               "",
               "சத்தாம் நேரம்",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ஒருங்கிணைந்த சர்வதேச நேரம்",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ஈக்வடார் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "கேம்பியர் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ஜார்ஜியா நிலையான நேரம்",
               "",
               "ஜார்ஜியா கோடை நேரம்",
               "",
               "ஜார்ஜியா நேரம்",
               "",
            };
        final String[] Irkutsk = new String[] {
               "இர்குட்ஸ்க் நிலையான நேரம்",
               "",
               "இர்குட்ஸ்க் கோடை நேரம்",
               "",
               "இர்குட்ஸ்க் நேரம்",
               "",
            };
        final String[] Magadan = new String[] {
               "மகதன் நிலையான நேரம்",
               "",
               "மகதன் கோடை நேரம்",
               "",
               "மகதன் நேரம்",
               "",
            };
        final String[] Myanmar = new String[] {
               "மியான்மர் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "நார்ஃபோக் தீவு நிலையான நேரம்",
               "",
               "நார்ஃபோக் தீவு பகலொளி நேரம்",
               "",
               "நார்ஃபோக் தீவு நேரம்",
               "",
            };
        final String[] Noronha = new String[] {
               "பெர்னான்டோ டி நோரோன்ஹா நிலையான நேரம்",
               "",
               "பெர்னான்டோ டி நோரோன்ஹா கோடை நேரம்",
               "",
               "பெர்னாண்டோ டி நோரன்ஹா நேரம்",
               "",
            };
        final String[] Reunion = new String[] {
               "ரீயூனியன் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ரோதேரா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "சாலமன் தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "டோக்கெலாவ் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "உருகுவே நிலையான நேரம்",
               "",
               "உருகுவே கோடை நேரம்",
               "",
               "உருகுவே நேரம்",
               "",
            };
        final String[] Vanuatu = new String[] {
               "வனுவாட்டு நிலையான நேரம்",
               "",
               "வனுவாட்டு கோடை நேரம்",
               "",
               "வனுவாட்டு நேரம்",
               "",
            };
        final String[] Yakutsk = new String[] {
               "யகுட்ஸ்க் நிலையான நேரம்",
               "",
               "யகுட்ஸ்க் கோடை நேரம்",
               "",
               "யகுட்ஸ்க் நேரம்",
               "",
            };
        final String[] Atlantic = new String[] {
               "அட்லாண்டிக் நிலையான நேரம்",
               "AST",
               "அட்லாண்டிக் பகலொளி நேரம்",
               "AST",
               "அட்லாண்டிக் நேரம்",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "பிரேசிலியா நிலையான நேரம்",
               "",
               "பிரேசிலியா கோடை நேரம்",
               "",
               "பிரேசிலியா நேரம்",
               "",
            };
        final String[] Chamorro = new String[] {
               "சாமோரோ நிலையான நேரம்",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "கொலம்பியா நிலையான நேரம்",
               "",
               "கொலம்பியா கோடை நேரம்",
               "",
               "கொலம்பியா நேரம்",
               "",
            };
        final String[] Falkland = new String[] {
               "ஃபாக்லாந்து தீவுகள் நிலையான நேரம்",
               "",
               "ஃபாக்லாந்து தீவுகள் கோடை நேரம்",
               "",
               "ஃபாக்லாந்து தீவுகள் நேரம்",
               "",
            };
        final String[] Malaysia = new String[] {
               "மலேஷிய நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "மாலத்தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "உலன் பாடர் நிலையான நேரம்",
               "",
               "உலன் பாடர் கோடை நேரம்",
               "",
               "உலன் பாடர் நேரம்",
               "",
            };
        final String[] Pakistan = new String[] {
               "பாகிஸ்தான் நிலையான நேரம்",
               "PKT",
               "பாகிஸ்தான் கோடை நேரம்",
               "PKST",
               "பாகிஸ்தான் நேரம்",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "பராகுவே நிலையான நேரம்",
               "",
               "பராகுவே கோடை நேரம்",
               "",
               "பராகுவே நேரம்",
               "",
            };
        final String[] Pitcairn = new String[] {
               "பிட்கெய்ர்ன் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "சகலின் நிலையான நேரம்",
               "",
               "சகலின் கோடை நேரம்",
               "",
               "சகலின் நேரம்",
               "",
            };
        final String[] Suriname = new String[] {
               "சுரினாம் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "அர்ஜென்டினா நிலையான நேரம்",
               "",
               "அர்ஜென்டினா கோடை நேரம்",
               "",
               "அர்ஜென்டினா நேரம்",
               "",
            };
        final String[] Christmas = new String[] {
               "கிறிஸ்துமஸ் தீவு நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "கலபகோஸ் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ஹாங்காங் நிலையான நேரம்",
               "HKT",
               "ஹாங்காங் கோடை நேரம்",
               "HKST",
               "ஹாங்காங் நேரம்",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "இந்தோசீன நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "பெட்ரோபவ்லோவ்ஸ்க் கம்சட்ஸ்கி தர நேரம்",
               "",
               "பெட்ரோபவ்லோவ்ஸ்க் கம்சட்ஸ்கி கோடை நேரம்",
               "",
               "பெட்ரோபவ்லோவ்ஸ்க் கம்சட்ஸ்கி நேரம்",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "கிர்கிஸ்தான் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "லார்ட் ஹோவ் நிலையான நேரம்",
               "",
               "லார்ட் ஹோவ் பகலொளி நேரம்",
               "",
               "லார்ட் ஹோவ் நேரம்",
               "",
            };
        final String[] Marquesas = new String[] {
               "மார்கியூசாஸ் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "மொரிஷியஸ் நிலையான நேரம்",
               "",
               "மொரிஷியஸ் கோடை நேரம்",
               "",
               "மொரிஷியஸ் நேரம்",
               "",
            };
        final String[] Singapore = new String[] {
               "சிங்கப்பூர் நிலையான நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "வெனிசுலா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "வோல்கோக்ராட் நிலையான நேரம்",
               "MSK",
               "வோல்கோக்ராட் கோடை நேரம்",
               "MSK",
               "வோல்கோக்ராட் நேரம்",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "அசர்பைஜான் நிலையான நேரம்",
               "",
               "அசர்பைஜான் கோடை நேரம்",
               "",
               "அசர்பைஜான் நேரம்",
               "",
            };
        final String[] Bangladesh = new String[] {
               "வங்கதேச நிலையான நேரம்",
               "",
               "வங்கதேச கோடை நேரம்",
               "",
               "வங்கதேச நேரம்",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "கேப் வெர்டே நிலையான நேரம்",
               "",
               "கேப் வெர்டே கோடை நேரம்",
               "",
               "கேப் வெர்டே நேரம்",
               "",
            };
        final String[] East_Timor = new String[] {
               "கிழக்கு திமோர் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "கஜகஸ்தான் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "சீசெல்ஸ் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "தஜிகிஸ்தான் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "உஸ்பெகிஸ்தான் நிலையான நேரம்",
               "",
               "உஸ்பெகிஸ்தான் கோடை நேரம்",
               "",
               "உஸ்பெகிஸ்தான் நேரம்",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ஆஃப்கானிஸ்தான் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "க்ரஸ்னோயார்ஸ்க் நிலையான நேரம்",
               "",
               "க்ரஸ்னோயார்ஸ்க் கோடை நேரம்",
               "",
               "க்ரஸ்னோயார்ஸ்க் நேரம்",
               "",
            };
        final String[] New_Zealand = new String[] {
               "நியூசிலாந்து நிலையான நேரம்",
               "NZST",
               "நியூசிலாந்து பகலொளி நேரம்",
               "NZDT",
               "நியூசிலாந்து நேரம்",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "நோவோசிபிரிஸ்க் நிலையான நேரம்",
               "",
               "நோவோசிபிரிஸ்க் கோடை நேரம்",
               "",
               "நோவோசிபிரிஸ்க் நேரம்",
               "",
            };
        final String[] Philippines = new String[] {
               "பிலிப்பைன் நிலையான நேரம்",
               "PST",
               "பிலிப்பைன் கோடை நேரம்",
               "PDT",
               "பிலிப்பைன் நேரம்",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "விளாடிவோஸ்டோக் நிலையான நேரம்",
               "",
               "விளாடிவோஸ்டோக் கோடை நேரம்",
               "",
               "விளாடிவோஸ்டோக் நேரம்",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "இந்தியப் பெருங்கடல் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "லைன் தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "நியூஃபவுண்ட்லாந்து நிலையான நேரம்",
               "NST",
               "நியூஃபவுண்ட்லாந்து பகலொளி நேரம்",
               "NDT",
               "நியூஃபவுண்ட்லாந்து நேரம்",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "துர்க்மெனிஸ்தான் நிலையான நேரம்",
               "",
               "துர்க்மெனிஸ்தான் கோடை நேரம்",
               "",
               "துர்க்மெனிஸ்தான் நேரம்",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ஃபிரஞ்சு கயானா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "நியூ கலிடோனியா நிலையான நேரம்",
               "",
               "நியூ கலிடோனியா கோடை நேரம்",
               "",
               "நியூ கலிடோனியா நேரம்",
               "",
            };
        final String[] South_Georgia = new String[] {
               "தெற்கு ஜார்ஜியா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "யேகாடெரின்பர்க் நிலையான நேரம்",
               "",
               "யேகாடெரின்பர்க் கோடை நேரம்",
               "",
               "யேகாடெரின்பர்க் நேரம்",
               "",
            };
        final String[] Africa_Central = new String[] {
               "மத்திய ஆப்பிரிக்க நேரம்",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "கிழக்கு ஆப்பிரிக்க நேரம்",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "மேற்கு ஆப்பிரிக்க நிலையான நேரம்",
               "WAT",
               "மேற்கு ஆப்பிரிக்க கோடை நேரம்",
               "WAT",
               "மேற்கு ஆப்பிரிக்க நேரம்",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "டுமோண்ட்-டி உர்வில்லே நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "மத்திய ஐரோப்பிய நிலையான நேரம்",
               "CET",
               "மத்திய ஐரோப்பிய கோடை நேரம்",
               "CEST",
               "மத்திய ஐரோப்பிய நேரம்",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "கிழக்கத்திய ஐரோப்பிய நிலையான நேரம்",
               "EET",
               "கிழக்கத்திய ஐரோப்பிய கோடை நேரம்",
               "EEST",
               "கிழக்கத்திய ஐரோப்பிய நேரம்",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "மேற்கத்திய ஐரோப்பிய நிலையான நேரம்",
               "WET",
               "மேற்கத்திய ஐரோப்பிய கோடை நேரம்",
               "WEST",
               "மேற்கத்திய ஐரோப்பிய நேரம்",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "மெக்ஸிகன் பசிபிக் நிலையான நேரம்",
               "MST",
               "மெக்ஸிகன் பசிபிக் பகலொளி நேரம்",
               "MDT",
               "மெக்ஸிகன் பசிபிக் நேரம்",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "தென் ஆப்பிரிக்க நிலையான நேரம்",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "மத்திய நிலையான நேரம்",
               "CST",
               "மத்திய பகலொளி நேரம்",
               "CDT",
               "மத்திய நேரம்",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "கிழக்கத்திய நிலையான நேரம்",
               "EST",
               "கிழக்கத்திய பகலொளி நேரம்",
               "EST",
               "கிழக்கத்திய நேரம்",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "பசிபிக் நிலையான நேரம்",
               "PST",
               "பசிபிக் பகலொளி நேரம்",
               "PDT",
               "பசிபிக் நேரம்",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "பிரெஞ்சு தெற்கத்திய & அண்டார்டிக் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "கில்பர்ட் தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ஹவாய்-அலேஷியன் நிலையான நேரம்",
               "HST",
               "ஹவாய்-அலேஷியன் பகலொளி நேரம்",
               "HST",
               "ஹவாய்-அலேஷியன் நேரம்",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "ஃபோனிக்ஸ் தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "செயின்ட் பியரி & மிக்குயிலான் நிலையான நேரம்",
               "",
               "செயின்ட் பியரி & மிக்குயிலான் பகலொளி நேரம்",
               "",
               "செயின்ட் பியரி & மிக்குயிலான் நேரம்",
               "",
            };
        final String[] America_Mountain = new String[] {
               "மவுன்டைன் நிலையான நேரம்",
               "MST",
               "மவுன்டைன் பகலொளி நேரம்",
               "MST",
               "மவுன்டைன் நேரம்",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "மார்ஷல் தீவுகள் நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "பபுவா நியூ கினியா நேரம்",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ஆஸ்திரேலியன் மத்திய நிலையான நேரம்",
               "ACST",
               "ஆஸ்திரேலியன் மத்திய பகலொளி நேரம்",
               "ACDT",
               "மத்திய ஆஸ்திரேலிய நேரம்",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ஆஸ்திரேலியன் கிழக்கத்திய நிலையான நேரம்",
               "AEST",
               "ஆஸ்திரேலியன் கிழக்கத்திய பகலொளி நேரம்",
               "AEDT",
               "கிழக்கத்திய ஆஸ்திரேலிய நேரம்",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ஆஸ்திரேலியன் மேற்கத்திய நிலையான நேரம்",
               "AWST",
               "ஆஸ்திரேலியன் மேற்கத்திய பகலொளி நேரம்",
               "AWDT",
               "மேற்கத்திய ஆஸ்திரேலிய நேரம்",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "மத்திய இந்தோனேசிய நேரம்",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "கிழக்கத்திய இந்தோனேசிய நேரம்",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "மேற்கத்திய இந்தோனேசிய நேரம்",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ஆஸ்திரேலியன் மத்திய மேற்கத்திய நிலையான நேரம்",
               "",
               "ஆஸ்திரேலியன் மத்திய மேற்கத்திய பகலொளி நேரம்",
               "",
               "ஆஸ்திரேலியன் மத்திய மேற்கத்திய நேரம்",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ஒருங்கிணைந்த சர்வதேச நேரம்",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "ஐரிஷ் நிலையான நேரம்",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ஒருங்கிணைந்த சர்வதேச நேரம்",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ஒருங்கிணைந்த சர்வதேச நேரம்",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ஒருங்கிணைந்த சர்வதேச நேரம்",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "ஒருங்கிணைந்த சர்வதேச நேரம்",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ஒருங்கிணைந்த சர்வதேச நேரம்",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "ஐரிஷ் நிலையான நேரம்",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "கிரீன்விச் சராசரி நேரம்",
                    "GMT",
                    "பிரிட்டிஷ் கோடை நேரம்",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ஏடன்" },
            { "timezone.excity.Asia/Baku", "பாக்கூ" },
            { "timezone.excity.Asia/Dili", "டிலி" },
            { "timezone.excity.Asia/Gaza", "காஸா" },
            { "timezone.excity.Asia/Hovd", "ஹோவ்த்" },
            { "timezone.excity.Asia/Omsk", "ஓம்ஸ்க்" },
            { "timezone.excity.Asia/Oral", "ஓரல்" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "அம்மான்" },
            { "timezone.excity.Asia/Aqtau", "அக்தவ்" },
            { "timezone.excity.Asia/Chita", "சிடா" },
            { "timezone.excity.Asia/Dhaka", "டாக்கா" },
            { "timezone.excity.Asia/Dubai", "துபாய்" },
            { "timezone.excity.Asia/Kabul", "காபூல்" },
            { "timezone.excity.Asia/Macau", "மகாவு" },
            { "timezone.excity.Asia/Qatar", "கத்தார்" },
            { "timezone.excity.Asia/Seoul", "சியோல்" },
            { "timezone.excity.Asia/Tokyo", "டோக்கியோ" },
            { "timezone.excity.Asia/Tomsk", "டாம்ஸ்க்" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ஜுபா" },
            { "timezone.excity.Africa/Lome", "லோம்" },
            { "timezone.excity.Asia/Almaty", "அல்மாதி" },
            { "timezone.excity.Asia/Anadyr", "அனடீர்" },
            { "timezone.excity.Asia/Aqtobe", "அக்டோப்" },
            { "timezone.excity.Asia/Atyrau", "அடிரா" },
            { "timezone.excity.Asia/Beirut", "பெய்ரூட்" },
            { "timezone.excity.Asia/Brunei", "புருனே" },
            { "timezone.excity.Asia/Hebron", "ஹெப்ரான்" },
            { "timezone.excity.Asia/Kuwait", "குவைத்" },
            { "timezone.excity.Asia/Manila", "மணிலா" },
            { "timezone.excity.Asia/Muscat", "மஸ்கட்" },
            { "timezone.excity.Asia/Riyadh", "ரியாத்" },
            { "timezone.excity.Asia/Saigon", "ஹோ சி மின் சிட்டி" },
            { "timezone.excity.Asia/Taipei", "தாய்பே" },
            { "timezone.excity.Asia/Tehran", "டெஹ்ரான்" },
            { "timezone.excity.Asia/Urumqi", "உரும்கி" },
            { "timezone.excity.Etc/Unknown", "தெரியாத நகரம்" },
            { "timezone.excity.Europe/Kiev", "கீவ்" },
            { "timezone.excity.Europe/Oslo", "ஓஸ்லோ" },
            { "timezone.excity.Europe/Riga", "ரிகா" },
            { "timezone.excity.Europe/Rome", "ரோம்" },
            { "timezone.excity.Indian/Mahe", "மாஹே" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "அக்ரா" },
            { "timezone.excity.Africa/Cairo", "கெய்ரோ" },
            { "timezone.excity.Africa/Ceuta", "சியூட்டா" },
            { "timezone.excity.Africa/Dakar", "டாகர்" },
            { "timezone.excity.Africa/Lagos", "லாகோஸ்" },
            { "timezone.excity.Africa/Tunis", "டுனிஸ்" },
            { "timezone.excity.America/Adak", "அடக்" },
            { "timezone.excity.America/Lima", "லிமா" },
            { "timezone.excity.America/Nome", "நோம்" },
            { "timezone.excity.Asia/Baghdad", "பாக்தாத்" },
            { "timezone.excity.Asia/Bahrain", "பஹ்ரைன்" },
            { "timezone.excity.Asia/Bangkok", "பாங்காக்" },
            { "timezone.excity.Asia/Barnaul", "பார்னால்" },
            { "timezone.excity.Asia/Bishkek", "பிஷ்கெக்" },
            { "timezone.excity.Asia/Colombo", "கொழும்பு" },
            { "timezone.excity.Asia/Irkutsk", "இர்குட்ஸ்க்" },
            { "timezone.excity.Asia/Jakarta", "ஜகார்த்தா" },
            { "timezone.excity.Asia/Karachi", "கராச்சி" },
            { "timezone.excity.Asia/Kuching", "குசிங்" },
            { "timezone.excity.Asia/Magadan", "மகதன்" },
            { "timezone.excity.Asia/Nicosia", "நிகோசியா" },
            { "timezone.excity.Asia/Rangoon", "ரங்கூன்" },
            { "timezone.excity.Asia/Tbilisi", "த்பிலிசி" },
            { "timezone.excity.Asia/Thimphu", "திம்பு" },
            { "timezone.excity.Asia/Yakutsk", "யகுட்ஸ்க்" },
            { "timezone.excity.Asia/Yerevan", "ஏரேவன்" },
            { "timezone.excity.Europe/Kirov", "கிரோவ்" },
            { "timezone.excity.Europe/Malta", "மால்டா" },
            { "timezone.excity.Europe/Minsk", "மின்ஸ்க்" },
            { "timezone.excity.Europe/Paris", "பாரீஸ்" },
            { "timezone.excity.Europe/Sofia", "சோஃபியா" },
            { "timezone.excity.Europe/Vaduz", "வதுஸ்" },
            { "timezone.excity.Indian/Cocos", "கோகோஸ்" },
            { "timezone.excity.Pacific/Apia", "அபியா" },
            { "timezone.excity.Pacific/Fiji", "ஃபிஜி" },
            { "timezone.excity.Pacific/Guam", "குவாம்" },
            { "timezone.excity.Pacific/Niue", "நியு" },
            { "timezone.excity.Pacific/Truk", "சுக்" },
            { "timezone.excity.Pacific/Wake", "வேக்" },
            { "timezone.excity.Africa/Asmera", "அஸ்மாரா" },
            { "timezone.excity.Africa/Bamako", "பமாகோ" },
            { "timezone.excity.Africa/Bangui", "பாங்குயீ" },
            { "timezone.excity.Africa/Banjul", "பஞ்சுல்" },
            { "timezone.excity.Africa/Bissau", "பிஸாவ்" },
            { "timezone.excity.Africa/Douala", "தவுலா" },
            { "timezone.excity.Africa/Harare", "ஹராரே" },
            { "timezone.excity.Africa/Kigali", "கிகலி" },
            { "timezone.excity.Africa/Luanda", "லுவான்டா" },
            { "timezone.excity.Africa/Lusaka", "லுசாகா" },
            { "timezone.excity.Africa/Malabo", "மாலபோ" },
            { "timezone.excity.Africa/Maputo", "மபுடோ" },
            { "timezone.excity.Africa/Maseru", "மசேரு" },
            { "timezone.excity.Africa/Niamey", "நியாமே" },
            { "timezone.excity.America/Aruba", "அரூபா" },
            { "timezone.excity.America/Bahia", "பாஹியா" },
            { "timezone.excity.America/Belem", "பெலெம்" },
            { "timezone.excity.America/Boise", "போய்ஸ்" },
            { "timezone.excity.America/Jujuy", "ஜூஜுய்" },
            { "timezone.excity.America/Sitka", "சிட்கா" },
            { "timezone.excity.America/Thule", "துலே" },
            { "timezone.excity.Asia/Ashgabat", "அஷ்காபாத்" },
            { "timezone.excity.Asia/Calcutta", "கொல்கத்தா" },
            { "timezone.excity.Asia/Damascus", "டமாஸ்கஸ்" },
            { "timezone.excity.Asia/Dushanbe", "துஷன்பே" },
            { "timezone.excity.Asia/Jayapura", "ஜெயபூரா" },
            { "timezone.excity.Asia/Katmandu", "காத்மாண்டு" },
            { "timezone.excity.Asia/Khandyga", "கான்டிகா" },
            { "timezone.excity.Asia/Makassar", "மக்கஸர்" },
            { "timezone.excity.Asia/Qostanay", "கோஸ்டானே" },
            { "timezone.excity.Asia/Sakhalin", "சகலின்" },
            { "timezone.excity.Asia/Shanghai", "ஷாங்காய்" },
            { "timezone.excity.Asia/Tashkent", "தாஷ்கண்ட்" },
            { "timezone.excity.Asia/Ust-Nera", "உஸ்ட்-நேரா" },
            { "timezone.excity.Europe/Athens", "ஏதன்ஸ்" },
            { "timezone.excity.Europe/Berlin", "பெர்லின்" },
            { "timezone.excity.Europe/Dublin", "டப்ளின்" },
            { "timezone.excity.Europe/Jersey", "ஜெர்சி" },
            { "timezone.excity.Europe/Lisbon", "லிஸ்பன்" },
            { "timezone.excity.Europe/London", "லண்டன்" },
            { "timezone.excity.Europe/Madrid", "மேட்ரிட்" },
            { "timezone.excity.Europe/Monaco", "மொனாக்கோ" },
            { "timezone.excity.Europe/Moscow", "மாஸ்கோ" },
            { "timezone.excity.Europe/Prague", "ப்ராக்" },
            { "timezone.excity.Europe/Samara", "சமாரா" },
            { "timezone.excity.Europe/Skopje", "ஸ்கோப்ஜே" },
            { "timezone.excity.Europe/Tirane", "திரானே" },
            { "timezone.excity.Europe/Vienna", "வியன்னா" },
            { "timezone.excity.Europe/Warsaw", "வார்ஸா" },
            { "timezone.excity.Europe/Zagreb", "ஸக்ரெப்" },
            { "timezone.excity.Europe/Zurich", "ஜூரிச்" },
            { "timezone.excity.Indian/Chagos", "சாகோஸ்" },
            { "timezone.excity.Indian/Comoro", "கொமரோ" },
            { "timezone.excity.Pacific/Efate", "ஈஃபேட்" },
            { "timezone.excity.Pacific/Nauru", "நவ்ரூ" },
            { "timezone.excity.Pacific/Palau", "பாலவ்" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "அபிட்ஜான்" },
            { "timezone.excity.Africa/Algiers", "அல்ஜியர்ஸ்" },
            { "timezone.excity.Africa/Conakry", "கோனக்ரே" },
            { "timezone.excity.Africa/Kampala", "கம்பாலா" },
            { "timezone.excity.Africa/Mbabane", "பபான்" },
            { "timezone.excity.Africa/Nairobi", "நைரோபி" },
            { "timezone.excity.Africa/Tripoli", "த்ரிபோலி" },
            { "timezone.excity.America/Belize", "பெலிஸ்" },
            { "timezone.excity.America/Bogota", "போகோடா" },
            { "timezone.excity.America/Cancun", "கன்குன்" },
            { "timezone.excity.America/Cayman", "கேமன்" },
            { "timezone.excity.America/Cuiaba", "குயாபே" },
            { "timezone.excity.America/Dawson", "டாவ்சன்" },
            { "timezone.excity.America/Denver", "டென்வர்" },
            { "timezone.excity.America/Guyana", "கயானா" },
            { "timezone.excity.America/Havana", "ஹவானா" },
            { "timezone.excity.America/Inuvik", "இனுவிக்" },
            { "timezone.excity.America/Juneau", "ஜுனியூ" },
            { "timezone.excity.America/La_Paz", "லா பாஸ்" },
            { "timezone.excity.America/Maceio", "மேசியோ" },
            { "timezone.excity.America/Manaus", "மனாஸ்" },
            { "timezone.excity.America/Merida", "மெரிடா" },
            { "timezone.excity.America/Nassau", "நசவ்" },
            { "timezone.excity.America/Panama", "பனாமா" },
            { "timezone.excity.America/Recife", "ரெஸிஃபி" },
            { "timezone.excity.America/Regina", "ரெஜினா" },
            { "timezone.excity.Asia/Famagusta", "ஃபாமகுஸ்டா" },
            { "timezone.excity.Asia/Hong_Kong", "ஹாங்காங்" },
            { "timezone.excity.Asia/Jerusalem", "ஜெருசலேம்" },
            { "timezone.excity.Asia/Kamchatka", "காம்சட்கா" },
            { "timezone.excity.Asia/Pontianak", "போன்டியானாக்" },
            { "timezone.excity.Asia/Pyongyang", "பியாங்யாங்" },
            { "timezone.excity.Asia/Qyzylorda", "கிஸிலோர்டா" },
            { "timezone.excity.Asia/Samarkand", "சமார்கண்ட்" },
            { "timezone.excity.Asia/Singapore", "சிங்கப்பூர்" },
            { "timezone.excity.Asia/Vientiane", "வியன்டியன்" },
            { "timezone.excity.Europe/Andorra", "அண்டோரா" },
            { "timezone.excity.Europe/Saratov", "சரடோவ்" },
            { "timezone.excity.Europe/Tallinn", "டலின்" },
            { "timezone.excity.Europe/Vatican", "வாடிகன்" },
            { "timezone.excity.Europe/Vilnius", "வில்னியஸ்" },
            { "timezone.excity.Indian/Mayotte", "மயோட்டி" },
            { "timezone.excity.Indian/Reunion", "ரீயூனியன்" },
            { "timezone.excity.Pacific/Easter", "ஈஸ்டர்" },
            { "timezone.excity.Pacific/Kanton", "கேன்டன்" },
            { "timezone.excity.Pacific/Kosrae", "கோஸ்ரே" },
            { "timezone.excity.Pacific/Majuro", "மஜுரோ" },
            { "timezone.excity.Pacific/Midway", "மிட்வே" },
            { "timezone.excity.Pacific/Noumea", "நோவுமியா" },
            { "timezone.excity.Pacific/Ponape", "ஃபோன்பெய்" },
            { "timezone.excity.Pacific/Saipan", "சைபன்" },
            { "timezone.excity.Pacific/Tahiti", "தஹிதி" },
            { "timezone.excity.Pacific/Tarawa", "தராவா" },
            { "timezone.excity.Pacific/Wallis", "வாலிஸ்" },
            { "timezone.excity.Africa/Blantyre", "பிளான்டையர்" },
            { "timezone.excity.Africa/Djibouti", "ஜிபௌட்டி" },
            { "timezone.excity.Africa/El_Aaiun", "எல் ஆயுன்" },
            { "timezone.excity.Africa/Freetown", "ஃப்ரீடவுன்" },
            { "timezone.excity.Africa/Gaborone", "கபோரோன்" },
            { "timezone.excity.Africa/Khartoum", "கார்டோம்" },
            { "timezone.excity.Africa/Kinshasa", "கின்ஷசா" },
            { "timezone.excity.Africa/Monrovia", "மான்ரோவியா" },
            { "timezone.excity.Africa/Ndjamena", "ஜமேனா" },
            { "timezone.excity.Africa/Sao_Tome", "சாவோ டோமே" },
            { "timezone.excity.Africa/Windhoek", "வைண்ட்ஹோக்" },
            { "timezone.excity.America/Antigua", "ஆன்டிகுவா" },
            { "timezone.excity.America/Caracas", "கரகாஸ்" },
            { "timezone.excity.America/Cayenne", "கெய்ன்" },
            { "timezone.excity.America/Chicago", "சிகாகோ" },
            { "timezone.excity.America/Cordoba", "கார்டோபா" },
            { "timezone.excity.America/Creston", "க்ரெஸ்டான்" },
            { "timezone.excity.America/Curacao", "க்யூராகோ" },
            { "timezone.excity.America/Detroit", "டெட்ராய்ட்" },
            { "timezone.excity.America/Godthab", "நூக்" },
            { "timezone.excity.America/Grenada", "கிரனடா" },
            { "timezone.excity.America/Halifax", "ஹலிஃபேக்ஸ்" },
            { "timezone.excity.America/Iqaluit", "இகாலூயித்" },
            { "timezone.excity.America/Jamaica", "ஜமைக்கா" },
            { "timezone.excity.America/Managua", "மானாகுவா" },
            { "timezone.excity.America/Marigot", "மாரிகாட்" },
            { "timezone.excity.America/Mendoza", "மென்டோஸா" },
            { "timezone.excity.America/Moncton", "மாங்டான்" },
            { "timezone.excity.America/Noronha", "நோரன்ஹா" },
            { "timezone.excity.America/Ojinaga", "ஒஜினகா" },
            { "timezone.excity.America/Phoenix", "ஃபோனிக்ஸ்" },
            { "timezone.excity.America/Tijuana", "டிஜுவானா" },
            { "timezone.excity.America/Toronto", "டொரொன்டோ" },
            { "timezone.excity.America/Tortola", "டோர்டோலா" },
            { "timezone.excity.America/Yakutat", "யகுடட்" },
            { "timezone.excity.Asia/Phnom_Penh", "ஃப்னோம் பென்" },
            { "timezone.excity.Atlantic/Azores", "அசோரஸ்" },
            { "timezone.excity.Atlantic/Canary", "கேனரி" },
            { "timezone.excity.Atlantic/Faeroe", "ஃபரோ" },
            { "timezone.excity.Australia/Eucla", "யூக்லா" },
            { "timezone.excity.Australia/Perth", "பெர்த்" },
            { "timezone.excity.Europe/Belgrade", "பெல்கிரேட்" },
            { "timezone.excity.Europe/Brussels", "புரூசல்ஸ்" },
            { "timezone.excity.Europe/Budapest", "புடாபெஸ்ட்" },
            { "timezone.excity.Europe/Busingen", "பசிங்ஜென்" },
            { "timezone.excity.Europe/Chisinau", "சிசினவ்" },
            { "timezone.excity.Europe/Guernsey", "கர்னஸே" },
            { "timezone.excity.Europe/Helsinki", "ஹெல்சிங்கி" },
            { "timezone.excity.Europe/Istanbul", "இஸ்தான்புல்" },
            { "timezone.excity.Europe/Sarajevo", "சரயேவோ" },
            { "timezone.excity.Indian/Maldives", "மாலத்தீவுகள்" },
            { "timezone.excity.Pacific/Chatham", "சத்தாம்" },
            { "timezone.excity.Pacific/Fakaofo", "ஃபகாஃபோ" },
            { "timezone.excity.Pacific/Gambier", "கேம்பியர்" },
            { "timezone.excity.Pacific/Norfolk", "நார்ஃபோக்" },
            { "timezone.excity.Africa/Bujumbura", "புஜும்புரா" },
            { "timezone.excity.Africa/Mogadishu", "மொகாதிஷு" },
            { "timezone.excity.America/Anguilla", "அங்குயுலா" },
            { "timezone.excity.America/Asuncion", "அஸன்சியன்" },
            { "timezone.excity.America/Barbados", "பார்படாஸ்" },
            { "timezone.excity.America/Dominica", "டொமினிகா" },
            { "timezone.excity.America/Edmonton", "எட்மான்டான்" },
            { "timezone.excity.America/Eirunepe", "ஈருனெபே" },
            { "timezone.excity.America/Mazatlan", "மஸட்லன்" },
            { "timezone.excity.America/Miquelon", "மிக்யூலன்" },
            { "timezone.excity.America/New_York", "நியூயார்க்" },
            { "timezone.excity.America/Resolute", "ரெசலூட்" },
            { "timezone.excity.America/Santarem", "சான்டரெம்" },
            { "timezone.excity.America/Santiago", "சாண்டியாகோ" },
            { "timezone.excity.America/St_Johns", "செயின்ட் ஜான்ஸ்" },
            { "timezone.excity.America/St_Kitts", "செயின்ட் கீட்ஸ்" },
            { "timezone.excity.America/St_Lucia", "செயின்ட் லூசியா" },
            { "timezone.excity.America/Winnipeg", "வின்னிபெக்" },
            { "timezone.excity.Antarctica/Casey", "கேஸி" },
            { "timezone.excity.Antarctica/Davis", "டேவிஸ்" },
            { "timezone.excity.Antarctica/Syowa", "ஸ்யோவா" },
            { "timezone.excity.Antarctica/Troll", "ட்ரோல்" },
            { "timezone.excity.Asia/Krasnoyarsk", "கிராஸ்னோயார்க்ஸ்" },
            { "timezone.excity.Asia/Novosibirsk", "நோவோசீபிர்ஸ்க்" },
            { "timezone.excity.Asia/Ulaanbaatar", "உலான்பாட்டர்" },
            { "timezone.excity.Asia/Vladivostok", "விளாடிவொஸ்தோக்" },
            { "timezone.excity.Atlantic/Bermuda", "பெர்முடா" },
            { "timezone.excity.Atlantic/Madeira", "மடிரா" },
            { "timezone.excity.Atlantic/Stanley", "ஸ்டேன்லி" },
            { "timezone.excity.Australia/Darwin", "டார்வின்" },
            { "timezone.excity.Australia/Hobart", "ஹோபர்ட்" },
            { "timezone.excity.Australia/Sydney", "சிட்னி" },
            { "timezone.excity.Europe/Amsterdam", "ஆம்ஸ்ட்ரடாம்" },
            { "timezone.excity.Europe/Astrakhan", "அஸ்ட்ராகான்" },
            { "timezone.excity.Europe/Bucharest", "புசாரெஸ்ட்" },
            { "timezone.excity.Europe/Gibraltar", "ஜிப்ரால்டர்" },
            { "timezone.excity.Europe/Ljubljana", "ஜுப்லானா" },
            { "timezone.excity.Europe/Mariehamn", "மரிஹம்" },
            { "timezone.excity.Europe/Podgorica", "போட்கோரிகா" },
            { "timezone.excity.Europe/Stockholm", "ஸ்டாக்ஹோம்" },
            { "timezone.excity.Europe/Ulyanovsk", "உல்யானோஸ்க்" },
            { "timezone.excity.Europe/Volgograd", "வோல்கோகிராட்" },
            { "timezone.excity.Indian/Christmas", "கிறிஸ்துமஸ்" },
            { "timezone.excity.Indian/Kerguelen", "கெர்யூலென்" },
            { "timezone.excity.Indian/Mauritius", "மொரிஷியஸ்" },
            { "timezone.excity.Pacific/Auckland", "ஆக்லாந்து" },
            { "timezone.excity.Pacific/Funafuti", "ஃபுனாஃபுடி" },
            { "timezone.excity.Pacific/Honolulu", "ஹோனோலூலூ" },
            { "timezone.excity.Pacific/Pitcairn", "பிட்கெய்ர்ன்" },
            { "timezone.excity.Africa/Casablanca", "காஸாபிளான்கா" },
            { "timezone.excity.Africa/Libreville", "லிப்ரேவில்லே" },
            { "timezone.excity.Africa/Lubumbashi", "லுபும்பாஷி" },
            { "timezone.excity.Africa/Nouakchott", "நோவாக்சோட்" },
            { "timezone.excity.Africa/Porto-Novo", "போர்ட்டோ-நோவோ" },
            { "timezone.excity.America/Anchorage", "அங்கோரேஜ்" },
            { "timezone.excity.America/Araguaina", "அரகுவாய்னா" },
            { "timezone.excity.America/Boa_Vista", "போவா விஸ்டா" },
            { "timezone.excity.America/Catamarca", "கடமார்கா" },
            { "timezone.excity.America/Chihuahua", "சுவாவா" },
            { "timezone.excity.America/Fortaleza", "ஃபோர்டாலெசா" },
            { "timezone.excity.America/Glace_Bay", "கிலேஸ் வளைகுடா" },
            { "timezone.excity.America/Goose_Bay", "கூஸ் பே" },
            { "timezone.excity.America/Guatemala", "கவுதமாலா" },
            { "timezone.excity.America/Guayaquil", "குவாயகில்" },
            { "timezone.excity.America/Matamoros", "மடமோராஸ்" },
            { "timezone.excity.America/Menominee", "மெனோமினி" },
            { "timezone.excity.America/Monterrey", "மான்டெர்ரே" },
            { "timezone.excity.America/Sao_Paulo", "சாவோ பவுலோ" },
            { "timezone.excity.America/St_Thomas", "செயின்ட் தாமஸ்" },
            { "timezone.excity.America/Vancouver", "வான்கூவர்" },
            { "timezone.excity.Antarctica/Mawson", "மாசன்" },
            { "timezone.excity.Antarctica/Palmer", "பால்மர்" },
            { "timezone.excity.Antarctica/Vostok", "வோஸ்டோக்" },
            { "timezone.excity.Asia/Kuala_Lumpur", "கோலாலம்பூர்" },
            { "timezone.excity.Asia/Novokuznetsk", "நோவோகுஸ்நெட்ஸ்க்" },
            { "timezone.excity.Europe/Bratislava", "பிரடிஸ்லாவா" },
            { "timezone.excity.Europe/Copenhagen", "கோபன்ஹேகன்" },
            { "timezone.excity.Europe/Luxembourg", "லக்சம்பர்க்" },
            { "timezone.excity.Europe/San_Marino", "சான் மரினோ" },
            { "timezone.excity.Europe/Simferopol", "சிம்ஃபெரோபோல்" },
            { "timezone.excity.Pacific/Enderbury", "எண்டர்பரி" },
            { "timezone.excity.Pacific/Galapagos", "கலபகோஸ்" },
            { "timezone.excity.Pacific/Kwajalein", "க்வாஜாலீயன்" },
            { "timezone.excity.Pacific/Marquesas", "மார்கியூசாஸ்" },
            { "timezone.excity.Pacific/Pago_Pago", "பேகோ பேகோ" },
            { "timezone.excity.Pacific/Rarotonga", "ரரோடோங்கா" },
            { "timezone.excity.Pacific/Tongatapu", "டோன்கடப்பு" },
            { "timezone.excity.Africa/Addis_Ababa", "அடிஸ் அபாபா" },
            { "timezone.excity.Africa/Brazzaville", "பிராஸாவில்லி" },
            { "timezone.excity.Africa/Ouagadougou", "அவுகடவ்கு" },
            { "timezone.excity.America/Costa_Rica", "கோஸ்டா ரிகா" },
            { "timezone.excity.America/Grand_Turk", "கிராண்ட் டர்க்" },
            { "timezone.excity.America/Guadeloupe", "கவுடேலூப்" },
            { "timezone.excity.America/Hermosillo", "ஹெர்மோசிலோ" },
            { "timezone.excity.America/Kralendijk", "கிரெலன்டிஜ்" },
            { "timezone.excity.America/Louisville", "லூயிஸ்வில்லே" },
            { "timezone.excity.America/Martinique", "மார்ட்டினிக்" },
            { "timezone.excity.America/Metlakatla", "மெட்லகட்லா" },
            { "timezone.excity.America/Montevideo", "மான்டேவீடியோ" },
            { "timezone.excity.America/Montserrat", "மான்செரேட்" },
            { "timezone.excity.America/Paramaribo", "பரமரிபோ" },
            { "timezone.excity.America/Rio_Branco", "ரியோ பிரான்கோ" },
            { "timezone.excity.America/St_Vincent", "செயின்ட் வின்சென்ட்" },
            { "timezone.excity.America/Whitehorse", "வொயிட்ஹார்ஸ்" },
            { "timezone.excity.Antarctica/McMurdo", "மெக்மர்டோ" },
            { "timezone.excity.Antarctica/Rothera", "ரோதேரா" },
            { "timezone.excity.Asia/Srednekolymsk", "ஸ்ரெட்நிகோலிம்ஸ்க்" },
            { "timezone.excity.Asia/Yekaterinburg", "யெகாடிரின்பர்க்" },
            { "timezone.excity.Atlantic/Reykjavik", "ரேக்ஜாவிக்" },
            { "timezone.excity.Atlantic/St_Helena", "செயின்ட் ஹெலெனா" },
            { "timezone.excity.Australia/Adelaide", "அடிலெய்ட்" },
            { "timezone.excity.Australia/Brisbane", "பிரிஸ்பேன்" },
            { "timezone.excity.Australia/Lindeman", "லின்டெமன்" },
            { "timezone.excity.Europe/Isle_of_Man", "ஐல் ஆஃப் மேன்" },
            { "timezone.excity.Europe/Kaliningrad", "கலினின்கிராட்" },
            { "timezone.excity.Pacific/Kiritimati", "கிரிடிமாட்டி" },
            { "timezone.excity.Africa/Johannesburg", "ஜோஹன்னஸ்பெர்க்" },
            { "timezone.excity.America/El_Salvador", "எல் சால்வடோர்" },
            { "timezone.excity.America/Fort_Nelson", "ஃபோர்ட் நெல்சன்" },
            { "timezone.excity.America/Los_Angeles", "லாஸ் ஏஞ்சல்ஸ்" },
            { "timezone.excity.America/Mexico_City", "மெக்ஸிகோ நகரம்" },
            { "timezone.excity.America/Porto_Velho", "போர்ட்டோ வெல்ஹோ" },
            { "timezone.excity.America/Puerto_Rico", "பியூர்டோ ரிகோ" },
            { "timezone.excity.America/Tegucigalpa", "தெகுசிகல்பா" },
            { "timezone.excity.Arctic/Longyearbyen", "லாங்இயர்பியன்" },
            { "timezone.excity.Atlantic/Cape_Verde", "கேப் வெர்டே" },
            { "timezone.excity.Australia/Lord_Howe", "லார்ட் ஹோவே" },
            { "timezone.excity.Australia/Melbourne", "மெல்போர்ன்" },
            { "timezone.excity.Indian/Antananarivo", "ஆண்டனநரிவோ" },
            { "timezone.excity.Pacific/Guadalcanal", "க்வாடால்கேனல்" },
            { "timezone.excity.Africa/Dar_es_Salaam", "தார் எஸ் சலாம்" },
            { "timezone.excity.America/Blanc-Sablon", "ப்லாங்க்-சப்லான்" },
            { "timezone.excity.America/Buenos_Aires", "ப்யூனோஸ் ஏர்ஸ்" },
            { "timezone.excity.America/Campo_Grande", "கேம்போ கிராண்டே" },
            { "timezone.excity.America/Danmarkshavn", "டென்மார்க்ஷாவ்ன்" },
            { "timezone.excity.America/Dawson_Creek", "டாவ்சன் கிரீக்" },
            { "timezone.excity.America/Indiana/Knox", "நாக்ஸ், இண்டியானா" },
            { "timezone.excity.America/Indianapolis", "இண்டியானாபொலிஸ்" },
            { "timezone.excity.America/Punta_Arenas", "புன்டா அரீனாஸ்" },
            { "timezone.excity.America/Rankin_Inlet", "ரான்கின் இன்லெட்" },
            { "timezone.excity.America/Scoresbysund", "இடோகோர்டோர்மிட்" },
            { "timezone.excity.Antarctica/Macquarie", "மாக்கியூரி" },
            { "timezone.excity.Pacific/Bougainville", "போகெய்ன்வில்லே" },
            { "timezone.excity.Pacific/Port_Moresby", "போர்ட் மோர்ஸ்பை" },
            { "timezone.excity.America/Cambridge_Bay", "கேம்பிரிட்ஜ் வளைகுடா" },
            { "timezone.excity.America/Ciudad_Juarez", "சியுடாட் வாரஸ்" },
            { "timezone.excity.America/Coral_Harbour", "அடிகோகன்" },
            { "timezone.excity.America/Indiana/Vevay", "வேவே, இண்டியானா" },
            { "timezone.excity.America/Lower_Princes", "லோயர் பிரின்ஸஸ் குவார்ட்டர்" },
            { "timezone.excity.America/Port_of_Spain", "போர்ட் ஆஃப் ஸ்பெயின்" },
            { "timezone.excity.America/Santo_Domingo", "சாண்டோ டோமிங்கோ" },
            { "timezone.excity.America/St_Barthelemy", "செயின்ட் பார்தேலெமி" },
            { "timezone.excity.America/Swift_Current", "ஸ்விஃப்ட் கரண்ட்" },
            { "timezone.excity.Australia/Broken_Hill", "புரோக்கன் ஹில்" },
            { "timezone.excity.America/Bahia_Banderas", "பஹியா பந்தேராஸ்" },
            { "timezone.excity.America/Port-au-Prince", "போர்ட்-அவ்-பிரின்ஸ்" },
            { "timezone.excity.Atlantic/South_Georgia", "தெற்கு ஜார்ஜியா" },
            { "timezone.excity.America/Argentina/Salta", "சால்டா" },
            { "timezone.excity.America/Indiana/Marengo", "மரென்கோ, இண்டியானா" },
            { "timezone.excity.America/Indiana/Winamac", "வினாமேக், இண்டியானா" },
            { "timezone.excity.America/Argentina/Tucuman", "டுகுமன்" },
            { "timezone.excity.America/Argentina/Ushuaia", "உஷுவாயா" },
            { "timezone.excity.America/Indiana/Tell_City", "டெல் சிட்டி, இண்டியானா" },
            { "timezone.excity.America/Indiana/Vincennes", "வின்செனேஸ், இண்டியானா" },
            { "timezone.excity.Antarctica/DumontDUrville", "டுமோண்ட்-டி உர்வில்லே" },
            { "timezone.excity.America/Argentina/La_Rioja", "லா ரியோஜா" },
            { "timezone.excity.America/Argentina/San_Juan", "சான் ஜுவான்" },
            { "timezone.excity.America/Argentina/San_Luis", "சான் லூயிஸ்" },
            { "timezone.excity.America/Indiana/Petersburg", "பீட்டர்ஸ்பெர்க், இண்டியானா" },
            { "timezone.excity.America/Kentucky/Monticello", "மான்டிசெல்லோ, கென்டகி" },
            { "timezone.excity.America/North_Dakota/Beulah", "பெவுலா, வடக்கு டகோட்டா" },
            { "timezone.excity.America/North_Dakota/Center", "சென்டர், வடக்கு டகோடா" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ரியோ கேலெகோஸ்" },
            { "timezone.excity.America/North_Dakota/New_Salem", "நியூ சலேம், வடக்கு டகோடா" },
        };
        return data;
    }
}
