/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ccp extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "𑄚𑄃𑄪𑄢𑄪";
        final String metaValue_TK = "𑄑𑄮𑄇𑄬𑄣𑄃𑄪";
        final String metaValue_TV = "𑄑𑄪𑄞𑄣𑄪";
        final String metaValue_bn = "𑄝𑄁𑄣";
        final String metaValue_ka = "𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴";
        final String metaValue_el = "𑄉𑄳𑄢𑄨𑄇𑄴";
        final String metaValue_he = "𑄦𑄨𑄛𑄴𑄝𑄳𑄢𑄪";
        final String metaValue_jv = "𑄎𑄞𑄚𑄨𑄎𑄴";
        final String metaValue_ko = "𑄇𑄮𑄢𑄨𑄠𑄚𑄴";
        final String metaValue_lo = "𑄣𑄃𑄮";
        final String metaValue_ml = "𑄟𑄣𑄠𑄣𑄟𑄴";
        final String metaValue_or = "𑄃𑄮𑄢𑄨𑄠";
        final String metaValue_syr = "𑄥𑄨𑄢𑄨𑄠𑄇𑄴";
        final String metaValue_ta = "𑄖𑄟𑄨𑄣𑄴";
        final String metaValue_te = "𑄖𑄬𑄣𑄬𑄉𑄪";
        final String metaValue_th = "𑄗𑄭";
        final String metaValue_bo = "𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨";
        final String metaValue_vai = "𑄞𑄭";
        final String metaValue_peo = "𑄛𑄪𑄢𑄮𑄚𑄴 𑄜𑄢𑄴𑄥𑄨";
        final Object[][] data = new Object[][] {
            { "001", "𑄛𑄨𑄖𑄴𑄗𑄨𑄟𑄨" },
            { "002", "𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "003", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇" },
            { "005", "𑄘𑄨𑄉𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇" },
            { "009", "𑄃𑄮𑄥𑄨𑄠𑄚𑄨𑄠" },
            { "011", "𑄛𑄧𑄏𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "013", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "014", "𑄛𑄪𑄇𑄴𑄘𑄩 𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "015", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "017", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "019", "𑄃𑄟𑄬𑄢𑄨𑄇𑄥𑄴" },
            { "021", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄎𑄉𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇" },
            { "029", "𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴" },
            { "030", "𑄛𑄪𑄉𑄬𑄘𑄩 𑄃𑄬𑄥𑄨𑄠" },
            { "034", "𑄘𑄧𑄉𑄨𑄚𑄬 𑄃𑄬𑄥𑄨𑄠" },
            { "035", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄛𑄪𑄇𑄴 𑄃𑄬𑄥𑄨𑄠" },
            { "039", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴" },
            { "053", "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄬𑄥𑄨𑄠" },
            { "054", "𑄟𑄳𑄠𑄣𑄬𑄚𑄬𑄥𑄨𑄠" },
            { "057", "𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠 𑄎𑄉" },
            { "061", "𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠" },
            { "142", "𑄃𑄬𑄥𑄨𑄠" },
            { "143", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄬𑄥𑄨𑄠" },
            { "145", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄬𑄥𑄨𑄠" },
            { "150", "𑄄𑄃𑄪𑄢𑄮𑄛𑄴" },
            { "151", "𑄛𑄪𑄉𑄬𑄘𑄨 𑄄𑄃𑄪𑄢𑄮𑄛𑄴" },
            { "154", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴" },
            { "155", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴" },
            { "419", "𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇" },
            { "AC", "𑄃𑄳𑄠𑄥𑄴𑄥𑄬𑄚𑄴𑄥𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "AD", "𑄃𑄚𑄴𑄓𑄮𑄢" },
            { "AE", "𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴" },
            { "AF", "𑄃𑄛𑄴𑄉𑄚𑄨𑄌𑄴𑄖𑄚𑄴" },
            { "AG", "𑄆𑄚𑄴𑄖𑄨𑄉𑄱 𑄃𑄮 𑄝𑄢𑄴𑄟𑄪𑄓" },
            { "AI", "𑄄𑄳𑄠𑄋𑄴𑄉𑄪𑄃𑄨𑄣" },
            { "AL", "𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠" },
            { "AM", "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠" },
            { "AO", "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣" },
            { "AQ", "𑄃𑄳𑄠𑄚𑄴𑄑𑄢𑄴𑄇𑄧𑄑𑄨𑄇" },
            { "AR", "𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚" },
            { "AS", "𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄟𑄮𑄠" },
            { "AT", "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠" },
            { "AU", "𑄃𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠" },
            { "AW", "𑄃𑄢𑄪𑄝" },
            { "AX", "𑄃𑄣𑄚𑄴𑄓𑄧 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "AZ", "𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴" },
            { "BA", "𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄮 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚" },
            { "BB", "𑄝𑄢𑄴𑄝𑄘𑄮𑄌𑄴" },
            { "BD", "𑄝𑄁𑄣𑄘𑄬𑄌𑄴" },
            { "BE", "𑄝𑄬𑄣𑄴𑄎𑄨𑄠𑄟𑄴" },
            { "BF", "𑄝𑄪𑄢𑄴𑄇𑄨𑄚 𑄜𑄥𑄮" },
            { "BG", "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠" },
            { "BH", "𑄝𑄦𑄧𑄢𑄭𑄚𑄴" },
            { "BI", "𑄝𑄪𑄢𑄪𑄚𑄴𑄘𑄨" },
            { "BJ", "𑄝𑄬𑄚𑄨𑄚𑄴" },
            { "BL", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄝𑄢𑄴𑄗𑄬𑄣𑄨𑄟𑄨" },
            { "BM", "𑄝𑄢𑄴𑄟𑄪𑄓" },
            { "BN", "𑄝𑄳𑄢𑄪𑄚𑄬𑄭" },
            { "BO", "𑄝𑄧𑄣𑄨𑄞𑄨𑄠" },
            { "BQ", "𑄇𑄳𑄠𑄢𑄨𑄝𑄨𑄠𑄚𑄴 𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄧𑄥𑄴" },
            { "BR", "𑄝𑄳𑄢𑄎𑄨𑄣𑄴" },
            { "BS", "𑄝𑄦𑄟 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "BT", "𑄞𑄪𑄑𑄚𑄴" },
            { "BV", "𑄝𑄮𑄞𑄬𑄑𑄴 𑄞𑄨𑄘𑄳𑄠" },
            { "BW", "𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚" },
            { "BY", "𑄝𑄬𑄣𑄢𑄪𑄌𑄴" },
            { "BZ", "𑄝𑄬𑄣𑄨𑄎𑄴" },
            { "CA", "𑄇𑄚𑄓" },
            { "CC", "𑄇𑄮𑄇𑄮𑄌𑄴 (𑄇𑄨𑄣𑄨𑄁) 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "CD", "𑄇𑄧𑄋𑄴𑄉𑄮-𑄚𑄨𑄇𑄴𑄥𑄥" },
            { "CF", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇𑄢𑄴𑄛𑄳𑄢𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧" },
            { "CG", "𑄇𑄧𑄋𑄴𑄉𑄮-𑄝𑄳𑄢𑄎𑄞𑄨𑄣𑄴" },
            { "CH", "𑄥𑄭𑄪𑄎𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "CI", "𑄃𑄭𑄞𑄧𑄢𑄨 𑄇𑄮𑄌𑄴𑄑𑄴" },
            { "CK", "𑄇𑄪𑄇𑄪 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "CL", "𑄌𑄨𑄣𑄨" },
            { "CM", "𑄇𑄳𑄠𑄟𑄬𑄢𑄪𑄚𑄴" },
            { "CN", "𑄌𑄩𑄚𑄴" },
            { "CO", "𑄃𑄣𑄧𑄟𑄴𑄝𑄨𑄠" },
            { "CP", "𑄇𑄳𑄣𑄨𑄛𑄢𑄴𑄑𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄳𑄓𑄴" },
            { "CR", "𑄇𑄮𑄥𑄳𑄑𑄢𑄨𑄇" },
            { "CU", "𑄇𑄨𑄃𑄪𑄝" },
            { "CV", "𑄇𑄬𑄛𑄴𑄞𑄢𑄴𑄘𑄬" },
            { "CW", "𑄇𑄨𑄃𑄪𑄢𑄥𑄃𑄮" },
            { "CX", "𑄇𑄳𑄢𑄨𑄥𑄴𑄟𑄥𑄴 𑄞𑄨𑄘𑄳𑄠" },
            { "CY", "𑄥𑄭𑄛𑄳𑄢𑄥𑄴" },
            { "CZ", "𑄌𑄬𑄌𑄨𑄠" },
            { "DE", "𑄎𑄢𑄴𑄟𑄚𑄨" },
            { "DG", "𑄘𑄨𑄠𑄬𑄉𑄮 𑄉𑄢𑄴𑄥𑄨𑄠" },
            { "DJ", "𑄎𑄨𑄝𑄪𑄖𑄨" },
            { "DK", "𑄓𑄬𑄚𑄴𑄟𑄢𑄴𑄇𑄧" },
            { "DM", "𑄓𑄮𑄟𑄨𑄚𑄨𑄇" },
            { "DO", "𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧" },
            { "DZ", "𑄃𑄢𑄴𑄎𑄬𑄢𑄨𑄠" },
            { "EA", "𑄇𑄪𑄃𑄪𑄑 𑄃𑄳𑄃 𑄟𑄬𑄣𑄨𑄣" },
            { "EC", "𑄄𑄇𑄪𑄠𑄬𑄓𑄧𑄢𑄴" },
            { "EE", "𑄆𑄌𑄴𑄖𑄮𑄚𑄨𑄠" },
            { "EG", "𑄟𑄨𑄥𑄧𑄢𑄴" },
            { "EH", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄥𑄦𑄢" },
            { "ER", "𑄄𑄢𑄨𑄖𑄳𑄢𑄨𑄠" },
            { "ES", "𑄥𑄳𑄛𑄬𑄚𑄴" },
            { "ET", "𑄃𑄨𑄜𑄨𑄃𑄮𑄛𑄨𑄠" },
            { "EU", "𑄄𑄃𑄪𑄢𑄮𑄛𑄩𑄠𑄧 𑄄𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴" },
            { "FI", "𑄜𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "FJ", "𑄜𑄨𑄎𑄨" },
            { "FK", "𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "FM", "𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠" },
            { "FO", "𑄜𑄳𑄠𑄢𑄧𑄃𑄮 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "FR", "𑄜𑄳𑄢𑄚𑄴𑄥𑄴" },
            { "GA", "𑄉𑄳𑄠𑄝𑄧𑄚𑄴" },
            { "GB", "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮" },
            { "GD", "𑄉𑄳𑄢𑄬𑄚𑄓" },
            { "GE", "𑄎𑄧𑄢𑄴𑄎𑄨𑄠" },
            { "GF", "𑄜𑄧𑄢𑄥𑄩 𑄉𑄠𑄚" },
            { "GG", "𑄉𑄳𑄢𑄚𑄴𑄏𑄨" },
            { "GH", "𑄊𑄚" },
            { "GI", "𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴" },
            { "GL", "𑄉𑄳𑄢𑄩𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "GM", "𑄉𑄟𑄴𑄝𑄨𑄠" },
            { "GN", "𑄉𑄨𑄚𑄨" },
            { "GP", "𑄉𑄪𑄠𑄘𑄬𑄣𑄯𑄛𑄴" },
            { "GQ", "𑄚𑄨𑄢𑄧𑄇𑄴𑄈𑄩𑄠𑄧 𑄉𑄨𑄚𑄨" },
            { "GR", "𑄉𑄳𑄢𑄨𑄌𑄴" },
            { "GS", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄮 𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄪𑄃𑄨𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "GT", "𑄉𑄪𑄠𑄖𑄬𑄟𑄣" },
            { "GU", "𑄉𑄪𑄠𑄟𑄴" },
            { "GW", "𑄉𑄨𑄚𑄨-𑄝𑄨𑄥𑄃𑄪" },
            { "GY", "𑄉𑄨𑄠𑄚" },
            { "HK", "𑄦𑄧𑄁𑄇𑄧𑄁 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚" },
            { "HM", "𑄦𑄢𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠 𑄃𑄳𑄃 𑄟𑄳𑄠𑄇𑄴𑄓𑄮𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "HN", "𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴" },
            { "HR", "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠" },
            { "HT", "𑄦𑄭𑄖𑄨" },
            { "HU", "𑄦𑄧𑄋𑄴𑄉𑄬𑄢𑄨" },
            { "IC", "𑄇𑄳𑄠𑄚𑄢𑄨 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "ID", "𑄄𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠" },
            { "IE", "𑄃𑄠𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "IL", "𑄄𑄎𑄴𑄢𑄠𑄬𑄣𑄴" },
            { "IM", "𑄃𑄭𑄣𑄴 𑄃𑄧𑄜𑄴 𑄟𑄳𑄠𑄚𑄴" },
            { "IN", "𑄞𑄢𑄧𑄖𑄴" },
            { "IQ", "𑄄𑄢𑄇𑄴" },
            { "IR", "𑄄𑄢𑄚𑄴" },
            { "IS", "𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "IT", "𑄄𑄖𑄣𑄨" },
            { "JE", "𑄎𑄢𑄴𑄥𑄨" },
            { "JM", "𑄎𑄟𑄭𑄇" },
            { "JO", "𑄎𑄧𑄢𑄴𑄓𑄧𑄚𑄴" },
            { "JP", "𑄎𑄛𑄚𑄴" },
            { "KE", "𑄇𑄬𑄚𑄨𑄠" },
            { "KG", "𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄨𑄌𑄴𑄖𑄚𑄴" },
            { "KH", "𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠" },
            { "KI", "𑄇𑄨𑄢𑄨𑄝𑄖𑄨" },
            { "KM", "𑄇𑄧𑄟𑄮𑄢𑄮𑄌𑄴" },
            { "KN", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄇𑄨𑄑𑄴𑄥𑄴 𑄃𑄮 𑄚𑄬𑄞𑄨𑄌𑄴" },
            { "KP", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠" },
            { "KR", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠" },
            { "KW", "𑄇𑄪𑄠𑄬𑄖𑄴" },
            { "KY", "𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "KZ", "𑄇𑄎𑄈𑄌𑄴𑄖𑄚𑄴" },
            { "LA", "𑄣𑄃𑄮𑄌𑄴" },
            { "LB", "𑄣𑄬𑄝𑄚𑄧𑄚𑄴" },
            { "LC", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄣𑄪𑄥𑄨𑄠" },
            { "LI", "𑄣𑄨𑄌𑄬𑄚𑄴𑄥𑄳𑄑𑄬𑄃𑄨𑄚𑄴" },
            { "LK", "𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇" },
            { "LR", "𑄃𑄭𑄝𑄬𑄢𑄨𑄠" },
            { "LS", "𑄣𑄬𑄥𑄮𑄗𑄮" },
            { "LT", "𑄣𑄨𑄗𑄪𑄠𑄚𑄨𑄠" },
            { "LU", "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄧" },
            { "LV", "𑄣𑄖𑄴𑄞𑄨𑄠" },
            { "LY", "𑄣𑄨𑄝𑄨𑄠" },
            { "MA", "𑄟𑄮𑄢𑄧𑄇𑄴𑄇𑄮" },
            { "MC", "𑄟𑄮𑄚𑄇𑄮" },
            { "MD", "𑄟𑄮𑄣𑄴𑄘𑄞𑄨𑄠" },
            { "ME", "𑄟𑄧𑄚𑄴𑄑𑄨𑄚𑄨𑄉𑄳𑄢𑄮" },
            { "MF", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄨𑄚𑄴" },
            { "MG", "𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴" },
            { "MH", "𑄟𑄢𑄴𑄥𑄣𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "MK", "𑄟𑄳𑄠𑄥𑄓𑄮𑄚𑄨𑄠" },
            { "ML", "𑄟𑄣𑄨" },
            { "MM", "𑄟𑄠𑄚𑄴𑄟𑄢𑄴 (𑄝𑄢𑄴𑄟)" },
            { "MN", "𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠" },
            { "MO", "𑄟𑄳𑄠𑄇𑄃𑄮 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚" },
            { "MP", "𑄅𑄪𑄖𑄴𑄖𑄮𑄉𑄎𑄢𑄴 𑄟𑄢𑄨𑄠𑄚 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "MQ", "𑄟𑄢𑄴𑄑𑄨𑄚𑄨𑄇𑄴" },
            { "MR", "𑄟𑄧𑄢𑄨𑄖𑄚𑄨𑄠" },
            { "MS", "𑄟𑄧𑄚𑄴𑄑𑄴𑄥𑄬𑄢𑄑𑄴" },
            { "MT", "𑄟𑄣𑄴𑄑" },
            { "MU", "𑄟𑄧𑄢𑄨𑄥𑄥𑄴" },
            { "MV", "𑄟𑄣𑄴𑄘𑄨𑄛𑄴" },
            { "MW", "𑄟𑄣𑄃𑄪𑄃𑄨" },
            { "MX", "𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮" },
            { "MY", "𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠" },
            { "MZ", "𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴" },
            { "NA", "𑄚𑄟𑄨𑄝𑄨𑄠" },
            { "NC", "𑄚𑄱 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠" },
            { "NE", "𑄚𑄭𑄎𑄢𑄴" },
            { "NF", "𑄚𑄨𑄢𑄴𑄜𑄮𑄇𑄴 𑄞𑄨𑄘𑄳𑄠" },
            { "NG", "𑄚𑄭𑄎𑄬𑄢𑄨𑄠" },
            { "NI", "𑄚𑄨𑄇𑄢𑄉𑄪𑄠" },
            { "NL", "𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴𑄥𑄴" },
            { "NO", "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬" },
            { "NP", "𑄚𑄬𑄛𑄣𑄴" },
            { "NR", metaValue_NR },
            { "NU", "𑄚𑄨𑄃𑄪𑄠𑄬" },
            { "NZ", "𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "OM", "𑄃𑄮𑄟𑄚𑄴" },
            { "PA", "𑄛𑄚𑄟" },
            { "PE", "𑄛𑄬𑄢𑄪" },
            { "PF", "𑄜𑄧𑄢𑄥𑄩 𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠" },
            { "PG", "𑄛𑄛𑄪𑄠 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨" },
            { "PH", "𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴" },
            { "PK", "𑄛𑄇𑄨𑄌𑄴𑄖𑄚𑄴" },
            { "PL", "𑄛𑄮𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "PM", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄢𑄪𑄠𑄬𑄣𑄧𑄚𑄴" },
            { "PN", "𑄛𑄨𑄇𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "PR", "𑄛𑄪𑄠𑄬𑄢𑄴𑄖𑄮 𑄢𑄨𑄇𑄮" },
            { "PS", "𑄜𑄨𑄣𑄨𑄌𑄴𑄖𑄨𑄚𑄴 𑄎𑄉𑄊𑄚𑄨" },
            { "PT", "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄣𑄴" },
            { "PW", "𑄛𑄣𑄃𑄪" },
            { "PY", "𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬" },
            { "QA", "𑄇𑄖𑄢𑄴" },
            { "QO", "𑄃𑄅𑄪𑄑𑄣𑄭𑄚𑄨𑄁 𑄃𑄮𑄥𑄚𑄨𑄠" },
            { "RE", "𑄢𑄨𑄃𑄨𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴" },
            { "RO", "𑄢𑄮𑄟𑄚𑄨𑄠" },
            { "RS", "𑄥𑄢𑄴𑄝𑄨𑄠" },
            { "RU", "𑄢𑄥𑄨𑄠" },
            { "RW", "𑄢𑄪𑄠𑄚𑄴𑄓" },
            { "SA", "𑄥𑄯𑄘𑄨 𑄃𑄢𑄧𑄝𑄴" },
            { "SB", "𑄥𑄧𑄣𑄮𑄟𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "SC", "𑄥𑄨𑄥𑄨𑄣𑄨" },
            { "SD", "𑄥𑄪𑄘𑄚𑄴" },
            { "SE", "𑄥𑄭𑄪𑄓𑄬𑄚𑄴" },
            { "SG", "𑄥𑄨𑄋𑄴𑄉𑄛𑄪𑄢𑄴" },
            { "SH", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄦𑄬𑄣𑄬𑄚" },
            { "SI", "𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠" },
            { "SJ", "𑄥𑄣𑄴𑄝𑄢𑄴𑄓𑄴 𑄃𑄮 𑄎𑄚𑄴 𑄟𑄬𑄠𑄬𑄚𑄴" },
            { "SK", "𑄥𑄳𑄣𑄮𑄞𑄇𑄨𑄠" },
            { "SL", "𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄃𑄮𑄚𑄴" },
            { "SM", "𑄥𑄚𑄴 𑄟𑄢𑄨𑄚𑄮" },
            { "SN", "𑄥𑄬𑄚𑄬𑄉𑄣𑄴" },
            { "SO", "𑄥𑄮𑄟𑄣𑄨𑄠" },
            { "SR", "𑄥𑄪𑄢𑄨𑄚𑄟𑄴" },
            { "SS", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄴" },
            { "ST", "𑄥𑄃𑄮𑄑𑄟 𑄃𑄮 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄨" },
            { "SV", "𑄆𑄣𑄴 𑄥𑄣𑄴𑄞𑄬𑄘𑄧𑄢𑄴" },
            { "SX", "𑄥𑄨𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄬𑄚𑄴" },
            { "SY", "𑄥𑄨𑄢𑄨𑄠" },
            { "SZ", "𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "TA", "𑄑𑄳𑄢𑄌𑄴𑄑𑄚𑄴 𑄓 𑄇𑄪𑄚𑄴𑄦" },
            { "TC", "𑄖𑄪𑄢𑄴𑄇𑄧𑄌𑄴 𑄃𑄮 𑄇𑄭𑄇𑄮𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "TD", "𑄌𑄘𑄴" },
            { "TF", "𑄜𑄢𑄥𑄩 𑄘𑄧𑄉𑄨𑄚𑄧 𑄎𑄉" },
            { "TG", "𑄑𑄮𑄉𑄮" },
            { "TH", "𑄗𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴" },
            { "TJ", "𑄖𑄎𑄨𑄇𑄴𑄥𑄳𑄗𑄚𑄴" },
            { "TK", metaValue_TK },
            { "TL", "𑄖𑄨𑄟𑄪𑄢𑄴-𑄣𑄬𑄌𑄴𑄖𑄬" },
            { "TM", "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴" },
            { "TN", "𑄖𑄨𑄃𑄪𑄚𑄨𑄥𑄨𑄠" },
            { "TO", "𑄑𑄮𑄋𑄴𑄉" },
            { "TR", "𑄖𑄪𑄢𑄧𑄌𑄴𑄇𑄧" },
            { "TT", "𑄖𑄳𑄢𑄨𑄚𑄨𑄚𑄘𑄴 𑄃𑄮 𑄑𑄮𑄝𑄳𑄠𑄉𑄮" },
            { "TV", metaValue_TV },
            { "TW", "𑄖𑄭𑄤𑄚𑄴" },
            { "TZ", "𑄖𑄚𑄴𑄎𑄚𑄨𑄠" },
            { "UA", "𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄴" },
            { "UG", "𑄅𑄉𑄚𑄴𑄓" },
            { "UM", "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄦𑄭𑄇𑄪𑄢𑄬 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "UN", "𑄎𑄘𑄨𑄥𑄧𑄁𑄊𑄧" },
            { "US", "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮" },
            { "UY", "𑄅𑄪𑄢𑄪𑄉𑄪𑄠𑄬" },
            { "UZ", "𑄅𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄴" },
            { "VA", "𑄞𑄳𑄠𑄑𑄨𑄇𑄚𑄴 𑄥𑄨𑄑𑄨" },
            { "VC", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄑𑄴 𑄃𑄮 𑄘𑄳𑄠 𑄉𑄳𑄢𑄬𑄚𑄓𑄨𑄚𑄴𑄥𑄴" },
            { "VE", "𑄞𑄬𑄚𑄬𑄎𑄪𑄠𑄬𑄣" },
            { "VG", "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "VI", "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠" },
            { "VN", "𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄴" },
            { "VU", "𑄞𑄚𑄪𑄠𑄑𑄪" },
            { "WF", "𑄤𑄣𑄨𑄌𑄴 𑄃𑄮 𑄜𑄪𑄑𑄪𑄚" },
            { "WS", "𑄥𑄟𑄮𑄠" },
            { "XK", "𑄇𑄧𑄥𑄮𑄞𑄮" },
            { "YE", "𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄴" },
            { "YT", "𑄟𑄠𑄮𑄖𑄴𑄖𑄬" },
            { "ZA", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇" },
            { "ZM", "𑄎𑄟𑄴𑄝𑄨𑄠" },
            { "ZW", "𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬" },
            { "ZZ", "𑄃𑄨𑄌𑄨𑄚𑄴 𑄎𑄉" },
            { "aa", "𑄃𑄜𑄢𑄴" },
            { "ab", "𑄃𑄝𑄴𑄈𑄎𑄨𑄠𑄚𑄴" },
            { "ae", "𑄃𑄝𑄬𑄌𑄴𑄖𑄩𑄠𑄧" },
            { "af", "𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴" },
            { "ak", "𑄃𑄇𑄚𑄴" },
            { "am", "𑄃𑄟𑄴𑄦𑄢𑄨𑄇𑄴" },
            { "an", "𑄃𑄢𑄴𑄉𑄮𑄚𑄨𑄎𑄴" },
            { "ar", "𑄃𑄢𑄧𑄝𑄩" },
            { "as", "𑄃𑄥𑄟𑄨" },
            { "av", "𑄃𑄞𑄬𑄢𑄨𑄇𑄴" },
            { "ay", "𑄃𑄠𑄧𑄟𑄢" },
            { "az", "𑄃𑄎𑄢𑄴𑄝𑄳𑄆𑄎𑄚𑄩" },
            { "ba", "𑄝𑄌𑄴𑄇𑄨𑄢𑄴" },
            { "be", "𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄧" },
            { "bg", "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠𑄧" },
            { "bi", "𑄝𑄨𑄥𑄴𑄣𑄟" },
            { "bm", "𑄝𑄟𑄴𑄝𑄢" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "𑄝𑄳𑄢𑄬𑄑𑄧𑄚𑄴" },
            { "bs", "𑄝𑄧𑄥𑄴𑄚𑄩𑄠𑄚𑄴" },
            { "ca", "𑄇𑄖𑄣𑄚𑄴" },
            { "ce", "𑄌𑄬𑄌𑄬𑄚𑄴" },
            { "ch", "𑄌𑄟𑄮𑄢𑄮" },
            { "co", "𑄇𑄧𑄢𑄴𑄥𑄨𑄇𑄚𑄴" },
            { "cr", "𑄇𑄳𑄢𑄨" },
            { "cs", "𑄌𑄬𑄇𑄴" },
            { "cu", "𑄌𑄢𑄴𑄌𑄴 𑄥𑄳𑄣𑄞𑄨𑄇𑄴" },
            { "cv", "𑄌𑄪𑄝𑄥𑄴" },
            { "cy", "𑄃𑄮𑄠𑄬𑄣𑄧𑄌𑄴" },
            { "da", "𑄓𑄬𑄚𑄨𑄌𑄴" },
            { "de", "𑄎𑄢𑄴𑄟𑄚𑄴" },
            { "dv", "𑄘𑄨𑄝𑄬𑄦𑄨" },
            { "dz", "𑄎𑄮𑄋𑄴𑄉" },
            { "ee", "𑄃𑄨𑄅𑄠𑄨" },
            { "el", metaValue_el },
            { "en", "𑄃𑄨𑄁𑄢𑄨𑄎𑄨" },
            { "eo", "𑄆𑄥𑄴𑄛𑄬𑄢𑄚𑄴𑄖𑄮" },
            { "es", "𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴" },
            { "et", "𑄆𑄌𑄴𑄖𑄨𑄚𑄩𑄠𑄧" },
            { "eu", "𑄝𑄌𑄴𑄇𑄧" },
            { "fa", "𑄜𑄢𑄴𑄥𑄨" },
            { "ff", "𑄜𑄪𑄣𑄳𑄦" },
            { "fi", "𑄜𑄨𑄚𑄨𑄌𑄴" },
            { "fj", "𑄜𑄨𑄎𑄨𑄠𑄚𑄴" },
            { "fo", "𑄜𑄢𑄮𑄌𑄴" },
            { "fr", "𑄜𑄧𑄢𑄥𑄨" },
            { "fy", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴" },
            { "ga", "𑄃𑄭𑄢𑄨𑄌𑄴" },
            { "gd", "𑄃𑄨𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄧-𑄉𑄳𑄠𑄬𑄣𑄨𑄇𑄴" },
            { "gl", "𑄉𑄳𑄠𑄣𑄨𑄥𑄨𑄠𑄧" },
            { "gn", "𑄉𑄪𑄠𑄢𑄚𑄨" },
            { "gu", "𑄉𑄪𑄎𑄴𑄢𑄖𑄨" },
            { "gv", "𑄟𑄳𑄠𑄇𑄴𑄥𑄧" },
            { "ha", "𑄦𑄃𑄪𑄥" },
            { "he", metaValue_he },
            { "hi", "𑄦𑄨𑄚𑄴𑄓𑄨" },
            { "ho", "𑄦𑄪𑄢𑄨 𑄟𑄮𑄖𑄪" },
            { "hr", "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄩𑄠𑄧" },
            { "ht", "𑄦𑄭𑄖𑄨𑄠𑄚𑄴" },
            { "hu", "𑄦𑄁𑄉𑄬𑄢𑄩𑄠𑄧" },
            { "hy", "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄧" },
            { "hz", "𑄦𑄬𑄢𑄬𑄢𑄮" },
            { "ia", "𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄪𑄠" },
            { "id", "𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄧" },
            { "ie", "𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄧" },
            { "ig", "𑄃𑄨𑄉𑄴𑄝𑄮" },
            { "ii", "𑄥𑄨𑄥𑄪𑄠𑄚𑄴𑄠𑄨" },
            { "ik", "𑄃𑄨𑄚𑄪𑄛𑄨𑄠𑄇𑄴" },
            { "io", "𑄃𑄨𑄓𑄮" },
            { "is", "𑄃𑄭𑄌𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨𑄠𑄧" },
            { "it", "𑄃𑄨𑄖𑄣𑄩𑄠𑄧" },
            { "iu", "𑄃𑄨𑄚𑄪𑄇𑄴𑄑𑄨𑄑𑄪𑄖𑄴" },
            { "ja", "𑄎𑄛𑄚𑄨" },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "𑄇𑄧𑄁𑄉𑄮" },
            { "ki", "𑄇𑄨𑄇𑄪𑄠𑄪" },
            { "kj", "𑄇𑄮𑄠𑄚𑄨𑄠𑄟" },
            { "kk", "𑄇𑄎𑄇𑄴" },
            { "kl", "𑄇𑄳𑄠𑄣𑄣𑄴𑄣𑄨𑄥𑄪𑄖𑄴" },
            { "km", "𑄈𑄧𑄟𑄬𑄢𑄴" },
            { "kn", "𑄇𑄧𑄚𑄴𑄚𑄧𑄢𑄴" },
            { "ko", metaValue_ko },
            { "kr", "𑄇𑄚𑄪𑄢𑄨" },
            { "ks", "𑄇𑄌𑄴𑄟𑄨𑄢𑄨" },
            { "ku", "𑄇𑄪𑄢𑄴𑄘𑄨𑄥𑄴" },
            { "kv", "𑄇𑄮𑄟𑄨" },
            { "kw", "𑄇𑄧𑄢𑄴𑄚𑄨𑄌𑄴" },
            { "ky", "𑄇𑄨𑄢𑄴𑄉𑄨𑄌𑄴" },
            { "la", "𑄣𑄑𑄨𑄚𑄴" },
            { "lb", "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄩𑄠𑄧" },
            { "lg", "𑄉𑄚𑄴𑄓" },
            { "li", "𑄣𑄨𑄟𑄴𑄝𑄪𑄢𑄴𑄉𑄨𑄌𑄴" },
            { "ln", "𑄣𑄨𑄋𑄴𑄉𑄣" },
            { "lo", metaValue_lo },
            { "lt", "𑄣𑄨𑄗𑄪𑄠𑄬𑄚𑄩𑄠𑄧" },
            { "lu", "𑄣𑄪𑄝-𑄇𑄑𑄋𑄴𑄉" },
            { "lv", "𑄣𑄖𑄴𑄞𑄩𑄠𑄧" },
            { "mg", "𑄟𑄣𑄉𑄥𑄨" },
            { "mh", "𑄟𑄢𑄴𑄥𑄣𑄨𑄎𑄴" },
            { "mi", "𑄟𑄃𑄮𑄢𑄨" },
            { "mk", "𑄟𑄳𑄠𑄥𑄨𑄓𑄮𑄚𑄩𑄠𑄧" },
            { "ml", metaValue_ml },
            { "mn", "𑄟𑄧𑄁𑄉𑄮𑄣𑄨𑄠𑄧" },
            { "mr", "𑄟𑄢𑄒𑄨" },
            { "ms", "𑄟𑄣𑄧𑄠𑄴" },
            { "mt", "𑄟𑄧𑄣𑄴𑄑𑄨𑄠𑄧" },
            { "my", "𑄝𑄧𑄢𑄴𑄟𑄨" },
            { "na", metaValue_NR },
            { "nb", "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄨𑄠𑄚𑄴 𑄝𑄮𑄇𑄴𑄟𑄣𑄴" },
            { "nd", "𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄆𑄚𑄴𑄘𑄬𑄝𑄨𑄣𑄨" },
            { "ne", "𑄚𑄬𑄛𑄣𑄨" },
            { "ng", "𑄆𑄚𑄴𑄘𑄮𑄋𑄴𑄉" },
            { "nl", "𑄓𑄌𑄴" },
            { "nn", "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄚𑄴 𑄚𑄨𑄚𑄧𑄢𑄴𑄥𑄳𑄇𑄴" },
            { "no", "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄧" },
            { "nr", "𑄓𑄧𑄉𑄨𑄚𑄴 𑄆𑄚𑄴𑄓𑄬𑄝𑄬𑄣𑄬" },
            { "nv", "𑄚𑄞𑄎𑄮" },
            { "ny", "𑄚𑄠𑄚𑄴𑄎" },
            { "oc", "𑄃𑄧𑄇𑄴𑄥𑄨𑄑𑄚𑄴" },
            { "oj", "𑄃𑄮𑄎𑄨𑄝𑄧𑄤" },
            { "om", "𑄃𑄧𑄢𑄮𑄟𑄮" },
            { "or", metaValue_or },
            { "os", "𑄃𑄮𑄥𑄬𑄑𑄨𑄇𑄴" },
            { "pa", "𑄛𑄚𑄴𑄎𑄝𑄩" },
            { "pi", "𑄛𑄣𑄨" },
            { "pl", "𑄛𑄮𑄣𑄨𑄌𑄴" },
            { "ps", "𑄛𑄌𑄴𑄑𑄪" },
            { "pt", "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴" },
            { "qu", "𑄇𑄬𑄌𑄪𑄠" },
            { "rm", "𑄢𑄮𑄟𑄚𑄴𑄥𑄴" },
            { "rn", "𑄢𑄪𑄚𑄴𑄘𑄨" },
            { "ro", "𑄢𑄮𑄟𑄚𑄩𑄠𑄧" },
            { "ru", "𑄢𑄪𑄌𑄴" },
            { "rw", "𑄇𑄨𑄚𑄴𑄠𑄢𑄮𑄠𑄚𑄴𑄓" },
            { "sa", "𑄥𑄧𑄁𑄥𑄴𑄇𑄳𑄢𑄨𑄖𑄴" },
            { "sc", "𑄥𑄢𑄴𑄓𑄨𑄚𑄨𑄠𑄚𑄴" },
            { "sd", "𑄥𑄨𑄚𑄴𑄙𑄨" },
            { "se", "𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨" },
            { "sg", "𑄥𑄋𑄴𑄉𑄮" },
            { "sh", "𑄥𑄢𑄴𑄝𑄮-𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄧" },
            { "si", "𑄥𑄨𑄁𑄦𑄧𑄣𑄩" },
            { "sk", "𑄥𑄳𑄣𑄮𑄞𑄇𑄴" },
            { "sl", "𑄥𑄳𑄣𑄮𑄞𑄬𑄚𑄩𑄠𑄧" },
            { "sm", "𑄥𑄟𑄮𑄠𑄚𑄴" },
            { "sn", "𑄥𑄮𑄚" },
            { "so", "𑄥𑄮𑄟𑄣𑄨" },
            { "sq", "𑄃𑄣𑄴𑄝𑄬𑄚𑄩𑄠𑄧" },
            { "sr", "𑄥𑄢𑄴𑄝𑄩𑄠𑄧" },
            { "ss", "𑄥𑄮𑄠𑄖𑄨" },
            { "st", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄮𑄗𑄮" },
            { "su", "𑄥𑄪𑄘𑄚𑄩" },
            { "sv", "𑄥𑄭𑄪𑄓𑄨𑄥𑄴" },
            { "sw", "𑄥𑄱𑄦𑄨𑄣𑄨" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "𑄖𑄎𑄨𑄇𑄴" },
            { "th", metaValue_th },
            { "ti", "𑄖𑄨𑄉𑄧𑄢𑄨𑄚𑄨𑄠" },
            { "tk", "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨" },
            { "tl", "𑄖𑄉𑄣𑄧𑄇𑄴" },
            { "tn", "𑄥𑄱𑄚" },
            { "to", "𑄑𑄮𑄋𑄴𑄉𑄚𑄴" },
            { "tr", "𑄖𑄪𑄢𑄴𑄇𑄩" },
            { "ts", "𑄥𑄧𑄋𑄴𑄉" },
            { "tt", "𑄖𑄖𑄢𑄴" },
            { "tw", "𑄑𑄮𑄠𑄭" },
            { "ty", "𑄖𑄦𑄨𑄖𑄨𑄠𑄚𑄴" },
            { "ug", "𑄃𑄪𑄃𑄨𑄊𑄪𑄢𑄴" },
            { "uk", "𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄩𑄠𑄧" },
            { "ur", "𑄃𑄪𑄢𑄴𑄘𑄪" },
            { "uz", "𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄩𑄠𑄧" },
            { "ve", "𑄞𑄬𑄚𑄴𑄓" },
            { "vi", "𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄩" },
            { "vo", "𑄞𑄮𑄣𑄛𑄪𑄇𑄴" },
            { "wa", "𑄤𑄣𑄪𑄚𑄴" },
            { "wo", "𑄤𑄃𑄮𑄣𑄮𑄜𑄴" },
            { "xh", "𑄎𑄮𑄥" },
            { "yi", "𑄠𑄨𑄖𑄴𑄘𑄨𑄥𑄴" },
            { "yo", "𑄃𑄨𑄃𑄮𑄢𑄪𑄝" },
            { "za", "𑄏𑄪𑄠𑄋𑄴" },
            { "zh", "𑄌𑄩𑄚" },
            { "zu", "𑄎𑄪𑄣𑄪" },
            { "ace", "𑄃𑄳𑄃𑄌𑄳𑄆𑄚𑄨𑄎𑄴" },
            { "ach", "𑄃𑄇𑄮𑄣𑄨" },
            { "ada", "𑄃𑄧𑄘𑄟𑄳𑄉𑄬" },
            { "ady", "𑄃𑄘𑄬𑄉𑄬" },
            { "afh", "𑄃𑄜𑄳𑄢𑄨𑄦𑄨𑄣𑄨" },
            { "agq", "𑄃𑄬𑄊𑄟𑄴" },
            { "ain", "𑄃𑄳𑄆𑄚𑄪" },
            { "akk", "𑄃𑄇𑄳𑄦𑄴𑄘𑄨𑄠𑄚𑄴" },
            { "ale", "𑄃𑄣𑄬𑄅𑄖𑄴" },
            { "alt", "𑄓𑄧𑄉𑄨𑄚𑄴 𑄃𑄣𑄴𑄖𑄭" },
            { "ang", "𑄛𑄪𑄢𑄧𑄚𑄨 𑄃𑄟𑄧𑄣𑄧𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄩" },
            { "anp", "𑄃𑄋𑄳𑄉𑄨𑄇" },
            { "arc", "𑄃𑄢𑄟𑄳𑄆𑄇𑄴" },
            { "arn", "𑄟𑄛𑄪𑄌𑄨" },
            { "arp", "𑄃𑄢𑄛𑄦𑄮" },
            { "arw", "𑄃𑄢𑄤𑄇𑄴" },
            { "asa", "𑄃𑄥𑄪" },
            { "ast", "𑄃𑄌𑄴𑄖𑄪𑄢𑄨𑄠𑄧" },
            { "awa", "𑄃𑄤𑄙𑄨" },
            { "bal", "𑄝𑄬𑄣𑄪𑄌𑄩" },
            { "ban", "𑄝𑄣𑄨𑄚𑄩𑄠𑄧" },
            { "bas", "𑄝𑄥" },
            { "bej", "𑄝𑄬𑄎" },
            { "bem", "𑄝𑄬𑄟𑄴𑄝" },
            { "bez", "𑄝𑄬𑄚" },
            { "bgn", "𑄛𑄧𑄏𑄨𑄟𑄴 𑄝𑄣𑄮𑄌𑄨" },
            { "bho", "𑄞𑄮𑄎𑄴𑄛𑄪𑄢𑄨" },
            { "bik", "𑄝𑄨𑄇𑄮𑄣𑄴" },
            { "bin", "𑄝𑄨𑄚𑄨" },
            { "bla", "𑄥𑄨𑄇𑄴𑄥𑄨𑄇" },
            { "bra", "𑄝𑄳𑄢𑄎𑄴" },
            { "brx", "𑄝𑄮𑄢𑄮" },
            { "bua", "𑄝𑄪𑄢𑄨𑄠𑄖𑄴" },
            { "bug", "𑄝𑄪𑄉𑄨𑄚𑄨" },
            { "byn", "𑄝𑄳𑄣𑄨𑄚𑄴" },
            { "cad", "𑄇𑄳𑄠𑄓𑄮" },
            { "car", "𑄝𑄳𑄠𑄢𑄨𑄛𑄴" },
            { "cch", "𑄃𑄖𑄴𑄥𑄟𑄴" },
            { "ccp", "𑄌𑄋𑄴𑄟𑄳𑄦" },
            { "ceb", "𑄌𑄬𑄝𑄪𑄠𑄚𑄮" },
            { "cgg", "𑄌𑄨𑄉" },
            { "chb", "𑄌𑄨𑄛𑄴𑄌" },
            { "chg", "𑄌𑄉𑄖𑄳𑄆" },
            { "chk", "𑄌𑄪𑄇𑄨" },
            { "chm", "𑄟𑄢𑄨" },
            { "chn", "𑄌𑄨𑄚𑄪𑄇𑄴 𑄎𑄢𑄴𑄉𑄧𑄚𑄴" },
            { "cho", "𑄌𑄧𑄇𑄴𑄑𑄳𑄅𑄧𑄠𑄧" },
            { "chp", "𑄌𑄨𑄛𑄮𑄤𑄚𑄴" },
            { "chr", "𑄌𑄬𑄢𑄮𑄇𑄩" },
            { "chy", "𑄥𑄳𑄆𑄠𑄬𑄚𑄴" },
            { "ckb", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴" },
            { "cop", "𑄇𑄧𑄛𑄴𑄑𑄨𑄇𑄴" },
            { "crh", "𑄇𑄳𑄢𑄨𑄟𑄨𑄠𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨" },
            { "crs", "𑄥𑄬𑄥𑄬𑄣𑄧𑄤 𑄇𑄳𑄢𑄬𑄃𑄮𑄣𑄴 𑄜𑄳𑄢𑄬𑄐𑄴𑄌𑄧" },
            { "csb", "𑄇𑄥𑄪𑄝𑄨𑄠𑄚𑄴" },
            { "dak", "𑄓𑄇𑄮𑄑" },
            { "dar", "𑄘𑄢𑄴𑄉𑄧𑄤" },
            { "dav", "𑄖𑄳𑄆𑄖" },
            { "del", "𑄓𑄬𑄣𑄤𑄬𑄢𑄴" },
            { "den", "𑄥𑄳𑄣𑄳𑄠𑄞𑄴" },
            { "dgr", "𑄘𑄮𑄉𑄳𑄢𑄨𑄝𑄴" },
            { "din", "𑄓𑄨𑄁𑄇" },
            { "dje", "𑄎𑄢𑄴𑄟" },
            { "doi", "𑄓𑄮𑄉𑄧𑄢𑄨" },
            { "dsb", "𑄙𑄮𑄣𑄴𑄚𑄬𑄭𑄙𑄳𑄠𑄬 𑄥𑄮𑄢𑄴𑄝𑄨𑄠𑄚𑄴" },
            { "dua", "𑄘𑄱𑄣" },
            { "dum", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄓𑄌𑄴" },
            { "dyo", "𑄎𑄧𑄣-𑄜𑄧𑄚𑄩" },
            { "dyu", "𑄓𑄨𑄃𑄪𑄣" },
            { "dzg", "𑄘𑄉𑄎" },
            { "ebu", "𑄃𑄬𑄟𑄳𑄝𑄪𑄪" },
            { "efi", "𑄆𑄜𑄨𑄇𑄴" },
            { "egy", "𑄛𑄪𑄢𑄨𑄚𑄩 𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧" },
            { "eka", "𑄃𑄨𑄇𑄎𑄪𑄇𑄴" },
            { "elx", "𑄆𑄣𑄟𑄭𑄖𑄴" },
            { "enm", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨" },
            { "ewo", "𑄄𑄃𑄮𑄚𑄴𑄓𑄮" },
            { "fan", "𑄜𑄳𑄠𑄋𑄴𑄉𑄧" },
            { "fat", "𑄜𑄚𑄴𑄖𑄨" },
            { "fil", "𑄜𑄨𑄣𑄨𑄛𑄨𑄚𑄮" },
            { "fon", "𑄜𑄧𑄚𑄴" },
            { "frm", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄜𑄧𑄢𑄥𑄨" },
            { "fro", "𑄛𑄪𑄢𑄮𑄚𑄨 𑄜𑄧𑄢𑄥𑄨" },
            { "frr", "𑄅𑄖𑄴𑄗𑄧𑄢𑄴 𑄎𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴" },
            { "frs", "𑄛𑄪𑄉𑄮 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄧" },
            { "fur", "𑄜𑄳𑄢𑄨𑄃𑄪𑄣𑄨𑄠𑄚𑄴" },
            { "gaa", "𑄉𑄳𑄃" },
            { "gag", "𑄉𑄉𑄃𑄪𑄌𑄴" },
            { "gan", "𑄉𑄧𑄚𑄴" },
            { "gay", "𑄉𑄧𑄠𑄮" },
            { "gba", "𑄝𑄠" },
            { "gez", "𑄉𑄩𑄎𑄴" },
            { "gil", "𑄉𑄨𑄣𑄴𑄝𑄢𑄴𑄑𑄨𑄎𑄴" },
            { "gmh", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧-𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩" },
            { "goh", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩" },
            { "gon", "𑄉𑄮𑄚𑄴𑄓𑄨" },
            { "gor", "𑄉𑄢𑄮𑄚𑄴𑄖𑄣𑄮" },
            { "got", "𑄉𑄧𑄗𑄨𑄇𑄴" },
            { "grb", "𑄉𑄳𑄢𑄬𑄝𑄮" },
            { "grc", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄉𑄳𑄢𑄩𑄇𑄴" },
            { "gsw", "𑄥𑄪𑄃𑄨𑄌𑄴 𑄥𑄢𑄴𑄟𑄚𑄴" },
            { "guz", "𑄉𑄪𑄥𑄩" },
            { "gwi", "𑄉𑄧𑄃𑄮𑄃𑄨𑄌𑄴𑄃𑄨𑄚𑄴" },
            { "hai", "𑄦𑄭𑄓" },
            { "hak", "𑄦𑄧𑄇𑄴" },
            { "haw", "𑄦𑄤𑄃𑄨𑄠𑄚𑄴" },
            { "hil", "𑄦𑄨𑄣𑄨𑄉𑄳𑄠𑄠𑄧𑄚𑄮𑄚𑄴" },
            { "hit", "𑄦𑄨𑄖𑄨𑄨𑄖𑄴" },
            { "hmn", "𑄦𑄳𑄦𑄟𑄮𑄋𑄴" },
            { "hsb", "𑄅𑄪𑄉𑄪𑄢𑄬 𑄥𑄮𑄢𑄴𑄥𑄨𑄠𑄚𑄴" },
            { "hsn", "Xiang 𑄌𑄨𑄚" },
            { "hup", "𑄦𑄪𑄛" },
            { "iba", "𑄃𑄨𑄝𑄚𑄴" },
            { "ibb", "𑄃𑄨𑄝𑄨𑄝𑄨𑄠𑄧" },
            { "ilo", "𑄃𑄨𑄣𑄮𑄇𑄮" },
            { "inh", "𑄃𑄨𑄁𑄉𑄪𑄌𑄴" },
            { "jbo", "𑄣𑄮𑄌𑄴𑄝𑄚𑄴" },
            { "jgo", "𑄉𑄮𑄟𑄴𑄝" },
            { "jmc", "𑄟𑄇𑄟𑄬" },
            { "jpr", "𑄎𑄪𑄘𑄬𑄃𑄮 𑄜𑄢𑄴𑄥𑄨" },
            { "jrb", "𑄎𑄪𑄘𑄬𑄃𑄮 𑄃𑄢𑄧𑄝𑄨" },
            { "kaa", "𑄇𑄢-𑄇𑄣𑄴𑄛𑄇𑄴" },
            { "kab", "𑄇𑄝𑄭𑄣𑄬" },
            { "kac", "𑄇𑄌𑄨𑄚𑄴" },
            { "kaj", "𑄃𑄧𑄌𑄴𑄎𑄪" },
            { "kam", "𑄇𑄟𑄴𑄝" },
            { "kaw", "𑄇𑄃𑄪𑄃𑄨" },
            { "kbd", "𑄇𑄝𑄢𑄴𑄓𑄨𑄠𑄚𑄴" },
            { "kcg", "𑄑𑄃𑄨𑄠𑄛𑄴" },
            { "kde", "𑄟𑄇𑄮𑄚𑄴𑄘𑄬" },
            { "kea", "𑄇𑄝𑄪𑄞𑄢𑄴𑄘𑄨𑄠𑄚𑄪" },
            { "kfo", "𑄇𑄮𑄢𑄮" },
            { "kha", "𑄈𑄥𑄨" },
            { "kho", "𑄈𑄮𑄑𑄚𑄨𑄎𑄴" },
            { "khq", "𑄇𑄮𑄠𑄧𑄢 𑄌𑄩𑄚𑄨" },
            { "kkj", "𑄇𑄇𑄮" },
            { "kln", "𑄇𑄣𑄬𑄚𑄴𑄎𑄨𑄚𑄴" },
            { "kmb", "𑄇𑄨𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪" },
            { "koi", "𑄇𑄧𑄟𑄨-𑄛𑄢𑄧𑄟𑄨𑄃𑄇𑄴" },
            { "kok", "𑄇𑄮𑄋𑄴𑄇𑄚𑄨" },
            { "kos", "𑄇𑄮𑄥𑄳𑄢𑄭𑄚𑄴" },
            { "kpe", "𑄇𑄴𑄛𑄬𑄣𑄳𑄣𑄬" },
            { "krc", "𑄇𑄢𑄴𑄌𑄮-𑄝𑄣𑄴𑄇𑄢𑄴" },
            { "krl", "𑄇𑄢𑄬𑄣𑄨𑄠𑄚𑄴" },
            { "kru", "𑄇𑄪𑄢𑄪𑄇𑄴" },
            { "ksb", "𑄥𑄟𑄴𑄝𑄣" },
            { "ksf", "𑄝𑄜𑄨𑄠" },
            { "ksh", "𑄇𑄣𑄴𑄥𑄧" },
            { "kum", "𑄇𑄪𑄟𑄨𑄇𑄴" },
            { "kut", "𑄇𑄪𑄑𑄬𑄚𑄭" },
            { "lad", "𑄣𑄓𑄨𑄚𑄮" },
            { "lag", "𑄣𑄋𑄴𑄉𑄨" },
            { "lah", "𑄣𑄚𑄴𑄓" },
            { "lam", "𑄣𑄟𑄴𑄝" },
            { "lez", "𑄣𑄬𑄎𑄴𑄊𑄨𑄠𑄚𑄴" },
            { "lkt", "𑄣𑄇𑄮𑄑" },
            { "lol", "𑄟𑄮𑄋𑄴𑄉𑄮" },
            { "loz", "𑄣𑄮𑄎𑄨" },
            { "lrc", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄣𑄪𑄢𑄨" },
            { "lua", "𑄣𑄪𑄝-𑄣𑄪𑄣𑄪𑄠" },
            { "lui", "𑄣𑄭𑄪𑄥𑄬𑄚𑄮" },
            { "lun", "𑄣𑄪𑄚𑄴𑄓" },
            { "luo", "𑄣𑄪𑄠𑄮" },
            { "lus", "𑄟𑄨𑄎𑄮" },
            { "luy", "𑄣𑄭𑄪𑄠" },
            { "mad", "𑄟𑄘𑄪𑄢𑄬𑄥𑄬" },
            { "mag", "𑄟𑄉𑄦𑄨" },
            { "mai", "𑄟𑄳𑄆𑄧𑄗𑄨𑄣𑄨" },
            { "mak", "𑄟𑄳𑄠𑄇𑄥𑄢𑄴" },
            { "man", "𑄟𑄳𑄠𑄚𑄴𑄓𑄨𑄁𑄉𑄮" },
            { "mas", "𑄟𑄥𑄭" },
            { "mdf", "𑄟𑄮𑄇𑄴𑄥" },
            { "mdr", "𑄟𑄳𑄠𑄚𑄴𑄓𑄢𑄴" },
            { "men", "𑄟𑄬𑄚𑄴𑄓𑄬" },
            { "mer", "𑄟𑄬𑄢𑄪" },
            { "mfe", "𑄟𑄢𑄨𑄥𑄨𑄠𑄚𑄴" },
            { "mga", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄭𑄢𑄨𑄌𑄴" },
            { "mgh", "𑄟𑄈𑄪𑄠-𑄟𑄬𑄖𑄴𑄖𑄮" },
            { "mgo", "𑄟𑄬𑄑" },
            { "mic", "𑄟𑄨𑄇𑄟𑄳𑄠𑄇𑄴" },
            { "min", "𑄟𑄨𑄚𑄋𑄴𑄇𑄝𑄃𑄪" },
            { "mnc", "𑄟𑄚𑄴𑄌𑄪" },
            { "mni", "𑄟𑄚𑄨𑄛𑄪𑄢𑄩" },
            { "moh", "𑄟𑄮𑄦𑄃𑄮𑄇𑄴" },
            { "mos", "𑄟𑄧𑄥𑄨" },
            { "mua", "𑄟𑄪𑄘𑄋𑄴𑄉𑄧" },
            { "mul", "𑄝𑄣𑄧𑄇𑄴𑄇𑄚𑄨 𑄞𑄌𑄴" },
            { "mus", "𑄇𑄳𑄢𑄨𑄇𑄴" },
            { "mwl", "𑄟𑄨𑄢𑄚𑄴𑄓𑄨𑄎𑄴" },
            { "mwr", "𑄟𑄢𑄮𑄠𑄢𑄨" },
            { "myv", "𑄆𑄢𑄧𑄎𑄨𑄠" },
            { "mzn", "𑄟𑄎𑄚𑄴𑄘𑄬𑄢𑄚𑄨" },
            { "nan", "𑄚𑄚𑄴" },
            { "nap", "𑄚𑄬𑄠𑄛𑄮𑄣𑄨𑄑𑄚𑄴" },
            { "naq", "𑄚𑄟" },
            { "nds", "𑄖𑄧𑄣𑄬 𑄎𑄢𑄴𑄟𑄚𑄨" },
            { "new", "𑄚𑄬𑄃𑄮𑄠𑄢𑄨" },
            { "nia", "𑄚𑄨𑄠𑄌𑄴" },
            { "niu", "𑄚𑄨𑄃𑄪𑄠𑄚𑄴" },
            { "nmg", "𑄇𑄱𑄥𑄨𑄃𑄮" },
            { "nnh", "𑄚𑄨𑄋𑄴𑄉𑄬𑄟𑄴𑄝𑄪𑄚𑄴" },
            { "nog", "𑄚𑄮𑄉𑄭" },
            { "non", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄧𑄢𑄴𑄥𑄧" },
            { "nqo", "𑄆𑄚𑄴𑄇𑄮" },
            { "nso", "𑄃𑄪𑄖𑄴𑄗𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄮𑄗𑄮" },
            { "nus", "𑄚𑄪𑄠𑄢𑄴" },
            { "nwc", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄬𑄃𑄮𑄠𑄢𑄩" },
            { "nym", "𑄚𑄳𑄠𑄠𑄟𑄴𑄃𑄮𑄠𑄬𑄎𑄨" },
            { "nyn", "𑄚𑄳𑄠𑄠𑄋𑄴𑄇𑄮𑄣𑄬" },
            { "nyo", "𑄚𑄧𑄱𑄢𑄮" },
            { "nzi", "𑄆𑄚𑄴𑄎𑄨𑄟" },
            { "osa", "𑄃𑄮𑄥𑄬𑄌𑄴" },
            { "ota", "𑄃𑄧𑄑𑄮𑄟𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨" },
            { "pag", "𑄛𑄁𑄉𑄥𑄨𑄚𑄚𑄴" },
            { "pal", "𑄛𑄦𑄳𑄣𑄞𑄨" },
            { "pam", "𑄛𑄟𑄴𑄛𑄋𑄴𑄉" },
            { "pap", "𑄛𑄛𑄨𑄠𑄟𑄬𑄚𑄴𑄖𑄮" },
            { "pau", "𑄛𑄣𑄠𑄪𑄠𑄚𑄴" },
            { "pcm", "𑄚𑄎𑄬𑄢𑄨𑄠𑄧 𑄛𑄨𑄎𑄨𑄚𑄴" },
            { "peo", metaValue_peo },
            { "phn", "𑄜𑄮𑄚𑄨𑄥𑄨𑄠𑄚𑄴" },
            { "pon", "𑄛𑄮𑄚𑄴𑄦𑄧𑄛𑄳𑄆𑄬𑄠𑄚𑄴" },
            { "prg", "𑄛𑄴𑄢𑄪𑄥𑄨𑄠𑄚𑄴" },
            { "pro", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄛𑄳𑄢𑄮𑄞𑄬𑄚𑄴𑄥𑄣𑄴" },
            { "quc", "𑄇𑄳𑄦𑄨𑄌𑄬" },
            { "raj", "𑄢𑄎𑄴𑄥𑄳𑄦𑄚𑄨" },
            { "rap", "𑄢𑄛𑄚𑄳𑄆𑄪" },
            { "rar", "𑄢𑄢𑄮𑄑𑄮𑄁𑄉𑄚𑄴" },
            { "rof", "𑄢𑄧𑄟𑄴𑄝𑄮" },
            { "rom", "𑄢𑄮𑄟𑄚𑄨" },
            { "rup", "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴" },
            { "rwk", "𑄢𑄤" },
            { "sad", "𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄮𑄠𑄬" },
            { "sah", "𑄥𑄈" },
            { "sam", "𑄥𑄟𑄢𑄨𑄑𑄚𑄴 𑄃𑄢𑄟𑄨𑄇𑄴" },
            { "saq", "𑄥𑄟𑄴𑄝𑄪𑄢𑄪" },
            { "sas", "𑄥𑄥𑄇𑄴" },
            { "sat", "𑄥𑄀𑄃𑄮𑄖𑄣𑄨" },
            { "sba", "𑄚𑄳𑄠𑄉𑄟𑄴𑄝𑄬" },
            { "sbp", "𑄥𑄁𑄚𑄴𑄉𑄪" },
            { "scn", "𑄥𑄨𑄥𑄨𑄣𑄨𑄠𑄚𑄴" },
            { "sco", "𑄆𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄴" },
            { "sdh", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴" },
            { "seh", "𑄥𑄬𑄚" },
            { "sel", "𑄥𑄬𑄣𑄴𑄇𑄪𑄛𑄴" },
            { "ses", "𑄇𑄱𑄢𑄝𑄬𑄚𑄮 𑄥𑄬𑄚𑄳𑄚𑄨" },
            { "sga", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄃𑄭𑄢𑄨𑄌𑄴" },
            { "shi", "𑄖𑄌𑄬𑄣𑄴𑄦𑄨𑄖𑄴" },
            { "shn", "𑄥𑄚𑄴" },
            { "sid", "𑄥𑄨𑄓𑄟𑄮" },
            { "sma", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨" },
            { "smj", "𑄣𑄪𑄣𑄬 𑄥𑄟𑄨" },
            { "smn", "𑄃𑄨𑄚𑄢𑄨 𑄥𑄟𑄨" },
            { "sms", "𑄥𑄳𑄇𑄧𑄣𑄳𑄑𑄧 𑄥𑄟𑄨" },
            { "snk", "𑄥𑄮𑄚𑄨𑄋𑄴𑄇𑄬" },
            { "sog", "𑄥𑄮𑄇𑄴𑄓𑄠𑄚𑄴" },
            { "srn", "𑄥𑄳𑄢𑄚𑄚𑄴 𑄑𑄮𑄋𑄴𑄉𑄮" },
            { "srr", "𑄥𑄬𑄢𑄬𑄢𑄴" },
            { "ssy", "𑄥𑄦𑄮" },
            { "suk", "𑄥𑄪𑄇𑄪𑄟" },
            { "sus", "𑄥𑄪𑄥𑄪" },
            { "sux", "𑄥𑄪𑄟𑄬𑄢𑄩𑄠𑄧" },
            { "swb", "𑄇𑄧𑄟𑄮𑄢𑄨𑄠𑄚𑄴" },
            { "syc", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄥𑄨𑄢𑄨𑄃𑄮" },
            { "syr", metaValue_syr },
            { "tem", "𑄑𑄭𑄟𑄴𑄚𑄬" },
            { "teo", "𑄖𑄬𑄥𑄮" },
            { "ter", "𑄖𑄬𑄢𑄬𑄚𑄮" },
            { "tet", "𑄖𑄬𑄖𑄪𑄟𑄴" },
            { "tig", "𑄑𑄭𑄉𑄳𑄢𑄬" },
            { "tiv", "𑄑𑄨𑄞𑄴" },
            { "tkl", metaValue_TK },
            { "tlh", "𑄇𑄳𑄣𑄨𑄋𑄴𑄉𑄧𑄚𑄴" },
            { "tli", "𑄖𑄴𑄣𑄨𑄋𑄴𑄉𑄨𑄖𑄴" },
            { "tmh", "𑄖𑄟𑄥𑄬𑄇𑄴" },
            { "tog", "𑄚𑄠𑄥𑄑𑄮𑄋𑄴𑄉" },
            { "tpi", "𑄑𑄮𑄇𑄴 𑄛𑄨𑄥𑄨𑄚𑄴" },
            { "trv", "𑄖𑄢𑄮𑄇𑄮" },
            { "tsi", "𑄥𑄨𑄟𑄴𑄥𑄨𑄠𑄚𑄴" },
            { "tum", "𑄖𑄪𑄟𑄴𑄝𑄪𑄇" },
            { "tvl", metaValue_TV },
            { "twq", "𑄖𑄥𑄤𑄇𑄴" },
            { "tyv", "𑄑𑄪𑄞𑄨𑄚𑄨𑄠𑄚𑄴" },
            { "tzm", "𑄥𑄬𑄚𑄴𑄑𑄳𑄢𑄣𑄴 𑄃𑄣𑄴𑄖𑄌𑄴 𑄖𑄟𑄎𑄨𑄉𑄖𑄴" },
            { "udm", "𑄃𑄪𑄓𑄴𑄟𑄪𑄢𑄴𑄑𑄧" },
            { "uga", "𑄃𑄪𑄉𑄢𑄨𑄑𑄨𑄇𑄴" },
            { "umb", "𑄃𑄪𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪" },
            { "und", "𑄦𑄧𑄝𑄧𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄞𑄌𑄴" },
            { "vai", metaValue_vai },
            { "vot", "𑄞𑄮𑄑𑄨𑄇𑄴" },
            { "vun", "𑄞𑄪𑄚𑄴𑄏𑄮" },
            { "wae", "𑄤𑄣𑄧𑄥𑄬𑄢𑄴" },
            { "wal", "𑄤𑄣𑄟𑄮" },
            { "war", "𑄤𑄢𑄬" },
            { "was", "𑄤𑄥𑄮" },
            { "wbp", "𑄤𑄢𑄴𑄣𑄴𑄛𑄨𑄢𑄨" },
            { "wuu", "𑄤𑄌𑄨𑄚" },
            { "xal", "𑄇𑄣𑄴𑄟𑄳𑄆𑄧𑄇𑄴" },
            { "xog", "𑄥𑄮𑄉" },
            { "yao", "𑄃𑄨𑄠𑄃𑄮" },
            { "yap", "𑄃𑄨𑄠𑄛𑄬𑄥𑄬" },
            { "yav", "𑄠𑄋𑄴𑄉𑄧𑄝𑄬𑄚𑄴" },
            { "ybb", "𑄠𑄮𑄟𑄴𑄝" },
            { "yue", "𑄇𑄳𑄠𑄚𑄴𑄑𑄮𑄚𑄩𑄎𑄴" },
            { "zap", "𑄎𑄛𑄮𑄑𑄬𑄇𑄴" },
            { "zbl", "𑄃𑄉𑄬𑄠 𑄞𑄌𑄴" },
            { "zen", "𑄎𑄬𑄚𑄉" },
            { "zgh", "𑄉𑄧𑄟𑄴𑄘𑄮𑄣𑄴 𑄟𑄧𑄢𑄧𑄇𑄧𑄧𑄱𑄚𑄴𑄖𑄟𑄎𑄨𑄉𑄖𑄴" },
            { "zun", "𑄎𑄪𑄚𑄨" },
            { "zxx", "𑄞𑄏𑄧𑄢𑄴𑄘𑄮𑄇𑄳𑄠𑄬 𑄝𑄨𑄥𑄧𑄠𑄴 𑄚𑄳𑄄𑄬" },
            { "zza", "𑄎𑄎" },
            { "Arab", "𑄃𑄢𑄧𑄝𑄨" },
            { "Armi", "𑄃𑄢𑄧𑄟𑄨" },
            { "Armn", "𑄃𑄢𑄴𑄟𑄬𑄚𑄩𑄠𑄧" },
            { "Avst", "𑄃𑄞𑄬𑄥𑄧𑄖𑄚𑄴" },
            { "Bali", "𑄝𑄣𑄩𑄠𑄧" },
            { "Batk", "𑄖𑄑𑄇𑄴" },
            { "Beng", metaValue_bn },
            { "Blis", "𑄝𑄳𑄣𑄨𑄌𑄴𑄛𑄳𑄢𑄧𑄖𑄩𑄇𑄴" },
            { "Bopo", "𑄝𑄮𑄛𑄮𑄟𑄮𑄜𑄮" },
            { "Brah", "𑄝𑄳𑄢𑄟𑄴𑄦𑄴𑄟𑄩" },
            { "Brai", "𑄝𑄳𑄢𑄳𑄆𑄬𑄣𑄴" },
            { "Bugi", "𑄝𑄪𑄉𑄨" },
            { "Buhd", "𑄝𑄪𑄦𑄨𑄓𑄴" },
            { "Cakm", "𑄌𑄇𑄴𑄟" },
            { "Cans", "𑄎𑄧𑄙 𑄇𑄚𑄓𑄨𑄠𑄚𑄴 𑄃𑄳𑄠𑄝𑄳𑄢𑄮𑄎𑄨𑄚𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄬𑄝𑄨𑄇𑄴𑄥𑄧" },
            { "Cari", "𑄇𑄳𑄠𑄢𑄨𑄠𑄚𑄴" },
            { "Cham", "𑄌𑄳𑄠𑄟𑄴" },
            { "Cher", "𑄌𑄬𑄇𑄮𑄇𑄨" },
            { "Cirt", "𑄇𑄨𑄢𑄴𑄑𑄧" },
            { "Copt", "𑄇𑄮𑄛𑄴𑄑𑄨𑄇𑄴" },
            { "Cprt", "𑄥𑄭𑄛𑄳𑄢𑄮𑄠𑄬𑄖𑄴" },
            { "Cyrl", "𑄥𑄨𑄢𑄨𑄣𑄨𑄇𑄴" },
            { "Cyrs", "𑄛𑄪𑄢𑄮𑄚𑄨 𑄌𑄢𑄴𑄌𑄧 𑄥𑄳𑄣𑄞𑄮𑄚𑄨𑄇𑄴 𑄥𑄨𑄢𑄨𑄣𑄨𑄇𑄴" },
            { "Deva", "𑄘𑄬𑄛𑄴𑄚𑄉𑄧𑄢𑄨" },
            { "Dsrt", "𑄘𑄬𑄥𑄬𑄢𑄖𑄴" },
            { "Egyd", "𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧 𑄓𑄬𑄟𑄮𑄑𑄨𑄇𑄴" },
            { "Egyh", "𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧 𑄦𑄠𑄴𑄢𑄬𑄑𑄨𑄇𑄴" },
            { "Egyp", "𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧 𑄦𑄠𑄢𑄮𑄉𑄳𑄣𑄨𑄛𑄴" },
            { "Ethi", "𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄠𑄧" },
            { "Geok", "𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄧 𑄈𑄪𑄖𑄴𑄥𑄪𑄢𑄨" },
            { "Geor", metaValue_ka },
            { "Glag", "𑄉𑄳𑄣𑄉𑄮𑄣𑄨𑄑𑄨𑄇𑄴" },
            { "Goth", "𑄉𑄮𑄗𑄨𑄇𑄴" },
            { "Grek", metaValue_el },
            { "Gujr", "𑄉𑄪𑄎𑄴𑄢𑄑𑄨" },
            { "Guru", "𑄉𑄪𑄢𑄪𑄟𑄪𑄈𑄨" },
            { "Hanb", "𑄦𑄳𑄠𑄚𑄴𑄝𑄨" },
            { "Hang", "𑄦𑄋𑄴𑄉𑄪𑄣𑄴" },
            { "Hani", "𑄦𑄳𑄠𑄚𑄴" },
            { "Hano", "𑄦𑄳𑄠𑄚𑄪𑄚𑄪" },
            { "Hans", "𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫" },
            { "Hant", "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴" },
            { "Hebr", metaValue_he },
            { "Hira", "𑄦𑄨𑄢𑄉𑄚" },
            { "Hmng", "𑄜𑄦𑄃𑄮𑄟𑄧𑄋𑄴" },
            { "Hrkt", "𑄎𑄛𑄚𑄨 𑄦𑄧𑄢𑄧𑄇𑄴" },
            { "Hung", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄦𑄋𑄴𑄉𑄬𑄢𑄨𑄠𑄧" },
            { "Inds", "𑄥𑄨𑄚𑄴𑄙𑄪" },
            { "Ital", "𑄛𑄪𑄢𑄮𑄚𑄩 𑄃𑄨𑄖𑄣𑄨" },
            { "Jamo", "𑄎𑄳𑄠𑄟𑄮" },
            { "Java", metaValue_jv },
            { "Jpan", "𑄎𑄛𑄚𑄩" },
            { "Kali", "𑄇𑄠𑄦𑄧𑄣𑄨" },
            { "Kana", "𑄇𑄑𑄇𑄚" },
            { "Khar", "𑄈𑄢𑄮𑄌𑄴𑄒𑄩" },
            { "Khmr", "𑄈𑄬𑄟𑄬𑄢𑄴" },
            { "Knda", "𑄇𑄚𑄢" },
            { "Kore", metaValue_ko },
            { "Kthi", "𑄇𑄭𑄗𑄨" },
            { "Lana", "𑄣𑄚𑄳𑄦" },
            { "Laoo", metaValue_lo },
            { "Latf", "𑄜𑄳𑄢𑄇𑄴𑄑𑄪𑄢𑄴 𑄣𑄳𑄠𑄑𑄨𑄚𑄴" },
            { "Latg", "𑄉𑄳𑄠𑄣𑄨𑄇𑄴 𑄣𑄳𑄠𑄑𑄨𑄚𑄴" },
            { "Latn", "𑄣𑄳𑄠𑄑𑄨𑄚𑄴" },
            { "Lepc", "𑄣𑄬𑄛𑄴𑄌" },
            { "Limb", "𑄣𑄨𑄟𑄴𑄝𑄪" },
            { "Lina", "𑄣𑄨𑄚𑄨𑄠𑄢𑄴 𑄆" },
            { "Linb", "𑄣𑄨𑄚𑄨𑄠𑄢𑄴 𑄝𑄨" },
            { "Lyci", "𑄣𑄭𑄥𑄨𑄠𑄚𑄴" },
            { "Lydi", "𑄣𑄭𑄓𑄨𑄠𑄚𑄴" },
            { "Mand", "𑄟𑄳𑄠𑄚𑄴𑄓𑄠𑄩𑄚𑄴" },
            { "Mani", "𑄟𑄳𑄠𑄚𑄨𑄌𑄭𑄚𑄴" },
            { "Maya", "𑄟𑄠𑄚𑄴 𑄦𑄠𑄢𑄮𑄉𑄳𑄣𑄨𑄛𑄴" },
            { "Mero", "𑄟𑄬𑄢𑄮𑄃𑄨𑄑𑄨𑄇𑄴" },
            { "Mlym", metaValue_ml },
            { "Mong", "𑄟𑄮𑄋𑄴𑄉𑄮𑄣𑄩𑄠𑄧" },
            { "Moon", "𑄟𑄪𑄚𑄴" },
            { "Mtei", "𑄟𑄳𑄆𑄬𑄑𑄳𑄆𑄬 𑄟𑄠𑄬𑄇𑄴" },
            { "Mymr", "𑄟𑄠𑄚𑄴𑄟𑄢𑄴" },
            { "Nkoo", "𑄃𑄬𑄚𑄴𑄇𑄮" },
            { "Ogam", "𑄃𑄮𑄊𑄟𑄴" },
            { "Olck", "𑄃𑄮𑄣𑄴𑄌𑄨𑄇𑄨" },
            { "Orkh", "𑄃𑄧𑄢𑄴𑄈𑄮𑄚𑄴" },
            { "Orya", metaValue_or },
            { "Osma", "𑄃𑄮𑄥𑄟𑄚𑄨𑄠𑄧" },
            { "Perm", "𑄛𑄪𑄢𑄮𑄚𑄴 𑄛𑄢𑄴𑄟𑄨𑄇𑄴" },
            { "Phag", "𑄜𑄧𑄉𑄴𑄥𑄧-𑄛" },
            { "Phli", "𑄈𑄧𑄘𑄨𑄖𑄧 𑄛𑄳𑄦𑄣𑄧𑄞𑄩" },
            { "Phlp", "𑄥𑄧𑄣𑄴𑄑𑄢𑄴 𑄛𑄳𑄦𑄣𑄧𑄞𑄩" },
            { "Phlv", "𑄛𑄪𑄌𑄴𑄖𑄧𑄇𑄴 𑄛𑄳𑄦𑄣𑄧𑄞𑄩" },
            { "Phnx", "𑄜𑄨𑄚𑄨𑄥𑄩𑄠𑄧" },
            { "Plrd", "𑄛𑄮𑄣𑄢𑄴𑄓𑄧 𑄙𑄧𑄚𑄨𑄇𑄴" },
            { "Prti", "𑄛𑄢𑄴𑄗𑄨𑄠𑄧𑄚𑄴" },
            { "Rjng", "𑄢𑄬𑄎𑄳𑄠𑄋𑄴𑄉𑄧" },
            { "Roro", "𑄢𑄮𑄋𑄴𑄉𑄮𑄢𑄮𑄋𑄴𑄉𑄮" },
            { "Runr", "𑄢𑄪𑄚𑄨𑄇𑄴" },
            { "Samr", "𑄥𑄧𑄟𑄬𑄢𑄨𑄑𑄧𑄚𑄴" },
            { "Sara", "𑄥𑄢𑄖𑄨" },
            { "Saur", "𑄥𑄯𑄢𑄌𑄴𑄑𑄳𑄢𑄧" },
            { "Sgnw", "𑄌𑄨𑄚𑄴𑄦𑄧 𑄣𑄨𑄈𑄧𑄚𑄴" },
            { "Shaw", "𑄥𑄞𑄨𑄠𑄚𑄴" },
            { "Sinh", "𑄥𑄨𑄁𑄦𑄧𑄣𑄨" },
            { "Sund", "𑄥𑄚𑄴𑄘𑄚𑄨𑄎𑄴" },
            { "Sylo", "𑄥𑄨𑄣𑄬𑄑𑄨 𑄚𑄉𑄧𑄢𑄨" },
            { "Syrc", metaValue_syr },
            { "Syre", "𑄃𑄬𑄌𑄴𑄑𑄳𑄢𑄬𑄋𑄴𑄉𑄬𑄣𑄮 𑄥𑄨𑄢𑄨𑄠𑄇𑄴" },
            { "Syrj", "𑄛𑄧𑄏𑄨𑄟𑄴𑄎𑄉𑄢𑄴 𑄥𑄨𑄢𑄨𑄠𑄇𑄴" },
            { "Syrn", "𑄛𑄪𑄇𑄴𑄎𑄉𑄧𑄢𑄴 𑄥𑄨𑄢𑄨𑄠𑄇𑄴" },
            { "Tagb", "𑄑𑄉𑄮𑄤𑄚" },
            { "Tale", "𑄖𑄭𑄣𑄬" },
            { "Talu", "𑄚𑄱 𑄖𑄭 𑄣𑄪" },
            { "Taml", metaValue_ta },
            { "Tavt", "𑄖𑄭 𑄞𑄨𑄠𑄬𑄖𑄴" },
            { "Telu", metaValue_te },
            { "Teng", "𑄖𑄬𑄋𑄴𑄉𑄮𑄠𑄢𑄴" },
            { "Tfng", "𑄖𑄨𑄜𑄨𑄚𑄉𑄴" },
            { "Tglg", "𑄑𑄉𑄣𑄧𑄉𑄴" },
            { "Thaa", "𑄗𑄚" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "𑄅𑄪𑄉𑄢𑄨𑄑𑄨𑄇𑄴" },
            { "Vaii", metaValue_vai },
            { "Visp", "𑄘𑄬𑄉𑄧𑄎𑄭𑄘𑄳𑄠𑄬 𑄞𑄌𑄴" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "𑄥𑄪𑄟𑄬𑄢𑄧-𑄃𑄇𑄳𑄇𑄘𑄩𑄠𑄧 𑄇𑄩𑄣𑄧𑄇𑄴𑄢𑄪𑄛𑄴" },
            { "Yiii", "𑄅𑄪𑄃𑄨" },
            { "Zinh", "𑄇𑄭" },
            { "Zmth", "𑄚𑄘𑄞𑄬𑄖𑄴 𑄌𑄨𑄚𑄴𑄦𑄧" },
            { "Zsye", "𑄃𑄨𑄟𑄮𑄎𑄨" },
            { "Zsym", "𑄍𑄪𑄝𑄨𑄉𑄪𑄚𑄴" },
            { "Zxxx", "𑄚𑄧𑄣𑄬𑄇𑄴𑄈𑄳𑄠𑄬" },
            { "Zyyy", "𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴" },
            { "Zzzz", "𑄦𑄧𑄝𑄧𑄢𑄴𑄚𑄧𑄛𑄨𑄠𑄬 𑄦𑄧𑄢𑄧𑄇𑄴" },
            { "de_AT", "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠𑄚𑄴 𑄎𑄢𑄴𑄟𑄚𑄴" },
            { "de_CH", "𑄥𑄪𑄃𑄨𑄌𑄴 𑄦𑄭 𑄎𑄢𑄴𑄟𑄚𑄴" },
            { "en_AU", "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨" },
            { "en_CA", "𑄇𑄚𑄓𑄩𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨" },
            { "en_GB", "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨" },
            { "en_US", "𑄃𑄟𑄬𑄢𑄨𑄇𑄢𑄴 𑄃𑄨𑄁𑄢𑄎𑄨" },
            { "es_ES", "𑄄𑄅𑄢𑄮𑄛𑄩𑄠𑄧 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴" },
            { "es_MX", "𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴" },
            { "fr_CA", "𑄇𑄚𑄓𑄩𑄠𑄧 𑄜𑄧𑄢𑄥𑄨" },
            { "fr_CH", "𑄥𑄪𑄃𑄨𑄌𑄴 𑄜𑄧𑄢𑄥𑄨" },
            { "nl_BE", "𑄜𑄳𑄣𑄬𑄟𑄨𑄌𑄴" },
            { "pt_BR", "𑄝𑄳𑄢𑄎𑄨𑄣𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴" },
            { "pt_PT", "𑄃𑄨𑄃𑄪𑄢𑄮𑄛𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴" },
            { "ro_MD", "𑄟𑄧𑄣𑄴𑄘𑄞𑄨𑄠𑄧" },
            { "sw_CD", "𑄇𑄧𑄋𑄴𑄉𑄮 𑄥𑄱𑄦𑄨𑄣𑄨" },
            { "ar_001", "𑄚𑄱 𑄉𑄧𑄟𑄴 𑄃𑄢𑄧𑄝𑄩" },
            { "es_419", "𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴" },
            { "key.ca", "𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "key.cf", "𑄟𑄪𑄖𑄴𑄘𑄳𑄢 𑄜𑄧𑄢𑄴𑄟𑄳𑄠𑄑𑄴" },
            { "key.co", "𑄝𑄬𑄭𑄣𑄧𑄚𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "key.cu", "𑄑𑄬𑄋-𑄛𑄧𑄠𑄴𑄎𑄳𑄠" },
            { "key.hc", "𑄃𑄧𑄇𑄴𑄖𑄧𑄢𑄴 𑄃𑄨𑄏𑄬𑄛𑄴 (𑄷𑄸 𑄃𑄳𑄃 𑄸𑄺)" },
            { "key.lb", "𑄣𑄃𑄨𑄚𑄴 𑄞𑄉𑄴𑄉𑄧𑄢𑄚𑄢𑄴 𑄃𑄨𑄌𑄴𑄑𑄭𑄣𑄴" },
            { "key.ms", "𑄟𑄝𑄚𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "key.nu", "𑄚𑄘𑄅𑄪𑄚𑄴" },
            { "key.tz", "𑄃𑄧𑄇𑄴𑄖𑄧 𑄎𑄮𑄚𑄴" },
            { "key.va", "𑄃𑄨𑄘𑄪𑄉𑄮𑄢𑄴 𑄚𑄚𑄝𑄝𑄧𑄖𑄳𑄠" },
            { "nds_NL", "𑄣𑄮𑄥𑄳𑄠𑄇𑄴𑄥𑄧𑄚𑄴" },
            { "zh_Hans", "𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫 𑄌𑄩𑄚" },
            { "zh_Hant", "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄩𑄚" },
            { "type.ca.roc", "𑄟𑄨𑄁𑄉𑄪𑄃𑄮 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.hc.h11", "𑄷𑄸 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴 (𑄶-𑄷𑄷)" },
            { "type.hc.h12", "𑄷𑄸 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴 (𑄷-𑄷𑄸)" },
            { "type.hc.h23", "𑄸𑄺 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴(𑄷-𑄸𑄹)" },
            { "type.hc.h24", "𑄸𑄺 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴 (𑄷-𑄸𑄺)" },
            { "type.m0.bgn", "𑄝𑄨𑄎𑄨𑄃𑄬𑄚𑄴" },
            { "type.nu.arab", "𑄃𑄢𑄧𑄝𑄨-𑄞𑄢𑄨𑄖𑄩𑄠𑄧 𑄚𑄘" },
            { "type.nu.armn", "𑄃𑄢𑄴𑄟𑄬𑄚𑄩𑄠𑄧 𑄚𑄘" },
            { "type.nu.beng", "𑄝𑄁𑄣 𑄚𑄘" },
            { "type.nu.deva", "𑄘𑄬𑄝𑄧𑄚𑄉𑄧𑄢𑄨 𑄚𑄘" },
            { "type.nu.ethi", "𑄃𑄨𑄗𑄨𑄠𑄮𑄛𑄇𑄴 𑄚𑄘" },
            { "type.nu.geor", "𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄚𑄘" },
            { "type.nu.grek", "𑄉𑄳𑄢𑄨𑄇𑄴 𑄚𑄘𑄨" },
            { "type.nu.gujr", "𑄉𑄪𑄎𑄴𑄢𑄖𑄨 𑄚𑄘" },
            { "type.nu.guru", "𑄉𑄪𑄢𑄪𑄟𑄪𑄈𑄨 𑄚𑄘" },
            { "type.nu.hans", "𑄅𑄪𑄎𑄪𑄅𑄪𑄎𑄪 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄚𑄘" },
            { "type.nu.hant", "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄚𑄘" },
            { "type.nu.hebr", "𑄦𑄨𑄝𑄳𑄢𑄪 𑄚𑄘𑄨" },
            { "type.nu.jpan", "𑄎𑄛𑄚𑄨 𑄚𑄘" },
            { "type.nu.khmr", "𑄈𑄬𑄟𑄬𑄢𑄴 𑄚𑄘" },
            { "type.nu.knda", "𑄇𑄧𑄚𑄴𑄚𑄧𑄢𑄴 𑄚𑄘" },
            { "type.nu.laoo", "𑄣𑄃𑄮 𑄚𑄘" },
            { "type.nu.latn", "𑄃𑄮𑄠𑄬𑄌𑄴𑄑𑄢𑄴𑄚𑄴 𑄓𑄨𑄎𑄨𑄑𑄴" },
            { "type.nu.mlym", "𑄟𑄣𑄴𑄠𑄣𑄧𑄟𑄴 𑄚𑄘" },
            { "type.nu.mong", "𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄩𑄠𑄧 𑄚𑄘" },
            { "type.nu.mymr", "𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄚𑄘" },
            { "type.nu.orya", "𑄃𑄮𑄢𑄨𑄠 𑄚𑄘" },
            { "type.nu.taml", "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄖𑄟𑄨𑄣𑄴 𑄚𑄘" },
            { "type.nu.telu", "𑄖𑄬𑄣𑄪𑄉𑄪 𑄚𑄘" },
            { "type.nu.thai", "𑄗𑄭 𑄚𑄘" },
            { "type.nu.tibt", "𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨 𑄚𑄘" },
            { "type.nu.vaii", "𑄞𑄭 𑄚𑄘" },
            { "type.ca.dangi", "𑄓𑄋𑄴𑄉𑄨 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.co.ducet", "𑄓𑄨𑄜𑄧𑄣𑄴𑄑𑄴 𑄃𑄨𑄃𑄪𑄚𑄨𑄇𑄮𑄓𑄴 𑄝𑄬𑄭𑄣𑄧𑄚" },
            { "type.lb.loose", "𑄃𑄣𑄴𑄉 𑄣𑄭𑄚𑄴 𑄜𑄢𑄧𑄉𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "type.nu.roman", "𑄢𑄮𑄟𑄚𑄴 𑄚𑄘" },
            { "type.ca.coptic", "𑄇𑄧𑄛𑄴𑄑𑄨𑄇𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.ca.hebrew", "𑄦𑄨𑄝𑄳𑄢𑄪 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.ca.indian", "𑄞𑄢𑄧𑄘𑄧𑄢𑄴 𑄎𑄖𑄩𑄠𑄧 𑄝𑄧𑄢𑄴𑄥𑄧𑄛𑄧𑄚𑄴𑄏𑄩" },
            { "type.co.pinyin", "𑄛𑄨𑄚𑄨𑄚𑄴 𑄥𑄎𑄚" },
            { "type.co.search", "𑄃𑄧𑄎𑄧𑄃𑄧𑄌𑄴-𑄅𑄪𑄘𑄨𑄌𑄴𑄥𑄳𑄠 𑄖𑄮𑄉𑄚" },
            { "type.co.stroke", "𑄊𑄪𑄎𑄳𑄠𑄛𑄪𑄏𑄳𑄠 𑄥𑄎𑄬𑄭𑄗𑄧𑄚" },
            { "type.co.unihan", "𑄢𑄓𑄨𑄇𑄬𑄣𑄴 𑄃𑄨𑄌𑄴𑄑𑄳𑄢𑄮𑄇𑄴 𑄝𑄬𑄭𑄣𑄧𑄚" },
            { "type.d0.fwidth", "𑄛𑄪𑄢𑄮𑄃𑄮𑄏𑄢𑄴" },
            { "type.d0.hwidth", "𑄃𑄧𑄖𑄴𑄘𑄬𑄇𑄴 𑄃𑄮𑄏𑄢𑄴" },
            { "type.lb.normal", "𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴 𑄣𑄭𑄚𑄴 𑄜𑄢𑄧𑄉𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "type.lb.strict", "𑄑𑄭𑄑𑄴 𑄣𑄭𑄚𑄴 𑄜𑄢𑄧𑄉𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "type.m0.ungegn", "𑄃𑄚𑄴𑄎𑄨𑄃𑄨𑄎𑄨𑄃𑄬𑄚𑄴" },
            { "type.ms.metric", "𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄥𑄨𑄥𑄴𑄑𑄬𑄟𑄴" },
            { "type.nu.native", "𑄃𑄟𑄧𑄚𑄧 𑄎𑄉𑄢𑄴 𑄚𑄘𑄨" },
            { "type.ca.chinese", "𑄌𑄨𑄚 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.ca.iso8601", "ISO-861 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.ca.persian", "𑄜𑄢𑄴𑄥𑄨 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.cf.account", "𑄑𑄬𑄋𑄛𑄧𑄠𑄴𑄎𑄳𑄠 𑄃𑄨𑄏𑄬𑄝𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "type.d0.npinyin", "𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠" },
            { "type.nu.arabext", "𑄍𑄧𑄢𑄨𑄠𑄬 𑄍𑄨𑄖𑄴𑄖𑄳𑄠𑄬 𑄃𑄢𑄧𑄝𑄨-𑄞𑄢𑄧𑄖𑄩𑄠 𑄚𑄘" },
            { "type.nu.armnlow", "𑄃𑄢𑄴𑄟𑄬𑄚𑄩𑄠𑄧 𑄌𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄚𑄘" },
            { "type.nu.finance", "𑄃𑄧𑄢𑄴𑄗𑄧𑄚𑄨𑄖𑄨𑄇𑄴 𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠" },
            { "type.nu.greklow", "𑄉𑄳𑄢𑄨𑄇𑄴 𑄌𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄚𑄘" },
            { "type.nu.hanidec", "𑄌𑄳𑄆𑄚𑄨𑄇 𑄜𑄪𑄘𑄮 𑄚𑄘" },
            { "type.nu.hansfin", "𑄅𑄪𑄎𑄪𑄅𑄎𑄪 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄑𑄬𑄋 𑄚𑄘" },
            { "type.nu.hantfin", "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄑𑄬𑄋 𑄚𑄘" },
            { "type.nu.jpanfin", "𑄎𑄛𑄚𑄨 𑄑𑄬𑄋 𑄚𑄘" },
            { "type.nu.tamldec", "𑄖𑄟𑄨𑄣 𑄚𑄘" },
            { "type.ca.buddhist", "𑄝𑄪𑄖𑄴𑄙𑄮 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.ca.ethiopic", "𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄇𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.ca.japanese", "𑄎𑄛𑄚𑄨 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.cf.standard", "𑄟𑄚𑄧𑄇𑄴 𑄑𑄬𑄋𑄛𑄧𑄠𑄴𑄎𑄳𑄠𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "type.co.phonetic", "𑄢𑄳𑄦𑄧 𑄝𑄬𑄭𑄣𑄧𑄚" },
            { "type.co.searchjl", "𑄦𑄋𑄴𑄉𑄪𑄣𑄴 𑄛𑄧𑄖𑄴𑄗𑄧𑄟𑄴 𑄝𑄧𑄣𑄬𑄟𑄖𑄳𑄠𑄬 𑄦𑄧𑄢𑄧𑄇𑄴 𑄘𑄨𑄚𑄬𑄭 𑄖𑄮𑄉𑄚" },
            { "type.co.standard", "𑄉𑄧𑄟𑄴 𑄘𑄮𑄣𑄴 𑄝𑄬𑄭𑄣𑄧𑄚" },
            { "type.ms.uksystem", "𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄟𑄝𑄧𑄢𑄴 𑄥𑄨𑄥𑄴𑄑𑄬𑄟𑄴" },
            { "type.ms.ussystem", "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄟𑄝𑄧𑄢𑄴 𑄥𑄨𑄥𑄴𑄑𑄬𑄟𑄴" },
            { "type.nu.fullwide", "𑄛𑄪𑄢𑄮 𑄃𑄧𑄏𑄢𑄴 𑄚𑄘𑄨" },
            { "type.nu.romanlow", "𑄢𑄮𑄟𑄚𑄴 𑄌𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄚𑄘" },
            { "type.ca.gregorian", "𑄉𑄳𑄢𑄉𑄮𑄢𑄨𑄠𑄚𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
            { "type.co.phonebook", "𑄜𑄮𑄚𑄴𑄝𑄪𑄇𑄴 𑄥𑄎𑄚" },
            { "type.co.dictionary", "𑄇𑄧𑄙𑄖𑄢 𑄝𑄬𑄭𑄣𑄧𑄚𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴" },
            { "type.co.traditional", "𑄛𑄳𑄢𑄧𑄗𑄉𑄧𑄖𑄧 𑄝𑄬𑄭𑄣𑄧𑄚" },
            { "type.nu.traditional", "𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠" },
            { "type.ca.ethiopic-amete-alem", "𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄃𑄮 𑄃𑄟𑄬𑄖𑄬 𑄃𑄣𑄬𑄟𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴" },
        };
        return data;
    }
}
