/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_el extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "Φίτζι";
        final String metaValue_NU = "Νιούε";
        final String metaValue_TK = "Τοκελάου";
        final String metaValue_TV = "Τουβαλού";
        final String metaValue_ae = "Αβεστάν";
        final String metaValue_ban = "Μπαλινίζ";
        final String metaValue_zbl = "Σύμβολα Bliss";
        final String metaValue_ccp = "Τσάκμα";
        final String metaValue_chr = "Τσερόκι";
        final String metaValue_km = "Χμερ";
        final String metaValue_kn = "Κανάντα";
        final String metaValue_nqo = "Ν’Κο";
        final String metaValue_or = "Όντια";
        final String metaValue_te = "Τελούγκου";
        final String metaValue_vai = "Βάι";
        final String metaValue_ssy = "Σάχο";
        final Object[][] data = new Object[][] {
            { "001", "Κόσμος" },
            { "002", "Αφρική" },
            { "003", "Βόρεια Αμερική" },
            { "005", "Νότια Αμερική" },
            { "009", "Ωκεανία" },
            { "011", "Δυτική Αφρική" },
            { "013", "Κεντρική Αμερική" },
            { "014", "Ανατολική Αφρική" },
            { "015", "Βόρεια Αφρική" },
            { "017", "Μέση Αφρική" },
            { "018", "Νότιος Αφρική" },
            { "019", "Αμερική" },
            { "021", "Βόρειος Αμερική" },
            { "029", "Καραϊβική" },
            { "030", "Ανατολική Ασία" },
            { "034", "Νότια Ασία" },
            { "035", "Νοτιοανατολική Ασία" },
            { "039", "Νότια Ευρώπη" },
            { "053", "Αυστραλασία" },
            { "054", "Μελανησία" },
            { "057", "Περιοχή Μικρονησίας" },
            { "061", "Πολυνησία" },
            { "142", "Ασία" },
            { "143", "Κεντρική Ασία" },
            { "145", "Δυτική Ασία" },
            { "150", "Ευρώπη" },
            { "151", "Ανατολική Ευρώπη" },
            { "154", "Βόρεια Ευρώπη" },
            { "155", "Δυτική Ευρώπη" },
            { "202", "Υποσαχάρια Αφρική" },
            { "419", "Λατινική Αμερική" },
            { "AC", "Νήσος Ασενσιόν" },
            { "AD", "Ανδόρα" },
            { "AE", "Ηνωμένα Αραβικά Εμιράτα" },
            { "AF", "Αφγανιστάν" },
            { "AG", "Αντίγκουα και Μπαρμπούντα" },
            { "AI", "Ανγκουίλα" },
            { "AL", "Αλβανία" },
            { "AM", "Αρμενία" },
            { "AO", "Αγκόλα" },
            { "AQ", "Ανταρκτική" },
            { "AR", "Αργεντινή" },
            { "AS", "Αμερικανική Σαμόα" },
            { "AT", "Αυστρία" },
            { "AU", "Αυστραλία" },
            { "AW", "Αρούμπα" },
            { "AX", "Νήσοι Όλαντ" },
            { "AZ", "Αζερμπαϊτζάν" },
            { "BA", "Βοσνία - Ερζεγοβίνη" },
            { "BB", "Μπαρμπέιντος" },
            { "BD", "Μπανγκλαντές" },
            { "BE", "Βέλγιο" },
            { "BF", "Μπουρκίνα Φάσο" },
            { "BG", "Βουλγαρία" },
            { "BH", "Μπαχρέιν" },
            { "BI", "Μπουρούντι" },
            { "BJ", "Μπενίν" },
            { "BL", "Άγιος Βαρθολομαίος" },
            { "BM", "Βερμούδες" },
            { "BN", "Μπρουνέι" },
            { "BO", "Βολιβία" },
            { "BQ", "Ολλανδία Καραϊβικής" },
            { "BR", "Βραζιλία" },
            { "BS", "Μπαχάμες" },
            { "BT", "Μπουτάν" },
            { "BV", "Νήσος Μπουβέ" },
            { "BW", "Μποτσουάνα" },
            { "BY", "Λευκορωσία" },
            { "BZ", "Μπελίζ" },
            { "CA", "Καναδάς" },
            { "CC", "Νήσοι Κόκος (Κίλινγκ)" },
            { "CD", "Κονγκό - Κινσάσα" },
            { "CF", "Κεντροαφρικανική Δημοκρατία" },
            { "CG", "Κονγκό - Μπραζαβίλ" },
            { "CH", "Ελβετία" },
            { "CI", "Ακτή Ελεφαντοστού" },
            { "CK", "Νήσοι Κουκ" },
            { "CL", "Χιλή" },
            { "CM", "Καμερούν" },
            { "CN", "Κίνα" },
            { "CO", "Κολομβία" },
            { "CP", "Νήσος Κλίπερτον" },
            { "CQ", "Σαρκ" },
            { "CR", "Κόστα Ρίκα" },
            { "CU", "Κούβα" },
            { "CV", "Πράσινο Ακρωτήριο" },
            { "CW", "Κουρασάο" },
            { "CX", "Νήσος των Χριστουγέννων" },
            { "CY", "Κύπρος" },
            { "CZ", "Τσεχία" },
            { "DE", "Γερμανία" },
            { "DG", "Ντιέγκο Γκαρσία" },
            { "DJ", "Τζιμπουτί" },
            { "DK", "Δανία" },
            { "DM", "Ντομίνικα" },
            { "DO", "Δομινικανή Δημοκρατία" },
            { "DZ", "Αλγερία" },
            { "EA", "Θέουτα και Μελίγια" },
            { "EC", "Ισημερινός" },
            { "EE", "Εσθονία" },
            { "EG", "Αίγυπτος" },
            { "EH", "Δυτική Σαχάρα" },
            { "ER", "Ερυθραία" },
            { "ES", "Ισπανία" },
            { "ET", "Αιθιοπία" },
            { "EU", "Ευρωπαϊκή Ένωση" },
            { "EZ", "Ευρωζώνη" },
            { "FI", "Φινλανδία" },
            { "FJ", metaValue_FJ },
            { "FK", "Νήσοι Φόκλαντ" },
            { "FM", "Μικρονησία" },
            { "FO", "Νήσοι Φερόες" },
            { "FR", "Γαλλία" },
            { "GA", "Γκαμπόν" },
            { "GB", "Ηνωμένο Βασίλειο" },
            { "GD", "Γρενάδα" },
            { "GE", "Γεωργία" },
            { "GF", "Γαλλική Γουιάνα" },
            { "GG", "Γκέρνζι" },
            { "GH", "Γκάνα" },
            { "GI", "Γιβραλτάρ" },
            { "GL", "Γροιλανδία" },
            { "GM", "Γκάμπια" },
            { "GN", "Γουινέα" },
            { "GP", "Γουαδελούπη" },
            { "GQ", "Ισημερινή Γουινέα" },
            { "GR", "Ελλάδα" },
            { "GS", "Νήσοι Νότια Γεωργία και Νότιες Σάντουιτς" },
            { "GT", "Γουατεμάλα" },
            { "GU", "Γκουάμ" },
            { "GW", "Γουινέα Μπισάου" },
            { "GY", "Γουιάνα" },
            { "HK", "Χονγκ Κονγκ ΕΔΠ Κίνας" },
            { "HM", "Νήσοι Χερντ και Μακντόναλντ" },
            { "HN", "Ονδούρα" },
            { "HR", "Κροατία" },
            { "HT", "Αϊτή" },
            { "HU", "Ουγγαρία" },
            { "IC", "Κανάριοι Νήσοι" },
            { "ID", "Ινδονησία" },
            { "IE", "Ιρλανδία" },
            { "IL", "Ισραήλ" },
            { "IM", "Νήσος του Μαν" },
            { "IN", "Ινδία" },
            { "IO", "Βρετανικά Εδάφη Ινδικού Ωκεανού" },
            { "IQ", "Ιράκ" },
            { "IR", "Ιράν" },
            { "IS", "Ισλανδία" },
            { "IT", "Ιταλία" },
            { "JE", "Τζέρζι" },
            { "JM", "Τζαμάικα" },
            { "JO", "Ιορδανία" },
            { "JP", "Ιαπωνία" },
            { "KE", "Κένυα" },
            { "KG", "Κιργιστάν" },
            { "KH", "Καμπότζη" },
            { "KI", "Κιριμπάτι" },
            { "KM", "Κομόρες" },
            { "KN", "Σεν Κιτς και Νέβις" },
            { "KP", "Βόρεια Κορέα" },
            { "KR", "Νότια Κορέα" },
            { "KW", "Κουβέιτ" },
            { "KY", "Νήσοι Κέιμαν" },
            { "KZ", "Καζακστάν" },
            { "LA", "Λάος" },
            { "LB", "Λίβανος" },
            { "LC", "Αγία Λουκία" },
            { "LI", "Λιχτενστάιν" },
            { "LK", "Σρι Λάνκα" },
            { "LR", "Λιβερία" },
            { "LS", "Λεσότο" },
            { "LT", "Λιθουανία" },
            { "LU", "Λουξεμβούργο" },
            { "LV", "Λετονία" },
            { "LY", "Λιβύη" },
            { "MA", "Μαρόκο" },
            { "MC", "Μονακό" },
            { "MD", "Μολδαβία" },
            { "ME", "Μαυροβούνιο" },
            { "MF", "Άγιος Μαρτίνος (Γαλλικό τμήμα)" },
            { "MG", "Μαδαγασκάρη" },
            { "MH", "Νήσοι Μάρσαλ" },
            { "MK", "Βόρεια Μακεδονία" },
            { "ML", "Μάλι" },
            { "MM", "Μιανμάρ (Βιρμανία)" },
            { "MN", "Μογγολία" },
            { "MO", "Μακάο ΕΔΠ Κίνας" },
            { "MP", "Νήσοι Βόρειες Μαριάνες" },
            { "MQ", "Μαρτινίκα" },
            { "MR", "Μαυριτανία" },
            { "MS", "Μονσεράτ" },
            { "MT", "Μάλτα" },
            { "MU", "Μαυρίκιος" },
            { "MV", "Μαλδίβες" },
            { "MW", "Μαλάουι" },
            { "MX", "Μεξικό" },
            { "MY", "Μαλαισία" },
            { "MZ", "Μοζαμβίκη" },
            { "NA", "Ναμίμπια" },
            { "NC", "Νέα Καληδονία" },
            { "NE", "Νίγηρας" },
            { "NF", "Νήσος Νόρφολκ" },
            { "NG", "Νιγηρία" },
            { "NI", "Νικαράγουα" },
            { "NL", "Κάτω Χώρες" },
            { "NO", "Νορβηγία" },
            { "NP", "Νεπάλ" },
            { "NR", "Ναουρού" },
            { "NU", metaValue_NU },
            { "NZ", "Νέα Ζηλανδία" },
            { "OM", "Ομάν" },
            { "PA", "Παναμάς" },
            { "PE", "Περού" },
            { "PF", "Γαλλική Πολυνησία" },
            { "PG", "Παπούα Νέα Γουινέα" },
            { "PH", "Φιλιππίνες" },
            { "PK", "Πακιστάν" },
            { "PL", "Πολωνία" },
            { "PM", "Σεν Πιερ και Μικελόν" },
            { "PN", "Νήσοι Πίτκερν" },
            { "PR", "Πουέρτο Ρίκο" },
            { "PS", "Παλαιστινιακά Εδάφη" },
            { "PT", "Πορτογαλία" },
            { "PW", "Παλάου" },
            { "PY", "Παραγουάη" },
            { "QA", "Κατάρ" },
            { "QO", "Περιφερειακή Ωκεανία" },
            { "RE", "Ρεϊνιόν" },
            { "RO", "Ρουμανία" },
            { "RS", "Σερβία" },
            { "RU", "Ρωσία" },
            { "RW", "Ρουάντα" },
            { "SA", "Σαουδική Αραβία" },
            { "SB", "Νήσοι Σολομώντος" },
            { "SC", "Σεϋχέλλες" },
            { "SD", "Σουδάν" },
            { "SE", "Σουηδία" },
            { "SG", "Σιγκαπούρη" },
            { "SH", "Αγία Ελένη" },
            { "SI", "Σλοβενία" },
            { "SJ", "Σβάλμπαρντ και Γιαν Μαγιέν" },
            { "SK", "Σλοβακία" },
            { "SL", "Σιέρα Λεόνε" },
            { "SM", "Άγιος Μαρίνος" },
            { "SN", "Σενεγάλη" },
            { "SO", "Σομαλία" },
            { "SR", "Σουρινάμ" },
            { "SS", "Νότιο Σουδάν" },
            { "ST", "Σάο Τομέ και Πρίνσιπε" },
            { "SV", "Ελ Σαλβαδόρ" },
            { "SX", "Άγιος Μαρτίνος (Ολλανδικό τμήμα)" },
            { "SY", "Συρία" },
            { "SZ", "Εσουατίνι" },
            { "TA", "Τριστάν ντα Κούνια" },
            { "TC", "Νήσοι Τερκς και Κάικος" },
            { "TD", "Τσαντ" },
            { "TF", "Γαλλικά Νότια Εδάφη" },
            { "TG", "Τόγκο" },
            { "TH", "Ταϊλάνδη" },
            { "TJ", "Τατζικιστάν" },
            { "TK", metaValue_TK },
            { "TL", "Τιμόρ-Λέστε" },
            { "TM", "Τουρκμενιστάν" },
            { "TN", "Τυνησία" },
            { "TO", "Τόνγκα" },
            { "TR", "Τουρκία" },
            { "TT", "Τρινιντάντ και Τομπάγκο" },
            { "TV", metaValue_TV },
            { "TW", "Ταϊβάν" },
            { "TZ", "Τανζανία" },
            { "UA", "Ουκρανία" },
            { "UG", "Ουγκάντα" },
            { "UM", "Απομακρυσμένες Νησίδες ΗΠΑ" },
            { "UN", "Ηνωμένα Έθνη" },
            { "US", "Ηνωμένες Πολιτείες" },
            { "UY", "Ουρουγουάη" },
            { "UZ", "Ουζμπεκιστάν" },
            { "VA", "Βατικανό" },
            { "VC", "Άγιος Βικέντιος και Γρεναδίνες" },
            { "VE", "Βενεζουέλα" },
            { "VG", "Βρετανικές Παρθένες Νήσοι" },
            { "VI", "Αμερικανικές Παρθένες Νήσοι" },
            { "VN", "Βιετνάμ" },
            { "VU", "Βανουάτου" },
            { "WF", "Γουάλις και Φουτούνα" },
            { "WS", "Σαμόα" },
            { "XA", "Ψευδο-προφορές" },
            { "XB", "Ψευδο-αμφικατευθυντικό" },
            { "XK", "Κοσσυφοπέδιο" },
            { "YE", "Υεμένη" },
            { "YT", "Μαγιότ" },
            { "ZA", "Νότια Αφρική" },
            { "ZM", "Ζάμπια" },
            { "ZW", "Ζιμπάμπουε" },
            { "ZZ", "Άγνωστη περιοχή" },
            { "aa", "Αφάρ" },
            { "ab", "Αμπχαζικά" },
            { "ae", metaValue_ae },
            { "af", "Αφρικάανς" },
            { "ak", "Ακάν" },
            { "am", "Αμχαρικά" },
            { "an", "Αραγονικά" },
            { "ar", "Αραβικά" },
            { "as", "Ασαμικά" },
            { "av", "Αβαρικά" },
            { "ay", "Αϊμάρα" },
            { "az", "Αζερμπαϊτζανικά" },
            { "ba", "Μπασκίρ" },
            { "be", "Λευκορωσικά" },
            { "bg", "Βουλγαρικά" },
            { "bi", "Μπισλάμα" },
            { "bm", "Μπαμπάρα" },
            { "bn", "Βεγγαλικά" },
            { "bo", "Θιβετιανά" },
            { "br", "Βρετονικά" },
            { "bs", "Βοσνιακά" },
            { "ca", "Καταλανικά" },
            { "ce", "Τσετσενικά" },
            { "ch", "Τσαμόρο" },
            { "co", "Κορσικανικά" },
            { "cr", "Κρι" },
            { "cs", "Τσεχικά" },
            { "cu", "Εκκλησιαστικά Σλαβικά" },
            { "cv", "Τσουβασικά" },
            { "cy", "Ουαλικά" },
            { "da", "Δανικά" },
            { "de", "Γερμανικά" },
            { "dv", "Ντιβέχι" },
            { "dz", "Ντζόνγκχα" },
            { "ee", "Έουε" },
            { "el", "Ελληνικά" },
            { "en", "Αγγλικά" },
            { "eo", "Εσπεράντο" },
            { "es", "Ισπανικά" },
            { "et", "Εσθονικά" },
            { "eu", "Βασκικά" },
            { "fa", "Περσικά" },
            { "ff", "Φουλά" },
            { "fi", "Φινλανδικά" },
            { "fj", metaValue_FJ },
            { "fo", "Φεροϊκά" },
            { "fr", "Γαλλικά" },
            { "fy", "Δυτικά Φριζικά" },
            { "ga", "Ιρλανδικά" },
            { "gd", "Σκωτικά Κελτικά" },
            { "gl", "Γαλικιανά" },
            { "gn", "Γκουαρανί" },
            { "gu", "Γκουτζαρατικά" },
            { "gv", "Μανξ" },
            { "ha", "Χάουσα" },
            { "he", "Εβραϊκά" },
            { "hi", "Χίντι" },
            { "ho", "Χίρι Μότου" },
            { "hr", "Κροατικά" },
            { "ht", "Αϊτιανά" },
            { "hu", "Ουγγρικά" },
            { "hy", "Αρμενικά" },
            { "hz", "Χερέρο" },
            { "ia", "Ιντερλίνγκουα" },
            { "id", "Ινδονησιακά" },
            { "ie", "Ιντερλίνγκουε" },
            { "ig", "Ίγκμπο" },
            { "ii", "Σίτσουαν Γι" },
            { "ik", "Ινουπιάκ" },
            { "io", "Ίντο" },
            { "is", "Ισλανδικά" },
            { "it", "Ιταλικά" },
            { "iu", "Ινούκτιτουτ" },
            { "ja", "Ιαπωνικά" },
            { "jv", "Ιαβανικά" },
            { "ka", "Γεωργιανά" },
            { "kg", "Κονγκό" },
            { "ki", "Κικούγιου" },
            { "kj", "Κουανιάμα" },
            { "kk", "Καζακικά" },
            { "kl", "Καλαάλισουτ" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "Κορεατικά" },
            { "kr", "Κανούρι" },
            { "ks", "Κασμιρικά" },
            { "ku", "Κουρμάντζι" },
            { "kv", "Κόμι" },
            { "kw", "Κορνουαλικά" },
            { "ky", "Κιργιζικά" },
            { "la", "Λατινικά" },
            { "lb", "Λουξεμβουργιανά" },
            { "lg", "Γκάντα" },
            { "li", "Λιμβουργιανά" },
            { "ln", "Λινγκάλα" },
            { "lo", "Λαοτινά" },
            { "lt", "Λιθουανικά" },
            { "lu", "Λούμπα-Κατάνγκα" },
            { "lv", "Λετονικά" },
            { "mg", "Μαλγασικά" },
            { "mh", "Μαρσαλέζικα" },
            { "mi", "Μαορί" },
            { "mk", "Σλαβομακεδονικά" },
            { "ml", "Μαλαγιαλαμικά" },
            { "mn", "Μογγολικά" },
            { "mr", "Μαραθικά" },
            { "ms", "Μαλαισιανά" },
            { "mt", "Μαλτεζικά" },
            { "my", "Βιρμανικά" },
            { "na", "Ναούρου" },
            { "nb", "Νορβηγικά Μποκμάλ" },
            { "nd", "Βόρεια Ντεμπέλε" },
            { "ne", "Νεπαλικά" },
            { "ng", "Ντόνγκα" },
            { "nl", "Ολλανδικά" },
            { "nn", "Νορβηγικά Νινόρσκ" },
            { "no", "Νορβηγικά" },
            { "nr", "Νότια Ντεμπέλε" },
            { "nv", "Νάβαχο" },
            { "ny", "Νιάντζα" },
            { "oc", "Οξιτανικά" },
            { "oj", "Οζιβίγουα" },
            { "om", "Ορόμο" },
            { "or", metaValue_or },
            { "os", "Οσετικά" },
            { "pa", "Παντζαπικά" },
            { "pi", "Πάλι" },
            { "pl", "Πολωνικά" },
            { "ps", "Πάστο" },
            { "pt", "Πορτογαλικά" },
            { "qu", "Κέτσουα" },
            { "rm", "Ρομανικά" },
            { "rn", "Ρούντι" },
            { "ro", "Ρουμανικά" },
            { "ru", "Ρωσικά" },
            { "rw", "Κινιαρουάντα" },
            { "sa", "Σανσκριτικά" },
            { "sc", "Σαρδηνιακά" },
            { "sd", "Σίντι" },
            { "se", "Βόρεια Σάμι" },
            { "sg", "Σάνγκο" },
            { "sh", "Σερβοκροατικά" },
            { "si", "Σινχαλεζικά" },
            { "sk", "Σλοβακικά" },
            { "sl", "Σλοβενικά" },
            { "sm", "Σαμοανά" },
            { "sn", "Σόνα" },
            { "so", "Σομαλικά" },
            { "sq", "Αλβανικά" },
            { "sr", "Σερβικά" },
            { "ss", "Σουάτι" },
            { "st", "Νότια Σόθο" },
            { "su", "Σουνδανικά" },
            { "sv", "Σουηδικά" },
            { "sw", "Σουαχίλι" },
            { "ta", "Ταμιλικά" },
            { "te", metaValue_te },
            { "tg", "Τατζικικά" },
            { "th", "Ταϊλανδικά" },
            { "ti", "Τιγκρινικά" },
            { "tk", "Τουρκμενικά" },
            { "tl", "Τάγκαλογκ" },
            { "tn", "Τσουάνα" },
            { "to", "Τονγκανικά" },
            { "tr", "Τουρκικά" },
            { "ts", "Τσόνγκα" },
            { "tt", "Ταταρικά" },
            { "tw", "Τούι" },
            { "ty", "Ταϊτιανά" },
            { "ug", "Ουιγουρικά" },
            { "uk", "Ουκρανικά" },
            { "ur", "Ούρντου" },
            { "uz", "Ουζμπεκικά" },
            { "ve", "Βέντα" },
            { "vi", "Βιετναμικά" },
            { "vo", "Βολαπιούκ" },
            { "wa", "Βαλλωνικά" },
            { "wo", "Γουόλοφ" },
            { "xh", "Κόσα" },
            { "yi", "Γίντις" },
            { "yo", "Γιορούμπα" },
            { "za", "Ζουάνγκ" },
            { "zh", "Κινεζικά" },
            { "zu", "Ζουλού" },
            { "ace", "Ατσινιζικά" },
            { "ach", "Ακολί" },
            { "ada", "Αντάνγκμε" },
            { "ady", "Αντιγκέα" },
            { "afh", "Αφριχίλι" },
            { "agq", "Αγκέμ" },
            { "ain", "Αϊνού" },
            { "akk", "Ακάντιαν" },
            { "ale", "Αλεούτ" },
            { "alt", "Νότια Αλτάι" },
            { "ang", "Παλαιά Αγγλικά" },
            { "ann", "Ομπόλο" },
            { "anp", "Ανγκικά" },
            { "arc", "Αραμαϊκά" },
            { "arn", "Αραουκανικά" },
            { "arp", "Αραπάχο" },
            { "ars", "Αραβικά Νάτζντι" },
            { "arw", "Αραγουάκ" },
            { "asa", "Άσου" },
            { "ast", "Αστουριανά" },
            { "atj", "Ατικαμέκ" },
            { "awa", "Αγουαντί" },
            { "bal", "Μπαλούτσι" },
            { "ban", metaValue_ban },
            { "bas", "Μπάσα" },
            { "bax", "Μπαμούν" },
            { "bbj", "Γκομάλα" },
            { "bej", "Μπέζα" },
            { "bem", "Μπέμπα" },
            { "bez", "Μπένα" },
            { "bfd", "Μπαφούτ" },
            { "bgc", "Χαργιάνβι" },
            { "bgn", "Δυτικά Μπαλοχικά" },
            { "bho", "Μπότζπουρι" },
            { "bik", "Μπικόλ" },
            { "bin", "Μπίνι" },
            { "bkm", "Κομ" },
            { "bla", "Σικσίκα" },
            { "blo", "Ανίι" },
            { "bra", "Μπρατζ" },
            { "brx", "Μπόντο" },
            { "bss", "Ακόσι" },
            { "bua", "Μπουριάτ" },
            { "bug", "Μπουγκίζ" },
            { "bum", "Μπουλού" },
            { "byn", "Μπλιν" },
            { "byv", "Μεντούμπα" },
            { "cad", "Κάντο" },
            { "car", "Καρίμπ" },
            { "cay", "Καγιούγκα" },
            { "cch", "Ατσάμ" },
            { "ccp", metaValue_ccp },
            { "ceb", "Σεμπουάνο" },
            { "cgg", "Τσίγκα" },
            { "chb", "Τσίμπτσα" },
            { "chg", "Τσαγκατάι" },
            { "chk", "Τσουκίζι" },
            { "chm", "Μάρι" },
            { "chn", "Ιδιωματικά Σινούκ" },
            { "cho", "Τσόκτο" },
            { "chp", "Τσίπιουαν" },
            { "chr", metaValue_chr },
            { "chy", "Τσεγιέν" },
            { "ckb", "Κεντρικά Κουρδικά" },
            { "clc", "Τσιλκότιν" },
            { "cop", "Κοπτικά" },
            { "crg", "Μίτσιφ" },
            { "crh", "Τουρκικά Κριμαίας" },
            { "crj", "Νοτιοανατολικά Κρι" },
            { "crk", "Κρι πεδιάδας" },
            { "crl", "Βορειοανατολικά Κρι" },
            { "crm", "Μους Κρι" },
            { "crr", "Καρολίνα Αλγκονκιάν" },
            { "crs", "Κρεολικά Γαλλικά Σεϋχελλών" },
            { "csb", "Κασούμπιαν" },
            { "csw", "Κρι Βάλτου" },
            { "dak", "Ντακότα" },
            { "dar", "Ντάργκουα" },
            { "dav", "Τάιτα" },
            { "del", "Ντέλαγουερ" },
            { "den", "Σλαβικά" },
            { "dgr", "Ντόγκριμπ" },
            { "din", "Ντίνκα" },
            { "dje", "Ζάρμα" },
            { "doi", "Ντόγκρι" },
            { "dsb", "Κάτω Σορβικά" },
            { "dua", "Ντουάλα" },
            { "dum", "Μέσα Ολλανδικά" },
            { "dyo", "Τζόλα-Φόνι" },
            { "dyu", "Ντογιούλα" },
            { "dzg", "Νταζάγκα" },
            { "ebu", "Έμπου" },
            { "efi", "Εφίκ" },
            { "egy", "Αρχαία Αιγυπτιακά" },
            { "eka", "Εκατζούκ" },
            { "elx", "Ελαμάιτ" },
            { "enm", "Μέσα Αγγλικά" },
            { "ewo", "Εγουόντο" },
            { "fan", "Φανγκ" },
            { "fat", "Φάντι" },
            { "fil", "Φιλιππινικά" },
            { "fon", "Φον" },
            { "frc", "Γαλλικά (Λουιζιάνα)" },
            { "frm", "Μέσα Γαλλικά" },
            { "fro", "Παλαιά Γαλλικά" },
            { "frr", "Βόρεια Φριζιανά" },
            { "frs", "Ανατολικά Φριζιανά" },
            { "fur", "Φριουλανικά" },
            { "gaa", "Γκα" },
            { "gag", "Γκαγκάουζ" },
            { "gay", "Γκάγιο" },
            { "gba", "Γκμπάγια" },
            { "gez", "Γκιζ" },
            { "gil", "Γκιλμπερτίζ" },
            { "gmh", "Μέσα Άνω Γερμανικά" },
            { "goh", "Παλαιά Άνω Γερμανικά" },
            { "gon", "Γκόντι" },
            { "gor", "Γκοροντάλο" },
            { "got", "Γοτθικά" },
            { "grb", "Γκρίμπο" },
            { "grc", "Αρχαία Ελληνικά" },
            { "gsw", "Γερμανικά Ελβετίας" },
            { "guz", "Γκούσι" },
            { "gwi", "Γκουίτσιν" },
            { "hai", "Χάιντα" },
            { "haw", "Χαβαϊκά" },
            { "hax", "Βόρεια Χάιντα" },
            { "hil", "Χιλιγκαϊνόν" },
            { "hit", "Χιτίτε" },
            { "hmn", "Χμονγκ" },
            { "hsb", "Άνω Σορβικά" },
            { "hup", "Χούπα" },
            { "hur", "Χαλκομελέμ" },
            { "iba", "Ιμπάν" },
            { "ibb", "Ιμπίμπιο" },
            { "ikt", "Ινουκτιτούτ Δυτικού Καναδά" },
            { "ilo", "Ιλόκο" },
            { "inh", "Ινγκούς" },
            { "jbo", "Λόζμπαν" },
            { "jgo", "Νγκόμπα" },
            { "jmc", "Ματσάμε" },
            { "jpr", "Ιουδαϊκά-Περσικά" },
            { "jrb", "Ιουδαϊκά-Αραβικά" },
            { "kaa", "Κάρα-Καλπάκ" },
            { "kab", "Καμπίλε" },
            { "kac", "Κατσίν" },
            { "kaj", "Τζου" },
            { "kam", "Κάμπα" },
            { "kaw", "Κάουι" },
            { "kbd", "Καμπαρντιανά" },
            { "kbl", "Κανέμπου" },
            { "kcg", "Τιάπ" },
            { "kde", "Μακόντε" },
            { "kea", "Γλώσσα του Πράσινου Ακρωτηρίου" },
            { "kfo", "Κόρο" },
            { "kgp", "Κάινγκανγκ" },
            { "kha", "Κάσι" },
            { "kho", "Κοτανικά" },
            { "khq", "Κόιρα Τσίνι" },
            { "kkj", "Κάκο" },
            { "kln", "Καλεντζίν" },
            { "kmb", "Κιμπούντου" },
            { "koi", "Κόμι-Περμιάκ" },
            { "kok", "Κονκανικά" },
            { "kos", "Κοσραενικά" },
            { "kpe", "Κπέλε" },
            { "krc", "Καρατσάι-Μπαλκάρ" },
            { "krl", "Καρελικά" },
            { "kru", "Κουρούχ" },
            { "ksb", "Σαμπάλα" },
            { "ksf", "Μπάφια" },
            { "ksh", "Κολωνικά" },
            { "kum", "Κουμγιούκ" },
            { "kut", "Κουτενάι" },
            { "kwk", "Κουακουάλα" },
            { "kxv", "Κούβι" },
            { "lad", "Λαδίνο" },
            { "lag", "Λάνγκι" },
            { "lah", "Λάχδα" },
            { "lam", "Λάμπα" },
            { "lez", "Λεζγκικά" },
            { "lij", "Λιγουριανά" },
            { "lil", "Λιλουέτ" },
            { "lkt", "Λακότα" },
            { "lmo", "Λομβαρδικά" },
            { "lol", "Μόνγκο" },
            { "lou", "Κρεολικά (Λουιζιάνα)" },
            { "loz", "Λόζι" },
            { "lrc", "Βόρεια Λούρι" },
            { "lsm", "Σαάμια" },
            { "lua", "Λούμπα-Λουλούα" },
            { "lui", "Λουισένο" },
            { "lun", "Λούντα" },
            { "luo", "Λούο" },
            { "lus", "Μίζο" },
            { "luy", "Λούχια" },
            { "mad", "Μαντουρίζ" },
            { "maf", "Μάφα" },
            { "mag", "Μαγκάχι" },
            { "mai", "Μαϊτχίλι" },
            { "mak", "Μακασάρ" },
            { "man", "Μαντίνγκο" },
            { "mas", "Μασάι" },
            { "mde", "Μάμπα" },
            { "mdf", "Μόκσα" },
            { "mdr", "Μανδάρ" },
            { "men", "Μέντε" },
            { "mer", "Μέρου" },
            { "mfe", "Μορισιέν" },
            { "mga", "Μέσα Ιρλανδικά" },
            { "mgh", "Μακούβα-Μέτο" },
            { "mgo", "Μέτα" },
            { "mic", "Μικμάκ" },
            { "min", "Μινανγκαμπάου" },
            { "mnc", "Μαντσού" },
            { "mni", "Μανιπούρι" },
            { "moe", "Ινου-αϊμούν" },
            { "moh", "Μοχόκ" },
            { "mos", "Μόσι" },
            { "mua", "Μουντάνγκ" },
            { "mul", "Πολλαπλές γλώσσες" },
            { "mus", "Κρικ" },
            { "mwl", "Μιραντεζικά" },
            { "mwr", "Μαργουάρι" },
            { "mye", "Μιένε" },
            { "myv", "Έρζια" },
            { "mzn", "Μαζαντεράνι" },
            { "nan", "Μιν Ναν" },
            { "nap", "Ναπολιτανικά" },
            { "naq", "Νάμα" },
            { "nds", "Κάτω Γερμανικά" },
            { "new", "Νεγουάρι" },
            { "nia", "Νίας" },
            { "niu", metaValue_NU },
            { "nmg", "Κβάσιο" },
            { "nnh", "Νγκιεμπούν" },
            { "nog", "Νογκάι" },
            { "non", "Παλαιά Νορβηγικά" },
            { "nqo", metaValue_nqo },
            { "nso", "Βόρεια Σόθο" },
            { "nus", "Νούερ" },
            { "nwc", "Κλασικά Νεουάρι" },
            { "nym", "Νιαμγουέζι" },
            { "nyn", "Νιανκόλε" },
            { "nyo", "Νιόρο" },
            { "nzi", "Νζίμα" },
            { "ojb", "Βορειοδυτικά Οζιβίγουα" },
            { "ojc", "Κεντρικά Οτζίμπουα" },
            { "ojs", "Ότζι-Κρι" },
            { "ojw", "Δυτικά Οζιβίγουα" },
            { "oka", "Οκανάγκαν" },
            { "osa", "Οσάζ" },
            { "ota", "Οθωμανικά Τουρκικά" },
            { "pag", "Πανγκασινάν" },
            { "pal", "Παχλάβι" },
            { "pam", "Παμπάνγκα" },
            { "pap", "Παπιαμέντο" },
            { "pau", "Παλάουαν" },
            { "pcm", "Πίτζιν Νιγηρίας" },
            { "peo", "Αρχαία Περσικά" },
            { "phn", "Φοινικικά" },
            { "pis", "Πιτζίν" },
            { "pon", "Πομπηικά" },
            { "pqm", "Μαλισιτ-Πασσαμακουόντ" },
            { "prg", "Πρωσικά" },
            { "pro", "Παλαιά Προβανσάλ" },
            { "quc", "Κιτσέ" },
            { "raj", "Ραζασθάνι" },
            { "rap", "Ραπανούι" },
            { "rar", "Ραροτονγκάν" },
            { "rhg", "Ροχίνγκια" },
            { "rof", "Ρόμπο" },
            { "rom", "Ρομανί" },
            { "rup", "Αρομανικά" },
            { "rwk", "Ρουά" },
            { "sad", "Σαντάγουε" },
            { "sah", "Σαχά" },
            { "sam", "Σαμαρίτικα Αραμαϊκά" },
            { "saq", "Σαμπούρου" },
            { "sas", "Σασάκ" },
            { "sat", "Σαντάλι" },
            { "sba", "Νγκαμπέι" },
            { "sbp", "Σάνγκου" },
            { "scn", "Σικελικά" },
            { "sco", "Σκωτικά" },
            { "sdh", "Νότια Κουρδικά" },
            { "see", "Σένεκα" },
            { "seh", "Σένα" },
            { "sel", "Σελκούπ" },
            { "ses", "Κοϊραμπόρο Σένι" },
            { "sga", "Παλαιά Ιρλανδικά" },
            { "shi", "Τασελχίτ" },
            { "shn", "Σαν" },
            { "shu", "Αραβικά του Τσαντ" },
            { "sid", "Σιντάμο" },
            { "slh", "Νότια Λάσουτσιντ" },
            { "sma", "Νότια Σάμι" },
            { "smj", "Λούλε Σάμι" },
            { "smn", "Ινάρι Σάμι" },
            { "sms", "Σκολτ Σάμι" },
            { "snk", "Σονίνκε" },
            { "sog", "Σογκντιέν" },
            { "srn", "Σρανάν Τόνγκο" },
            { "srr", "Σερέρ" },
            { "ssy", metaValue_ssy },
            { "str", "Στρέιτς Σαλίς" },
            { "suk", "Σουκούμα" },
            { "sus", "Σούσου" },
            { "sux", "Σουμερικά" },
            { "swb", "Κομοριανά" },
            { "syc", "Κλασικά Συριακά" },
            { "syr", "Συριακά" },
            { "szl", "Σιλεσικά" },
            { "tce", "Νότια Τουτσόνε" },
            { "tem", "Τίμνε" },
            { "teo", "Τέσο" },
            { "ter", "Τερένο" },
            { "tet", "Τέτουμ" },
            { "tgx", "Τατζίς" },
            { "tht", "Ταλτάν" },
            { "tig", "Τίγκρε" },
            { "tiv", "Τιβ" },
            { "tkl", metaValue_TK },
            { "tlh", "Κλίνγκον" },
            { "tli", "Τλίνγκιτ" },
            { "tmh", "Ταμασέκ" },
            { "tog", "Νιάσα Τόνγκα" },
            { "tok", "Τόκι Πόνα" },
            { "tpi", "Τοκ Πισίν" },
            { "trv", "Ταρόκο" },
            { "tsi", "Τσίμσιαν" },
            { "ttm", "Βόρεια Τουτσόνε" },
            { "tum", "Τουμπούκα" },
            { "tvl", metaValue_TV },
            { "twq", "Τασαβάκ" },
            { "tyv", "Τουβινικά" },
            { "tzm", "Ταμαζίτ Κεντρικού Μαρόκο" },
            { "udm", "Ουντμούρτ" },
            { "uga", "Ουγκαριτικά" },
            { "umb", "Ουμπούντου" },
            { "und", "Άγνωστη γλώσσα" },
            { "vai", metaValue_vai },
            { "vec", "Βενετικά" },
            { "vmw", "Μακούα" },
            { "vot", "Βότικ" },
            { "vun", "Βούντζο" },
            { "wae", "Βάλσερ" },
            { "wal", "Γουολάιτα" },
            { "war", "Γουάραϊ" },
            { "was", "Γουασό" },
            { "wbp", "Γουαρλπίρι" },
            { "wuu", "Κινεζικά Γου" },
            { "xal", "Καλμίκ" },
            { "xnr", "Κάνγκρι" },
            { "xog", "Σόγκα" },
            { "yao", "Γιάο" },
            { "yap", "Γιαπίζ" },
            { "yav", "Γιανγκμπέν" },
            { "ybb", "Γιέμπα" },
            { "yrl", "Νινγκατού" },
            { "yue", "Καντονέζικα" },
            { "zap", "Ζάποτεκ" },
            { "zbl", metaValue_zbl },
            { "zen", "Ζενάγκα" },
            { "zgh", "Τυπικά Ταμαζίτ Μαρόκου" },
            { "zun", "Ζούνι" },
            { "zxx", "Χωρίς γλωσσολογικό περιεχόμενο" },
            { "zza", "Ζάζα" },
            { "Adlm", "Άντλαμ" },
            { "Arab", "Αραβικό" },
            { "Aran", "Νασταλίκ" },
            { "Armi", "Αυτοκρατορικό Αραμαϊκό" },
            { "Armn", "Αρμενικό" },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "Μπατάκ" },
            { "Beng", "Μπενγκάλι" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Μποπομόφο" },
            { "Brah", "Μπραχμί" },
            { "Brai", "Μπράιγ" },
            { "Bugi", "Μπούγκις" },
            { "Buhd", "Μπουχίντ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Ενοποιημένοι Καναδεζικοί Συλλαβισμοί Ιθαγενών" },
            { "Cari", "Καριάν" },
            { "Cham", "Τσαμ" },
            { "Cher", metaValue_chr },
            { "Cirt", "Σερθ" },
            { "Copt", "Κοπτικό" },
            { "Cprt", "Κυπριακό" },
            { "Cyrl", "Κυριλλικό" },
            { "Cyrs", "Παλαιό Εκκλησιαστικό Σλαβικό Κυριλλικό" },
            { "Deva", "Ντεβαναγκάρι" },
            { "Dsrt", "Ντεσερέ" },
            { "Egyd", "Λαϊκό Αιγυπτιακό" },
            { "Egyh", "Ιερατικό Αιγυπτιακό" },
            { "Egyp", "Αιγυπτιακά Ιερογλυφικά" },
            { "Ethi", "Αιθιοπικό" },
            { "Geok", "Γεωργιανό Κχουτσούρι" },
            { "Geor", "Γεωργιανό" },
            { "Glag", "Γκλαγκολιτικό" },
            { "Goth", "Γοτθικό" },
            { "Grek", "Ελληνικό" },
            { "Gujr", "Γκουγιαράτι" },
            { "Guru", "Γκουρμουκχί" },
            { "Hanb", "Χανμπ" },
            { "Hang", "Χανγκούλ" },
            { "Hani", "Χαν" },
            { "Hano", "Χανούνου" },
            { "Hans", "Απλοποιημένο" },
            { "Hant", "Παραδοσιακό" },
            { "Hebr", "Εβραϊκό" },
            { "Hira", "Χιραγκάνα" },
            { "Hmng", "Παχάχ Χμονγκ" },
            { "Hrkt", "Κατακάνα ή Χιραγκάνα" },
            { "Hung", "Παλαιό Ουγγρικό" },
            { "Inds", "Ίνδους" },
            { "Ital", "Παλαιό Ιταλικό" },
            { "Jamo", "Τζάμο" },
            { "Java", "Ιαβανεζικό" },
            { "Jpan", "Ιαπωνικό" },
            { "Kali", "Καγιάχ Λι" },
            { "Kana", "Κατακάνα" },
            { "Khar", "Καρόσθι" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", "Κορεατικό" },
            { "Kthi", "Καϊθί" },
            { "Lana", "Λάννα" },
            { "Laoo", "Λαοτινό" },
            { "Latf", "Φράκτουρ Λατινικό" },
            { "Latg", "Γαελικό Λατινικό" },
            { "Latn", "Λατινικό" },
            { "Lepc", "Λέπτσα" },
            { "Limb", "Λιμπού" },
            { "Lina", "Γραμμικό Α" },
            { "Linb", "Γραμμικό Β" },
            { "Lyci", "Λυκιανικό" },
            { "Lydi", "Λυδιανικό" },
            { "Mand", "Μανδαϊκό" },
            { "Mani", "Μανιχαϊκό" },
            { "Maya", "Ιερογλυφικά Μάγια" },
            { "Mero", "Μεροϊτικό" },
            { "Mlym", "Μαλαγιάλαμ" },
            { "Mong", "Μογγολικό" },
            { "Moon", "Μουν" },
            { "Mtei", "Μεϊτέι Μάγεκ" },
            { "Mymr", "Μιανμάρ" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "Όγκχαμ" },
            { "Olck", "Ολ Τσίκι" },
            { "Orkh", "Όρκχον" },
            { "Orya", metaValue_or },
            { "Osma", "Οσμάνγια" },
            { "Perm", "Παλαιό Περμικό" },
            { "Phag", "Παγκς-πα" },
            { "Phli", "Επιγραφικό Παχλάβι" },
            { "Phlp", "Ψάλτερ Παχλάβι" },
            { "Phlv", "Μπουκ Παχλαβί" },
            { "Phnx", "Φοινικικό" },
            { "Plrd", "Φωνητικό Πόλαρντ" },
            { "Prti", "Επιγραφικό Παρθιάν" },
            { "Rjng", "Ρετζάνγκ" },
            { "Rohg", "Χανίφι" },
            { "Roro", "Ρονγκορόνγκο" },
            { "Runr", "Ρουνίκ" },
            { "Samr", "Σαμαριτικό" },
            { "Sara", "Σαράθι" },
            { "Saur", "Σαουράστρα" },
            { "Sgnw", "Νοηματική γραφή" },
            { "Shaw", "Σαβιανό" },
            { "Sinh", "Σινχάλα" },
            { "Sund", "Σουνδανικό" },
            { "Sylo", "Συλότι Νάγκρι" },
            { "Syrc", "Συριακό" },
            { "Syre", "Εστραντζέλο Συριακό" },
            { "Syrj", "Δυτικό Συριακό" },
            { "Syrn", "Ανατολικό Συριακό" },
            { "Tagb", "Ταγκμάνγουα" },
            { "Tale", "Τάι Λε" },
            { "Talu", "Νέο Τάι Λούε" },
            { "Taml", "Ταμίλ" },
            { "Tavt", "Τάι Βιέτ" },
            { "Telu", metaValue_te },
            { "Teng", "Τεγνγουάρ" },
            { "Tfng", "Τιφινάγκ" },
            { "Tglg", "Ταγκαλόγκ" },
            { "Thaa", "Θαανά" },
            { "Thai", "Ταϊλανδικό" },
            { "Tibt", "Θιβετιανό" },
            { "Ugar", "Ουγκαριτικό" },
            { "Vaii", metaValue_vai },
            { "Visp", "Ορατή ομιλία" },
            { "Xpeo", "Παλαιό Περσικό" },
            { "Xsux", "Σούμερο-Ακάντιαν Κουνεϊφόρμ" },
            { "Yiii", "Γι" },
            { "Zinh", "Κληρονομημένο" },
            { "Zmth", "Μαθηματική σημειογραφία" },
            { "Zsye", "Emoji" },
            { "Zsym", "Σύμβολα" },
            { "Zxxx", "Άγραφο" },
            { "Zyyy", "Κοινό" },
            { "Zzzz", "Άγνωστη γραφή" },
            { "de_AT", "Γερμανικά Αυστρίας" },
            { "de_CH", "Υψηλά Γερμανικά Ελβετίας" },
            { "en_AU", "Αγγλικά Αυστραλίας" },
            { "en_CA", "Αγγλικά Καναδά" },
            { "en_GB", "Αγγλικά Βρετανίας" },
            { "en_US", "Αγγλικά Αμερικής" },
            { "es_ES", "Ισπανικά Ευρώπης" },
            { "es_MX", "Ισπανικά Μεξικού" },
            { "fa_AF", "Νταρί" },
            { "fr_CA", "Γαλλικά Καναδά" },
            { "fr_CH", "Γαλλικά Ελβετίας" },
            { "nl_BE", "Φλαμανδικά" },
            { "pt_BR", "Πορτογαλικά Βραζιλίας" },
            { "pt_PT", "Πορτογαλικά Ευρώπης" },
            { "ro_MD", "Μολδαβικά" },
            { "sw_CD", "Κονγκό Σουαχίλι" },
            { "%%1901", "Παραδοσιακή γερμανική ορθογραφία" },
            { "%%1994", "Τυποποιημένη ορθογραφία Ρεσιάν" },
            { "%%1996", "Γερμανική ορθογραφία του 1996" },
            { "ar_001", "Σύγχρονα Τυπικά Αραβικά" },
            { "es_419", "Ισπανικά Λατινικής Αμερικής" },
            { "key.ca", "Ημερολόγιο" },
            { "key.cf", "Μορφή νομίσματος" },
            { "key.co", "Σειρά ταξινόμησης" },
            { "key.cu", "Νόμισμα" },
            { "key.em", "Παρουσίαση emoji" },
            { "key.hc", "Κύκλος ωρών (12 ή 24)" },
            { "key.lb", "Στιλ αλλαγής γραμμών" },
            { "key.lw", "Αλλαγή γραμμής ανάμεσα σε λέξεις" },
            { "key.ms", "Σύστημα μέτρησης" },
            { "key.nu", "Αριθμοί" },
            { "key.ss", "Τέλος πρότασης μετά από σύντμηση" },
            { "key.tz", "Ζώνη ώρας" },
            { "key.va", "Παραλλαγή τοπικών ρυθμίσεων" },
            { "nds_NL", "Κάτω Γερμανικά Ολλανδίας" },
            { "%%BISKE", "Διάλεκτος Σαν Τζιόρτζιο/Βίλα" },
            { "%%BOONT", "Μπούντλινγκ" },
            { "%%KKCOR", "Κοινή ορθογραφία" },
            { "%%LIPAW", "Διάλεκτος Λιποβάζ της Ρεσιάν" },
            { "%%NEDIS", "Διάλεκτος Νατισόνε" },
            { "%%NJIVA", "Διάλεκτος Γκνιβά/Ντζιβά" },
            { "%%OSOJS", "Διάλεκτος Οσεακό/Οσοτζάν" },
            { "%%POSIX", "Υπολογιστής" },
            { "%%ROZAJ", "Ρεσιάν" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Διάλεκτος Στολβιτζά/Σολμπικά" },
            { "%%UCCOR", "Ενωποιημένη ορθογραφία" },
            { "zh_Hans", "Απλοποιημένα Κινεζικά" },
            { "zh_Hant", "Παραδοσιακά Κινεζικά" },
            { "%%FONIPA", "Διεθνής φωνητική αλφάβητος" },
            { "%%FONUPA", "Ουραλική φωνητική αλφάβητος" },
            { "%%PINYIN", "Εκλατινισμένα Πινγίν" },
            { "%%SCOUSE", "Σκουζ" },
            { "%%TARASK", "Ταρασκιεβική ορθογραφία" },
            { "%%UCRCOR", "Ενωποιημένη αναθεωρημένη ορθογραφία" },
            { "%%AREVELA", "Ανατολικά Αρμενικά" },
            { "%%AREVMDA", "Δυτικά Αρμενικά" },
            { "%%MONOTON", "Μονοτονικό" },
            { "%%POLYTON", "Πολυτονικό" },
            { "%%REVISED", "Αναθεωρημένη ορθογραφία" },
            { "%%1606NICT", "Νεότερα Μέσα Γαλλικά του 1606" },
            { "%%1694ACAD", "Πρώιμα Σύγχρονα Γαλλικά" },
            { "%%1959ACAD", "Ακαδημαϊκά" },
            { "%%BAKU1926", "Ενοποιημένη τουρκική λατινική αλφάβητος" },
            { "%%SCOTLAND", "Σκοτσεζικά τυποποιημένα Αγγλικά" },
            { "%%VALENCIA", "Βαλενθιανά" },
            { "%%WADEGILE", "Εκλατινισμένα Γουάντ-Γκιλς" },
            { "type.ca.roc", "Ημερολόγιο της Δημοκρατίας της Κίνας" },
            { "type.co.eor", "Ευρωπαϊκοί κανόνες ταξινόμησης" },
            { "type.hc.h11", "12ωρο σύστημα (0–11)" },
            { "type.hc.h12", "12ωρο σύστημα (1–12)" },
            { "type.hc.h23", "24ωρο σύστημα (0–23)" },
            { "type.hc.h24", "24ωρο σύστημα (1–24)" },
            { "type.m0.bgn", "Μεταγραφή BGN ΗΠΑ" },
            { "type.nu.arab", "Αραβικο-ινδικά ψηφία" },
            { "type.nu.armn", "Αρμενικά αριθμητικά" },
            { "type.nu.beng", "Βεγγαλικά ψηφία" },
            { "type.nu.cakm", "Ψηφία Τσάκμα" },
            { "type.nu.deva", "Ψηφία Ντεβαναγκάρι" },
            { "type.nu.ethi", "Αιθιοπικά αριθμητικά" },
            { "type.nu.geor", "Γεωργιανά αριθμητικά" },
            { "type.nu.grek", "Ελληνικά αριθμητικά" },
            { "type.nu.gujr", "Γκουτζαρατικά ψηφία" },
            { "type.nu.guru", "Ψηφία Γκουρμούκι" },
            { "type.nu.hans", "Απλοποιημένα κινεζικά αριθμητικά" },
            { "type.nu.hant", "Παραδοσιακά κινεζικά αριθμητικά" },
            { "type.nu.hebr", "Εβραϊκά αριθμητικά" },
            { "type.nu.java", "Ιαβαϊκά ψηφία" },
            { "type.nu.jpan", "Ιαπωνικά αριθμητικά" },
            { "type.nu.khmr", "Ψηφία Χμερ" },
            { "type.nu.knda", "Ψηφία Κανάντα" },
            { "type.nu.laoo", "Λαοϊκά ψηφία" },
            { "type.nu.latn", "Αραβικά αριθμητικά" },
            { "type.nu.mlym", "Μαλαγιαλαμικά ψηφία" },
            { "type.nu.mong", "Μογγολικά ψηφία" },
            { "type.nu.mtei", "Ψηφία Μεϊτεί Μαγιέκ" },
            { "type.nu.mymr", "Ψηφία Μιανμάρ" },
            { "type.nu.olck", "Ψηφία Ολ Τσίκι" },
            { "type.nu.orya", "Οριγικά ψηφία" },
            { "type.nu.taml", "Ταμιλικά αριθμητικά" },
            { "type.nu.telu", "Τελουγκουϊκά ψηφία" },
            { "type.nu.thai", "Ταϊλανδικά ψηφία" },
            { "type.nu.tibt", "Θιβετανικά ψηφία" },
            { "type.nu.vaii", "Ψηφία Βάι" },
            { "type.ca.dangi", "Κορεατικό ημερολόγιο ντάνγκι" },
            { "type.co.ducet", "Προεπιλεγμένη σειρά ταξινόμησης Unicode" },
            { "type.lb.loose", "Χαλαρό στιλ αλλαγής γραμμών" },
            { "type.nu.roman", "Λατινικά αριθμητικά" },
            { "type.ca.coptic", "Κοπτικό ημερολόγιο" },
            { "type.ca.hebrew", "Εβραϊκό ημερολόγιο" },
            { "type.ca.indian", "Ινδικό εθνικό ημερολόγιο" },
            { "type.co.compat", "Προηγούμενη σειρά ταξινόμησης, για συμβατότητα" },
            { "type.co.pinyin", "Σειρά ταξινόμησης Πινγίν" },
            { "type.co.search", "Αναζήτηση γενικού τύπου" },
            { "type.co.stroke", "Σειρά ταξινόμησης κινήσεων" },
            { "type.co.unihan", "Σειρά ταξινόμησης ριζικής αρίθμησης" },
            { "type.co.zhuyin", "Σειρά ταξινόμησης Τζουγίν" },
            { "type.d0.fwidth", "Πλήρους πλάτους" },
            { "type.d0.hwidth", "Μισού πλάτους" },
            { "type.lb.normal", "Κανονικό στιλ αλλαγής γραμμών" },
            { "type.lb.strict", "Στενό στιλ αλλαγής γραμμών" },
            { "type.m0.ungegn", "Μεταγραφή GEGN ΟΗΕ" },
            { "type.ms.metric", "Μετρικό σύστημα" },
            { "type.nu.native", "Εγγενή ψηφία" },
            { "type.ca.chinese", "Κινεζικό ημερολόγιο" },
            { "type.ca.islamic", "Ημερολόγιο Εγίρας" },
            { "type.ca.iso8601", "Ημερολόγιο ISO-8601" },
            { "type.ca.persian", "Περσικό ημερολόγιο" },
            { "type.cf.account", "Λογιστική μορφή νομίσματος" },
            { "type.d0.npinyin", "Αριθμητικό" },
            { "type.nu.arabext", "Εκτεταμένα αραβικο-ινδικά ψηφία" },
            { "type.nu.armnlow", "Πεζά αρμενικά αριθμητικά" },
            { "type.nu.finance", "Οικονομικά αριθμητικά" },
            { "type.nu.greklow", "Ελληνικά αριθμητικά πεζά" },
            { "type.nu.hanidec", "Κινεζικά δεκαδικά αριθμητικά" },
            { "type.nu.hansfin", "Απλοποιημένα κινεζικά οικονομικά αριθμητικά" },
            { "type.nu.hantfin", "Παραδοσιακά κινεζικά οικονομικά αριθμητικά" },
            { "type.nu.jpanfin", "Ιαπωνικά οικονομικά αριθμητικά" },
            { "type.nu.tamldec", "Ταμιλικά ψηφία" },
            { "type.ca.buddhist", "Βουδιστικό ημερολόγιο" },
            { "type.ca.ethiopic", "Αιθιοπικό ημερολόγιο" },
            { "type.ca.japanese", "Ιαπωνικό ημερολόγιο" },
            { "type.cf.standard", "Τυπική μορφή νομίσματος" },
            { "type.co.phonetic", "Φωνητική σειρά ταξινόμησης" },
            { "type.co.searchjl", "Αναζήτηση κατά αρχικό σύμφωνο Χανγκούλ" },
            { "type.co.standard", "Τυπική σειρά ταξινόμησης" },
            { "type.ms.uksystem", "Αγγλοσαξονικό σύστημα μέτρησης" },
            { "type.ms.ussystem", "Αμερικανικό σύστημα μέτρησης" },
            { "type.nu.fullwide", "Ψηφία πλήρους πλάτους" },
            { "type.nu.romanlow", "Πεζά λατινικά αριθμητικά" },
            { "type.ca.gregorian", "Γρηγοριανό ημερολόγιο" },
            { "type.co.phonebook", "Σειρά ταξινόμησης τηλεφωνικού καταλόγου" },
            { "type.co.dictionary", "Σειρά ταξινόμησης λεξικού" },
            { "type.co.traditional", "Παραδοσιακή σειρά ταξινόμησης" },
            { "type.nu.traditional", "Παραδοσιακά αριθμητικά" },
            { "type.ca.islamic-civil", "Ημερολόγιο Εγίρας (σε μορφή πίνακα, αστικό εποχής)" },
            { "type.ca.islamic-umalqura", "Ημερολόγιο Εγίρας (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Αιθιοπικό ημερολόγιο Άμετ Άλεμ" },
        };
        return data;
    }
}
