/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Svijet" },
            { "002", "Afrika" },
            { "003", "Sjevernoamerički kontinent" },
            { "005", "Južna Amerika" },
            { "009", "Oceanija" },
            { "011", "Zapadna Afrika" },
            { "013", "Centralna Amerika" },
            { "014", "Istočna Afrika" },
            { "015", "Sjeverna Afrika" },
            { "017", "Središnja Afrika" },
            { "018", "Južna Afrika" },
            { "019", "Amerike" },
            { "021", "Sjeverna Amerika" },
            { "029", "Karibi" },
            { "030", "Istočna Azija" },
            { "034", "Južna Azija" },
            { "035", "Jugoistočna Azija" },
            { "039", "Južna Europa" },
            { "053", "Australazija" },
            { "054", "Melanezija" },
            { "057", "Mikronezijsko područje" },
            { "061", "Polinezija" },
            { "142", "Azija" },
            { "143", "Srednja Azija" },
            { "145", "Zapadna Azija" },
            { "150", "Europa" },
            { "151", "Istočna Europa" },
            { "154", "Sjeverna Europa" },
            { "155", "Zapadna Europa" },
            { "202", "Subsaharska Afrika" },
            { "419", "Latinska Amerika" },
            { "AC", "Otok Uzašašća" },
            { "AD", "Andora" },
            { "AE", "Ujedinjeni Arapski Emirati" },
            { "AF", "Afganistan" },
            { "AG", "Antigva i Barbuda" },
            { "AI", "Angvila" },
            { "AL", "Albanija" },
            { "AM", "Armenija" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Američka Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "Ålandski otoci" },
            { "AZ", "Azerbajdžan" },
            { "BA", "Bosna i Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladeš" },
            { "BE", "Belgija" },
            { "BF", "Burkina Faso" },
            { "BG", "Bugarska" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Bermudi" },
            { "BN", "Brunej" },
            { "BO", "Bolivija" },
            { "BQ", "Karipski otoci Nizozemske" },
            { "BR", "Brazil" },
            { "BS", "Bahami" },
            { "BT", "Butan" },
            { "BV", "Otok Bouvet" },
            { "BW", "Bocvana" },
            { "BY", "Bjelorusija" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosovi (Keelingovi) Otoci" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Srednjoafrička Republika" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Švicarska" },
            { "CI", "Obala Bjelokosti" },
            { "CK", "Cookovi Otoci" },
            { "CL", "Čile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolumbija" },
            { "CP", "Otok Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Zelenortska Republika" },
            { "CW", "Curaçao" },
            { "CX", "Božićni Otok" },
            { "CY", "Cipar" },
            { "CZ", "Češka" },
            { "DE", "Njemačka" },
            { "DG", "Diego Garcia" },
            { "DJ", "Džibuti" },
            { "DK", "Danska" },
            { "DM", "Dominika" },
            { "DO", "Dominikanska Republika" },
            { "DZ", "Alžir" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Estonija" },
            { "EG", "Egipat" },
            { "EH", "Zapadna Sahara" },
            { "ER", "Eritreja" },
            { "ES", "Španjolska" },
            { "ET", "Etiopija" },
            { "EU", "Europska unija" },
            { "EZ", "eurozona" },
            { "FI", "Finska" },
            { "FJ", "Fidži" },
            { "FK", "Falklandski Otoci" },
            { "FM", "Mikronezija" },
            { "FO", "Farski Otoci" },
            { "FR", "Francuska" },
            { "GA", "Gabon" },
            { "GB", "Ujedinjeno Kraljevstvo" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Francuska Gijana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenland" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekvatorska Gvineja" },
            { "GR", "Grčka" },
            { "GS", "Južna Georgia i Otoci Južni Sandwich" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineja Bisau" },
            { "GY", "Gvajana" },
            { "HK", "PUP Hong Kong Kina" },
            { "HM", "Otoci Heard i McDonald" },
            { "HN", "Honduras" },
            { "HR", "Hrvatska" },
            { "HT", "Haiti" },
            { "HU", "Mađarska" },
            { "IC", "Kanari" },
            { "ID", "Indonezija" },
            { "IE", "Irska" },
            { "IL", "Izrael" },
            { "IM", "Otok Man" },
            { "IN", "Indija" },
            { "IO", "Britanski Indijskooceanski Teritorij" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italija" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenija" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komori" },
            { "KN", "Sveti Kristofor i Nevis" },
            { "KP", "Sjeverna Koreja" },
            { "KR", "Južna Koreja" },
            { "KW", "Kuvajt" },
            { "KY", "Kajmanski Otoci" },
            { "KZ", "Kazahstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Sveta Lucija" },
            { "LI", "Lihtenštajn" },
            { "LK", "Šri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "LU", "Luksemburg" },
            { "LV", "Latvija" },
            { "LY", "Libija" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavija" },
            { "ME", "Crna Gora" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Maršalovi Otoci" },
            { "MK", "Sjeverna Makedonija" },
            { "ML", "Mali" },
            { "MM", "Mjanmar (Burma)" },
            { "MN", "Mongolija" },
            { "MO", "PUP Makao Kina" },
            { "MP", "Sjevernomarijanski Otoci" },
            { "MQ", "Martinik" },
            { "MR", "Mauretanija" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricijus" },
            { "MV", "Maldivi" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "MY", "Malezija" },
            { "MZ", "Mozambik" },
            { "NA", "Namibija" },
            { "NC", "Nova Kaledonija" },
            { "NE", "Niger" },
            { "NF", "Otok Norfolk" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragva" },
            { "NL", "Nizozemska" },
            { "NO", "Norveška" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Novi Zeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francuska Polinezija" },
            { "PG", "Papua Nova Gvineja" },
            { "PH", "Filipini" },
            { "PK", "Pakistan" },
            { "PL", "Poljska" },
            { "PM", "Sveti Petar i Mikelon" },
            { "PN", "Pitcairnovi Otoci" },
            { "PR", "Portoriko" },
            { "PS", "Palestinsko područje" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paragvaj" },
            { "QA", "Katar" },
            { "QO", "Vanjska područja Oceanije" },
            { "RE", "Réunion" },
            { "RO", "Rumunjska" },
            { "RS", "Srbija" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "SA", "Saudijska Arabija" },
            { "SB", "Salomonovi Otoci" },
            { "SC", "Sejšeli" },
            { "SD", "Sudan" },
            { "SE", "Švedska" },
            { "SG", "Singapur" },
            { "SH", "Sveta Helena" },
            { "SI", "Slovenija" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "Slovačka" },
            { "SL", "Sijera Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "SR", "Surinam" },
            { "SS", "Južni Sudan" },
            { "ST", "Sveti Toma i Princip" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Sirija" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Otoci Turks i Caicos" },
            { "TD", "Čad" },
            { "TF", "Francuski Južni Teritoriji" },
            { "TG", "Togo" },
            { "TH", "Tajland" },
            { "TJ", "Tadžikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Turska" },
            { "TT", "Trinidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanzanija" },
            { "UA", "Ukrajina" },
            { "UG", "Uganda" },
            { "UM", "Mali udaljeni otoci SAD-a" },
            { "UN", "Ujedinjeni narodi" },
            { "US", "Sjedinjene Američke Države" },
            { "UY", "Urugvaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Sveti Vincent i Grenadini" },
            { "VE", "Venezuela" },
            { "VG", "Britanski Djevičanski Otoci" },
            { "VI", "Američki Djevičanski Otoci" },
            { "VN", "Vijetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo naglasci" },
            { "XB", "pseudo bidi" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Južnoafrička Republika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nepoznato područje" },
            { "aa", "afarski" },
            { "ab", "abhaski" },
            { "ae", "avestički" },
            { "af", "afrikaans" },
            { "ak", "akanski" },
            { "am", "amharski" },
            { "an", "aragonski" },
            { "ar", "arapski" },
            { "as", "asamski" },
            { "av", "avarski" },
            { "ay", "ajmarski" },
            { "az", "azerbajdžanski" },
            { "ba", "baškirski" },
            { "be", "bjeloruski" },
            { "bg", "bugarski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bangla" },
            { "bo", "tibetski" },
            { "br", "bretonski" },
            { "bs", "bosanski" },
            { "ca", "katalonski" },
            { "ce", "čečenski" },
            { "ch", "chamorro" },
            { "co", "korzički" },
            { "cr", "cree" },
            { "cs", "češki" },
            { "cu", "crkvenoslavenski" },
            { "cv", "čuvaški" },
            { "cy", "velški" },
            { "da", "danski" },
            { "de", "njemački" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grčki" },
            { "en", "engleski" },
            { "eo", "esperanto" },
            { "es", "španjolski" },
            { "et", "estonski" },
            { "eu", "baskijski" },
            { "fa", "perzijski" },
            { "ff", "fula" },
            { "fi", "finski" },
            { "fj", "fidžijski" },
            { "fo", "ferojski" },
            { "fr", "francuski" },
            { "fy", "zapadnofrizijski" },
            { "ga", "irski" },
            { "gd", "škotski gaelski" },
            { "gl", "galicijski" },
            { "gn", "gvaranski" },
            { "gu", "gudžaratski" },
            { "gv", "manski" },
            { "ha", "hausa" },
            { "he", "hebrejski" },
            { "hi", "hindski" },
            { "ho", "hiri motu" },
            { "hr", "hrvatski" },
            { "ht", "haićanski kreolski" },
            { "hu", "mađarski" },
            { "hy", "armenski" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezijski" },
            { "ie", "interligua" },
            { "ig", "igbo" },
            { "ii", "sichuan ji" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandski" },
            { "it", "talijanski" },
            { "iu", "inuktitut" },
            { "ja", "japanski" },
            { "jv", "javanski" },
            { "ka", "gruzijski" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazaški" },
            { "kl", "kalaallisut" },
            { "km", "kmerski" },
            { "kn", "karnatački" },
            { "ko", "korejski" },
            { "kr", "kanuri" },
            { "ks", "kašmirski" },
            { "ku", "kurmanji" },
            { "kv", "komi" },
            { "kw", "kornski" },
            { "ky", "kirgiski" },
            { "la", "latinski" },
            { "lb", "luksemburški" },
            { "lg", "ganda" },
            { "li", "limburški" },
            { "ln", "lingala" },
            { "lo", "laoski" },
            { "lt", "litavski" },
            { "lu", "luba-katanga" },
            { "lv", "latvijski" },
            { "mg", "malgaški" },
            { "mh", "maršalski" },
            { "mi", "maorski" },
            { "mk", "makedonski" },
            { "ml", "malajalamski" },
            { "mn", "mongolski" },
            { "mr", "marathski" },
            { "ms", "malajski" },
            { "mt", "malteški" },
            { "my", "burmanski" },
            { "na", "nauru" },
            { "nb", "norveški bokmål" },
            { "nd", "sjeverni ndebele" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "nl", "nizozemski" },
            { "nn", "norveški nynorsk" },
            { "no", "norveški" },
            { "nr", "južni ndebele" },
            { "nv", "navajo" },
            { "ny", "njandža" },
            { "oc", "okcitanski" },
            { "oj", "ojibwa" },
            { "om", "oromski" },
            { "or", "orijski" },
            { "os", "osetski" },
            { "pa", "pandžapski" },
            { "pi", "pali" },
            { "pl", "poljski" },
            { "ps", "paštunski" },
            { "pt", "portugalski" },
            { "qu", "kečuanski" },
            { "rm", "retoromanski" },
            { "rn", "rundi" },
            { "ro", "rumunjski" },
            { "ru", "ruski" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrtski" },
            { "sc", "sardski" },
            { "sd", "sindski" },
            { "se", "sjeverni sami" },
            { "sg", "sango" },
            { "sh", "srpsko-hrvatski" },
            { "si", "sinhaleški" },
            { "sk", "slovački" },
            { "sl", "slovenski" },
            { "sm", "samoanski" },
            { "sn", "shona" },
            { "so", "somalski" },
            { "sq", "albanski" },
            { "sr", "srpski" },
            { "ss", "svati" },
            { "st", "sesotski" },
            { "su", "sundanski" },
            { "sv", "švedski" },
            { "sw", "svahili" },
            { "ta", "tamilski" },
            { "te", "teluški" },
            { "tg", "tadžički" },
            { "th", "tajlandski" },
            { "ti", "tigrinja" },
            { "tk", "turkmenski" },
            { "tl", "tagalog" },
            { "tn", "cvana" },
            { "to", "tonganski" },
            { "tr", "turski" },
            { "ts", "tsonga" },
            { "tt", "tatarski" },
            { "tw", "twi" },
            { "ty", "tahićanski" },
            { "ug", "ujgurski" },
            { "uk", "ukrajinski" },
            { "ur", "urdski" },
            { "uz", "uzbečki" },
            { "ve", "venda" },
            { "vi", "vijetnamski" },
            { "vo", "volapük" },
            { "wa", "valonski" },
            { "wo", "volof" },
            { "xh", "xhosa" },
            { "yi", "jidiš" },
            { "yo", "jorupski" },
            { "za", "zhuang" },
            { "zh", "kineski" },
            { "zu", "zulu" },
            { "ace", "ačinski" },
            { "ach", "ačoli" },
            { "ada", "adangme" },
            { "ady", "adigejski" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainuski" },
            { "akk", "akadski" },
            { "ale", "aleutski" },
            { "alt", "južni altai" },
            { "ang", "staroengleski" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejski" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "najdi arapski" },
            { "arw", "aravački" },
            { "asa", "asu" },
            { "ast", "asturijski" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "belučki" },
            { "ban", "balijski" },
            { "bas", "basa" },
            { "bax", "bamunski" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "zapadnobaludžijski" },
            { "bho", "bhojpuri" },
            { "bik", "bikolski" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "burjatski" },
            { "bug", "buginski" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karipski" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "čibča" },
            { "chg", "čagatajski" },
            { "chk", "chuukese" },
            { "chm", "marijski" },
            { "chn", "chinook žargon" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "čerokijski" },
            { "chy", "čejenski" },
            { "ckb", "soranski kurdski" },
            { "clc", "chilcotin" },
            { "cop", "koptski" },
            { "crg", "michif" },
            { "crh", "krimski turski" },
            { "crj", "jugoistični cree" },
            { "crk", "plains cree" },
            { "crl", "sjevernoistočni cree" },
            { "crm", "moose cree" },
            { "crr", "karolinski algonkijski" },
            { "crs", "sejšelski kreolski" },
            { "csb", "kašupski" },
            { "csw", "močvarni cree" },
            { "dak", "dakota jezik" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delavarski" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "donjolužički" },
            { "dua", "duala" },
            { "dum", "srednjonizozemski" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "staroegipatski" },
            { "eka", "ekajuk" },
            { "elx", "elamitski" },
            { "enm", "srednjoengleski" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipinski" },
            { "fon", "fon" },
            { "frc", "kajunski francuski" },
            { "frm", "srednjofrancuski" },
            { "fro", "starofrancuski" },
            { "frr", "sjevernofrizijski" },
            { "frs", "istočnofrizijski" },
            { "fur", "furlanski" },
            { "gaa", "ga" },
            { "gag", "gagauski" },
            { "gan", "gan kineski" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertski" },
            { "gmh", "srednjogornjonjemački" },
            { "goh", "starovisokonjemački" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gotski" },
            { "grb", "grebo" },
            { "grc", "starogrčki" },
            { "gsw", "švicarski njemački" },
            { "guz", "gusii" },
            { "gwi", "gwich’in" },
            { "hai", "haidi" },
            { "hak", "hakka kineski" },
            { "haw", "havajski" },
            { "hax", "južni haida" },
            { "hil", "hiligaynonski" },
            { "hit", "hetitski" },
            { "hmn", "hmong" },
            { "hsb", "gornjolužički" },
            { "hsn", "xiang kineski" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "zapadnokanadski inuktitut" },
            { "ilo", "iloko" },
            { "inh", "ingušetski" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "judejsko-perzijski" },
            { "jrb", "judejsko-arapski" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabilski" },
            { "kac", "kačinski" },
            { "kaj", "kaje" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardinski" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "zelenortski" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanese" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permski" },
            { "kok", "konkani" },
            { "kos", "naurski" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "karelijski" },
            { "kru", "kuruški" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kelnski" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgiški" },
            { "lij", "ligurski" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombardski" },
            { "lol", "mongo" },
            { "lou", "lujzijanski kreolski" },
            { "loz", "lozi" },
            { "lrc", "sjevernolurski" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "mad", "madurski" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masajski" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "mauricijski kreolski" },
            { "mga", "srednjoirski" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mandžurski" },
            { "mni", "manipurski" },
            { "moe", "innu-aimun" },
            { "moh", "mohok" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "više jezika" },
            { "mus", "creek" },
            { "mwl", "mirandski" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "mordvinski" },
            { "mzn", "mazanderanski" },
            { "nan", "min nan kineski" },
            { "nap", "napolitanski" },
            { "naq", "nama" },
            { "nds", "donjonjemački" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niujski" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogajski" },
            { "non", "staronorveški" },
            { "nqo", "n’ko" },
            { "nso", "sjeverni sotski" },
            { "nus", "nuerski" },
            { "nwc", "klasični newari" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "sjeverozapadni ojibwa" },
            { "ojc", "centralni ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "zapadni ojibwa" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turski - otomanski" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauanski" },
            { "pcm", "nigerijski pidžin" },
            { "peo", "staroperzijski" },
            { "phn", "fenički" },
            { "pis", "pijin" },
            { "pon", "pohnpeian" },
            { "pqm", "maliseet-Passamaquoddy" },
            { "prg", "pruski" },
            { "pro", "staroprovansalski" },
            { "quc", "kiče" },
            { "raj", "rajasthani" },
            { "rap", "rapa nui" },
            { "rar", "rarotonški" },
            { "rhg", "rohindža" },
            { "rof", "rombo" },
            { "rom", "romski" },
            { "rup", "aromunski" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakutski" },
            { "sam", "samarijanski aramejski" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santalski" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilijski" },
            { "sco", "škotski" },
            { "sdh", "južnokurdski" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkupski" },
            { "ses", "koyraboro senni" },
            { "sga", "staroirski" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "čadski arapski" },
            { "sid", "sidamo" },
            { "slh", "južni lushootseed" },
            { "sma", "južni sami" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "str", "sjeverni sališki" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerski" },
            { "swb", "komorski" },
            { "syc", "klasični sirski" },
            { "syr", "sirijski" },
            { "szl", "šleski" },
            { "tce", "južni tutchone" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigriški" },
            { "tiv", "tiv" },
            { "tkl", "tokelaunski" },
            { "tlh", "klingonski" },
            { "tli", "tlingit" },
            { "tmh", "tamašečki" },
            { "tog", "nyasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshian" },
            { "ttm", "sjeverni tutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluanski" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinski" },
            { "tzm", "tamašek (Srednji Atlas)" },
            { "udm", "udmurtski" },
            { "uga", "ugaritski" },
            { "umb", "umbundu" },
            { "und", "nepoznati jezik" },
            { "vec", "venecijanski" },
            { "vmw", "makhuwa" },
            { "vot", "votski" },
            { "vun", "vunjo" },
            { "wae", "walserski" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu kineski" },
            { "xal", "kalmyk" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "japski" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonski" },
            { "zap", "zapotečki" },
            { "zbl", "Blissovi simboli" },
            { "zen", "zenaga" },
            { "zgh", "standardni marokanski tamašek" },
            { "zun", "zuni" },
            { "zxx", "bez jezičnog sadržaja" },
            { "zza", "zazaki" },
            { "Adlm", "adlam pismo" },
            { "Afak", "afaka pismo" },
            { "Arab", "arapsko pismo" },
            { "Aran", "nastaliq pismo" },
            { "Armi", "aramejsko pismo" },
            { "Armn", "armensko pismo" },
            { "Avst", "avestansko pismo" },
            { "Bali", "balijsko pismo" },
            { "Bamu", "bamum pismo" },
            { "Bass", "bassa vah pismo" },
            { "Batk", "batak pismo" },
            { "Beng", "bengalsko pismo" },
            { "Blis", "blissymbols" },
            { "Bopo", "bopomofo pismo" },
            { "Brah", "brahmi pismo" },
            { "Brai", "brajica" },
            { "Bugi", "buginsko pismo" },
            { "Buhd", "buhid pismo" },
            { "Cakm", "čakmansko pismo" },
            { "Cans", "unificirani kanadski aboriđinski slogovi" },
            { "Cari", "karijsko pismo" },
            { "Cham", "čamsko pismo" },
            { "Cher", "čeroki pismo" },
            { "Cirt", "cirth pismo" },
            { "Copt", "koptsko pismo" },
            { "Cprt", "cypriot pismo" },
            { "Cyrl", "ćirilica" },
            { "Cyrs", "staroslavenska crkvena čirilica" },
            { "Deva", "devangari pismo" },
            { "Dsrt", "deseret pismo" },
            { "Egyd", "egipatsko narodno pismo" },
            { "Egyh", "egipatsko hijeratsko pismo" },
            { "Egyp", "egipatski hijeroglifi" },
            { "Ethi", "etiopsko pismo" },
            { "Geok", "gruzijsko khutsuri pismo" },
            { "Geor", "gruzijsko pismo" },
            { "Glag", "glagoljica" },
            { "Goth", "gotičko pismo" },
            { "Gran", "grantha pismo" },
            { "Grek", "grčko pismo" },
            { "Gujr", "gudžaratsko pismo" },
            { "Guru", "gurmukhi pismo" },
            { "Hanb", "hanb pismo" },
            { "Hang", "hangul pismo" },
            { "Hani", "hansko pismo" },
            { "Hano", "hanunoo pismo" },
            { "Hans", "pojednostavljeno pismo" },
            { "Hant", "tradicionalno pismo" },
            { "Hebr", "hebrejsko pismo" },
            { "Hira", "hiragana pismo" },
            { "Hluw", "anatolijski hijeroglifi" },
            { "Hmng", "pahawh hmong pismo" },
            { "Hrkt", "japansko slogovno pismo" },
            { "Hung", "staro mađarsko pismo" },
            { "Inds", "indijsko pismo" },
            { "Ital", "staro talijansko pismo" },
            { "Jamo", "jamo pismo" },
            { "Java", "javansko pismo" },
            { "Jpan", "japansko pismo" },
            { "Jurc", "jurchen pismo" },
            { "Kali", "kayah li pismo" },
            { "Kana", "katakana pismo" },
            { "Khar", "kharoshthi pismo" },
            { "Khmr", "kmersko pismo" },
            { "Khoj", "khojki pismo" },
            { "Knda", "kannada pismo" },
            { "Kore", "korejsko pismo" },
            { "Kpel", "kpelle pismo" },
            { "Kthi", "kaithi pismo" },
            { "Lana", "lanna pismo" },
            { "Laoo", "laosko pismo" },
            { "Latf", "fraktur latinica" },
            { "Latg", "keltska latinica" },
            { "Latn", "latinica" },
            { "Lepc", "lepcha pismo" },
            { "Limb", "limbu pismo" },
            { "Lina", "linear A pismo" },
            { "Linb", "linear B pismo" },
            { "Lisu", "fraser pismo" },
            { "Loma", "loma pismo" },
            { "Lyci", "likijsko pismo" },
            { "Lydi", "lidijsko pismo" },
            { "Mand", "mandai pismo" },
            { "Mani", "manihejsko pismo" },
            { "Maya", "majanski hijeroglifi" },
            { "Mend", "mende pismo" },
            { "Merc", "meroitski kurziv" },
            { "Mero", "meroitic pismo" },
            { "Mlym", "malajalamsko pismo" },
            { "Mong", "mongolsko pismo" },
            { "Moon", "moon pismo" },
            { "Mroo", "mro pismo" },
            { "Mtei", "meitei mayek pismo" },
            { "Mymr", "mjanmarsko pismo" },
            { "Narb", "staro sjevernoarapsko pismo" },
            { "Nbat", "nabatejsko pismo" },
            { "Nkgb", "naxi geba pismo" },
            { "Nkoo", "n’ko pismo" },
            { "Nshu", "nushu pismo" },
            { "Ogam", "ogham pismo" },
            { "Olck", "ol chiki pismo" },
            { "Orkh", "orkhon pismo" },
            { "Orya", "orijsko pismo" },
            { "Osma", "osmanya pismo" },
            { "Palm", "palmyrene pismo" },
            { "Perm", "staro permic pismo" },
            { "Phag", "phags-pa pismo" },
            { "Phli", "pisani pahlavi" },
            { "Phlp", "psalter pahlavi" },
            { "Phlv", "pahlavi pismo" },
            { "Phnx", "feničko pismo" },
            { "Plrd", "pollard fonetsko pismo" },
            { "Prti", "pisani parthian" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang pismo" },
            { "Rohg", "hanifi pismo" },
            { "Roro", "rongorongo pismo" },
            { "Runr", "runsko pismo" },
            { "Samr", "samaritansko pismo" },
            { "Sara", "sarati pismo" },
            { "Sarb", "staro južnoarapsko pismo" },
            { "Saur", "saurashtra pismo" },
            { "Sgnw", "znakovno pismo" },
            { "Shaw", "shavian pismo" },
            { "Shrd", "sharada pismo" },
            { "Sind", "khudawadi pismo" },
            { "Sinh", "sinhaleško pismo" },
            { "Sora", "sora sompeng pismo" },
            { "Sund", "sundansko pismo" },
            { "Sylo", "syloti nagri pismo" },
            { "Syrc", "sirijsko pismo" },
            { "Syre", "sirijsko estrangelo pismo" },
            { "Syrj", "pismo zapadne Sirije" },
            { "Syrn", "pismo istočne Sirije" },
            { "Tagb", "tagbanwa pismo" },
            { "Takr", "takri pismo" },
            { "Tale", "tai le pismo" },
            { "Talu", "novo tai lue pismo" },
            { "Taml", "tamilsko pismo" },
            { "Tang", "tangut pismo" },
            { "Tavt", "tai viet pismo" },
            { "Telu", "teluško pismo" },
            { "Teng", "tengwar pismo" },
            { "Tfng", "tifinagh pismo" },
            { "Tglg", "tagalog pismo" },
            { "Thaa", "thaana pismo" },
            { "Thai", "tajsko pismo" },
            { "Tibt", "tibetansko pismo" },
            { "Tirh", "tirhuta pismo" },
            { "Ugar", "ugaritsko pismo" },
            { "Vaii", "vai pismo" },
            { "Visp", "Visible Speech" },
            { "Wara", "varang kshiti pismo" },
            { "Wole", "woleai pismo" },
            { "Xpeo", "staro perzijsko pismo" },
            { "Xsux", "sumersko-akadsko cuneiform pismo" },
            { "Yiii", "yi pismo" },
            { "Zinh", "nasljedno pismo" },
            { "Zmth", "matematičko znakovlje" },
            { "Zsye", "emotikoni" },
            { "Zsym", "simboli" },
            { "Zxxx", "jezik bez pismenosti" },
            { "Zyyy", "zajedničko pismo" },
            { "Zzzz", "nepoznato pismo" },
            { "de_AT", "austrijski njemački" },
            { "de_CH", "gornjonjemački (švicarski)" },
            { "en_AU", "australski engleski" },
            { "en_CA", "kanadski engleski" },
            { "en_GB", "britanski engleski" },
            { "en_US", "američki engleski" },
            { "es_ES", "europski španjolski" },
            { "es_MX", "meksički španjolski" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadski francuski" },
            { "fr_CH", "švicarski francuski" },
            { "nl_BE", "flamanski" },
            { "pt_BR", "brazilski portugalski" },
            { "pt_PT", "europski portugalski" },
            { "ro_MD", "moldavski" },
            { "sw_CD", "kongoanski svahili" },
            { "%%1901", "tradicionalan njemački pravopis" },
            { "%%1994", "standardizirani resian pravopis" },
            { "%%1996", "njemačka ortografija iz 1996." },
            { "ar_001", "moderni standardni arapski" },
            { "es_419", "latinoamerički španjolski" },
            { "key.ca", "kalendar" },
            { "key.cf", "format valute" },
            { "key.co", "redoslijed razvrstavanja" },
            { "key.cu", "valuta" },
            { "key.em", "Prezentacija emojija" },
            { "key.hc", "format vremena (12 ili 24)" },
            { "key.lb", "stil prijeloma retka" },
            { "key.lw", "Prijelomi redaka unutar riječi" },
            { "key.ms", "sustav mjernih jedinica" },
            { "key.nu", "brojevi" },
            { "key.ss", "Prijelom rečenice nakon kratice" },
            { "key.tz", "Vremenska zona" },
            { "key.va", "Varijanta zemlje/jezika" },
            { "nds_NL", "donjosaksonski" },
            { "%%ALUKU", "aluku dijalekt" },
            { "%%BISKE", "san giorgio/bila dijalekt" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "Uobičajeni pravopis" },
            { "%%KSCOR", "standardna ortografija" },
            { "%%LIPAW", "lipovački dijalekt resian jezika" },
            { "%%NEDIS", "natisone dijalekt" },
            { "%%NJIVA", "Gniva/Njiva dijalekt" },
            { "%%NULIK", "moderni volapuk" },
            { "%%OSOJS", "oseacco/osojane dijalekt" },
            { "%%POSIX", "Računalo" },
            { "%%ROZAJ", "resian" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "stolvizza/solbica dijalekt" },
            { "%%UCCOR", "ujednačena ortografija" },
            { "az_Arab", "južnoazerbajdžanski" },
            { "zh_Hans", "kineski (pojednostavljeni)" },
            { "zh_Hant", "kineski (tradicionalni)" },
            { "%%FONIPA", "IPA fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%PAMAKA", "pamaka dijalekt" },
            { "%%PINYIN", "Pinyin romanizacija" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "taraskievica pravopis" },
            { "%%UCRCOR", "ujednačena revidirana ortografija" },
            { "%%AREVELA", "istočno-armenijski" },
            { "%%AREVMDA", "zapadno-armenijski" },
            { "%%EMODENG", "rani moderni engleski" },
            { "%%METELKO", "metelčica" },
            { "%%MONOTON", "monotono" },
            { "%%POLYTON", "politono" },
            { "%%REVISED", "izmijenjen pravopis" },
            { "%%1606NICT", "kasni srednjofrancuski do 1606." },
            { "%%1694ACAD", "rani moderni francuski" },
            { "%%1959ACAD", "akademski" },
            { "%%BAKU1926", "unificirana turska abeceda" },
            { "%%SCOTLAND", "škotski standardni engleski" },
            { "%%VALENCIA", "valencijski" },
            { "%%WADEGILE", "Wade-Giles romanizacija" },
            { "type.ca.roc", "kalendar Republike Kine" },
            { "type.co.eor", "Europska pravila razvrstavanja" },
            { "type.hc.h11", "12-satni format (0 – 11)" },
            { "type.hc.h12", "12-satni format (0 – 12)" },
            { "type.hc.h23", "24-satni format (0 – 23)" },
            { "type.hc.h24", "24-satni format (1 – 24)" },
            { "type.m0.bgn", "transliteracija prema BGN-u" },
            { "type.nu.arab", "arapsko-indijske znamenke" },
            { "type.nu.armn", "armenski brojevi" },
            { "type.nu.beng", "znamenke bengalskog pisma" },
            { "type.nu.cakm", "znamenke čakmanskog pisma" },
            { "type.nu.deva", "znamenke pisma devanagari" },
            { "type.nu.ethi", "etiopski brojevi" },
            { "type.nu.geor", "gruzijski brojevi" },
            { "type.nu.grek", "grčki brojevi" },
            { "type.nu.gujr", "gudžaratske znamenke" },
            { "type.nu.guru", "znamenke pisma gurmukhi" },
            { "type.nu.hans", "pojednostavljeni kineski brojevi" },
            { "type.nu.hant", "tradicionalni kineski brojevi" },
            { "type.nu.hebr", "hebrejski brojevi" },
            { "type.nu.java", "javanske znamenke" },
            { "type.nu.jpan", "japanski brojevi" },
            { "type.nu.khmr", "khmerske znamenke" },
            { "type.nu.knda", "znamenke pisma kannada" },
            { "type.nu.laoo", "laoske znamenke" },
            { "type.nu.latn", "arapski brojevi" },
            { "type.nu.mlym", "malajalamske znamenke" },
            { "type.nu.mong", "Mongolske znamenke" },
            { "type.nu.mtei", "meetei mayek znamenke" },
            { "type.nu.mymr", "mijanmarske znamenke" },
            { "type.nu.olck", "oi chiki znamenke" },
            { "type.nu.orya", "orijske znamenke" },
            { "type.nu.taml", "tamilski brojevi" },
            { "type.nu.telu", "znamenke teluškog pisma" },
            { "type.nu.thai", "tajske znamenke" },
            { "type.nu.tibt", "tibetske znamenke" },
            { "type.nu.vaii", "vai znamenke" },
            { "type.ca.dangi", "dangi kalendar" },
            { "type.co.ducet", "standardno unicode razvrstavanje" },
            { "type.lb.loose", "slobodni stil prijeloma retka" },
            { "type.nu.roman", "rimski brojevi" },
            { "type.ca.coptic", "koptski kalendar" },
            { "type.ca.hebrew", "hebrejski kalendar" },
            { "type.ca.indian", "indijski nacionalni kalendar" },
            { "type.co.compat", "prethodni redoslijed razvrstavanja, radi kompatibilnosti" },
            { "type.co.pinyin", "pinyin razvrstavanje" },
            { "type.co.search", "općenito pretraživanje" },
            { "type.co.stroke", "razvrstavanje po redoslijedu poteza za kineski" },
            { "type.co.unihan", "razvrstavanje prema korijenu i potezu" },
            { "type.co.zhuyin", "zhuyin razvrstavanje" },
            { "type.d0.fwidth", "široki" },
            { "type.d0.hwidth", "uski" },
            { "type.lb.normal", "normalni stil prijeloma retka" },
            { "type.lb.strict", "strogi stil prijeloma retka" },
            { "type.m0.ungegn", "transliteracija prema UNGEGN-u" },
            { "type.ms.metric", "metrički sustav" },
            { "type.nu.native", "izvorne znamenke" },
            { "type.ca.chinese", "kineski kalendar" },
            { "type.ca.islamic", "hijri kalendar" },
            { "type.ca.iso8601", "ISO-8601 kalendar" },
            { "type.ca.persian", "perzijski kalendar" },
            { "type.cf.account", "računovodstveni format valute" },
            { "type.d0.npinyin", "Numerički" },
            { "type.nu.arabext", "proširene arapsko-indijske znamenke" },
            { "type.nu.armnlow", "mali armenski brojevi" },
            { "type.nu.finance", "Financijski brojevi" },
            { "type.nu.greklow", "mali grčki brojevi" },
            { "type.nu.hanidec", "kineski decimalni brojevi" },
            { "type.nu.hansfin", "pojednostavljeni kineski financijski brojevi" },
            { "type.nu.hantfin", "tradicionalni kineski financijski brojevi" },
            { "type.nu.jpanfin", "japanski financijski brojevi" },
            { "type.nu.tamldec", "tamilske znamenke" },
            { "type.ca.buddhist", "budistički kalendar" },
            { "type.ca.ethiopic", "etiopski kalendar" },
            { "type.ca.japanese", "japanski kalendar" },
            { "type.cf.standard", "standardni format valute" },
            { "type.co.phonetic", "fonetsko razvrstavanje" },
            { "type.co.searchjl", "Pretraživanje po početnom suglasniku hangula" },
            { "type.co.standard", "standardno razvrstavanje" },
            { "type.ms.uksystem", "imperijalni sustav mjera" },
            { "type.ms.ussystem", "američki sustav mjera" },
            { "type.nu.fullwide", "široke znamenke" },
            { "type.nu.romanlow", "mali rimski brojevi" },
            { "type.ca.gregorian", "gregorijanski kalendar" },
            { "type.co.phonebook", "razvrstavanje po abecedi" },
            { "type.co.dictionary", "rječničko razvrstavanje" },
            { "type.co.traditional", "tradicionalno razvrstavanje" },
            { "type.nu.traditional", "Tradicionalni brojevi" },
            { "type.ca.islamic-civil", "hijri kalendar (tabularni, civilna epoha)" },
            { "type.ca.islamic-umalqura", "hijri kalendar (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopski kalendar \"Amete Alem\"" },
        };
        return data;
    }
}
