/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.timer;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.kura.internal.wire.timer.EmitJob;
import org.eclipse.kura.internal.wire.timer.TimerExecutor;
import org.eclipse.kura.internal.wire.timer.TimerJobDataMap;
import org.eclipse.kura.internal.wire.timer.TimerOptions;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTimerExecutor
implements TimerExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CronTimerExecutor.class);
    private static final String GROUP_ID = "wires";
    private static AtomicInteger nextJobId = new AtomicInteger(0);
    private static SchedulerManager schedulerManager = new SchedulerManager();
    private final JobKey jobKey;

    public CronTimerExecutor(TimerOptions options, WireSupport wireSupport) throws SchedulerException {
        String expression = options.getCronExpression();
        int id = nextJobId.incrementAndGet();
        this.jobKey = new JobKey("emitJob" + id, GROUP_ID);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("emitTrigger" + id, GROUP_ID).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)expression)).build();
        TimerJobDataMap jobDataMap = new TimerJobDataMap();
        jobDataMap.putWireSupport(wireSupport);
        JobDetail job = JobBuilder.newJob(EmitJob.class).withIdentity(this.jobKey).setJobData((JobDataMap)jobDataMap).build();
        try {
            schedulerManager.onInstanceCreated();
            schedulerManager.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            schedulerManager.onInstanceDestroyed();
            throw e;
        }
    }

    @Override
    public void shutdown() {
        try {
            schedulerManager.deleteJob(this.jobKey);
        }
        catch (Exception e) {
            logger.warn("failed to delete job", (Throwable)e);
        }
        schedulerManager.onInstanceDestroyed();
    }

    private static class SchedulerManager {
        private int instanceCount;
        private Optional<Scheduler> scheduler = Optional.empty();
        private Optional<ServiceRegistration<EventHandler>> clockChangeEventHandler = Optional.empty();

        private SchedulerManager() {
        }

        Scheduler getScheduler() throws SchedulerException {
            if (this.scheduler.isPresent()) {
                return this.scheduler.get();
            }
            Scheduler newScheduler = new StdSchedulerFactory().getScheduler();
            newScheduler.start();
            this.scheduler = Optional.of(newScheduler);
            return newScheduler;
        }

        synchronized void onInstanceCreated() {
            ++this.instanceCount;
            if (!this.clockChangeEventHandler.isPresent()) {
                Hashtable<String, String> eventHandlerProperties = new Hashtable<String, String>();
                ((Dictionary)eventHandlerProperties).put("event.topics", "org/eclipse/kura/clock");
                BundleContext bundleContext = FrameworkUtil.getBundle(CronTimerExecutor.class).getBundleContext();
                this.clockChangeEventHandler = Optional.of(bundleContext.registerService(EventHandler.class, e -> this.rescheduleTriggers(), eventHandlerProperties));
            }
        }

        synchronized void onInstanceDestroyed() {
            --this.instanceCount;
            if (this.instanceCount > 0) {
                return;
            }
            if (this.clockChangeEventHandler.isPresent()) {
                this.clockChangeEventHandler.get().unregister();
                this.clockChangeEventHandler = Optional.empty();
            }
            if (this.scheduler.isPresent()) {
                try {
                    this.scheduler.get().shutdown();
                }
                catch (Exception e) {
                    logger.warn("failed to shutdown scheduler", (Throwable)e);
                }
                this.scheduler = Optional.empty();
            }
        }

        synchronized void scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }

        synchronized void deleteJob(JobKey jobKey) throws SchedulerException {
            this.getScheduler().deleteJob(jobKey);
        }

        synchronized void rescheduleTriggers() {
            Set keys;
            if (!this.scheduler.isPresent()) {
                return;
            }
            logger.info("system time changed, rescheduling triggers...");
            Scheduler currentScheduler = this.scheduler.get();
            try {
                keys = currentScheduler.getTriggerKeys(GroupMatcher.anyTriggerGroup());
            }
            catch (SchedulerException e) {
                logger.warn("failed to get scheduled triggers", (Throwable)e);
                return;
            }
            for (TriggerKey key : keys) {
                try {
                    Trigger newTrigger = currentScheduler.getTrigger(key).getTriggerBuilder().startNow().build();
                    logger.debug("rescheduling {}...", (Object)key);
                    currentScheduler.rescheduleJob(key, newTrigger);
                    logger.debug("rescheduling {}...done", (Object)key);
                }
                catch (Exception e) {
                    logger.warn("failed to reschedule trigger {}", (Object)key, (Object)e);
                }
            }
            logger.info("system time changed, rescheduling triggers...done");
        }
    }
}

